//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef plugins_postprocessingmode_pqCMBPostProcessingModeBehavior_h
#define plugins_postprocessingmode_pqCMBPostProcessingModeBehavior_h

#include <QActionGroup>

class pqServer;

class pqCMBPostProcessingModeBehavior : public QActionGroup
{
  Q_OBJECT
  using Superclass = QActionGroup;

public:
  pqCMBPostProcessingModeBehavior(QObject* parent = nullptr);
  ~pqCMBPostProcessingModeBehavior() override;

  static pqCMBPostProcessingModeBehavior* instance();

protected slots:
  virtual void switchModes(QAction* a);

protected:
  class pqInternal;
  pqInternal* m_p;
  bool m_menusBuilt;

  void buildMenus();

private:
  Q_DISABLE_COPY(pqCMBPostProcessingModeBehavior);
};

#endif
