if (WIN32)
  # On Windows we expect the Python source for module to be
  # in a different place than Unix builds and in a different
  # place than SMTK would put it by default. Tell SMTK where
  # to install Python source for the smtk module:
  set(SMTK_PYTHON_MODULEDIR ${SuperBuild_BINARY_DIR}/install/python)
endif()

add_external_project_or_just_build_dependencies(smtk
  DEPENDS boost qt shiboken paraview
  CMAKE_ARGS
    ${extra_cmake_args}
    "-C${CMAKE_BINARY_DIR}/env.cmake"
    -DBUILD_SHARED_LIBS:BOOL=ON
    -DSMTK_BUILD_QT:BOOL=ON
    -DSMTK_BUILD_ParaView:BOOL=ON
    -DParaView_DIR:PATH=${SuperBuild_BINARY_DIR}/paraview/src/paraview-build/
    -DSMTK_BUILD_PYTHON_WRAPPINGS:BOOL=${shiboken_ENABLED}
  )

if(shiboken_ENABLED)
  add_external_project_step(install_shiboken_python_plugin
    COMMENT "Fixing missing include files."
    COMMAND  ${CMAKE_COMMAND}
      -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
      -Dpv_version:STRING=${pv_version}
      -Dpv_python_executable:PATH=${pv_python_executable}
      -DBUILD_SHARED_LIBS:BOOL=ON
      -DSMTK_BIN_DIR:PATH=${install_location}
      -DTMP_DIR:PATH=<TMP_DIR>
      -P ${CMAKE_CURRENT_LIST_DIR}/install_smtk_python_plugin.cmake
    DEPENDEES install)
endif()

