//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtk_session_aeva_ImprintGeometry_h
#define smtk_session_aeva_ImprintGeometry_h

#include "smtk/session/aeva/Operation.h"
#include "smtk/session/aeva/Resource.h"

namespace smtk
{
namespace session
{
namespace aeva
{

/**\brief Create or replace a scalar array on an image with values proximal to
  *       unstructured mesh input(s).
  */
class SMTKAEVASESSION_EXPORT ImprintGeometry : public Operation
{

public:
  smtkTypeMacro(smtk::session::aeva::ImprintGeometry);
  smtkCreateMacro(ImprintGeometry);
  smtkSharedFromThisMacro(smtk::operation::Operation);
  smtkSuperclassMacro(Operation);

protected:
  Result operateInternal() override;
  const char* xmlDescription() const override;
};

} // namespace aeva
} // namespace session
} // namespace smtk

#endif // smtk_session_aeva_ImprintGeometry_h
