<?xml version="1.0" encoding="utf-8" ?>
<!-- Description of the AEVA "Export" Operator -->
<SMTK_AttributeResource Version="3">
  <Definitions>
    <include href="smtk/operation/Operation.xml"/>
    <AttDef Type="export" Label="export model to Salome or VTK" BaseType="operation">
      <AssociationsDef Name="models" Label="model(s)" NumberOfRequiredValues="1" Extensible="true">
        <!-- TODO should include new property filter string for "aeva_datatype" -->
        <Accepts><Resource Name="smtk::session::aeva::Resource" Filter="model"/></Accepts>
      </AssociationsDef>
      <ItemDefinitions>
        <File Name="filename" NumberOfRequiredValues="1" Extensible="true"
          ShouldExist="false"
          FileFilters="VTK Image Data (*.vti);; Salome Med Mesh (*.med)">
        </File>
      </ItemDefinitions>
    </AttDef>
    <!-- Result -->
    <include href="smtk/operation/Result.xml"/>
    <AttDef Type="result(export)" BaseType="result">
    </AttDef>
  </Definitions>
  <Views>
    <View Type="Operation" Title="export model to Salome or VTK" TopLevel="true" UseSelectionManager="true">
      <InstancedAttributes>
        <Att Type="export">
          <ItemViews>
            <View Path="/models" Type="qtReferenceTree">
              <PhraseModel Type="smtk::view::ResourcePhraseModel">
                <SubphraseGenerator Type="smtk::view::SubphraseGenerator"/>
                <Badges>
                  <Badge
                    Type="smtk::extension::qt::MembershipBadge"
                    MembershipCriteria="Components"
                    Filter="model"
                    Default="false"/>
                  <Badge
                    Type="smtk::extension::paraview::appcomponents::VisibilityBadge"
                    Default="false"/>
                </Badges>
              </PhraseModel>
            </View>
          </ItemViews>
        </Att>
      </InstancedAttributes>
    </View>
  </Views>
</SMTK_AttributeResource>
