<?xml version="1.0" encoding="utf-8" ?>
<!-- Description of the AEVA session "chart generation" Operation -->
<SMTK_AttributeResource Version="3">
  <Definitions>
    <include href="smtk/operation/Operation.xml"/>
    <AttDef Type="chart generation" Label="chart generation" BaseType="operation">
      <BriefDescription>Create a copy of the input surface mesh with chart ids assigned to the cell data.</BriefDescription>
      <DetailedDescription>
        Create a copy of the input surface mesh with chart ids assigned to its cell data. The charts (segmentations)
        is generated by following the approach described in Section 3 of LSCM paper. Feature edges are detected and
        chart regions grow from the feature edges until they meet other charts' boundaries. The distance to feature
        edges are computed using edge lengths.
        (https://members.loria.fr/Bruno.Levy/papers/LSCM_SIGGRAPH_2002.pdf)
      </DetailedDescription>
      <AssociationsDef Name="source" NumberOfRequiredValues="1">
        <BriefDescription>The input surface for generating charts</BriefDescription>
        <Accepts><Resource Name="smtk::session::aeva::Resource" Filter="face"/></Accepts>
      </AssociationsDef>

      <ItemDefinitions>
        <Double Name="feature angle" Label="feature angle">
          <BriefDescription>Feature angle: 0.0...180.0</BriefDescription>
          <DefaultValue>40.0</DefaultValue>
          <RangeInfo>
            <Min Inclusive="true">0.0</Min>
            <Max Inclusive="true">180.0</Max>
          </RangeInfo>
        </Double>
      </ItemDefinitions>
    </AttDef>
    <!-- Result -->
    <include href="smtk/operation/Result.xml"/>
    <AttDef Type="result(chart generation)" BaseType="result"/>
  </Definitions>
  <Views>
    <View Type="Operation" Title="chart generation" TopLevel="true" UseSelectionManager="true">
      <InstancedAttributes>
        <Att Type="chart generation">
          <ItemViews>
            <View Path="/source" Type="qtReferenceTree">
              <PhraseModel Type="smtk::view::ResourcePhraseModel">
                <SubphraseGenerator Type="smtk::view::SubphraseGenerator"/>
                <Badges>
                  <Badge
                    Type="smtk::extension::qt::MembershipBadge"
                    MembershipCriteria="ComponentsWithGeometry"
                    Filter="face"
                    Default="false"/>
                  <Badge
                    Type="smtk::extension::paraview::appcomponents::VisibilityBadge"
                    Default="false"/>
                </Badges>
              </PhraseModel>
            </View>
          </ItemViews>
        </Att>
      </InstancedAttributes>
    </View>
  </Views>
</SMTK_AttributeResource>
