<?xml version="1.0"?>
<SMTK_AttributeResource Version="6" DisplayHint="True" TemplateType="aeva.knee" TemplateVersion="1">

  <Definitions>

    <!-- relation.sbt -->

    <!-- Many types of anatomical relationships exist, but they all inherit a common base. -->
    <AttDef Type="relation" BaseType="">
    </AttDef>

    <!-- Inheritance (is-a) relations -->
    <AttDef Type="inheritance" BaseType="relation">
    </AttDef>

    <!-- Composition (has-a with possession) relations -->
    <AttDef Type="composition" BaseType="relation">
    </AttDef>

    <!-- Aggregation (has-a without possession; an aggreations of references) relations -->
    <AttDef Type="aggregation" BaseType="relation">
    </AttDef>

    <!-- Instantiation (token-type) relations -->
    <AttDef Type="instantiation" BaseType="relation">
    </AttDef>

    <!-- Geometric relations -->
    <AttDef Type="geometric" BaseType="relation">
    </AttDef>

    <!-- Geometric proximity -->
    <AttDef Type="proximal" BaseType="geometric">
    </AttDef>

    <!-- Geometric anchor (more than just proximal; non-empty shared boundary) -->
    <AttDef Type="attachment" BaseType="proximal">
    </AttDef>

    <!-- Mechanical adhesion (more than just geometric; shared boundary with a strength) -->
    <AttDef Type="adhesion" BaseType="attachment">
    </AttDef>

    <AttDef Type="surface adhesion" BaseType="adhesion">

      <AssociationsDef Name="surface" NumberOfRequiredValues="2" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="face"/>
          <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::UnstructuredData'"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>
        <Double Name="yield strength">
          <BriefDescription>
              The maximum shear stress that may exist on the boundary before local failure.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="curve adhesion" BaseType="adhesion">

      <AssociationsDef Name="curve" NumberOfRequiredValues="2" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="edge"/>
          <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::UnstructuredData'"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>
        <Double Name="yield strength">
          <BriefDescription>
              The maximum force per unit length that may exist on the boundary before local failure.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="point adhesion" BaseType="adhesion">

      <AssociationsDef Name="point" NumberOfRequiredValues="2" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="vertex"/>
          <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::UnstructuredData'"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>
        <Double Name="yield strength">
          <BriefDescription>
              The maximum force that may exist on the attachment point before failure.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>
      </ItemDefinitions>

    </AttDef>


    <!-- Geometric contact (more than just proximal; non-empty shared boundary) -->
    <AttDef Type="contact" BaseType="proximal">
    </AttDef>

    <!-- Mechanical sliding contact (more than just geometric; shared boundary with stiction) -->
    <AttDef Type="sliding contact" BaseType="contact">

      <AssociationsDef Name="surface" NumberOfRequiredValues="1" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="face"/>
          <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::UnstructuredData'"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>

        <Double Name="static friction coefficient">
          <BriefDescription>
              The static coefficient of friction.
              This is the ratio of tangential to normal stress above which sliding occurs.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double Name="dynamic friction coefficient">
          <BriefDescription>
              The dynamic coefficient of friction.
              This is the ratio of tangential to normal stress while sliding occurs.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>

    </AttDef>

    <!-- patient.sbt -->

    <AttDef Type="patient" BaseType="">
      <ItemDefinitions>
        <String Name="record number">
          <BriefDescription>An anonymous (non-identifying) patient record number.</BriefDescription>
        </String>
        <Int Name="age" Units="years">
          <BriefDescription>The approximate age of the patient in years (as an integer).</BriefDescription>
        </Int>
        <String Name="gender">
          <DiscreteInfo>
            <Value Enum="male">male</Value>
            <Value Enum="female">female</Value>
          </DiscreteInfo>
        </String>
        <String Name="notes">
        </String>
      </ItemDefinitions>
    </AttDef>
    <!-- anatomy.sbt -->


    <!-- Many types of anatomical features exist, but they all inherit a common base. -->
    <AttDef Type="anatomical feature" BaseType="">
    </AttDef>

    <!-- Volumetric anatomical features are regions of space.
         This type of feature is usually a tissue but
         might also include cavities (e.g., nasal cavities).
         You may think of these features as labels that segment a volume.
      -->
    <AttDef Type="anatomical volume" BaseType="anatomical feature" Unique="true">

      <AssociationsDef Name="geometry" Extensible="true">
        <Accepts>
          <Resource Name="smtk::session::aeva::Resource" Filter="volume|face|edge|vertex"/>
          <Resource Name="smtk::model::Resource" Filter="volume"/>
          <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::UnstructuredData'"/>
          <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::ImageData'"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
          <Resource Name="smtk::session::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

    </AttDef>

    <AttDef Type="cavity" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002553</BriefDescription>
    </AttDef>

    <AttDef Type="implant" BaseType="anatomical volume">
      <!-- Note there is no uberon entry for implants. -->
      <BriefDescription> http://purl.obolibrary.org/obo/NCIT_C41075</BriefDescription>
    </AttDef>

    <AttDef Type="bone tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002481</BriefDescription>
    </AttDef>

    <AttDef Type="cartilage tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002418</BriefDescription>
    </AttDef>

    <AttDef Type="ligament" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000211</BriefDescription>
    </AttDef>

    <AttDef Type="muscle tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002385</BriefDescription>
    </AttDef>

    <AttDef Type="tendon" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000043</BriefDescription>
    </AttDef>

    <AttDef Type="neural tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003714</BriefDescription>
    </AttDef>

    <!--
      Organs are collections of tissues in functional relationships.

      Organs may collect multiple types of tissue and may also include cavities.
      Organs also have relationships; these may be internal (i.e., between
      tissues and cavities collected within the organ) or external (i.e., with
      other organs and their constituents).
      -->
    <AttDef Type="organ" BaseType="anatomical feature" Unique="true">

      <AssociationsDef Name="tissues" NumberOfRequiredValues="1" Extensible="true">
        <Accepts>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
          <Resource Name="smtk::session::aeva::Resource" Filter="volume|face|edge|vertex"/>
          <Resource Name="smtk::session::mesh::Resource" Filter="*"/>
          <!-- <Resource Name="smtk::attribute::Resource" Filter="attribute[type='tissue']"/ -->
        </Accepts>
      </AssociationsDef>

    </AttDef>

    <AttDef Type="femur" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000981</BriefDescription>
      <!--
        TODO: Femurs have (see https://en.wikipedia.org/wiki/File:Knee_diagram.svg):
        + a surface attachment between bone and articular cartilage
        + a (point/curve/surface?) attachement to the LCL, MCL, PCL, and ACL
        TODO: Should we create left and right femur instances? Just have an int/string item on the femur
        indicating which side of the median/midsagittal plane the femur lies?
        TODO: Should the femur contain both bone and articular cartilage?
      -->
    </AttDef>

    <AttDef Type="tibia" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000979</BriefDescription>
    </AttDef>

    <AttDef Type="fibula" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0001446</BriefDescription>
    </AttDef>

    <AttDef Type="patella" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002446</BriefDescription>
    </AttDef>

    <AttDef Type="anterior cruciate ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003671</BriefDescription>
    </AttDef>

    <AttDef Type="posterior cruciate ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003680</BriefDescription>
    </AttDef>

    <AttDef Type="anterolateral ligament of knee" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0014899</BriefDescription>
    </AttDef>

    <AttDef Type="patellar ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003676</BriefDescription>
    </AttDef>

    <!-- Uberon does not appear to have these ligaments (or they are named differently)
    <AttDef Type="medial collateral ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_xxxxxxx</BriefDescription>
    </AttDef>

    <AttDef Type="lateral collateral ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_xxxxxxx</BriefDescription>
    </AttDef>
    -->

    <AttDef Type="quadriceps tendon" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0014848</BriefDescription>
    </AttDef>

    <AttDef Type="quadriceps femoris" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0001377</BriefDescription>
    </AttDef>

    <AttDef Type="femur cartilage element" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0010129</BriefDescription>
    </AttDef>

    <AttDef Type="patella cartilage element" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0012080</BriefDescription>
    </AttDef>

    <AttDef Type="meniscus" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000387</BriefDescription>
    </AttDef>

    <!-- Template for organ
    <AttDef Type="xxx" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_xxxxxxx</BriefDescription>
    </AttDef>
    -->

    <!-- Specific "named" adhesion and contact relationships for knee anatomy -->
    <AttDef Type="femur bone-femur cartilage adhesion" BaseType="surface adhesion">
      <AssociationsDef Name="surface" NumberOfRequiredValues="2" Extensible="false">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="face[integer{'side-set'=1}]"/>
          <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::UnstructuredData'"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>
    </AttDef>
    <!-- Femur bone -->
    <AttDef Type="femur bone-acl adhesion" BaseType="surface adhesion"/>
    <AttDef Type="femur bone-lcl adhesion" BaseType="surface adhesion"/>
    <AttDef Type="femur bone-mcl adhesion" BaseType="surface adhesion"/>
    <AttDef Type="femur bone-pcl adhesion" BaseType="surface adhesion"/>

    <AttDef Type="femur bone-acl contact" BaseType="sliding contact"/>
    <AttDef Type="femur bone-lcl contact" BaseType="sliding contact"/>
    <AttDef Type="femur bone-mcl contact" BaseType="sliding contact"/>
    <AttDef Type="femur bone-pcl contact" BaseType="sliding contact"/>
    <AttDef Type="femur bone-quadriceps tendon contact" BaseType="sliding contact"/>

    <!-- Tibia bone -->
    <AttDef Type="tibia bone-tibia cartilage (lateral) adhesion" BaseType="surface adhesion"/>
    <AttDef Type="tibia bone-tibia cartilage (medial) adhesion" BaseType="surface adhesion"/>
    <AttDef Type="tibia bone-meniscus cartilage (lateral) adhesion" BaseType="surface adhesion"/>
    <AttDef Type="tibia bone-meniscus cartilage (medial) adhesion" BaseType="surface adhesion"/>
    <AttDef Type="tibia bone-acl adhesion" BaseType="surface adhesion"/>
    <AttDef Type="tibia bone-mcl adhesion" BaseType="surface adhesion"/>
    <AttDef Type="tibia bone-pcl adhesion" BaseType="surface adhesion"/>
    <AttDef Type="tibia bone-patellar ligament adhesion" BaseType="surface adhesion"/>

    <AttDef Type="tibia bone-acl contact" BaseType="sliding contact"/>
    <AttDef Type="tibia bone-mcl contact" BaseType="sliding contact"/>
    <AttDef Type="tibia bone-pcl contact" BaseType="sliding contact"/>

    <!-- Fibula bone -->
    <AttDef Type="fibula bone-lcl adhesion" BaseType="surface adhesion"/>

    <!-- Patella bone -->
    <AttDef Type="patella bone-patellar ligament adhesion" BaseType="surface adhesion"/>
    <AttDef Type="patella bone-patella cartilage adhesion" BaseType="surface adhesion"/>
    <AttDef Type="patella bone-quadriceps tendon adhesion" BaseType="surface adhesion"/>

    <!-- Femur cartilage -->
    <AttDef Type="femur cartilage-tibia cartilage (lateral) contact" BaseType="sliding contact"/>
    <AttDef Type="femur cartilage-tibia cartilage (medial) contact" BaseType="sliding contact"/>
    <AttDef Type="femur cartilage-patella cartilage contact" BaseType="sliding contact"/>
    <AttDef Type="femur cartilage-meniscus cartilage (lateral) contact" BaseType="sliding contact"/>
    <AttDef Type="femur cartilage-meniscus cartilage (medial) contact" BaseType="sliding contact"/>
    <AttDef Type="femur cartilage-quadriceps tendon contact" BaseType="sliding contact"/>

    <!-- Tibia cartilage (lateral) -->
    <AttDef Type="tibia cartilage (lateral)-meniscus cartilage (lateral) contact" BaseType="sliding contact"/>

    <!-- Tibia cartilage (medial) -->
    <AttDef Type="tibia cartilage (medial)-meniscus cartilage (medial) contact" BaseType="sliding contact"/>

    <!-- Meniscus cartilage (medial) -->
    <AttDef Type="meniscus cartilage (medial)-mcl adhesion" BaseType="surface adhesion"/>
    <AttDef Type="meniscus cartilage (medial)-pcl contact" BaseType="sliding contact"/>

    <!-- ACL ligament -->
    <AttDef Type="acl-pcl contact" BaseType="sliding contact"/>

    <AttDef Type="landmark" BaseType="anatomical feature" Version="0">
      <ItemDefinitions>
        <String Name="notes" Optional="true" IsEnabledByDefault="false">
          <BriefDescription>
              A name for the landmark that describes its definition or purpose.
          </BriefDescription>
        </String>
      </ItemDefinitions>
    </AttDef>

    <AttDef Type="point landmark" BaseType="landmark" Version="0">
      <ItemDefinitions>
        <Double Name="location" NumberOfRequiredValues="3">
          <BriefDescription>
              The coordinates of the point in space.
          </BriefDescription>
        </Double>
      </ItemDefinitions>
    </AttDef>

    <AttDef Type="line landmark" BaseType="landmark" Version="0">
      <ItemDefinitions>
        <Group Name="points" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="point 1" NumberOfRequiredValues="3">
              <BriefDescription>
                A point in space through which the line passes.
              </BriefDescription>
            </Double>
            <Double Name="point 2" NumberOfRequiredValues="3">
              <BriefDescription>
                A point in space through which the line passes.
              </BriefDescription>
            </Double>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>

    <!-- material.sbt -->

    <AttDef Type="rank 2 tensor function" BaseType="">
      <ItemDefinitions>
        <String Name="tensor type">
          <ChildrenDefinitions>
            <String Name="general functions" NumberOfRequiredValues="9"/>
            <String Name="symmetric functions" NumberOfRequiredValues="6"/>
            <String Name="diagonal functions" NumberOfRequiredValues="3"/>
          </ChildrenDefinitions>
          <DiscreteInfo>
            <Structure>
              <Value Enum="general">general</Value>
              <Items><Item>general functions</Item></Items>
              <Value Enum="symmetric">symmetric</Value>
              <Items><Item>symmetric functions</Item></Items>
              <Value Enum="diagonal">diagonal</Value>
              <Items><Item>diagonal functions</Item></Items>
            </Structure>
          </DiscreteInfo>
        </String>
      </ItemDefinitions>
    </AttDef>

    <AttDef Type="cauchy-green deformation tensor" BaseType="">

      <ItemDefinitions>
        <String
          Name="type"
          NumberOfRequiredValues="1"
        >
          <ChildrenDefinitions>

            <Double
              Name="b"
              Label="B"
              NumberOfRequiredValues="9"
            >
              <ExpressionType>rank 2 tensor function</ExpressionType>
            </Double>
            <String
              Name="field name"
              NumberOfRequiredValues="1"
            />
            <Component Name="field source" NumberOfRequiredValues="1" Extensible="true">
              <Accepts>
                <Resource Name="smtk::model::Resource" Filter="volume"/>
                <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::UnstructuredData'"/>
                <Resource Name="smtk::markup::Resource" Filter="'smtk::markup::ImageData'"/>
                <Resource Name="smtk::mesh::Resource" Filter="any"/>
              </Accepts>
            </Component>

          </ChildrenDefinitions>
          <DiscreteInfo DefaultIndex="0">

            <Structure>
              <Value Enum="constant">constant</Value>
              <BriefDescription>
                  The deformation tensor is constant over space or
                  an analytical function of spatial coordinates.
              </BriefDescription>
              <Items><Item>b</Item></Items>
            </Structure>

            <Structure>
              <Value Enum="field">field</Value>
              <BriefDescription>
                  The deformation tensor is provided by field data
                  accompanying the model.
              </BriefDescription>
              <Items>
                <Item>field source</Item>
                <Item>field name</Item>
              </Items>
            </Structure>

          </DiscreteInfo>
        </String>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="material" BaseType="" Abstract="true">

        <AssociationsDef Name="anatomical volume" >
          <Accepts>
            <Resource Name="smtk::attribute::Resource" Filter="attribute[type='anatomical volume']"/>
          </Accepts>
        </AssociationsDef>

      <ItemDefinitions>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="solid" BaseType="material" Version="0" Unique="true">
      <ItemDefinitions>

        <!-- Solids have a density.  -->
        <Double
          Name="density"
          Label="ρ"
        >
          <BriefDescription>
            Density of the solid material (mass per unit volume).
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>

        <!-- Solids have an initial strain.  -->
        <Double
          Name="initial strain"
          Label="ε0"
        >
          <BriefDescription>
            Initial strain of the material (length per unit length).
            This quantity is signed (negative in the case of compression).
          </BriefDescription>
        </Double>

      </ItemDefinitions>
    </AttDef>

    <AttDef Type="neo-hookean solid" BaseType="solid" Version="0" Unique="true">
      <BriefDescription>
        Neo-Hookean models only accumulate strain energy along
        the principal direction of the deformation tensor.
      </BriefDescription>
      <ItemDefinitions>

        <Component
          Name="strain tensor"
          Label="f"
          NumberOfRequiredValues="0"
          MaximumNumberOfValues="1"
          Extensible="true"
        >
          <BriefDescription>
            Anisotropic fiber orientation tensor.
          </BriefDescription>
          <Accepts>
            <Resource Name="smtk::attribute::Resource" Filter="attribute[type='cauchy-green deformation tensor']"/>
          </Accepts>
        </Component>

        <Double
          Name="c1"
          Label="C1"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>
    </AttDef>

    <AttDef Type="mooney-rivlin solid" BaseType="neo-hookean solid" Version="0" Unique="true">
      <BriefDescription>
        Mooney-Rivlin solids accumulate strain energy along two
        highest principal directions of the deformation tensor.
      </BriefDescription>
      <ItemDefinitions>

        <Double
          Name="c2"
          Label="C2"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>
    </AttDef>

    <AttDef Type="trans iso mooney-rivlin solid" BaseType="mooney-rivlin solid" Version="0" Unique="true">
      <ItemDefinitions>

        <Double
          Name="c3"
          Label="C3"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double
          Name="c4"
          Label="C4"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double
          Name="c5"
          Label="C5"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double
          Name="lambda max"
          Label="λ_max"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>
    </AttDef>

  </Definitions>

  <Prerequisites>
    <!-- anatomy.sbt -->

    <!-- Individual bones must be labeled as bone tissue. -->
    <Rule Type="femur"><Def>bone tissue</Def></Rule>
    <Rule Type="fibula"><Def>bone tissue</Def></Rule>
    <Rule Type="tibia"><Def>bone tissue</Def></Rule>
    <Rule Type="patella"><Def>bone tissue</Def></Rule>

    <!-- Individual ligaments must be labeled as ligament. -->
    <Rule Type="anterior cruciate ligament"><Def>ligament</Def></Rule>
    <Rule Type="posterior cruciate ligament"><Def>ligament</Def></Rule>
    <Rule Type="anterolateral ligament of knee"><Def>ligament</Def></Rule>
    <Rule Type="patellar ligament"><Def>ligament</Def></Rule>

    <!-- Individual tendons must be labeled as tendon. -->
    <Rule Type="quadriceps tendon"><Def>tendon</Def></Rule>

    <!-- Individual muscles must be labeled as muscle tissue. -->
    <Rule Type="quadriceps femoris"><Def>muscle tissue</Def></Rule>

    <!-- Individual cartilage must be labeled as cartilage tissue. -->
    <Rule Type="femur cartilage element"><Def>cartilage tissue</Def></Rule>
    <Rule Type="meniscus"><Def>cartilage tissue</Def></Rule>
    <Rule Type="patella cartilage element"><Def>cartilage tissue</Def></Rule>

    <!-- Individual nerves must be labeled as neural tissue. -->
    <!-- Rule Type="xxx"><Def>neural tissue</Def></Rule -->

    <!-- Side sets for relationships must come from the proper organ -->
    <Rule Type="femur bone-acl adhesion"><Def>femur</Def></Rule>
  </Prerequisites>

  <Attributes>
    <!-- anatomy.sbt -->

        <Att Name="bone tissue" Type="bone tissue" />
        <Att Name="muscle tissue" Type="muscle tissue" />
        <Att Name="cartilage tissue" Type="cartilage tissue" />
        <Att Name="ligament" Type="ligament" />
        <Att Name="tendon" Type="tendon" />
        <Att Name="neural tissue" Type="neural tissue" />

        <Att Name="anterior cruciate ligament, left" Type="anterior cruciate ligament"/>
        <Att Name="anterior cruciate ligament, right" Type="anterior cruciate ligament"/>
        <Att Name="anterolateral ligament of knee, left" Type="anterolateral ligament of knee"/>
        <Att Name="anterolateral ligament of knee, right" Type="anterolateral ligament of knee"/>
        <Att Name="femur, left" Type="femur"/>
        <Att Name="femur, right" Type="femur"/>
        <Att Name="femur cartilage element, left" Type="femur cartilage element"/>
        <Att Name="femur cartilage element, right" Type="femur cartilage element"/>
        <Att Name="fibula, left" Type="fibula"/>
        <Att Name="fibula, right" Type="fibula"/>
        <Att Name="meniscus, left" Type="meniscus"/>
        <Att Name="meniscus, right" Type="meniscus"/>
        <Att Name="patella, left" Type="patella"/>
        <Att Name="patella, right" Type="patella"/>
        <Att Name="patella cartilage element, left" Type="patella cartilage element"/>
        <Att Name="patella cartilage element, right" Type="patella cartilage element"/>
        <Att Name="patellar ligament, left" Type="patellar ligament"/>
        <Att Name="patellar ligament, right" Type="patellar ligament"/>
        <Att Name="posterior cruciate ligament, left" Type="posterior cruciate ligament"/>
        <Att Name="posterior cruciate ligament, right" Type="posterior cruciate ligament"/>
        <Att Name="quadriceps tendon, left" Type="quadriceps tendon"/>
        <Att Name="quadriceps tendon, right" Type="quadriceps tendon"/>
        <Att Name="quadriceps femoris, left" Type="quadriceps femoris"/>
        <Att Name="quadriceps femoris, right" Type="quadriceps femoris"/>
        <Att Name="tibia, left" Type="tibia"/>
        <Att Name="tibia, right" Type="tibia"/>

        <!-- Femur bone -->
        <Att Name="femur bone-femur cartilage adhesion" Type="femur bone-femur cartilage adhesion"/>
        <Att Name="femur bone-acl adhesion" Type="femur bone-acl adhesion"/>
        <Att Name="femur bone-lcl adhesion" Type="femur bone-lcl adhesion"/>
        <Att Name="femur bone-mcl adhesion" Type="femur bone-mcl adhesion"/>
        <Att Name="femur bone-pcl adhesion" Type="femur bone-pcl adhesion"/>

        <Att Name="femur bone-acl contact" Type="femur bone-acl contact"/>
        <Att Name="femur bone-lcl contact" Type="femur bone-lcl contact"/>
        <Att Name="femur bone-mcl contact" Type="femur bone-mcl contact"/>
        <Att Name="femur bone-pcl contact" Type="femur bone-pcl contact"/>
        <Att Name="femur bone-quadriceps tendon contact" Type="femur bone-quadriceps tendon contact"/>

        <!-- Tibia bone -->
        <Att Name="tibia bone-tibia cartilage (lateral) adhesion" Type="tibia bone-tibia cartilage (lateral) adhesion"/>
        <Att Name="tibia bone-tibia cartilage (medial) adhesion" Type="tibia bone-tibia cartilage (medial) adhesion"/>
        <Att Name="tibia bone-meniscus cartilage (lateral) adhesion" Type="tibia bone-meniscus cartilage (lateral) adhesion"/>
        <Att Name="tibia bone-meniscus cartilage (medial) adhesion" Type="tibia bone-meniscus cartilage (medial) adhesion"/>
        <Att Name="tibia bone-acl adhesion" Type="tibia bone-acl adhesion"/>
        <Att Name="tibia bone-mcl adhesion" Type="tibia bone-mcl adhesion"/>
        <Att Name="tibia bone-pcl adhesion" Type="tibia bone-pcl adhesion"/>
        <Att Name="tibia bone-patellar ligament adhesion" Type="tibia bone-patellar ligament adhesion"/>

        <Att Name="tibia bone-acl contact" Type="tibia bone-acl contact"/>
        <Att Name="tibia bone-mcl contact" Type="tibia bone-mcl contact"/>
        <Att Name="tibia bone-pcl contact" Type="tibia bone-pcl contact"/>

        <!-- Fibula bone -->
        <Att Name="fibula bone-lcl adhesion" Type="fibula bone-lcl adhesion"/>

        <!-- Patella bone -->
        <Att Name="patella bone-patellar ligament adhesion" Type="patella bone-patellar ligament adhesion"/>
        <Att Name="patella bone-patella cartilage adhesion" Type="patella bone-patella cartilage adhesion"/>
        <Att Name="patella bone-quadriceps tendon adhesion" Type="patella bone-quadriceps tendon adhesion"/>

        <!-- Femur cartilage -->
        <Att Name="femur cartilage-tibia cartilage (lateral) contact" Type="femur cartilage-tibia cartilage (lateral) contact"/>
        <Att Name="femur cartilage-tibia cartilage (medial) contact" Type="femur cartilage-tibia cartilage (medial) contact"/>
        <Att Name="femur cartilage-patella cartilage contact" Type="femur cartilage-patella cartilage contact"/>
        <Att Name="femur cartilage-meniscus cartilage (lateral) contact" Type="femur cartilage-meniscus cartilage (lateral) contact"/>
        <Att Name="femur cartilage-meniscus cartilage (medial) contact" Type="femur cartilage-meniscus cartilage (medial) contact"/>
        <Att Name="femur cartilage-quadriceps tendon contact" Type="femur cartilage-quadriceps tendon contact"/>

        <!-- Tibia cartilage (lateral) -->
        <Att Name="tibia cartilage (lateral)-meniscus cartilage (lateral) contact" Type="tibia cartilage (lateral)-meniscus cartilage (lateral) contact"/>

        <!-- Tibia cartilage (medial) -->
        <Att Name="tibia cartilage (medial)-meniscus cartilage (medial) contact" Type="tibia cartilage (medial)-meniscus cartilage (medial) contact"/>

        <!-- Meniscus cartilage (medial) -->
        <Att Name="meniscus cartilage (medial)-mcl adhesion" Type="meniscus cartilage (medial)-mcl adhesion"/>
        <Att Name="meniscus cartilage (medial)-pcl contact" Type="meniscus cartilage (medial)-pcl contact"/>

        <!-- ACL ligament -->
        <Att Name="acl-pcl contact" Type="acl-pcl contact"/>

  </Attributes>

  <Views>
    <View Type="Group" Title="SimBuilder" TopLevel="true"
      FilterByAdvanceLevel="false" FilterByCategoryMode="false">
      <DefaultColor>1., 1., 0.5, 1.</DefaultColor>
      <InvalidColor>1, 0.5, 0.5, 1</InvalidColor>
      <AdvancedFontEffects />
      <Views>
        <View Title="Patient"/>
        <View Title="Anatomy"/>
        <View Title="Materials"/>
        <View Title="Fields"/>
        <View Title="Relations"/>
        <View Title="Landmarks"/>
      </Views>
    </View>

    <View Type="Instanced" Title="Patient">
      <InstancedAttributes>
        <Att Name="patient information" Type="patient"/>
      </InstancedAttributes>
    </View>

    <View Type="Group" Title="Anatomy">
      <Views>
        <View Title="Tissue Labels"/>
        <View Title="Organs"/>
      </Views>
    </View>

    <!-- Explicitly list labels...
    <View Type="Instanced" Title="Tissue Labels">
      <InstancedAttributes>
        <Att Name="bone tissue" Type="bone tissue" />
        <Att Name="muscle tissue" Type="muscle tissue" />
        <Att Name="cartilage tissue" Type="cartilage tissue" />
        <Att Name="ligament" Type="ligament" />
        <Att Name="tendon" Type="tendon" />
        <Att Name="neural tissue" Type="neural tissue" />
      </InstancedAttributes>
    </View>
    -->

    <!-- ... or allow user to choose labels? -->
    <View Type="Attribute" Title="Tissue Labels">
      <AttributeTypes>
        <Att Type="anatomical volume"/>
      </AttributeTypes>
    </View>
    <!-- -->

    <!-- Explicitly list organs...
    <View Type="Instanced" Title="Organs">
      <InstancedAttributes>
        <Att Name="anterior cruciate ligament, left" Type="anterior cruciate ligament"/>
        <Att Name="anterior cruciate ligament, right" Type="anterior cruciate ligament"/>
        <Att Name="anterolateral ligament of knee, left" Type="anterolateral ligament of knee"/>
        <Att Name="anterolateral ligament of knee, right" Type="anterolateral ligament of knee"/>
        <Att Name="femur, left" Type="femur"/>
        <Att Name="femur, right" Type="femur"/>
        <Att Name="femur cartilage element, left" Type="femur cartilage element"/>
        <Att Name="femur cartilage element, right" Type="femur cartilage element"/>
        <Att Name="fibula, left" Type="fibula"/>
        <Att Name="fibula, right" Type="fibula"/>
        <Att Name="meniscus, left" Type="meniscus"/>
        <Att Name="meniscus, right" Type="meniscus"/>
        <Att Name="patella, left" Type="patella"/>
        <Att Name="patella, right" Type="patella"/>
        <Att Name="patella cartilage element, left" Type="patella cartilage element"/>
        <Att Name="patella cartilage element, right" Type="patella cartilage element"/>
        <Att Name="patellar ligament, left" Type="patellar ligament"/>
        <Att Name="patellar ligament, right" Type="patellar ligament"/>
        <Att Name="posterior cruciate ligament, left" Type="posterior cruciate ligament"/>
        <Att Name="posterior cruciate ligament, right" Type="posterior cruciate ligament"/>
        <Att Name="quadriceps tendon, left" Type="quadriceps tendon"/>
        <Att Name="quadriceps tendon, right" Type="quadriceps tendon"/>
        <Att Name="quadriceps femoris, left" Type="quadriceps femoris"/>
        <Att Name="quadriceps femoris, right" Type="quadriceps femoris"/>
        <Att Name="tibia, left" Type="tibia"/>
        <Att Name="tibia, right" Type="tibia"/>
      </InstancedAttributes>
    </View>
    -->

    <!-- ... or allow user to choose organs?  -->
    <View Type="Attribute" Title="Organs">
      <AttributeTypes>
        <Att Type="organ"/>
      </AttributeTypes>
    </View>

    <View Type="Attribute" Title="Relations">
      <AttributeTypes>
        <Att Type="adhesion"/>
        <Att Type="sliding contact"/>
      </AttributeTypes>
    </View>

    <View Type="Attribute" Title="Landmarks">
      <AttributeTypes>
        <Att Type="point landmark">
          <ItemViews>
            <View Item="location" Type="Point" ShowControls="true"/>
          </ItemViews>
        </Att>
        <Att Type="line landmark">
          <ItemViews>
            <View Item="points" Type="Line" Point1="point 1" Point2="point 2" ShowControls="true"/>
          </ItemViews>
        </Att>
      </AttributeTypes>
    </View>

    <View Type="Attribute" Title="Materials">
      <AttributeTypes>
        <Att Type="material"/>
      </AttributeTypes>
    </View>

    <View Type="Attribute" Title="Fields">
      <AttributeTypes>
        <Att Type="cauchy-green deformation tensor"/>
      </AttributeTypes>
    </View>

  </Views>
</SMTK_AttributeResource>
