#!/bin/sh

# Install build requirements.
dnf install -y \
    zlib-devel libcurl-devel python-devel python-unversioned-command \
    freeglut-devel glew-devel graphviz-devel libpng-devel mesa-dri-drivers \
    libxcb libxcb-devel libXext-devel libXt-devel xcb-util xcb-util-devel \
    xcb-util-wm-devel xcb-util-image-devel mesa-libGL-devel libxkbcommon-devel \
    libxkbcommon-x11-devel xcb-util-keysyms-devel xcb-util-renderutil-devel \
    diffutils hostname file

# fontconfig installed as work-around for occt, should be fixed upstream
# see https://dev.opencascade.org/index.php?q=node/1295
dnf install -y \
    fontconfig-devel

# Install development tools
dnf install -y \
    gcc-c++ \
    cmake \
    git-core \
    git-lfs \
    ninja-build \
    make \
    which

# Install memcheck and lint tools
dnf install -y \
    clang-tools-extra \
    libasan \
    libubsan \
    valgrind

dnf clean all
