<?xml version="1.0"?>
<SMTK_AttributeResource Version="3">
  <Definitions>
    <AttDef Type="ace3p-export" BaseType="operation" Label="Export to ACE3P" Version="2">
      <!-- Version 2 adds option for NEWT Session ID -->
      <BriefDescription>
        Write ACE3P input file for selected program.
      </BriefDescription>
      <DetailedDescription>
      </DetailedDescription>
      <ItemDefinitions>
        <Resource Name="model" Label="Model" LockType="DoNotLock">
          <Accepts>
            <Resource Name="smtk::model::Resource" />
          </Accepts>
        </Resource>
        <Resource Name="attributes" Label="Attributes" LockType="DoNotLock">
          <Accepts>
            <Resource Name="smtk::attribute::Resource"/>
          </Accepts>
        </Resource>
        <File Name="MeshFile" Label="Mesh File" ShouldExist="True"
          FileFilters="Exodus files (*.exo *.ex2 *.gen);;NetCDf files (*.ncdf);; All files (*.*)" Version="0"/>
        <String Name="Analysis" Label="ACE3P Analysis" Version="0">
          <ChildrenDefinitions>
            <Directory Name="OutputFolder" Label="Export Folder" Version="0">
              <BriefDescription>The folder to use on the local filesystem</BriefDescription>
            </Directory>
            <String Name="OutputFilePrefix" Label="Filename prefix" Version="0">
              <BriefDescription>The prefix to use for generated files</BriefDescription>
            </String>
            <String Name="AcdtoolTask" Label="Acdtool Task" Version="0">
              <ChildrenDefinitions>
                <String Name="AcdtoolMesh" Label="Mesh Task" Version="0">
                  <ChildrenDefinitions>
                    <String Name="OutputFilename" Label="Output filename" Version="0">
                      <BriefDescription>Filename for the generated .ncdf file</BriefDescription>
                      <DefaultValue>outputmesh.ncdf</DefaultValue>
                    </String>
                  </ChildrenDefinitions>
                  <DiscreteInfo>
                    <Value Enum="Stats">stats</Value>
                    <Value Enum="Check">check</Value>
                    <Structure>
                      <Value Enum="Fix">fix</Value>
                      <Items>
                        <Item>OutputFilename</Item>
                      </Items>
                    </Structure>
                  </DiscreteInfo>
                </String>
              </ChildrenDefinitions>
              <DiscreteInfo>
                <Value Enum="meshconvert">meshconvert</Value>
                <Structure>
                  <Value Enum="mesh">mesh</Value>
                  <Items>
                    <Item>AcdtoolMesh</Item>
                  </Items>
                </Structure>
                <!--
                <Value Enum="postprocess">postprocess</Value>
              -->
              </DiscreteInfo>
            </String>
          </ChildrenDefinitions>
          <DiscreteInfo>
            <Value Enum="">none</Value>
            <Structure>
              <Value Enum="Acdtool">acdtool</Value>
              <Items>
                <Item>AcdtoolTask</Item>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Omega3P">omega3p</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="S3P">s3p</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="T3P">t3p</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Track3P">track3p</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="TEM3P Eigenmode">tem3p-eigen</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="TEM3P Elastic">tem3p-structure</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="TEM3P Harmonic Response">tem3p-harmonic</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="TEM3P Thermal Linear">tem3p-thermal-linear</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="TEM3P Thermal Nonlinear">tem3p-thermal-nonlinear</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="TEM3P ThermoElastic">tem3p-thermo-elastic</Value>
              <Items>
                <Item>OutputFolder</Item>
                <Item>OutputFilePrefix</Item>
              </Items>
            </Structure>
          </DiscreteInfo>
        </String>
        <Directory Name="ProjectFolder" Label="Project Folder" AdvanceLevel="1"
                   Optional="true" IsEnabledByDefault="false" Version="0">
          <BriefDescription>The project root folder on the local filesystem</BriefDescription>
        </Directory>

        <Group Name="NERSCSimulation" Label="Submit job to NERSC"
               Optional="true" IsEnabledByDefault="false"
               Version="1" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <String Name="JobName" Label="Job name" Version="0">
              <BriefDescription>Label you can use to track your job</BriefDescription>
              <DefaultValue>ACE3P</DefaultValue>
            </String>
            <String Name="JobNotes" Label="Notes" Version="0" MultipleLines="true">
              <BriefDescription>Optional notes you want to save with this job</BriefDescription>
              <DefaultValue> </DefaultValue>
            </String>
            <String Name="CumulusHost" Label="Cumulus host" Version="0">
              <!-- DefaultValue>http://localhost:8080</DefaultValue
                -->
              <DefaultValue>https://ace3p.kitware.com</DefaultValue>
            </String>
            <String Name="NERSCRepository" Label="Project repository" Version="0" />

            <String Name="NERSCCredentials" Label="NERSC Credentials" Version="0">
              <ChildrenDefinitions>
                <String Name="NEWTSessionId" Label="NEWT Session ID" Version="0" />
                <String Name="NERSCAccountName" Label="NERSC Account name" Version="0" />
                <String Name="NERSCAccountPassword" Label="Password"
                        Secure="true" Version="0" />
                <String Name="NERSCMultfactorToken" Label="Multifactor token" Version="0" />
              </ChildrenDefinitions>
              <DiscreteInfo DefaultIndex="0">
                <Structure>
                  <Value Enum="NEWT">newt_sessionid</Value>
                  <Items>
                    <Item>NEWTSessionId</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value Enum="Login">login</Value>
                  <Items>
                    <Item>NERSCAccountName</Item>
                    <Item>NERSCAccountPassword</Item>
                    <Item>NERSCMultfactorToken</Item>
                  </Items>
                </Structure>
              </DiscreteInfo>
            </String>
            <String Name="Machine" Label="NERSC Machine" Version="0">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Cori (Cray XC40)">cori</Value>
              </DiscreteInfo>
            </String>
            <Group Name="JobDirectory" Label="Job directory" Version="1" NumberOfRequiredGroups="1" Enabled="true">
              <BriefDescription>The working directory to use on the NERSC machine.</BriefDescription>
              <ItemDefinitions>
                <String Name="FileSystem" Label="File System" Version="0">
                  <ChildrenDefinitions>
                    <String Name="SubFolder" Label="Subfolder"  Version="0">
                      <BriefDescription>Relative path from user's $SCRATCH directory</BriefDescription>
                    </String>
                    <Void Name="AppendJobNameFolder" Label="Append Job Name Folder" Version="0"
                      Optional="true" IsEnabledByDefault="true">
                      <BriefDescription>Adds a folder with the job name to the specified path</BriefDescription>
                    </Void>
                    <String Name="FullPath" Label="Full Path"  Version="0">
                      <BriefDescription>Absolute path on NERSC machine</BriefDescription>
                    </String>
                  </ChildrenDefinitions>
                  <DiscreteInfo DefaultIndex = "0">
                    <Structure>
                      <Value Enum="$SCRATCH">scratch</Value>
                      <Items>
                        <Item>SubFolder</Item>
                        <Item>AppendJobNameFolder</Item>
                      </Items>
                    </Structure>
                    <Structure>
                      <Value Enum="Other">other</Value>
                      <Items>
                        <Item>FullPath</Item>
                      </Items>
                    </Structure>
                  </DiscreteInfo>
                </String>
              </ItemDefinitions>
            </Group>
            <String Name="Queue" Label="Queue" Version="0">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="debug">debug</Value>
                <Value Enum="regular">normal</Value>
                <Value Enum="premium">premium</Value>
                <Value Enum="low priority">low</Value>
                <Value Enum="scavenger">scavenger</Value>
              </DiscreteInfo>
            </String>
            <Int Name="NumberOfNodes" Label="Number of nodes" Version="0">
              <DefaultValue>1</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>
            <!--  Note that SLAC calls this number of "cores" -->
            <Int Name="NumberOfTasks" Label="Number of cores" Version="0">
              <BriefDescription>Number of processes per node</BriefDescription>
              <DefaultValue>1</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>
            <Int Name="Timeout" Label="Time limit" Units="min" Version="0">
              <DefaultValue>5</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>
<!--             <String Name="TailFile" Label="Tail Filename" Version="0" AdvanceLevel="1">
            </String>
 -->          </ItemDefinitions>
        </Group>

        <Group Name="AWSSimulation" Label="Specify AWS Job (Experimental)" AdvanceLevel="1"
               Optional="true" IsEnabledByDefault="false"
               Version="1" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <String Name="JobName" Label="Job name" Version="0">
              <BriefDescription>Label you can use to track your job</BriefDescription>
              <DefaultValue>ACE3P</DefaultValue>
            </String>
            <String Name="JobNotes" Label="Notes" Version="0" MultipleLines="true">
              <BriefDescription>Optional notes you want to save with this job</BriefDescription>
              <DefaultValue> </DefaultValue>
            </String>
            <File Name="AWSConfigFile" Label="AWS Config File" ShouldExist="true" Version="0">
              <BriefDescription>AWS ParallelCluster config file to use as a template</BriefDescription>
            </File>
            <String Name="ClusterSection" Label="Cluster Section">
              <DefaultValue>cluster default</DefaultValue>
            </String>
            <String Name="InstanceType" Label="AWS Instance Family">
              <ChildrenDefinitions>
                <String Name="c4" Label="Instance Type">
                  <DiscreteInfo>
                    <Value Enum="c4.large (2 vCPU, 3.75 GB, 500 Mbps)">c4.large</Value>
                    <Value Enum="c4.xlarge (4 vCPU, 7.5 GB, 750 Mbps)">c4.xlarge</Value>
                    <Value Enum="c4.2xlarge (8 vCPU, 15 GB, 1000 Mbps)">c4.2xlarge</Value>
                    <Value Enum="c4.4xlarge (16 vCPU, 30 GB, 2000 Mbps)">c4.4xlarge</Value>
                    <Value Enum="c4.8xlarge (36 vCPU, 60 GB, 4000 Mbps)">c4.8xlarge</Value>
                  </DiscreteInfo>
                </String>
                <String Name="c5" Label="Instance Type">
                  <DiscreteInfo>
                    <Value Enum="c5.large (2 vCPU, 4 GB, Up to 10 Gbps)">c5.large</Value>
                    <Value Enum="c5.xlarge (4 vCPU, 8 GB, Up to 10 Gbps)">c5.xlarge</Value>
                    <Value Enum="c5.2xlarge (8 vCPU, 16 GB, Up to 10 Gbps)">c5.2xlarge</Value>
                    <Value Enum="c5.4xlarge (16 vCPU, 32 GB, Up to 10 Gbps)">c5.4xlarge</Value>
                    <Value Enum="c5.9xlarge (36 vCPU, 72 GB, 10 Gbps)">c5.9xlarge</Value>
                    <Value Enum="c5.12xlarge (48 vCPU, 96 GB, 12 Gbps)">c5.12xlarge</Value>
                    <Value Enum="c5.18xlarge (72 vCPU, 144 GB, 25 Gbps)">c5.18xlarge</Value>
                    <Value Enum="c5.24xlarge (96 vCPU, 192 GB, 25 Gbps)">c5.24xlarge</Value>
                  </DiscreteInfo>
                </String>
                <String Name="c5n" Label="Instance Type">
                  <ChildrenDefinitions>
                    <Void Name="ElasticFabricAdapter" Label="Use Elastic Fabric Adapter (EFA)"
                          Optional="true" IsEnabledByDefault="false" />
                  </ChildrenDefinitions>
                  <DiscreteInfo>
                    <Value Enum="c5n.large (2 vCPU, 5.25 GB, Up to 25 Gbps)">c5n.large</Value>
                    <Value Enum="c5n.xlarge (4 vCPU, 10.5 GB, Up to 25 Gbps)">c5n.xlarge</Value>
                    <Value Enum="c5n.2xlarge (8 vCPU, 21 GB, Up to 25 Gbps)">c5n.2xlarge</Value>
                    <Value Enum="c5n.4xlarge (16 vCPU, 42 GB, Up to 25 Gbps)">c5n.4xlarge</Value>
                    <Value Enum="c5n.9xlarge (36 vCPU, 96 GB, 50 Gbps)">c5n.9xlarge</Value>
                    <Structure>
                      <Value Enum="c5n.18xlarge (72 vCPU, 192 GB, 100 Gbps)">c5n.18xlarge</Value>
                      <Items>
                        <Item>ElasticFabricAdapter</Item>
                      </Items>
                    </Structure>
                  </DiscreteInfo>
                </String>
                <String Name="t2" Label="Instance Type">
                  <DiscreteInfo>
                    <Value Enum="t2.micro (1 vCPU, 1 GB)">t2.micro</Value>
                    <Value Enum="t2.large (2 vCPU, 8 GB)">t2.large</Value>
                    <Value Enum="t2.xlarge (4 vCPU, 16GB)">t2.xlarge</Value>
                    <Value Enum="t2.2xlarge (8 vCPU, 32GB)">t2.2xlarge</Value>
                  </DiscreteInfo>
                </String>
                <String Name="t3" Label="Instance Type">
                  <DiscreteInfo>
                    <Value Enum="t3.large (2 vCPU, 8 GB)">t3.large</Value>
                    <Value Enum="t3.xlarge (4 vCPU, 16GB)">t3.xlarge</Value>
                    <Value Enum="t3.2xlarge (8 vCPU, 32GB)">t3.2xlarge</Value>
                  </DiscreteInfo>
                </String>
                <String Name="t3a" Label="Instance Type">
                  <DiscreteInfo>
                    <Value Enum="t3a.large (2 vCPU, 8 GB)">t3a.large</Value>
                    <Value Enum="t3a.xlarge (4 vCPU, 16GB)">t3a.xlarge</Value>
                    <Value Enum="t3a.2xlarge (8 vCPU, 32GB)">t3a.2xlarge</Value>
                  </DiscreteInfo>
                </String>
                <String Name="OtherType" Label="Other" />
              </ChildrenDefinitions>
              <DiscreteInfo>
                <Structure>
                  <Value>c4</Value>
                  <Items>
                    <Item>c4</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value>c5</Value>
                  <Items>
                    <Item>c5</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value>c5n</Value>
                  <Items>
                    <Item>c5n</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value>t2</Value>
                  <Items>
                    <Item>t2</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value>t3</Value>
                  <Items>
                    <Item>t3</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value>t3a</Value>
                  <Items>
                    <Item>t3a</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value>Other</Value>
                  <Items>
                    <Item>OtherType</Item>
                  </Items>
                </Structure>
              </DiscreteInfo>
            </String>
            <Int Name="NumberOfNodes" Label="Number of nodes" Version="0">
              <DefaultValue>1</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>
            <Int Name="Timeout" Label="Time limit" Units="min" Version="0">
              <DefaultValue>5</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>

          </ItemDefinitions>
        </Group>

      </ItemDefinitions>
     </AttDef>

   </Definitions>
  <Views>
    <View Type="Instanced" Title="Export Settings" TopLevel="true" FilterByCategory="false" FilterByAdvanceLevel="true">
      <InstancedAttributes>
        <Att Name="Options" Type="ace3p-export" />
      </InstancedAttributes>
    </View>
  </Views>
</SMTK_AttributeResource>
