/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkmFeatureAnalysis.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkPExtractGrid
 * @brief   Extract VOI and/or sub-sample a distributed
 *  structured dataset.
 *
 *
 *  vtkmFeatureAnalysis inherits from vtkExtractVOI and provides additional
 *  functionality when dealing with a distributed dataset. Specifically, when
 *  sub-sampling a dataset, a gap may be introduced between partitions. This
 *  filter handles such cases correctly by growing the grid to the right to
 *  close the gap.
 *
 * @sa
 *  vtkExtractVOI
 */

#ifndef vtkmFeatureAnalysis_h
#define vtkmFeatureAnalysis_h

#include "vtkDataSetAlgorithm.h"
#include "vtkAcceleratorsVTKmFiltersMPIModule.h" //required for correct implementation

// Forward Declarations
class vtkInformation;
class vtkInformationVector;
class vtkMPIController;
class vtkMPIController;

class VTKACCELERATORSVTKMFILTERSMPI_EXPORT vtkmFeatureAnalysis : public vtkDataSetAlgorithm
{
public:
  static vtkmFeatureAnalysis* New();
  vtkTypeMacro(vtkmFeatureAnalysis, vtkDataSetAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  vtkSetVector2Macro(FeatureGaussian, double);
  vtkGetVectorMacro(FeatureGaussian, double, 2);

  vtkSetVector3Macro(ClusterBlockSize, int);
  vtkGetVectorMacro(ClusterBlockSize, int, 3);

  vtkSetVector3Macro(HistDims, int);
  vtkGetVectorMacro(HistDims, int, 3);


protected:
  vtkmFeatureAnalysis();
  ~vtkmFeatureAnalysis() override;

  // Standard VTK Pipeline methods
  int RequestData(vtkInformation*, vtkInformationVector**,
                  vtkInformationVector*) override;
  int FillOutputPortInformation(int port, vtkInformation* info) override;

private:
  vtkmFeatureAnalysis(const vtkmFeatureAnalysis&) = delete;
  void operator=(const vtkmFeatureAnalysis&) = delete;
  // mean, stddev of target feature
  double FeatureGaussian[2];
  // X, Y, Z
  int ClusterBlockSize[3];
  // Histogram bins/output field dimension
  int HistDims[3];
  vtkMPIController* Controller;
};

#endif
