import vtk
try:
    # Not directly used here, but if it's not imported when VTK_USE_MPI, we get following error:
    # Attempting to use an MPI routine before initializing MPICH
    from mpi4py import MPI
except ImportError:
    pass

controller = vtk.vtkMPIController()
controller.Initialize()
vtk.vtkMultiProcessController.SetGlobalController(controller)
if controller.GetLocalProcessId() == 0:
    print("Feature analyis for {} ranks".format(controller.GetNumberOfProcesses()))


reader = vtk.vtkUnstructuredGridReader()
reader.SetFileName("/home/danlipsa/projects/stat_feature_detect_vtkm/src/data/fcc_legacy_400.vtk")
reader.Update()

data = vtk.vtkPolyData()
data.SetPoints(reader.GetOutput().GetPoints())

distribute = vtk.vtkDistributedPointCloudFilter()
distribute.SetInputData(data)

fa = vtk.vtkmFeatureAnalysis()
fa.SetHistDims(128, 16, 128)
fa.SetClusterBlockSize(8, 8, 8)
fa.SetFeatureGaussian(2.5, 10)
fa.SetInputConnection(distribute.GetOutputPort())

writer = vtk.vtkXMLPartitionedDataSetWriter()
writer.SetInputConnection(fa.GetOutputPort())
writer.SetFileName("./out_sim_field.pvtp")
writer.Write()

controller.Finalize()
