//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2012 Sandia Corporation.
//  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
//  the U.S. Government retains certain rights in this software.
//
//=============================================================================

// To run in Darwin: /projects/opt/x86_64/openmpi/3.1.6-gcc_7.4.0/bin/mpiexec "-n" "4" "/home/sdutta/VTK_danlipsa_new/build/bin/vtkAcceleratorsVTKmFiltersMPICxxTests-MPI" "TestVTKMFeatureAnalysis"


#include "vtkmFeatureAnalysis.h"

#include "vtkMPIController.h"
#include "vtkUnstructuredGridReader.h"
#include "vtkUnstructuredGrid.h"
#include "vtkPolyData.h"
#include "vtkDistributedPointCloudFilter.h"
#include "vtkmFeatureAnalysis.h"
#include "vtkXMLPartitionedDataSetWriter.h"

#include "vtkImageData.h"
#include "vtkThreshold.h"
#include "vtkConnectivityFilter.h"
#include "vtkPointData.h"
#include <vtkPartitionedDataSet.h>
#include <vtkXMLImageDataWriter.h>

int TestVTKMFeatureAnalysis(int argc, char* argv[])
{
  vtkNew<vtkMPIController> controller;
  controller->Initialize(&argc, &argv, 0);
  vtkMultiProcessController::SetGlobalController(controller);
  if (controller->GetLocalProcessId() == 0)
  {
    std::cout << "Feature analysis for "
              << controller->GetNumberOfProcesses() << " ranks" << std::endl;
  }

  vtkNew<vtkUnstructuredGridReader> reader;
  reader->SetFileName("/home/sdutta/stat_feature_detect_vtkm_kitware/data/fcc_legacy_400.vtk");
  //reader->SetFileName("/Users/sdutta/Codes/stat_feature_detect_vtkm_kitware/data/fcc_legacy_400.vtk");
  reader->Update();

  // //Use VTK APIs to distribute points to each process. Currently not working as expected.
  //////////////////////////////////////////////////////////////////////////////////////////
  /*vtkNew<vtkPolyData> data;
  data->SetPoints(reader->GetOutput()->GetPoints());
  vtkNew<vtkDistributedPointCloudFilter> distribute;
  distribute->SetInputData(data);
  distribute->Update();*/


  //Divide data for ech processor to be distributed manually for now.
  int rank = controller->GetLocalProcessId();
  int numberOfProcessors = controller->GetNumberOfProcesses();
  int points_per_process = int(reader->GetOutput()->GetNumberOfPoints()/numberOfProcessors);
  vtkSmartPointer<vtkPolyData> data = vtkSmartPointer<vtkPolyData>::New();
  vtkSmartPointer<vtkPoints> localpts = vtkSmartPointer<vtkPoints>::New();
  int startIndex = 0;
  int endIndex = 0;
  if (rank<numberOfProcessors-1)
  {
    startIndex = rank*points_per_process;
    endIndex = (rank+1)*points_per_process;
  }
  else
  {
    startIndex = rank*points_per_process;
    endIndex = reader->GetOutput()->GetNumberOfPoints()-1;
  }
  //Populate data for each process
  for (int i=startIndex; i < endIndex; i++){
    localpts->InsertNextPoint(reader->GetOutput()->GetPoint(i));
  }
  data->SetPoints(localpts);

  std::cout<< "Rank: " << rank << " number of points: " << localpts->GetNumberOfPoints() <<std::endl;

  //Call the filter
  vtkNew<vtkmFeatureAnalysis> fa;
  fa->SetHistDims(128, 16, 128);
  fa->SetClusterBlockSize(8, 8, 8);
  fa->SetFeatureGaussian(2.5, 10);
  //fa->SetInputConnection(distribute->GetOutputPort());
  fa->SetInputData(data);
  fa->Update();

  vtkPartitionedDataSet* outdata = vtkPartitionedDataSet::SafeDownCast(fa->GetOutputDataObject(0));
  if (controller->GetLocalProcessId() == 0)
  {
    vtkImageData* similarity = vtkImageData::SafeDownCast(outdata->GetPartition(0));

    double* range1 = similarity->GetPointData()->GetArray("ClusterIds")->GetRange();
    //std::cout<<range1[0]<<" "<<range1[1]<<std::endl;
    //Assert the number of clusters
    if (range1[1] != 511)
    {
      std::cerr << "Output produced wrong number of clusters!" << std::endl;
      exit(EXIT_FAILURE);
    }

    double* range2 = similarity->GetPointData()->GetArray("density")->GetRange();
    //std::cout<<range2[0]<<" "<<range2[1]<<std::endl;
    //Assert range of density values for histogram based density estimation
    if (range2[0] != 0 && range2[1] != 28)
    {
      std::cerr << "Output produced wrong density estimation!" << std::endl;
      exit(EXIT_FAILURE);
    }


    //Do threshold and connectivity to find out number of segments for verification
    vtkSmartPointer<vtkThreshold> thresholding = vtkSmartPointer<vtkThreshold>::New();
    thresholding->SetInputData(similarity);
    //thresholding->ThresholdByLower(2.0);
    thresholding->SetThresholdFunction(1);
    thresholding->SetLowerThreshold(2.0);
    thresholding->SetInputArrayToProcess(0, 0, 0,
                                          "vtkDataObject::FIELD_ASSOCIATION_POINTS",
                                          "feature_similarity");
    vtkSmartPointer<vtkConnectivityFilter> segmentation = vtkSmartPointer<vtkConnectivityFilter>::New();
    segmentation->SetInputConnection(thresholding->GetOutputPort());
    segmentation->SetExtractionModeToAllRegions();
    segmentation->ColorRegionsOn();
    segmentation->Update();

    //Assert number of segmented regions. With the test data, it should produce 25 segments.
    if (segmentation->GetNumberOfExtractedRegions() != 40)
    {
      std::cerr << "Wrong number of segmented regions produced!" << std::endl;
      exit(EXIT_FAILURE);
    }

  }

  // Write the output dataset
  vtkNew<vtkXMLPartitionedDataSetWriter> writer;
  writer->SetInputDataObject(outdata);
  writer->SetFileName("./out_sim_field.pvti");
  writer->Write();

  controller->Finalize();

  return 0;
}
