/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.layering;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLViewportNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseFixedViewport
extends AbstractNode
implements VRMLViewportNodeType {
    private static final int FIELD_X = 1;
    private static final int FIELD_Y = 2;
    private static final int FIELD_WIDTH = 3;
    private static final int FIELD_HEIGHT = 4;
    private static final int NUM_FIELDS = 5;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected int vfX;
    protected int vfY;
    protected int vfWidth;
    protected int vfHeight;

    protected BaseFixedViewport() {
        super("FixedViewport");
        this.hasChanged = new boolean[5];
    }

    protected BaseFixedViewport(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public int getViewportType() {
        return 3;
    }

    public boolean isFixedX() {
        return true;
    }

    public boolean isFixedY() {
        return true;
    }

    public boolean isFixedWidth() {
        return true;
    }

    public boolean isFixedHeight() {
        return true;
    }

    public float getViewX() {
        return this.vfX;
    }

    public float getViewY() {
        return this.vfY;
    }

    public float getViewWidth() {
        return this.vfWidth;
    }

    public float getViewHeight() {
        return this.vfHeight;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return fieldDecl[n];
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getNumFields() {
        return 5;
    }

    public int getPrimaryType() {
        return 92;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.intValue = this.vfX;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 2: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.intValue = this.vfY;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 3: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.intValue = this.vfWidth;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 4: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.intValue = this.vfHeight;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldAccessException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "x");
                }
                this.vfX = n2;
                break;
            }
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "y");
                }
                this.vfY = n2;
                break;
            }
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "width");
                }
                this.vfWidth = n2;
                break;
            }
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "height");
                }
                this.vfHeight = n2;
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseFixedViewport.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseFixedViewport.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFInt32", "x");
        BaseFixedViewport.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFInt32", "y");
        BaseFixedViewport.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFInt32", "width");
        BaseFixedViewport.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFInt32", "height");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("x", new Integer(1));
        fieldMap.put("y", new Integer(2));
        fieldMap.put("width", new Integer(3));
        fieldMap.put("height", new Integer(4));
    }
}

