/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkVectorText.cc
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


Copyright (c) 1993-1996 Ken Martin, Will Schroeder, Bill Lorensen.

This software is copyrighted by Ken Martin, Will Schroeder and Bill Lorensen.
The following terms apply to all files associated with the software unless
explicitly disclaimed in individual files. This copyright specifically does
not apply to the related textbook "The Visualization Toolkit" ISBN
013199837-4 published by Prentice Hall which is covered by its own copyright.

The authors hereby grant permission to use, copy, and distribute this
software and its documentation for any purpose, provided that existing
copyright notices are retained in all copies and that this notice is included
verbatim in any distributions. Additionally, the authors grant permission to
modify this software and its documentation for any purpose, provided that
such modifications are not distributed without the explicit consent of the
authors and that existing copyright notices are retained in all copies. Some
of the algorithms implemented by this software are patented, observe all
applicable patent law.

IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN
"AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE
MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.


=========================================================================*/
#include "vtkVectorText.hh"
#include "vtkFloatPoints.hh"
#include "vtkTransformPolyFilter.hh"
#include "vtkPolyReader.hh"

char *VTK_VECTOR_TEXT_0 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 64 float\n"
"0.179993 11.240000 0.000000 0.000000 14.350000 0.000000 \n"
"0.199982 17.680000 0.000000 0.679993 8.449980 0.000000 \n"
"0.769989 20.730000 0.000000 1.500000 6.000000 0.000000 \n"
"1.669980 23.459999 0.000000 2.599980 3.919980 0.000000 \n"
"2.889980 25.799999 0.000000 3.970000 2.250000 0.000000 \n"
"4.380000 27.709999 0.000000 5.269990 15.010000 0.000000 \n"
"5.340000 11.850000 0.000000 5.549990 9.120000 0.000000 \n"
"5.590000 1.019990 0.000000 5.889980 6.799990 0.000000 \n"
"6.370000 4.910000 0.000000 6.989990 3.440000 0.000000 \n"
"7.429990 0.259979 0.000000 7.739990 2.389980 0.000000 \n"
"8.630000 1.759980 0.000000 9.479980 0.000000 0.000000 \n"
"9.660000 1.549990 0.000000 10.730000 1.769990 0.000000 \n"
"11.640000 0.290009 0.000000 11.660000 2.419980 0.000000 \n"
"12.440000 3.509980 0.000000 13.090000 5.030000 0.000000 \n"
"13.580000 1.139980 0.000000 13.580000 7.000000 0.000000 \n"
"13.940000 9.419980 0.000000 14.150000 12.280000 0.000000 \n"
"15.280000 2.509980 0.000000 14.220000 15.590000 0.000000 \n"
"5.340000 18.270000 0.000000 5.539980 21.080000 0.000000 \n"
"5.880000 23.430000 0.000000 6.109990 29.129999 0.000000 \n"
"6.359990 25.350000 0.000000 6.979980 26.820000 0.000000 \n"
"7.739990 27.870001 0.000000 8.060000 30.030001 0.000000 \n"
"8.649990 28.490000 0.000000 9.699980 28.700001 0.000000 \n"
"10.190000 30.340000 0.000000 10.740000 28.480000 0.000000 \n"
"11.640000 27.840000 0.000000 12.180000 30.070000 0.000000 \n"
"12.420000 26.780001 0.000000 13.060000 25.320000 0.000000 \n"
"13.560000 23.450001 0.000000 13.970000 29.299999 0.000000 \n"
"13.920000 21.209999 0.000000 14.150000 18.580000 0.000000 \n"
"15.550000 28.049999 0.000000 16.719999 4.370000 0.000000 \n"
"16.889999 26.360001 0.000000 17.879999 6.679990 0.000000 \n"
"17.980000 24.270000 0.000000 18.740000 9.399990 0.000000 \n"
"18.780001 21.820000 0.000000 19.260000 12.500000 0.000000 \n"
"19.280001 19.030001 0.000000 19.450001 15.950000 0.000000 \n"

"POLYGONS 64 256\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 9 12 13 \n"
"3 9 13 14 \n"
"3 14 13 15 \n"
"3 14 15 16 \n"
"3 14 16 17 \n"
"3 14 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 18 20 21 \n"
"3 21 20 22 \n"
"3 21 22 23 \n"
"3 21 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 24 26 27 \n"
"3 24 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 28 30 31 \n"
"3 28 31 32 \n"
"3 32 31 33 \n"
"3 10 34 11 \n"
"3 34 10 35 \n"
"3 35 10 36 \n"
"3 36 10 37 \n"
"3 36 37 38 \n"
"3 38 37 39 \n"
"3 39 37 40 \n"
"3 40 37 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 43 41 44 \n"
"3 43 44 45 \n"
"3 45 44 46 \n"
"3 46 44 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 49 47 50 \n"
"3 50 47 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 53 51 33 \n"
"3 33 51 32 \n"
"3 32 51 54 \n"
"3 32 54 55 \n"
"3 55 54 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 57 58 59 \n"
"3 59 58 60 \n"
"3 59 60 61 \n"
"3 61 60 62 \n"
"3 61 62 63 \n"
;

char *VTK_VECTOR_TEXT_1 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 40 float\n"
"0.000000 28.780001 0.000000 0.660004 27.500000 0.000000 \n"
"0.000000 27.500000 0.000000 0.750000 28.830000 0.000000 \n"
"1.190000 27.500000 0.000000 2.090010 27.469999 0.000000 \n"
"2.820010 27.379999 0.000000 3.810000 26.930000 0.000000 \n"
"4.870010 29.090000 0.000000 4.290010 26.040001 0.000000 \n"
"4.430010 24.580000 0.000000 0.350006 0.000000 0.000000 \n"
"0.350006 1.370000 0.000000 1.150010 1.370000 0.000000 \n"
"2.030000 1.440000 0.000000 2.050000 0.100006 0.000000 \n"
"2.740010 1.580020 0.000000 3.480010 0.149994 0.000000 \n"
"3.750000 2.179990 0.000000 4.070010 2.660000 0.000000 \n"
"4.280000 3.290010 0.000000 4.430010 5.050020 0.000000 \n"
"4.980010 0.170013 0.000000 4.390000 4.080020 0.000000 \n"
"6.910000 0.170013 0.000000 8.830000 0.170013 0.000000 \n"
"9.520000 5.130000 0.000000 9.520000 29.580000 0.000000 \n"
"9.540010 4.060000 0.000000 9.640000 3.200010 0.000000 \n"
"9.820010 2.540010 0.000000 10.110000 2.060000 0.000000 \n"
"10.330000 0.149994 0.000000 10.530000 1.720000 0.000000 \n"
"11.110000 1.510010 0.000000 11.760000 0.100006 0.000000 \n"
"11.850000 1.399990 0.000000 12.800000 1.370000 0.000000 \n"
"13.460000 0.000000 0.000000 13.460000 1.370000 0.000000 \n"

"POLYGONS 38 152\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 5 3 6 \n"
"3 6 3 7 \n"
"3 7 3 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 11 12 13 \n"
"3 11 13 14 \n"
"3 11 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 17 19 20 \n"
"3 21 10 8 \n"
"3 21 8 22 \n"
"3 21 22 23 \n"
"3 23 22 20 \n"
"3 20 22 17 \n"
"3 8 24 22 \n"
"3 24 8 25 \n"
"3 25 8 26 \n"
"3 26 8 27 \n"
"3 25 26 28 \n"
"3 25 28 29 \n"
"3 25 29 30 \n"
"3 25 30 31 \n"
"3 25 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 32 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 38 37 39 \n"
;

char *VTK_VECTOR_TEXT_2 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 52 float\n"
"4.909990 4.870000 0.000000 4.579990 7.200010 0.000000 \n"
"5.860000 8.820010 0.000000 7.310000 7.630000 0.000000 \n"
"7.390000 10.720000 0.000000 8.649990 12.270000 0.000000 \n"
"8.849990 9.160000 0.000000 9.629990 13.500000 0.000000 \n"
"10.390000 14.470000 0.000000 10.800000 10.980000 0.000000 \n"
"10.960000 15.230000 0.000000 12.440000 17.629999 0.000000 \n"
"13.100000 19.370001 0.000000 13.190000 13.150000 0.000000 \n"
"13.330000 21.209999 0.000000 14.510000 14.410000 0.000000 \n"
"0.970001 22.670000 0.000000 0.610001 22.670000 0.000000 \n"
"1.409990 28.340000 0.000000 2.970000 23.969999 0.000000 \n"
"3.649990 28.950001 0.000000 5.000000 24.930000 0.000000 \n"
"5.689990 29.379999 0.000000 7.000000 25.530001 0.000000 \n"
"7.610000 29.629999 0.000000 8.899990 25.730000 0.000000 \n"
"9.470000 29.719999 0.000000 9.879990 25.650000 0.000000 \n"
"10.750000 25.410000 0.000000 11.450000 29.580000 0.000000 \n"
"11.500000 25.020000 0.000000 12.140000 24.500000 0.000000 \n"
"12.650000 23.850000 0.000000 13.020000 23.080000 0.000000 \n"
"13.220000 29.190001 0.000000 13.250000 22.200001 0.000000 \n"
"14.760000 28.549999 0.000000 15.630000 15.610000 0.000000 \n"
"16.059999 27.680000 0.000000 16.549999 16.750000 0.000000 \n"
"17.110001 26.610001 0.000000 17.280001 17.860001 0.000000 \n"
"17.870001 25.330000 0.000000 18.209999 20.030001 0.000000 \n"
"18.350000 23.860001 0.000000 18.510000 22.230000 0.000000 \n"
"0.000000 0.000000 0.000000 1.209990 2.320010 0.000000 \n"
"2.629990 4.560000 0.000000 3.519990 5.799990 0.000000 \n"
"19.350000 0.000000 0.000000 19.350000 4.870000 0.000000 \n"

"POLYGONS 50 200\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 3 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 6 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 9 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 16 17 18 \n"
"3 16 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 21 20 22 \n"
"3 21 22 23 \n"
"3 23 22 24 \n"
"3 23 24 25 \n"
"3 25 24 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 28 26 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 31 29 32 \n"
"3 32 29 33 \n"
"3 33 29 34 \n"
"3 33 34 35 \n"
"3 35 34 14 \n"
"3 14 34 15 \n"
"3 15 34 36 \n"
"3 15 36 37 \n"
"3 37 36 38 \n"
"3 37 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 46 47 48 \n"
"3 46 48 49 \n"
"3 46 49 1 \n"
"3 46 1 0 \n"
"3 46 0 50 \n"
"3 50 0 51 \n"
;

char *VTK_VECTOR_TEXT_3 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 84 float\n"
"0.710007 1.149990 0.000000 0.000000 7.700010 0.000000 \n"
"1.020000 7.790010 0.000000 1.660000 6.420010 0.000000 \n"
"2.420000 5.209990 0.000000 3.280000 4.160000 0.000000 \n"
"4.240010 3.290010 0.000000 4.259990 0.270020 0.000000 \n"
"5.289990 2.600010 0.000000 6.410000 2.090000 0.000000 \n"
"7.600010 1.780000 0.000000 8.009990 0.000000 0.000000 \n"
"8.850010 1.679990 0.000000 10.000000 1.810000 0.000000 \n"
"10.490000 0.170013 0.000000 11.060000 2.190000 0.000000 \n"
"12.020000 2.800020 0.000000 12.710000 0.679993 0.000000 \n"
"12.850000 3.610020 0.000000 13.530000 4.580020 0.000000 \n"
"14.040000 5.709990 0.000000 14.650000 1.510010 0.000000 \n"
"14.370000 6.970000 0.000000 14.480000 8.320010 0.000000 \n"
"1.020000 23.020000 0.000000 0.710007 23.200001 0.000000 \n"
"1.500000 29.090000 0.000000 3.160000 24.620001 0.000000 \n"
"3.560000 29.610001 0.000000 5.380000 25.780001 0.000000 \n"
"5.509990 29.969999 0.000000 7.610000 26.500000 0.000000 \n"
"9.340000 30.240000 0.000000 9.789990 26.740000 0.000000 \n"
"11.320000 30.129999 0.000000 11.580000 26.459999 0.000000 \n"
"12.980000 25.670000 0.000000 13.100000 29.799999 0.000000 \n"
"13.890000 24.450001 0.000000 14.210000 22.889999 0.000000 \n"
"14.660000 29.270000 0.000000 12.040000 17.360001 0.000000 \n"
"11.850000 18.879999 0.000000 12.680000 19.500000 0.000000 \n"
"13.340000 20.230000 0.000000 13.460000 17.809999 0.000000 \n"
"13.820000 21.040001 0.000000 14.110000 21.930000 0.000000 \n"
"14.730000 18.389999 0.000000 15.830000 19.090000 0.000000 \n"
"15.980000 28.549999 0.000000 16.750000 19.900000 0.000000 \n"
"17.040001 27.660000 0.000000 17.490000 20.809999 0.000000 \n"
"17.820000 26.600000 0.000000 18.020000 21.809999 0.000000 \n"
"18.299999 25.389999 0.000000 18.350000 22.900000 0.000000 \n"
"18.469999 24.040001 0.000000 6.460010 13.240000 0.000000 \n"
"7.840000 13.280000 0.000000 7.080000 13.240000 0.000000 \n"
"8.460010 17.709999 0.000000 9.289990 13.190000 0.000000 \n"
"9.730000 17.980000 0.000000 10.590000 12.940000 0.000000 \n"
"10.870000 18.370001 0.000000 11.730000 12.520000 0.000000 \n"
"12.690000 11.950000 0.000000 13.450000 11.230000 0.000000 \n"
"13.730000 16.870001 0.000000 14.010000 10.390000 0.000000 \n"
"14.360000 9.410000 0.000000 15.210000 16.230000 0.000000 \n"
"16.299999 2.630000 0.000000 16.469999 15.460000 0.000000 \n"
"17.510000 14.550000 0.000000 17.620001 4.030000 0.000000 \n"
"18.330000 13.510000 0.000000 18.590000 5.679990 0.000000 \n"
"18.920000 12.340000 0.000000 19.190001 7.560000 0.000000 \n"
"19.280001 11.050000 0.000000 19.400000 9.649990 0.000000 \n"

"POLYGONS 82 328\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 0 4 5 \n"
"3 0 5 6 \n"
"3 0 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 7 9 10 \n"
"3 7 10 11 \n"
"3 11 10 12 \n"
"3 11 12 13 \n"
"3 11 13 14 \n"
"3 14 13 15 \n"
"3 14 15 16 \n"
"3 14 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 17 19 20 \n"
"3 17 20 21 \n"
"3 21 20 22 \n"
"3 21 22 23 \n"
"3 24 25 26 \n"
"3 24 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 36 34 37 \n"
"3 36 37 38 \n"
"3 38 37 39 \n"
"3 39 37 40 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 41 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 45 47 48 \n"
"3 48 47 39 \n"
"3 48 39 40 \n"
"3 48 40 49 \n"
"3 49 40 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 51 52 53 \n"
"3 53 52 54 \n"
"3 53 54 55 \n"
"3 55 54 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 59 60 61 \n"
"3 60 59 62 \n"
"3 60 62 63 \n"
"3 63 62 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 65 66 67 \n"
"3 67 66 42 \n"
"3 67 42 41 \n"
"3 67 41 68 \n"
"3 68 41 69 \n"
"3 69 41 70 \n"
"3 69 70 71 \n"
"3 71 70 72 \n"
"3 72 70 23 \n"
"3 23 70 73 \n"
"3 23 73 21 \n"
"3 21 73 74 \n"
"3 74 73 75 \n"
"3 74 75 76 \n"
"3 74 76 77 \n"
"3 77 76 78 \n"
"3 77 78 79 \n"
"3 79 78 80 \n"
"3 79 80 81 \n"
"3 81 80 82 \n"
"3 81 82 83 \n"
;

char *VTK_VECTOR_TEXT_4 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 14 float\n"
"0.000000 7.440000 0.000000 0.000000 8.950010 0.000000 \n"
"3.319990 11.030000 0.000000 11.430000 7.440000 0.000000 \n"
"11.430000 11.030000 0.000000 11.430000 22.230000 0.000000 \n"
"15.590000 30.420000 0.000000 11.430000 0.000000 0.000000 \n"
"16.250000 0.000000 0.000000 16.250000 7.440000 0.000000 \n"
"16.250000 11.030000 0.000000 16.250000 30.420000 0.000000 \n"
"20.330000 7.440000 0.000000 20.330000 11.030000 0.000000 \n"

"POLYGONS 14 56\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 1 5 2 \n"
"3 5 1 6 \n"
"3 7 3 4 \n"
"3 7 4 5 \n"
"3 7 5 6 \n"
"3 7 6 8 \n"
"3 8 6 9 \n"
"3 9 6 10 \n"
"3 10 6 11 \n"
"3 10 12 9 \n"
"3 12 10 13 \n"
;

char *VTK_VECTOR_TEXT_5 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 53 float\n"
"1.640000 15.720000 0.000000 0.839996 15.680000 0.000000 \n"
"1.640000 29.540001 0.000000 2.480010 20.639999 0.000000 \n"
"2.500000 15.750000 0.000000 3.080000 15.760000 0.000000 \n"
"3.230010 20.639999 0.000000 3.900010 15.770000 0.000000 \n"
"4.930010 20.700001 0.000000 6.020000 20.730000 0.000000 \n"
"6.650010 15.660000 0.000000 8.950000 20.559999 0.000000 \n"
"9.030000 15.330000 0.000000 11.040000 14.800000 0.000000 \n"
"11.530000 20.049999 0.000000 12.680000 14.040000 0.000000 \n"
"13.760000 19.230000 0.000000 13.960000 13.080000 0.000000 \n"
"14.860000 11.900000 0.000000 15.410000 10.510000 0.000000 \n"
"15.620000 18.090000 0.000000 15.590000 8.899990 0.000000 \n"
"2.830000 25.240000 0.000000 17.090000 25.240000 0.000000 \n"
"17.230000 29.540001 0.000000 0.839996 6.549990 0.000000 \n"
"2.000000 0.920013 0.000000 0.000000 1.769990 0.000000 \n"
"2.710010 4.450010 0.000000 3.760010 0.369995 0.000000 \n"
"4.740010 2.920010 0.000000 5.470000 0.079987 0.000000 \n"
"6.890000 2.000000 0.000000 7.350010 0.000000 0.000000 \n"
"9.170000 1.679990 0.000000 9.820010 0.200012 0.000000 \n"
"10.460000 1.829990 0.000000 11.670000 2.250000 0.000000 \n"
"12.070000 0.779999 0.000000 12.760000 2.920010 0.000000 \n"
"13.710000 3.799990 0.000000 14.070000 1.720000 0.000000 \n"
"14.490000 4.870000 0.000000 15.080000 6.090000 0.000000 \n"
"15.460000 7.450010 0.000000 15.770000 2.980010 0.000000 \n"
"17.090000 16.660000 0.000000 17.150000 4.530000 0.000000 \n"
"18.170000 14.930000 0.000000 18.180000 6.350010 0.000000 \n"
"18.820000 12.940000 0.000000 18.820000 8.410000 0.000000 \n"
"19.040001 10.670000 0.000000 \n"
"POLYGONS 51 204\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 4 3 5 \n"
"3 5 3 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 7 9 10 \n"
"3 10 9 11 \n"
"3 10 11 12 \n"
"3 12 11 13 \n"
"3 13 11 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 17 16 18 \n"
"3 18 16 19 \n"
"3 19 16 20 \n"
"3 19 20 21 \n"
"3 2 22 3 \n"
"3 22 2 23 \n"
"3 23 2 24 \n"
"3 25 26 27 \n"
"3 26 25 28 \n"
"3 26 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 38 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 41 44 45 \n"
"3 45 44 21 \n"
"3 45 21 20 \n"
"3 45 20 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
;

char *VTK_VECTOR_TEXT_6 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 85 float\n"
"5.269990 17.490000 0.000000 5.459990 13.920000 0.000000 \n"
"5.250000 12.680000 0.000000 5.810000 14.990000 0.000000 \n"
"6.280000 15.900000 0.000000 6.590000 18.290001 0.000000 \n"
"6.870000 16.620001 0.000000 7.569990 17.139999 0.000000 \n"
"7.920000 18.840000 0.000000 8.379990 17.469999 0.000000 \n"
"9.299990 17.580000 0.000000 9.310000 19.160000 0.000000 \n"
"10.340000 17.389999 0.000000 10.800000 19.260000 0.000000 \n"
"11.290000 16.860001 0.000000 12.150000 16.020000 0.000000 \n"
"12.650000 19.080000 0.000000 12.880000 14.890000 0.000000 \n"
"13.480000 13.510000 0.000000 13.930000 11.920000 0.000000 \n"
"14.330000 18.559999 0.000000 14.210000 10.130000 0.000000 \n"
"14.300000 8.190000 0.000000 0.179993 10.520000 0.000000 \n"
"0.000000 13.460000 0.000000 0.239990 17.020000 0.000000 \n"
"0.699997 7.880000 0.000000 0.919998 20.250000 0.000000 \n"
"1.560000 5.580020 0.000000 2.030000 23.110001 0.000000 \n"
"2.720000 3.640010 0.000000 3.509990 25.549999 0.000000 \n"
"4.159990 2.080020 0.000000 5.179990 11.290000 0.000000 \n"
"5.330000 27.540001 0.000000 5.629990 20.100000 0.000000 \n"
"6.120000 22.370001 0.000000 6.730000 24.280001 0.000000 \n"
"7.470000 29.010000 0.000000 7.480000 25.840000 0.000000 \n"
"8.349990 27.049999 0.000000 9.360000 27.910000 0.000000 \n"
"9.879990 29.930000 0.000000 10.500000 28.430000 0.000000 \n"
"11.780000 28.610001 0.000000 12.530000 30.240000 0.000000 \n"
"13.820000 28.270000 0.000000 15.430000 29.969999 0.000000 \n"
"15.550000 27.330000 0.000000 16.910000 25.820000 0.000000 \n"
"16.940001 29.629999 0.000000 17.799999 23.820000 0.000000 \n"
"18.549999 29.139999 0.000000 18.860001 24.040001 0.000000 \n"
"5.269990 9.149990 0.000000 5.530000 7.240020 0.000000 \n"
"5.879990 0.940002 0.000000 5.959990 5.560000 0.000000 \n"
"6.530000 4.149990 0.000000 7.250000 3.020020 0.000000 \n"
"7.849990 0.240021 0.000000 8.099990 2.190000 0.000000 \n"
"9.060000 1.679990 0.000000 10.050000 0.000000 0.000000 \n"
"10.140000 1.500000 0.000000 11.060000 1.620000 0.000000 \n"
"11.870000 1.970000 0.000000 12.030000 0.179993 0.000000 \n"
"12.590000 2.540010 0.000000 13.190000 3.320010 0.000000 \n"
"13.660000 4.280000 0.000000 13.840000 0.720001 0.000000 \n"
"14.010000 5.429990 0.000000 14.230000 6.730010 0.000000 \n"
"15.450000 1.580020 0.000000 15.810000 17.730000 0.000000 \n"
"16.830000 2.740020 0.000000 17.070000 16.600000 0.000000 \n"
"17.950001 4.149990 0.000000 18.090000 15.210000 0.000000 \n"
"18.780001 5.810000 0.000000 18.850000 13.580000 0.000000 \n"
"19.299999 7.660000 0.000000 19.320000 11.730000 0.000000 \n"
"19.480000 9.700010 0.000000 \n"
"POLYGONS 85 340\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 4 0 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 10 8 11 \n"
"3 10 11 12 \n"
"3 12 11 13 \n"
"3 12 13 14 \n"
"3 14 13 15 \n"
"3 15 13 16 \n"
"3 15 16 17 \n"
"3 17 16 18 \n"
"3 18 16 19 \n"
"3 19 16 20 \n"
"3 19 20 21 \n"
"3 21 20 22 \n"
"3 23 24 25 \n"
"3 23 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 32 31 33 \n"
"3 33 31 2 \n"
"3 2 31 0 \n"
"3 0 31 34 \n"
"3 0 34 35 \n"
"3 35 34 36 \n"
"3 36 34 37 \n"
"3 37 34 38 \n"
"3 37 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 41 38 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 44 42 45 \n"
"3 44 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 49 47 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 51 52 53 \n"
"3 32 33 54 \n"
"3 32 54 55 \n"
"3 32 55 56 \n"
"3 56 55 57 \n"
"3 56 57 58 \n"
"3 56 58 59 \n"
"3 56 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 60 62 63 \n"
"3 63 62 64 \n"
"3 63 64 65 \n"
"3 63 65 66 \n"
"3 63 66 67 \n"
"3 67 66 68 \n"
"3 67 68 69 \n"
"3 67 69 70 \n"
"3 67 70 71 \n"
"3 71 70 72 \n"
"3 71 72 73 \n"
"3 71 73 74 \n"
"3 74 73 22 \n"
"3 74 22 20 \n"
"3 74 20 75 \n"
"3 74 75 76 \n"
"3 76 75 77 \n"
"3 76 77 78 \n"
"3 78 77 79 \n"
"3 78 79 80 \n"
"3 80 79 81 \n"
"3 80 81 82 \n"
"3 82 81 83 \n"
"3 82 83 84 \n"
;

char *VTK_VECTOR_TEXT_7 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 7 float\n"
"6.290010 0.000000 0.000000 2.040010 0.000000 0.000000 \n"
"15.330000 24.799999 0.000000 18.780001 28.480000 0.000000 \n"
"0.000000 29.540001 0.000000 0.000000 24.799999 0.000000 \n"
"18.780001 29.540001 0.000000 \n"
"POLYGONS 5 20\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 4 2 5 \n"
"3 2 4 3 \n"
"3 3 4 6 \n"
;

char *VTK_VECTOR_TEXT_8 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 120 float\n"
"3.640010 16.790001 0.000000 4.030000 24.490000 0.000000 \n"
"4.170010 23.299999 0.000000 4.600010 22.280001 0.000000 \n"
"4.929990 15.870000 0.000000 5.399990 21.370001 0.000000 \n"
"6.510010 14.880000 0.000000 6.600010 20.510000 0.000000 \n"
"3.550020 13.470000 0.000000 4.070010 10.270000 0.000000 \n"
"3.810000 8.549990 0.000000 4.830020 11.770000 0.000000 \n"
"4.910000 14.200000 0.000000 6.090000 13.020000 0.000000 \n"
"7.840000 14.000000 0.000000 8.550020 13.600000 0.000000 \n"
"9.590000 18.709999 0.000000 10.560000 12.460000 0.000000 \n"
"11.010000 17.900000 0.000000 12.180000 17.270000 0.000000 \n"
"12.210000 11.430000 0.000000 13.540000 10.480000 0.000000 \n"
"13.550000 16.520000 0.000000 13.860000 18.209999 0.000000 \n"
"14.990000 17.170000 0.000000 15.080000 19.410000 0.000000 \n"
"15.830000 20.840000 0.000000 16.200001 17.840000 0.000000 \n"
"16.080000 22.500000 0.000000 14.570000 9.579990 0.000000 \n"
"15.140000 15.400000 0.000000 15.330000 8.709990 0.000000 \n"
"15.840000 7.840000 0.000000 16.120001 6.959990 0.000000 \n"
"16.450001 14.360000 0.000000 16.209999 6.019990 0.000000 \n"
"0.600006 21.360001 0.000000 0.529999 22.450001 0.000000 \n"
"0.709991 24.090000 0.000000 0.820007 20.370001 0.000000 \n"
"1.209990 19.440001 0.000000 1.230010 25.590000 0.000000 \n"
"1.800020 18.549999 0.000000 2.050020 26.930000 0.000000 \n"
"2.600010 17.680000 0.000000 3.140010 28.090000 0.000000 \n"
"4.140010 25.410000 0.000000 4.450010 26.260000 0.000000 \n"
"4.489990 29.040001 0.000000 4.950010 27.030001 0.000000 \n"
"5.610020 27.700001 0.000000 6.050020 29.740000 0.000000 \n"
"6.410000 28.250000 0.000000 7.340000 28.660000 0.000000 \n"
"7.790010 30.190001 0.000000 8.370000 28.920000 0.000000 \n"
"9.480010 29.010000 0.000000 9.700010 30.340000 0.000000 \n"
"10.780000 28.879999 0.000000 11.740000 30.200001 0.000000 \n"
"12.010000 28.490000 0.000000 13.120000 27.879999 0.000000 \n"
"13.590000 29.799999 0.000000 14.110000 27.080000 0.000000 \n"
"14.930000 26.120001 0.000000 15.220000 29.160000 0.000000 \n"
"15.550000 25.010000 0.000000 15.940000 23.799999 0.000000 \n"
"16.610001 28.290001 0.000000 17.190001 18.530001 0.000000 \n"
"17.740000 27.219999 0.000000 17.969999 19.270000 0.000000 \n"
"18.559999 20.070000 0.000000 18.570000 25.969999 0.000000 \n"
"18.959999 20.950001 0.000000 19.090000 24.549999 0.000000 \n"
"19.190001 21.920000 0.000000 19.270000 22.990000 0.000000 \n"
"0.089996 8.850010 0.000000 0.190002 6.060000 0.000000 \n"
"0.000000 7.660000 0.000000 0.369995 9.940000 0.000000 \n"
"0.739990 4.600010 0.000000 0.850006 10.940000 0.000000 \n"
"1.530000 11.850000 0.000000 1.620000 3.290010 0.000000 \n"
"2.429990 12.700000 0.000000 2.800020 2.169980 0.000000 \n"
"3.959990 7.160000 0.000000 4.239990 1.259980 0.000000 \n"
"4.390010 5.859990 0.000000 5.060000 4.690000 0.000000 \n"
"5.929990 0.579987 0.000000 5.959990 3.669980 0.000000 \n"
"7.050020 2.820010 0.000000 7.810000 0.149994 0.000000 \n"
"8.300020 2.179990 0.000000 9.679990 1.780000 0.000000 \n"
"9.880000 0.000000 0.000000 11.160000 1.639980 0.000000 \n"
"11.960000 0.149994 0.000000 12.230000 1.720000 0.000000 \n"
"13.200000 1.959990 0.000000 13.860000 0.589996 0.000000 \n"
"14.060000 2.350010 0.000000 14.800000 2.870000 0.000000 \n"
"15.400000 3.509980 0.000000 15.520000 1.290010 0.000000 \n"
"15.840000 4.259980 0.000000 16.120001 5.100010 0.000000 \n"
"16.950001 2.229980 0.000000 17.510000 13.350000 0.000000 \n"
"18.100000 3.399990 0.000000 18.340000 12.370000 0.000000 \n"
"18.950001 11.370000 0.000000 18.950001 4.769990 0.000000 \n"
"19.360001 10.330000 0.000000 19.480000 6.310000 0.000000 \n"
"19.590000 9.220000 0.000000 19.670000 8.019990 0.000000 \n"

"POLYGONS 122 488\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 8 9 10 \n"
"3 9 8 11 \n"
"3 11 8 12 \n"
"3 11 12 13 \n"
"3 13 12 6 \n"
"3 13 6 14 \n"
"3 14 6 7 \n"
"3 14 7 15 \n"
"3 15 7 16 \n"
"3 15 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 17 19 20 \n"
"3 20 19 21 \n"
"3 21 19 22 \n"
"3 22 19 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 24 26 27 \n"
"3 27 26 28 \n"
"3 22 29 21 \n"
"3 29 22 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 33 30 34 \n"
"3 33 34 35 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 44 45 0 \n"
"3 0 45 1 \n"
"3 1 45 46 \n"
"3 46 45 47 \n"
"3 47 45 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 50 48 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 53 51 54 \n"
"3 53 54 55 \n"
"3 55 54 56 \n"
"3 56 54 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 61 59 62 \n"
"3 61 62 63 \n"
"3 63 62 64 \n"
"3 64 62 65 \n"
"3 64 65 66 \n"
"3 66 65 67 \n"
"3 67 65 68 \n"
"3 67 68 28 \n"
"3 28 68 27 \n"
"3 27 68 69 \n"
"3 69 68 70 \n"
"3 69 70 71 \n"
"3 71 70 72 \n"
"3 72 70 73 \n"
"3 72 73 74 \n"
"3 74 73 75 \n"
"3 74 75 76 \n"
"3 76 75 77 \n"
"3 78 79 80 \n"
"3 79 78 81 \n"
"3 79 81 82 \n"
"3 82 81 83 \n"
"3 82 83 84 \n"
"3 82 84 85 \n"
"3 85 84 86 \n"
"3 85 86 87 \n"
"3 87 86 8 \n"
"3 87 8 10 \n"
"3 87 10 88 \n"
"3 87 88 89 \n"
"3 89 88 90 \n"
"3 89 90 91 \n"
"3 89 91 92 \n"
"3 92 91 93 \n"
"3 92 93 94 \n"
"3 92 94 95 \n"
"3 95 94 96 \n"
"3 95 96 97 \n"
"3 95 97 98 \n"
"3 98 97 99 \n"
"3 98 99 100 \n"
"3 100 99 101 \n"
"3 100 101 102 \n"
"3 100 102 103 \n"
"3 103 102 104 \n"
"3 103 104 105 \n"
"3 103 105 106 \n"
"3 103 106 107 \n"
"3 107 106 108 \n"
"3 107 108 109 \n"
"3 107 109 110 \n"
"3 110 109 35 \n"
"3 110 35 34 \n"
"3 110 34 111 \n"
"3 110 111 112 \n"
"3 112 111 113 \n"
"3 112 113 114 \n"
"3 112 114 115 \n"
"3 115 114 116 \n"
"3 115 116 117 \n"
"3 117 116 118 \n"
"3 117 118 119 \n"
;

char *VTK_VECTOR_TEXT_9 = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 86 float\n"
"0.709991 1.149990 0.000000 0.450012 6.200010 0.000000 \n"
"1.549990 6.420010 0.000000 2.470000 4.360020 0.000000 \n"
"2.500000 0.610016 0.000000 3.810000 2.840000 0.000000 \n"
"4.010010 0.260010 0.000000 5.510010 1.910000 0.000000 \n"
"6.690000 0.000000 0.000000 7.530000 1.590000 0.000000 \n"
"8.850010 1.760010 0.000000 9.440000 0.309998 0.000000 \n"
"10.020000 2.270020 0.000000 11.050000 3.130000 0.000000 \n"
"11.910000 1.230010 0.000000 11.940000 4.330020 0.000000 \n"
"12.680000 5.880000 0.000000 13.290000 7.770020 0.000000 \n"
"14.090000 2.709990 0.000000 13.750000 10.020000 0.000000 \n"
"14.080000 12.620000 0.000000 4.049990 28.639999 0.000000 \n"
"5.179990 22.090000 0.000000 5.179990 21.830000 0.000000 \n"
"5.260010 23.520000 0.000000 5.480010 24.809999 0.000000 \n"
"5.639980 29.510000 0.000000 5.850010 25.930000 0.000000 \n"
"6.329990 26.889999 0.000000 6.940000 27.660000 0.000000 \n"
"7.440000 30.059999 0.000000 7.649990 28.219999 0.000000 \n"
"8.450010 28.570000 0.000000 9.350010 28.690001 0.000000 \n"
"9.389980 30.240000 0.000000 10.400000 28.520000 0.000000 \n"
"11.350000 28.020000 0.000000 11.600000 30.010000 0.000000 \n"
"12.190000 27.209999 0.000000 12.900000 26.120001 0.000000 \n"
"13.480000 24.770000 0.000000 13.580000 29.330000 0.000000 \n"
"13.910000 23.180000 0.000000 14.170000 21.379999 0.000000 \n"
"15.300000 28.219999 0.000000 14.260000 19.389999 0.000000 \n"
"0.170013 18.480000 0.000000 0.000000 20.500000 0.000000 \n"
"0.179993 22.530001 0.000000 0.639984 16.629999 0.000000 \n"
"0.709991 24.400000 0.000000 1.410000 15.000000 0.000000 \n"
"1.549990 26.049999 0.000000 2.440000 13.610000 0.000000 \n"
"2.670010 27.480000 0.000000 3.720000 12.480000 0.000000 \n"
"5.209990 11.640000 0.000000 5.320010 19.870001 0.000000 \n"
"5.620000 18.100000 0.000000 6.079990 16.530001 0.000000 \n"
"6.679990 15.200000 0.000000 6.910000 11.120000 0.000000 \n"
"7.410000 14.130000 0.000000 8.250000 13.330000 0.000000 \n"
"8.769990 10.930000 0.000000 9.190000 12.830000 0.000000 \n"
"10.190000 11.040000 0.000000 10.230000 12.660000 0.000000 \n"
"11.140000 12.770000 0.000000 11.530000 11.340000 0.000000 \n"
"11.950000 13.110000 0.000000 12.640000 13.660000 0.000000 \n"
"12.820000 11.870000 0.000000 13.210000 14.420000 0.000000 \n"
"13.660000 15.380000 0.000000 13.990000 16.530001 0.000000 \n"
"14.190000 17.870001 0.000000 15.940000 4.720000 0.000000 \n"
"16.740000 26.719999 0.000000 17.430000 7.209990 0.000000 \n"
"17.900000 24.830000 0.000000 18.530001 10.140000 0.000000 \n"
"18.740000 22.600000 0.000000 19.209999 13.480000 0.000000 \n"
"19.270000 20.040001 0.000000 19.440001 17.180000 0.000000 \n"

"POLYGONS 86 344\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 8 9 10 \n"
"3 8 10 11 \n"
"3 11 10 12 \n"
"3 11 12 13 \n"
"3 11 13 14 \n"
"3 14 13 15 \n"
"3 14 15 16 \n"
"3 14 16 17 \n"
"3 14 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 21 22 23 \n"
"3 22 21 24 \n"
"3 24 21 25 \n"
"3 25 21 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 28 26 29 \n"
"3 29 26 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 33 30 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 36 34 37 \n"
"3 36 37 38 \n"
"3 38 37 39 \n"
"3 39 37 40 \n"
"3 40 37 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 43 41 44 \n"
"3 43 44 45 \n"
"3 46 47 48 \n"
"3 46 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 51 52 53 \n"
"3 53 52 54 \n"
"3 53 54 55 \n"
"3 55 54 21 \n"
"3 55 21 23 \n"
"3 55 23 56 \n"
"3 56 23 57 \n"
"3 56 57 58 \n"
"3 56 58 59 \n"
"3 56 59 60 \n"
"3 56 60 61 \n"
"3 61 60 62 \n"
"3 61 62 63 \n"
"3 61 63 64 \n"
"3 64 63 65 \n"
"3 64 65 66 \n"
"3 66 65 67 \n"
"3 66 67 68 \n"
"3 66 68 69 \n"
"3 69 68 70 \n"
"3 69 70 71 \n"
"3 69 71 72 \n"
"3 72 71 73 \n"
"3 72 73 74 \n"
"3 72 74 75 \n"
"3 72 75 20 \n"
"3 20 75 76 \n"
"3 20 76 18 \n"
"3 18 76 45 \n"
"3 18 45 44 \n"
"3 18 44 77 \n"
"3 77 44 78 \n"
"3 77 78 79 \n"
"3 79 78 80 \n"
"3 79 80 81 \n"
"3 81 80 82 \n"
"3 81 82 83 \n"
"3 83 82 84 \n"
"3 83 84 85 \n"
;

char *VTK_VECTOR_TEXT_A = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 51 float\n"
"6.523000 0.080017 0.000000 6.909000 2.739990 0.000000 \n"
"7.056000 2.030000 0.000000 7.518000 1.520020 0.000000 \n"
"7.673000 0.080017 0.000000 8.329000 1.220000 0.000000 \n"
"8.773000 0.050018 0.000000 9.522000 1.100010 0.000000 \n"
"10.097000 0.000000 0.000000 10.097000 1.060000 0.000000 \n"
"9.389000 10.360000 0.000000 9.832000 11.650000 0.000000 \n"
"18.113001 11.650000 0.000000 18.822001 10.360000 0.000000 \n"
"18.822001 0.000000 0.000000 18.822001 1.149990 0.000000 \n"
"20.143000 1.239990 0.000000 20.440001 0.050018 0.000000 \n"
"21.020000 1.520020 0.000000 21.506001 2.050020 0.000000 \n"
"21.799999 0.080017 0.000000 21.656000 2.830020 0.000000 \n"
"0.000000 1.060000 0.000000 1.299000 0.050018 0.000000 \n"
"0.000000 0.000000 0.000000 1.659000 1.340000 0.000000 \n"
"2.391000 0.080017 0.000000 3.078000 2.200010 0.000000 \n"
"3.550000 0.080017 0.000000 4.297000 3.679990 0.000000 \n"
"5.049000 0.089996 0.000000 5.359000 5.800020 0.000000 \n"
"6.997000 3.520020 0.000000 7.352000 4.690000 0.000000 \n"
"13.640000 22.410000 0.000000 15.456000 30.549999 0.000000 \n"
"21.257999 4.340000 0.000000 21.573000 3.489990 0.000000 \n"
"23.243999 0.080017 0.000000 25.111000 0.089996 0.000000 \n"
"25.908001 6.239990 0.000000 26.516001 4.890010 0.000000 \n"
"26.952000 0.080017 0.000000 27.094999 3.790010 0.000000 \n"
"27.670000 2.910000 0.000000 28.266001 2.230010 0.000000 \n"
"28.382000 0.080017 0.000000 29.620001 1.370000 0.000000 \n"
"29.738001 0.050018 0.000000 31.355000 0.000000 0.000000 \n"
"31.355000 1.020020 0.000000 \n"
"POLYGONS 51 204\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 10 11 12 \n"
"3 10 12 13 \n"
"3 14 15 16 \n"
"3 14 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 17 19 20 \n"
"3 20 19 21 \n"
"3 22 23 24 \n"
"3 23 22 25 \n"
"3 23 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 30 31 0 \n"
"3 0 31 1 \n"
"3 1 31 32 \n"
"3 32 31 33 \n"
"3 33 31 10 \n"
"3 10 31 11 \n"
"3 11 31 34 \n"
"3 34 31 35 \n"
"3 34 35 12 \n"
"3 12 35 13 \n"
"3 13 35 36 \n"
"3 36 35 37 \n"
"3 37 35 38 \n"
"3 37 38 21 \n"
"3 21 38 20 \n"
"3 35 39 38 \n"
"3 39 35 40 \n"
"3 39 40 41 \n"
"3 39 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 42 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 49 47 50 \n"
;

char *VTK_VECTOR_TEXT_B = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 111 float\n"
"0.000000 29.850000 0.000000 0.530998 28.790001 0.000000 \n"
"0.000000 28.790001 0.000000 0.796997 29.850000 0.000000 \n"
"1.897000 28.559999 0.000000 2.785000 27.889999 0.000000 \n"
"3.941990 29.809999 0.000000 3.071000 27.350000 0.000000 \n"
"3.265000 26.650000 0.000000 3.375000 25.790001 0.000000 \n"
"3.410000 24.760000 0.000000 14.570000 15.680000 0.000000 \n"
"14.401000 16.760000 0.000000 15.362000 17.389999 0.000000 \n"
"16.105000 18.209999 0.000000 16.320000 16.040001 0.000000 \n"
"16.632000 19.219999 0.000000 16.945999 20.410000 0.000000 \n"
"17.849001 16.549999 0.000000 17.049999 21.790001 0.000000 \n"
"8.413990 15.990000 0.000000 9.035000 14.620000 0.000000 \n"
"8.413990 14.620000 0.000000 10.037000 14.620000 0.000000 \n"
"10.186000 15.950000 0.000000 10.407000 14.620000 0.000000 \n"
"11.816000 16.040001 0.000000 12.024000 14.480000 0.000000 \n"
"13.220000 16.309999 0.000000 13.476000 14.080000 0.000000 \n"
"14.747000 13.430000 0.000000 15.821000 12.550000 0.000000 \n"
"16.684000 11.450000 0.000000 16.705999 15.330000 0.000000 \n"
"17.320000 10.150000 0.000000 17.709000 8.660000 0.000000 \n"
"18.528999 14.820000 0.000000 17.849001 7.000000 0.000000 \n"
"7.850000 29.809999 0.000000 8.413990 5.229980 0.000000 \n"
"8.413990 28.570000 0.000000 9.256000 29.809999 0.000000 \n"
"9.345000 28.610001 0.000000 11.138000 28.500000 0.000000 \n"
"11.188000 29.850000 0.000000 12.489000 29.850000 0.000000 \n"
"12.697000 28.180000 0.000000 14.021000 27.629999 0.000000 \n"
"14.658000 29.730000 0.000000 15.107000 26.879999 0.000000 \n"
"15.955000 25.920000 0.000000 16.563000 24.750000 0.000000 \n"
"16.576000 29.370001 0.000000 16.927999 23.370001 0.000000 \n"
"18.229000 28.770000 0.000000 19.149000 17.209999 0.000000 \n"
"19.608999 27.959999 0.000000 20.219000 18.020000 0.000000 \n"
"20.698999 26.930000 0.000000 21.059000 18.969999 0.000000 \n"
"21.489000 25.700001 0.000000 21.659000 20.070000 0.000000 \n"
"21.979000 24.280001 0.000000 22.018999 21.299999 0.000000 \n"
"22.139000 22.680000 0.000000 0.000000 0.049988 0.000000 \n"
"0.000000 1.070010 0.000000 0.530998 1.109990 0.000000 \n"
"1.161000 0.070007 0.000000 1.897000 1.329990 0.000000 \n"
"2.513000 0.089996 0.000000 2.785000 2.009980 0.000000 \n"
"3.265000 3.229980 0.000000 3.410000 5.100010 0.000000 \n"
"4.777000 29.809999 0.000000 3.375000 4.070010 0.000000 \n"
"5.757000 0.089996 0.000000 5.846000 29.809999 0.000000 \n"
"7.457000 0.089996 0.000000 8.445000 4.120000 0.000000 \n"
"8.466000 0.070007 0.000000 8.552990 3.239990 0.000000 \n"
"8.759990 2.570010 0.000000 9.090000 2.070010 0.000000 \n"
"9.564990 1.729980 0.000000 9.654000 0.049988 0.000000 \n"
"10.208000 1.519990 0.000000 11.042000 1.410000 0.000000 \n"
"11.420000 0.009979 0.000000 12.090000 1.380000 0.000000 \n"
"12.622000 0.000000 0.000000 13.393000 1.470000 0.000000 \n"
"14.541000 1.750000 0.000000 15.082000 0.130005 0.000000 \n"
"15.527000 2.209990 0.000000 16.347000 2.840000 0.000000 \n"
"16.995001 3.639980 0.000000 17.243999 0.509979 0.000000 \n"
"17.469000 4.609990 0.000000 17.749001 5.729980 0.000000 \n"
"19.099001 1.139980 0.000000 20.059000 14.120000 0.000000 \n"
"20.629000 2.009980 0.000000 21.289000 13.250000 0.000000 \n"
"21.839001 3.109990 0.000000 22.239000 12.190000 0.000000 \n"
"22.719000 4.449980 0.000000 22.899000 10.930000 0.000000 \n"
"23.249001 6.009980 0.000000 23.299000 9.470000 0.000000 \n"
"23.429001 7.799990 0.000000 \n"
"POLYGONS 113 452\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 5 3 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 8 6 9 \n"
"3 9 6 10 \n"
"3 11 12 13 \n"
"3 11 13 14 \n"
"3 11 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 15 17 18 \n"
"3 18 17 19 \n"
"3 20 21 22 \n"
"3 21 20 23 \n"
"3 23 20 24 \n"
"3 23 24 25 \n"
"3 25 24 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 29 28 12 \n"
"3 29 12 11 \n"
"3 29 11 30 \n"
"3 30 11 31 \n"
"3 31 11 32 \n"
"3 32 11 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 35 33 36 \n"
"3 35 36 37 \n"
"3 38 22 39 \n"
"3 22 38 20 \n"
"3 20 38 40 \n"
"3 40 38 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 43 41 44 \n"
"3 43 44 45 \n"
"3 43 45 46 \n"
"3 46 45 47 \n"
"3 47 45 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 50 48 51 \n"
"3 51 48 52 \n"
"3 51 52 53 \n"
"3 53 52 19 \n"
"3 19 52 18 \n"
"3 18 52 54 \n"
"3 18 54 55 \n"
"3 55 54 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 57 58 59 \n"
"3 59 58 60 \n"
"3 59 60 61 \n"
"3 61 60 62 \n"
"3 61 62 63 \n"
"3 63 62 64 \n"
"3 65 66 67 \n"
"3 65 67 68 \n"
"3 68 67 69 \n"
"3 68 69 70 \n"
"3 70 69 71 \n"
"3 70 71 72 \n"
"3 73 10 6 \n"
"3 73 6 74 \n"
"3 73 74 75 \n"
"3 75 74 76 \n"
"3 75 76 72 \n"
"3 72 76 70 \n"
"3 76 74 77 \n"
"3 76 77 78 \n"
"3 78 77 38 \n"
"3 78 38 39 \n"
"3 78 39 79 \n"
"3 78 79 80 \n"
"3 80 79 81 \n"
"3 80 81 82 \n"
"3 80 82 83 \n"
"3 80 83 84 \n"
"3 80 84 85 \n"
"3 85 84 86 \n"
"3 85 86 87 \n"
"3 85 87 88 \n"
"3 88 87 89 \n"
"3 88 89 90 \n"
"3 90 89 91 \n"
"3 90 91 92 \n"
"3 90 92 93 \n"
"3 93 92 94 \n"
"3 93 94 95 \n"
"3 93 95 96 \n"
"3 93 96 97 \n"
"3 97 96 98 \n"
"3 97 98 99 \n"
"3 99 37 36 \n"
"3 99 36 100 \n"
"3 99 100 97 \n"
"3 100 36 101 \n"
"3 100 101 102 \n"
"3 102 101 103 \n"
"3 102 103 104 \n"
"3 104 103 105 \n"
"3 104 105 106 \n"
"3 106 105 107 \n"
"3 106 107 108 \n"
"3 108 107 109 \n"
"3 108 109 110 \n"
;

char *VTK_VECTOR_TEXT_C = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 61 float\n"
"4.710000 26.420000 0.000000 6.189990 19.299999 0.000000 \n"
"5.980000 16.559999 0.000000 6.800000 21.780001 0.000000 \n"
"7.180000 28.250000 0.000000 7.770000 23.969999 0.000000 \n"
"9.090000 25.840000 0.000000 10.090000 29.610001 0.000000 \n"
"10.710000 27.350000 0.000000 12.610000 28.469999 0.000000 \n"
"13.390000 30.450001 0.000000 14.770000 29.170000 0.000000 \n"
"17.049999 30.730000 0.000000 17.139999 29.410000 0.000000 \n"
"19.190001 29.250000 0.000000 19.879999 30.580000 0.000000 \n"
"21.090000 28.799999 0.000000 22.799999 28.080000 0.000000 \n"
"22.850000 30.129999 0.000000 24.299999 27.100000 0.000000 \n"
"25.570000 25.879999 0.000000 25.840000 29.410000 0.000000 \n"
"26.590000 24.450001 0.000000 27.330000 22.830000 0.000000 \n"
"27.770000 21.040001 0.000000 28.740000 28.430000 0.000000 \n"
"28.790001 21.040001 0.000000 0.299995 11.880000 0.000000 \n"
"0.000000 15.100000 0.000000 0.320000 18.459999 0.000000 \n"
"1.170000 8.970000 0.000000 1.230000 21.490000 0.000000 \n"
"2.560000 6.389980 0.000000 2.710000 24.160000 0.000000 \n"
"4.439990 4.199980 0.000000 6.210000 13.520000 0.000000 \n"
"6.770000 2.419980 0.000000 6.870000 10.710000 0.000000 \n"
"7.920000 8.179990 0.000000 9.320000 5.979980 0.000000 \n"
"9.490000 1.100010 0.000000 11.020000 4.179990 0.000000 \n"
"12.580000 0.279999 0.000000 12.990000 2.829990 0.000000 \n"
"15.170000 1.979980 0.000000 15.990000 0.000000 0.000000 \n"
"17.540001 1.679990 0.000000 19.129999 1.810000 0.000000 \n"
"19.540001 0.229980 0.000000 20.690001 2.179990 0.000000 \n"
"22.219999 2.790010 0.000000 22.760000 0.970001 0.000000 \n"
"23.709999 3.639980 0.000000 25.139999 4.720000 0.000000 \n"
"25.969999 2.350010 0.000000 26.510000 6.019990 0.000000 \n"
"27.680000 3.310000 0.000000 27.799999 7.530000 0.000000 \n"
"29.010000 9.260010 0.000000 29.320000 9.260010 0.000000 \n"
"29.500000 4.470000 0.000000 \n"
"POLYGONS 59 236\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 9 7 10 \n"
"3 9 10 11 \n"
"3 11 10 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 14 12 15 \n"
"3 14 15 16 \n"
"3 16 15 17 \n"
"3 17 15 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 20 18 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 23 21 24 \n"
"3 24 21 25 \n"
"3 24 25 26 \n"
"3 27 28 29 \n"
"3 27 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 34 33 0 \n"
"3 34 0 2 \n"
"3 34 2 35 \n"
"3 34 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 36 39 40 \n"
"3 40 39 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 45 47 48 \n"
"3 48 47 49 \n"
"3 48 49 50 \n"
"3 48 50 51 \n"
"3 51 50 52 \n"
"3 51 52 53 \n"
"3 51 53 54 \n"
"3 54 53 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 56 57 58 \n"
"3 56 58 59 \n"
"3 56 59 60 \n"
;

char *VTK_VECTOR_TEXT_D = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 80 float\n"
"0.000000 0.269989 0.000000 0.000000 1.290010 0.000000 \n"
"0.759995 1.329990 0.000000 1.070010 0.269989 0.000000 \n"
"2.140000 1.540010 0.000000 2.190000 0.269989 0.000000 \n"
"3.030000 2.209990 0.000000 3.090000 0.269989 0.000000 \n"
"3.500000 3.440000 0.000000 3.759990 0.269989 0.000000 \n"
"3.600010 4.290010 0.000000 3.640000 5.320010 0.000000 \n"
"3.640000 24.980000 0.000000 0.000000 29.010000 0.000000 \n"
"0.000000 30.070000 0.000000 0.630005 30.070000 0.000000 \n"
"0.759995 29.010000 0.000000 1.070010 30.030001 0.000000 \n"
"2.140000 28.780001 0.000000 3.030000 28.110001 0.000000 \n"
"4.210010 0.269989 0.000000 4.430010 29.940001 0.000000 \n"
"3.600010 26.010000 0.000000 3.500000 26.870001 0.000000 \n"
"3.310000 27.570000 0.000000 7.110000 0.250000 0.000000 \n"
"8.060000 29.940001 0.000000 8.640000 6.380000 0.000000 \n"
"8.670000 4.959990 0.000000 8.790010 0.209991 0.000000 \n"
"8.800000 3.850010 0.000000 9.040010 3.000000 0.000000 \n"
"9.440000 2.389980 0.000000 9.840000 0.179993 0.000000 \n"
"10.030000 1.970000 0.000000 10.830000 1.709990 0.000000 \n"
"11.080000 0.130005 0.000000 11.870000 1.590000 0.000000 \n"
"13.200000 1.549990 0.000000 13.300000 0.040009 0.000000 \n"
"14.930000 0.000000 0.000000 16.000000 1.759980 0.000000 \n"
"18.459999 2.399990 0.000000 18.620001 0.269989 0.000000 \n"
"20.570000 3.440000 0.000000 21.920000 1.070010 0.000000 \n"
"22.340000 4.870000 0.000000 23.730000 6.690000 0.000000 \n"
"24.740000 8.880000 0.000000 24.780001 2.359990 0.000000 \n"
"25.350000 11.420000 0.000000 25.559999 14.310000 0.000000 \n"
"27.180000 4.130000 0.000000 8.640000 28.480000 0.000000 \n"
"9.750000 28.520000 0.000000 11.900000 28.600000 0.000000 \n"
"11.920000 29.980000 0.000000 13.350000 30.010000 0.000000 \n"
"13.560000 28.610001 0.000000 14.540000 30.020000 0.000000 \n"
"15.480000 30.030001 0.000000 16.170000 30.030001 0.000000 \n"
"16.250000 28.360001 0.000000 18.629999 27.639999 0.000000 \n"
"19.490000 29.760000 0.000000 20.680000 26.450001 0.000000 \n"
"22.400000 24.830000 0.000000 22.500000 28.969999 0.000000 \n"
"23.760000 22.780001 0.000000 24.750000 20.330000 0.000000 \n"
"25.139999 27.700001 0.000000 25.350000 17.500000 0.000000 \n"
"27.389999 25.990000 0.000000 29.100000 6.340000 0.000000 \n"
"29.209999 23.860001 0.000000 30.510000 8.970000 0.000000 \n"
"30.549999 21.360001 0.000000 31.370001 11.990000 0.000000 \n"
"31.379999 18.520000 0.000000 31.670000 15.370000 0.000000 \n"

"POLYGONS 80 320\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 13 14 15 \n"
"3 13 15 16 \n"
"3 16 15 17 \n"
"3 16 17 18 \n"
"3 18 17 19 \n"
"3 12 20 9 \n"
"3 20 12 21 \n"
"3 21 12 22 \n"
"3 21 22 23 \n"
"3 21 23 24 \n"
"3 21 24 19 \n"
"3 21 19 17 \n"
"3 21 25 20 \n"
"3 25 21 26 \n"
"3 25 26 27 \n"
"3 25 27 28 \n"
"3 25 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 29 31 32 \n"
"3 29 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 33 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 40 41 42 \n"
"3 40 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 45 47 48 \n"
"3 45 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 49 51 52 \n"
"3 26 53 27 \n"
"3 53 26 54 \n"
"3 54 26 55 \n"
"3 55 26 56 \n"
"3 55 56 57 \n"
"3 55 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 58 60 61 \n"
"3 58 61 62 \n"
"3 62 61 63 \n"
"3 63 61 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 66 64 67 \n"
"3 66 67 68 \n"
"3 68 67 69 \n"
"3 69 67 70 \n"
"3 69 70 71 \n"
"3 71 70 51 \n"
"3 51 70 52 \n"
"3 52 70 72 \n"
"3 52 72 73 \n"
"3 73 72 74 \n"
"3 73 74 75 \n"
"3 75 74 76 \n"
"3 75 76 77 \n"
"3 77 76 78 \n"
"3 77 78 79 \n"
;

char *VTK_VECTOR_TEXT_E = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 101 float\n"
"0.000000 29.799999 0.000000 0.479996 28.740000 0.000000 \n"
"0.000000 28.740000 0.000000 1.410000 29.760000 0.000000 \n"
"1.870000 28.510000 0.000000 2.649990 29.730000 0.000000 \n"
"2.750000 27.840000 0.000000 3.039990 27.299999 0.000000 \n"
"3.220000 26.600000 0.000000 4.870000 29.690001 0.000000 \n"
"3.330000 25.740000 0.000000 3.360000 24.709999 0.000000 \n"
"8.370000 16.070000 0.000000 11.200000 14.390000 0.000000 \n"
"8.370000 14.390000 0.000000 11.330000 16.070000 0.000000 \n"
"12.620000 14.360000 0.000000 12.700000 16.100000 0.000000 \n"
"13.760000 14.240000 0.000000 13.790000 16.209999 0.000000 \n"
"14.640000 16.410000 0.000000 14.640000 14.010000 0.000000 \n"
"15.270000 16.730000 0.000000 15.300000 13.650000 0.000000 \n"
"15.730000 17.190001 0.000000 15.760000 13.130000 0.000000 \n"
"16.030001 17.809999 0.000000 16.070000 12.430000 0.000000 \n"
"16.209999 18.610001 0.000000 16.250000 11.510000 0.000000 \n"
"16.290001 19.620001 0.000000 16.340000 10.360000 0.000000 \n"
"16.340000 20.280001 0.000000 17.620001 15.320000 0.000000 \n"
"17.660000 13.140000 0.000000 17.719999 11.930000 0.000000 \n"
"17.799999 10.360000 0.000000 17.660000 17.490000 0.000000 \n"
"17.719999 18.700001 0.000000 17.799999 20.280001 0.000000 \n"
"7.200000 29.670000 0.000000 8.370000 5.360020 0.000000 \n"
"8.370000 28.160000 0.000000 8.580000 29.670000 0.000000 \n"
"10.180000 29.670000 0.000000 11.510000 28.160000 0.000000 \n"
"11.800000 29.670000 0.000000 13.190000 29.670000 0.000000 \n"
"13.440000 28.110001 0.000000 15.050000 27.920000 0.000000 \n"
"15.520000 29.690001 0.000000 16.350000 27.570000 0.000000 \n"
"17.400000 27.049999 0.000000 17.740000 29.730000 0.000000 \n"
"18.230000 26.320000 0.000000 18.860001 25.360001 0.000000 \n"
"19.340000 24.150000 0.000000 20.370001 29.799999 0.000000 \n"
"19.700001 22.670000 0.000000 20.540001 27.600000 0.000000 \n"
"20.709999 25.730000 0.000000 20.900000 24.120001 0.000000 \n"
"21.120001 22.719999 0.000000 0.000000 0.000000 0.000000 \n"
"0.000000 1.020020 0.000000 0.479996 1.020020 0.000000 \n"
"1.870000 1.260010 0.000000 2.740010 0.040009 0.000000 \n"
"2.750000 1.929990 0.000000 3.039990 2.470000 0.000000 \n"
"3.220000 3.160000 0.000000 3.360000 5.050020 0.000000 \n"
"3.330000 4.010010 0.000000 6.789990 0.140015 0.000000 \n"
"8.399990 4.320010 0.000000 8.530000 3.489990 0.000000 \n"
"8.759990 2.850010 0.000000 9.130000 2.370000 0.000000 \n"
"9.649990 2.040010 0.000000 10.350000 1.830020 0.000000 \n"
"11.070000 0.170013 0.000000 11.240000 1.709990 0.000000 \n"
"12.350000 1.679990 0.000000 13.710000 0.170013 0.000000 \n"
"14.450000 1.750000 0.000000 16.129999 0.140015 0.000000 \n"
"16.219999 1.980010 0.000000 17.680000 2.390010 0.000000 \n"
"18.790001 0.080017 0.000000 18.870001 3.000000 0.000000 \n"
"19.809999 3.830020 0.000000 20.370001 0.040009 0.000000 \n"
"20.530001 4.890010 0.000000 21.059999 6.220000 0.000000 \n"
"21.430000 7.840000 0.000000 22.180000 0.000000 0.000000 \n"
"22.230000 0.880005 0.000000 22.320000 2.560000 0.000000 \n"
"22.420000 3.989990 0.000000 22.719999 6.860020 0.000000 \n"
"22.799999 7.610020 0.000000 \n"
"POLYGONS 99 396\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 8 5 9 \n"
"3 8 9 10 \n"
"3 10 9 11 \n"
"3 12 13 14 \n"
"3 13 12 15 \n"
"3 13 15 16 \n"
"3 16 15 17 \n"
"3 16 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 18 20 21 \n"
"3 21 20 22 \n"
"3 21 22 23 \n"
"3 23 22 24 \n"
"3 23 24 25 \n"
"3 25 24 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 31 33 34 \n"
"3 31 34 35 \n"
"3 31 35 36 \n"
"3 32 37 33 \n"
"3 37 32 38 \n"
"3 38 32 39 \n"
"3 40 14 41 \n"
"3 14 40 12 \n"
"3 12 40 42 \n"
"3 42 40 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 45 47 48 \n"
"3 48 47 49 \n"
"3 49 47 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 52 50 53 \n"
"3 52 53 54 \n"
"3 54 53 55 \n"
"3 55 53 56 \n"
"3 56 53 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 58 60 61 \n"
"3 58 61 62 \n"
"3 63 64 65 \n"
"3 63 65 66 \n"
"3 63 66 67 \n"
"3 67 66 68 \n"
"3 67 68 69 \n"
"3 67 69 70 \n"
"3 71 11 9 \n"
"3 71 9 72 \n"
"3 72 9 73 \n"
"3 72 73 70 \n"
"3 70 73 67 \n"
"3 73 9 40 \n"
"3 73 40 41 \n"
"3 73 41 74 \n"
"3 73 74 75 \n"
"3 73 75 76 \n"
"3 73 76 77 \n"
"3 73 77 78 \n"
"3 73 78 79 \n"
"3 73 79 80 \n"
"3 80 79 81 \n"
"3 80 81 82 \n"
"3 80 82 83 \n"
"3 83 82 84 \n"
"3 83 84 85 \n"
"3 85 84 86 \n"
"3 85 86 87 \n"
"3 85 87 88 \n"
"3 88 87 89 \n"
"3 88 89 90 \n"
"3 88 90 91 \n"
"3 91 90 92 \n"
"3 91 92 93 \n"
"3 91 93 94 \n"
"3 91 94 95 \n"
"3 95 94 96 \n"
"3 96 94 97 \n"
"3 97 94 98 \n"
"3 98 94 99 \n"
"3 99 94 100 \n"
;

char *VTK_VECTOR_TEXT_F = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 77 float\n"
"0.000000 0.000000 0.000000 0.000000 1.020020 0.000000 \n"
"0.399994 1.060000 0.000000 1.509990 0.040009 0.000000 \n"
"1.780000 1.280000 0.000000 2.670000 1.940000 0.000000 \n"
"3.959990 0.080017 0.000000 2.950000 2.470000 0.000000 \n"
"3.140000 3.160000 0.000000 3.239990 4.010010 0.000000 \n"
"3.280000 5.050020 0.000000 3.280000 24.709999 0.000000 \n"
"8.230000 0.080017 0.000000 8.280000 5.050020 0.000000 \n"
"8.319990 4.020020 0.000000 8.429990 3.170010 0.000000 \n"
"8.909990 1.940000 0.000000 9.799990 1.270020 0.000000 \n"
"10.720000 0.040009 0.000000 11.160000 1.060000 0.000000 \n"
"11.380000 0.000000 0.000000 12.270000 0.000000 0.000000 \n"
"12.270000 1.020020 0.000000 8.280000 16.070000 0.000000 \n"
"11.380000 14.430000 0.000000 8.280000 14.430000 0.000000 \n"
"11.560000 16.070000 0.000000 12.850000 14.390000 0.000000 \n"
"13.070000 16.110001 0.000000 14.040000 14.260000 0.000000 \n"
"14.270000 16.230000 0.000000 14.990000 14.020000 0.000000 \n"
"15.200000 16.459999 0.000000 15.720000 13.640000 0.000000 \n"
"15.890000 16.830000 0.000000 16.250000 13.120000 0.000000 \n"
"16.370001 17.370001 0.000000 16.620001 12.440000 0.000000 \n"
"16.690001 18.110001 0.000000 16.850000 11.560000 0.000000 \n"
"16.879999 19.070000 0.000000 16.959999 10.490000 0.000000 \n"
"16.959999 20.280001 0.000000 18.160000 15.360000 0.000000 \n"
"18.170000 13.230000 0.000000 18.209999 12.040000 0.000000 \n"
"18.290001 10.490000 0.000000 18.170000 17.510000 0.000000 \n"
"18.209999 18.709999 0.000000 18.290001 20.280001 0.000000 \n"
"0.000000 29.799999 0.000000 0.399994 28.740000 0.000000 \n"
"0.000000 28.740000 0.000000 1.530000 29.760000 0.000000 \n"
"1.780000 28.500000 0.000000 2.659990 29.760000 0.000000 \n"
"2.670000 27.820000 0.000000 2.950000 27.280001 0.000000 \n"
"3.140000 26.600000 0.000000 6.110000 0.089996 0.000000 \n"
"3.239990 25.740000 0.000000 6.810000 29.680000 0.000000 \n"
"8.280000 28.299999 0.000000 10.630000 29.670000 0.000000 \n"
"11.560000 28.299999 0.000000 13.750000 28.240000 0.000000 \n"
"15.560000 28.030001 0.000000 17.030001 27.670000 0.000000 \n"
"18.639999 29.760000 0.000000 18.190001 27.120001 0.000000 \n"
"19.070000 26.370001 0.000000 19.719999 25.379999 0.000000 \n"
"20.170000 24.139999 0.000000 21.299999 29.799999 0.000000 \n"
"20.459999 22.629999 0.000000 21.480000 26.360001 0.000000 \n"
"21.790001 22.719999 0.000000 \n"
"POLYGONS 75 300\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 3 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 6 8 9 \n"
"3 6 9 10 \n"
"3 6 10 11 \n"
"3 12 13 14 \n"
"3 12 14 15 \n"
"3 12 15 16 \n"
"3 12 16 17 \n"
"3 12 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 21 19 22 \n"
"3 23 24 25 \n"
"3 24 23 26 \n"
"3 24 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 37 36 38 \n"
"3 37 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 41 44 45 \n"
"3 41 45 46 \n"
"3 42 47 43 \n"
"3 47 42 48 \n"
"3 48 42 49 \n"
"3 50 51 52 \n"
"3 51 50 53 \n"
"3 51 53 54 \n"
"3 54 53 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 57 55 58 \n"
"3 11 59 6 \n"
"3 59 11 60 \n"
"3 59 60 61 \n"
"3 61 60 58 \n"
"3 61 58 55 \n"
"3 61 12 59 \n"
"3 12 61 13 \n"
"3 13 61 25 \n"
"3 25 61 23 \n"
"3 23 61 62 \n"
"3 62 61 63 \n"
"3 62 63 64 \n"
"3 64 63 65 \n"
"3 65 63 66 \n"
"3 66 63 67 \n"
"3 67 63 68 \n"
"3 67 68 69 \n"
"3 69 68 70 \n"
"3 70 68 71 \n"
"3 71 68 72 \n"
"3 72 68 73 \n"
"3 72 73 74 \n"
"3 74 73 75 \n"
"3 74 75 76 \n"
;

char *VTK_VECTOR_TEXT_G = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 82 float\n"
"21.309999 12.360000 0.000000 21.309999 13.510000 0.000000 \n"
"22.110001 13.480000 0.000000 22.190001 12.260000 0.000000 \n"
"22.680000 13.460000 0.000000 22.900000 12.100000 0.000000 \n"
"23.450001 11.860000 0.000000 23.860001 11.500000 0.000000 \n"
"24.969999 13.420000 0.000000 24.139999 11.020000 0.000000 \n"
"24.330000 10.390000 0.000000 24.420000 9.579990 0.000000 \n"
"24.450001 8.590000 0.000000 4.849990 26.510000 0.000000 \n"
"6.179990 19.770000 0.000000 5.980000 17.010000 0.000000 \n"
"6.759990 22.209999 0.000000 7.409990 28.320000 0.000000 \n"
"7.720000 24.309999 0.000000 9.030000 26.059999 0.000000 \n"
"10.430000 29.670000 0.000000 10.680000 27.450001 0.000000 \n"
"12.670000 28.450001 0.000000 13.860000 30.500000 0.000000 \n"
"14.980000 29.070000 0.000000 17.590000 29.270000 0.000000 \n"
"17.670000 30.780001 0.000000 19.780001 29.150000 0.000000 \n"
"20.469999 30.670000 0.000000 21.730000 28.780001 0.000000 \n"
"23.270000 30.340000 0.000000 23.440001 28.170000 0.000000 \n"
"24.889999 27.320000 0.000000 26.090000 26.250000 0.000000 \n"
"26.129999 29.770000 0.000000 27.030001 24.940001 0.000000 \n"
"27.690001 23.410000 0.000000 29.100000 28.959999 0.000000 \n"
"28.080000 21.660000 0.000000 29.280001 21.660000 0.000000 \n"
"0.080002 16.950001 0.000000 0.319992 12.010000 0.000000 \n"
"0.000000 15.230000 0.000000 0.330002 18.590000 0.000000 \n"
"1.239990 9.079990 0.000000 1.269990 21.610001 0.000000 \n"
"2.709990 6.479980 0.000000 2.789990 24.260000 0.000000 \n"
"4.679990 4.260010 0.000000 6.239990 13.830000 0.000000 \n"
"6.970000 10.900000 0.000000 7.120000 2.459990 0.000000 \n"
"8.129990 8.280000 0.000000 9.689990 6.010010 0.000000 \n"
"9.959990 1.120000 0.000000 11.580000 4.160000 0.000000 \n"
"13.170000 0.290009 0.000000 13.770000 2.769990 0.000000 \n"
"16.219999 1.899990 0.000000 16.700001 0.000000 0.000000 \n"
"18.870001 1.590000 0.000000 19.490000 0.119995 0.000000 \n"
"20.219999 1.669980 0.000000 21.490000 1.919980 0.000000 \n"
"22.219999 0.549988 0.000000 22.860001 2.399990 0.000000 \n"
"23.709999 0.899994 0.000000 24.450001 3.139980 0.000000 \n"
"25.340000 1.359990 0.000000 26.889999 13.420000 0.000000 \n"
"27.180000 1.949980 0.000000 28.850000 13.420000 0.000000 \n"
"29.280001 2.660000 0.000000 29.280001 8.769990 0.000000 \n"
"29.309999 9.699980 0.000000 29.410000 10.460000 0.000000 \n"
"29.889999 11.530000 0.000000 30.870001 12.110000 0.000000 \n"
"31.049999 13.460000 0.000000 31.580000 12.260000 0.000000 \n"
"32.470001 12.360000 0.000000 32.470001 13.510000 0.000000 \n"

"POLYGONS 80 320\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 7 4 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 10 8 11 \n"
"3 11 8 12 \n"
"3 13 14 15 \n"
"3 14 13 16 \n"
"3 16 13 17 \n"
"3 16 17 18 \n"
"3 18 17 19 \n"
"3 19 17 20 \n"
"3 19 20 21 \n"
"3 21 20 22 \n"
"3 22 20 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 25 23 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 33 30 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 36 34 37 \n"
"3 36 37 38 \n"
"3 38 37 39 \n"
"3 40 41 42 \n"
"3 41 40 43 \n"
"3 41 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 48 47 13 \n"
"3 48 13 15 \n"
"3 48 15 49 \n"
"3 48 49 50 \n"
"3 48 50 51 \n"
"3 51 50 52 \n"
"3 51 52 53 \n"
"3 51 53 54 \n"
"3 54 53 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 56 57 58 \n"
"3 56 58 59 \n"
"3 59 58 60 \n"
"3 59 60 61 \n"
"3 61 60 62 \n"
"3 61 62 63 \n"
"3 61 63 64 \n"
"3 64 63 65 \n"
"3 64 65 66 \n"
"3 66 65 67 \n"
"3 67 12 8 \n"
"3 67 8 68 \n"
"3 67 68 66 \n"
"3 68 8 69 \n"
"3 68 69 70 \n"
"3 70 69 71 \n"
"3 70 71 72 \n"
"3 72 71 73 \n"
"3 73 71 74 \n"
"3 74 71 75 \n"
"3 75 71 76 \n"
"3 76 71 77 \n"
"3 77 71 78 \n"
"3 77 78 79 \n"
"3 79 78 80 \n"
"3 80 78 81 \n"
;

char *VTK_VECTOR_TEXT_H = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 104 float\n"
"0.000000 29.799999 0.000000 0.439972 28.740000 0.000000 \n"
"0.000000 28.740000 0.000000 0.829987 29.780001 0.000000 \n"
"1.459990 29.760000 0.000000 1.819980 28.510000 0.000000 \n"
"2.709990 27.840000 0.000000 3.750000 29.740000 0.000000 \n"
"2.989990 27.299999 0.000000 3.179990 26.600000 0.000000 \n"
"3.289980 25.740000 0.000000 3.319980 24.709999 0.000000 \n"
"7.439970 0.059998 0.000000 8.319980 5.050020 0.000000 \n"
"8.359990 4.010010 0.000000 8.459990 3.160000 0.000000 \n"
"8.649990 2.470000 0.000000 8.679990 0.029999 0.000000 \n"
"8.929990 1.940000 0.000000 9.819980 1.280000 0.000000 \n"
"10.230000 0.000000 0.000000 10.830000 0.000000 0.000000 \n"
"11.200000 1.060000 0.000000 11.690000 0.000000 0.000000 \n"
"11.690000 1.020020 0.000000 0.000000 0.000000 0.000000 \n"
"0.000000 1.020020 0.000000 0.439972 1.060000 0.000000 \n"
"1.459990 0.000000 0.000000 1.819980 1.280000 0.000000 \n"
"2.709990 1.940000 0.000000 3.099980 0.029999 0.000000 \n"
"2.989990 2.470000 0.000000 3.179990 3.160000 0.000000 \n"
"3.289980 4.010010 0.000000 3.319980 5.050020 0.000000 \n"
"4.379970 0.059998 0.000000 5.289980 0.080017 0.000000 \n"
"5.840000 0.089996 0.000000 5.840000 29.709999 0.000000 \n"
"6.489990 0.080017 0.000000 8.319980 14.970000 0.000000 \n"
"8.319980 16.610001 0.000000 8.319980 24.709999 0.000000 \n"
"8.359990 25.740000 0.000000 8.459990 26.600000 0.000000 \n"
"8.649990 27.299999 0.000000 8.929990 27.840000 0.000000 \n"
"9.819980 28.510000 0.000000 10.230000 29.760000 0.000000 \n"
"11.200000 28.740000 0.000000 11.690000 28.740000 0.000000 \n"
"11.690000 29.799999 0.000000 24.040001 14.970000 0.000000 \n"
"24.040001 16.610001 0.000000 20.770000 29.799999 0.000000 \n"
"21.170000 28.740000 0.000000 20.770000 28.740000 0.000000 \n"
"22.230000 29.760000 0.000000 22.549999 28.500000 0.000000 \n"
"23.440001 27.820000 0.000000 23.590000 29.730000 0.000000 \n"
"23.719999 27.280001 0.000000 23.910000 26.600000 0.000000 \n"
"24.010000 25.740000 0.000000 24.760000 29.700001 0.000000 \n"
"24.040001 24.709999 0.000000 20.680000 0.000000 0.000000 \n"
"20.680000 1.020020 0.000000 21.170000 1.060000 0.000000 \n"
"22.410000 0.050018 0.000000 22.549999 1.280000 0.000000 \n"
"23.440001 1.940000 0.000000 23.780001 0.080017 0.000000 \n"
"23.719999 2.470000 0.000000 23.910000 3.160000 0.000000 \n"
"24.010000 4.010010 0.000000 24.040001 5.050020 0.000000 \n"
"26.480000 0.089996 0.000000 26.570000 29.670000 0.000000 \n"
"27.389999 29.680000 0.000000 28.400000 29.700001 0.000000 \n"
"29.049999 5.050020 0.000000 29.080000 4.010010 0.000000 \n"
"29.190001 3.160000 0.000000 29.209999 0.080017 0.000000 \n"
"29.379999 2.470000 0.000000 29.660000 1.940000 0.000000 \n"
"30.540001 1.280000 0.000000 30.590000 0.050018 0.000000 \n"
"31.930000 1.060000 0.000000 32.330002 0.000000 0.000000 \n"
"32.330002 1.020020 0.000000 29.049999 24.709999 0.000000 \n"
"29.080000 25.740000 0.000000 29.190001 26.600000 0.000000 \n"
"29.379999 27.299999 0.000000 29.580000 29.730000 0.000000 \n"
"29.660000 27.840000 0.000000 30.540001 28.510000 0.000000 \n"
"30.950001 29.760000 0.000000 31.930000 28.740000 0.000000 \n"
"32.419998 28.740000 0.000000 32.419998 29.799999 0.000000 \n"

"POLYGONS 102 408\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 9 7 10 \n"
"3 10 7 11 \n"
"3 12 13 14 \n"
"3 12 14 15 \n"
"3 12 15 16 \n"
"3 12 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 17 19 20 \n"
"3 20 19 21 \n"
"3 21 19 22 \n"
"3 21 22 23 \n"
"3 23 22 24 \n"
"3 25 26 27 \n"
"3 25 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 28 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 31 33 34 \n"
"3 35 11 7 \n"
"3 35 7 36 \n"
"3 35 36 34 \n"
"3 34 36 31 \n"
"3 7 37 36 \n"
"3 37 7 38 \n"
"3 38 7 39 \n"
"3 38 39 40 \n"
"3 40 39 12 \n"
"3 12 39 13 \n"
"3 13 39 41 \n"
"3 41 39 42 \n"
"3 42 39 43 \n"
"3 43 39 44 \n"
"3 44 39 45 \n"
"3 45 39 46 \n"
"3 46 39 47 \n"
"3 47 39 48 \n"
"3 48 39 49 \n"
"3 48 49 50 \n"
"3 50 49 51 \n"
"3 51 49 52 \n"
"3 42 53 41 \n"
"3 53 42 54 \n"
"3 55 56 57 \n"
"3 56 55 58 \n"
"3 56 58 59 \n"
"3 59 58 60 \n"
"3 60 58 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
"3 63 61 64 \n"
"3 64 61 65 \n"
"3 64 65 66 \n"
"3 67 68 69 \n"
"3 67 69 70 \n"
"3 70 69 71 \n"
"3 70 71 72 \n"
"3 70 72 73 \n"
"3 73 72 74 \n"
"3 73 74 75 \n"
"3 73 75 76 \n"
"3 77 53 54 \n"
"3 77 54 66 \n"
"3 77 66 65 \n"
"3 77 65 78 \n"
"3 77 78 76 \n"
"3 76 78 73 \n"
"3 78 65 79 \n"
"3 78 79 80 \n"
"3 78 80 81 \n"
"3 78 81 82 \n"
"3 78 82 83 \n"
"3 78 83 84 \n"
"3 78 84 85 \n"
"3 85 84 86 \n"
"3 85 86 87 \n"
"3 85 87 88 \n"
"3 85 88 89 \n"
"3 89 88 90 \n"
"3 89 90 91 \n"
"3 91 90 92 \n"
"3 81 93 82 \n"
"3 93 81 94 \n"
"3 94 81 95 \n"
"3 95 81 96 \n"
"3 96 81 97 \n"
"3 96 97 98 \n"
"3 98 97 99 \n"
"3 99 97 100 \n"
"3 99 100 101 \n"
"3 101 100 102 \n"
"3 102 100 103 \n"
;

char *VTK_VECTOR_TEXT_I = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 46 float\n"
"0.000000 29.799999 0.000000 0.440002 28.740000 0.000000 \n"
"0.000000 28.740000 0.000000 0.829987 29.780001 0.000000 \n"
"1.459990 29.760000 0.000000 1.819980 28.510000 0.000000 \n"
"2.709990 27.840000 0.000000 3.750000 29.740000 0.000000 \n"
"2.989990 27.299999 0.000000 3.179990 26.600000 0.000000 \n"
"3.289980 25.740000 0.000000 3.319980 24.709999 0.000000 \n"
"0.000000 0.000000 0.000000 0.000000 1.020020 0.000000 \n"
"0.440002 1.060000 0.000000 1.729980 0.050018 0.000000 \n"
"1.819980 1.280000 0.000000 2.709990 1.940000 0.000000 \n"
"2.989990 2.470000 0.000000 3.120000 0.080017 0.000000 \n"
"3.179990 3.160000 0.000000 3.289980 4.010010 0.000000 \n"
"3.319980 5.050020 0.000000 5.840000 0.089996 0.000000 \n"
"5.840000 29.709999 0.000000 8.319980 5.050020 0.000000 \n"
"8.359990 4.010010 0.000000 8.459990 3.160000 0.000000 \n"
"8.569980 0.080017 0.000000 8.649990 2.470000 0.000000 \n"
"8.929990 1.940000 0.000000 9.819980 1.280000 0.000000 \n"
"9.949980 0.050018 0.000000 11.200000 1.060000 0.000000 \n"
"11.690000 0.000000 0.000000 11.690000 1.020020 0.000000 \n"
"8.319980 24.709999 0.000000 8.359990 25.740000 0.000000 \n"
"8.459990 26.600000 0.000000 8.649990 27.299999 0.000000 \n"
"8.929990 27.840000 0.000000 9.819980 28.510000 0.000000 \n"
"10.230000 29.760000 0.000000 11.200000 28.740000 0.000000 \n"
"11.690000 28.740000 0.000000 11.690000 29.799999 0.000000 \n"

"POLYGONS 44 176\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 9 7 10 \n"
"3 10 7 11 \n"
"3 12 13 14 \n"
"3 12 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 15 17 18 \n"
"3 15 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 22 11 7 \n"
"3 22 7 23 \n"
"3 22 23 21 \n"
"3 21 23 19 \n"
"3 23 7 24 \n"
"3 23 24 25 \n"
"3 23 25 26 \n"
"3 23 26 27 \n"
"3 23 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 28 30 31 \n"
"3 28 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 24 36 25 \n"
"3 36 24 37 \n"
"3 37 24 38 \n"
"3 38 24 39 \n"
"3 39 24 40 \n"
"3 40 24 41 \n"
"3 41 24 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 44 42 45 \n"
;

char *VTK_VECTOR_TEXT_J = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 54 float\n"
"0.000000 6.769990 0.000000 1.260010 0.369995 0.000000 \n"
"0.000000 0.709991 0.000000 1.329990 6.769990 0.000000 \n"
"1.470000 5.500000 0.000000 1.690000 4.389980 0.000000 \n"
"2.010010 3.450010 0.000000 2.370000 0.149994 0.000000 \n"
"2.399990 2.690000 0.000000 2.889980 2.090000 0.000000 \n"
"3.459990 1.670010 0.000000 4.120000 1.410000 0.000000 \n"
"4.519990 0.000000 0.000000 4.870000 1.329990 0.000000 \n"
"6.090000 1.560000 0.000000 6.429990 0.119995 0.000000 \n"
"6.540010 1.880000 0.000000 6.889980 2.350010 0.000000 \n"
"7.139980 2.989990 0.000000 8.070010 0.510010 0.000000 \n"
"7.310000 3.810000 0.000000 7.410000 4.829990 0.000000 \n"
"7.440000 6.070010 0.000000 7.440000 25.110001 0.000000 \n"
"4.120000 30.200001 0.000000 4.560000 29.139999 0.000000 \n"
"4.120000 29.139999 0.000000 5.649990 30.150000 0.000000 \n"
"5.940000 28.900000 0.000000 6.829990 28.219999 0.000000 \n"
"6.929990 30.129999 0.000000 7.109990 27.680000 0.000000 \n"
"7.299990 27.000000 0.000000 7.410000 26.139999 0.000000 \n"
"8.299990 30.110001 0.000000 9.420010 1.160000 0.000000 \n"
"10.050000 30.110001 0.000000 10.520000 2.079990 0.000000 \n"
"11.350000 3.290010 0.000000 11.780000 30.110001 0.000000 \n"
"11.940000 4.780000 0.000000 12.290000 6.579990 0.000000 \n"
"12.400000 8.679990 0.000000 12.400000 25.110001 0.000000 \n"
"12.430000 26.139999 0.000000 12.540000 27.000000 0.000000 \n"
"12.740000 27.700001 0.000000 13.030000 28.240000 0.000000 \n"
"13.140000 30.129999 0.000000 13.930000 28.910000 0.000000 \n"
"14.430000 30.150000 0.000000 15.320000 29.139999 0.000000 \n"
"15.990000 29.139999 0.000000 15.990000 30.200001 0.000000 \n"

"POLYGONS 52 208\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 1 5 6 \n"
"3 1 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 7 9 10 \n"
"3 7 10 11 \n"
"3 7 11 12 \n"
"3 12 11 13 \n"
"3 12 13 14 \n"
"3 12 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 15 17 18 \n"
"3 15 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 19 21 22 \n"
"3 19 22 23 \n"
"3 24 25 26 \n"
"3 25 24 27 \n"
"3 25 27 28 \n"
"3 28 27 29 \n"
"3 29 27 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 33 30 34 \n"
"3 33 34 23 \n"
"3 23 34 19 \n"
"3 19 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 37 36 38 \n"
"3 38 36 39 \n"
"3 38 39 40 \n"
"3 40 39 41 \n"
"3 41 39 42 \n"
"3 42 39 43 \n"
"3 43 39 44 \n"
"3 44 39 45 \n"
"3 45 39 46 \n"
"3 46 39 47 \n"
"3 47 39 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 52 50 53 \n"
;

char *VTK_VECTOR_TEXT_K = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 92 float\n"
"0.079987 29.799999 0.000000 0.479980 28.740000 0.000000 \n"
"0.079987 28.740000 0.000000 1.739990 29.740000 0.000000 \n"
"1.870000 28.500000 0.000000 2.750000 27.820000 0.000000 \n"
"3.079990 29.700001 0.000000 3.040010 27.280001 0.000000 \n"
"3.220000 26.600000 0.000000 3.329990 25.740000 0.000000 \n"
"4.380000 29.680000 0.000000 3.359990 24.709999 0.000000 \n"
"0.000000 0.000000 0.000000 0.000000 1.020020 0.000000 \n"
"0.479980 1.060000 0.000000 1.729980 0.050018 0.000000 \n"
"1.870000 1.280000 0.000000 2.750000 1.940000 0.000000 \n"
"3.100010 0.080017 0.000000 3.040010 2.470000 0.000000 \n"
"3.220000 3.160000 0.000000 3.329990 4.010010 0.000000 \n"
"3.359990 5.050020 0.000000 5.799990 0.089996 0.000000 \n"
"5.889980 29.670000 0.000000 7.389980 29.680000 0.000000 \n"
"8.370000 5.050020 0.000000 8.399990 4.010010 0.000000 \n"
"8.510010 3.160000 0.000000 8.519990 0.080017 0.000000 \n"
"8.690000 2.470000 0.000000 8.979980 1.940000 0.000000 \n"
"9.859990 1.280000 0.000000 9.910000 0.050018 0.000000 \n"
"11.250000 1.060000 0.000000 11.640000 0.000000 0.000000 \n"
"11.640000 1.020020 0.000000 8.370000 12.530000 0.000000 \n"
"8.370000 14.610000 0.000000 8.370000 24.709999 0.000000 \n"
"8.399990 25.740000 0.000000 8.510010 26.600000 0.000000 \n"
"8.690000 29.700001 0.000000 8.690000 27.299999 0.000000 \n"
"8.979980 27.840000 0.000000 9.859990 28.510000 0.000000 \n"
"10.050000 29.740000 0.000000 11.250000 28.740000 0.000000 \n"
"11.730000 28.740000 0.000000 11.730000 29.799999 0.000000 \n"
"17.219999 29.799999 0.000000 18.469999 28.549999 0.000000 \n"
"17.219999 28.610001 0.000000 18.940001 29.730000 0.000000 \n"
"19.260000 28.360001 0.000000 19.670000 28.010000 0.000000 \n"
"20.350000 29.690001 0.000000 19.790001 27.459999 0.000000 \n"
"10.270000 14.520000 0.000000 13.180000 10.980000 0.000000 \n"
"11.420000 13.110000 0.000000 13.900000 18.070000 0.000000 \n"
"18.600000 25.639999 0.000000 19.139999 26.240000 0.000000 \n"
"19.510000 26.730000 0.000000 20.719999 24.980000 0.000000 \n"
"21.709999 25.930000 0.000000 22.610001 26.730000 0.000000 \n"
"23.070000 29.670000 0.000000 24.270000 27.860001 0.000000 \n"
"25.850000 28.469999 0.000000 27.540001 28.650000 0.000000 \n"
"27.990000 28.650000 0.000000 27.990000 29.799999 0.000000 \n"
"14.700000 9.120000 0.000000 18.459999 4.429990 0.000000 \n"
"19.100000 3.620000 0.000000 19.590000 2.959990 0.000000 \n"
"20.230000 1.950010 0.000000 22.120001 0.050018 0.000000 \n"
"20.530001 1.060000 0.000000 20.629999 0.000000 0.000000 \n"
"23.270000 0.100006 0.000000 25.280001 4.120000 0.000000 \n"
"25.370001 0.130005 0.000000 26.549999 2.700010 0.000000 \n"
"27.520000 0.100006 0.000000 27.660000 1.810000 0.000000 \n"
"28.740000 0.050018 0.000000 28.840000 1.310000 0.000000 \n"
"30.330000 0.000000 0.000000 30.330000 1.060000 0.000000 \n"

"POLYGONS 90 360\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 5 3 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 8 6 9 \n"
"3 9 6 10 \n"
"3 9 10 11 \n"
"3 12 13 14 \n"
"3 12 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 15 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 18 20 21 \n"
"3 22 11 10 \n"
"3 22 10 21 \n"
"3 21 10 23 \n"
"3 21 23 18 \n"
"3 23 10 24 \n"
"3 23 24 25 \n"
"3 23 25 26 \n"
"3 23 26 27 \n"
"3 23 27 28 \n"
"3 23 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 29 31 32 \n"
"3 29 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 25 37 26 \n"
"3 37 25 38 \n"
"3 38 25 39 \n"
"3 39 25 40 \n"
"3 40 25 41 \n"
"3 41 25 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 44 42 45 \n"
"3 45 42 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 48 46 49 \n"
"3 50 51 52 \n"
"3 51 50 53 \n"
"3 51 53 54 \n"
"3 54 53 55 \n"
"3 55 53 56 \n"
"3 55 56 57 \n"
"3 38 58 37 \n"
"3 58 59 60 \n"
"3 59 58 61 \n"
"3 61 58 38 \n"
"3 61 38 62 \n"
"3 61 62 63 \n"
"3 61 63 64 \n"
"3 61 64 65 \n"
"3 65 64 57 \n"
"3 65 57 56 \n"
"3 65 56 66 \n"
"3 66 56 67 \n"
"3 67 56 68 \n"
"3 67 68 69 \n"
"3 69 68 70 \n"
"3 70 68 71 \n"
"3 71 68 72 \n"
"3 72 68 73 \n"
"3 61 74 59 \n"
"3 74 61 75 \n"
"3 75 61 76 \n"
"3 76 61 77 \n"
"3 77 61 78 \n"
"3 78 61 79 \n"
"3 78 79 80 \n"
"3 80 79 81 \n"
"3 61 82 79 \n"
"3 82 61 83 \n"
"3 82 83 84 \n"
"3 84 83 85 \n"
"3 84 85 86 \n"
"3 86 85 87 \n"
"3 86 87 88 \n"
"3 88 87 89 \n"
"3 88 89 90 \n"
"3 90 89 91 \n"
;

char *VTK_VECTOR_TEXT_L = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 59 float\n"
"0.000000 29.799999 0.000000 0.660004 28.740000 0.000000 \n"
"0.000000 28.740000 0.000000 1.560000 29.750000 0.000000 \n"
"2.030000 28.510000 0.000000 2.880000 29.730000 0.000000 \n"
"2.919980 27.840000 0.000000 3.199980 27.299999 0.000000 \n"
"3.399990 26.600000 0.000000 4.280000 29.709999 0.000000 \n"
"3.510010 25.740000 0.000000 3.540010 24.709999 0.000000 \n"
"7.829990 29.709999 0.000000 8.549990 24.709999 0.000000 \n"
"8.549990 6.550020 0.000000 8.579990 25.740000 0.000000 \n"
"8.690000 26.600000 0.000000 8.889980 27.299999 0.000000 \n"
"9.169980 27.840000 0.000000 9.209990 29.730000 0.000000 \n"
"10.060000 28.510000 0.000000 10.520000 29.750000 0.000000 \n"
"11.420000 28.740000 0.000000 12.090000 28.740000 0.000000 \n"
"12.090000 29.799999 0.000000 0.000000 0.000000 0.000000 \n"
"0.000000 1.020020 0.000000 0.660004 1.060000 0.000000 \n"
"2.030000 1.280000 0.000000 2.880000 0.040009 0.000000 \n"
"2.919980 1.959990 0.000000 3.399990 3.179990 0.000000 \n"
"3.540010 5.050020 0.000000 6.070010 29.709999 0.000000 \n"
"3.510010 4.020020 0.000000 7.060000 0.140015 0.000000 \n"
"8.590000 5.100010 0.000000 8.739990 3.959990 0.000000 \n"
"9.049990 3.080020 0.000000 9.530000 2.440000 0.000000 \n"
"10.240000 2.000000 0.000000 11.200000 1.730010 0.000000 \n"
"11.510000 0.170013 0.000000 12.450000 1.590000 0.000000 \n"
"14.040000 1.550020 0.000000 14.260000 0.170013 0.000000 \n"
"15.870000 1.620000 0.000000 16.780001 0.140015 0.000000 \n"
"17.430000 1.850010 0.000000 18.730000 2.270020 0.000000 \n"
"19.549999 0.080017 0.000000 19.820000 2.880000 0.000000 \n"
"20.700001 3.700010 0.000000 21.190001 0.040009 0.000000 \n"
"21.410000 4.760010 0.000000 21.969999 6.070010 0.000000 \n"
"22.410000 7.660000 0.000000 23.070000 0.000000 0.000000 \n"
"23.740000 7.570010 0.000000 \n"
"POLYGONS 57 228\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 8 5 9 \n"
"3 8 9 10 \n"
"3 10 9 11 \n"
"3 12 13 14 \n"
"3 13 12 15 \n"
"3 15 12 16 \n"
"3 16 12 17 \n"
"3 17 12 18 \n"
"3 18 12 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 23 21 24 \n"
"3 25 26 27 \n"
"3 25 27 28 \n"
"3 25 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 32 11 9 \n"
"3 32 9 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 34 35 31 \n"
"3 31 35 29 \n"
"3 35 33 12 \n"
"3 35 12 14 \n"
"3 35 14 36 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 35 38 39 \n"
"3 35 39 40 \n"
"3 35 40 41 \n"
"3 35 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 47 49 50 \n"
"3 50 49 51 \n"
"3 50 51 52 \n"
"3 50 52 53 \n"
"3 53 52 54 \n"
"3 53 54 55 \n"
"3 53 55 56 \n"
"3 53 56 57 \n"
"3 57 56 58 \n"
;

char *VTK_VECTOR_TEXT_M = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 89 float\n"
"0.000000 0.579987 0.000000 0.000000 1.639980 0.000000 \n"
"0.950012 1.759980 0.000000 1.730010 1.970000 0.000000 \n"
"2.020020 0.619995 0.000000 2.340000 2.289980 0.000000 \n"
"2.810000 2.750000 0.000000 3.100010 0.639984 0.000000 \n"
"3.149990 3.359990 0.000000 3.380000 4.160000 0.000000 \n"
"3.520020 5.149990 0.000000 3.590000 6.380000 0.000000 \n"
"4.030000 25.250000 0.000000 4.080020 26.309999 0.000000 \n"
"4.610020 0.669983 0.000000 0.709991 30.379999 0.000000 \n"
"2.340000 29.010000 0.000000 0.709991 29.280001 0.000000 \n"
"2.670010 30.280001 0.000000 3.370000 28.490000 0.000000 \n"
"3.610020 30.260000 0.000000 3.920010 27.620001 0.000000 \n"
"4.830020 30.250000 0.000000 5.490020 6.380000 0.000000 \n"
"5.530000 5.100010 0.000000 5.660000 4.060000 0.000000 \n"
"5.890010 3.239990 0.000000 6.090000 0.639984 0.000000 \n"
"6.240020 2.609990 0.000000 6.730010 2.169980 0.000000 \n"
"7.160000 0.619995 0.000000 7.380000 1.870000 0.000000 \n"
"8.200010 1.699980 0.000000 9.209990 0.579987 0.000000 \n"
"9.209990 1.639980 0.000000 26.040001 0.579987 0.000000 \n"
"26.040001 1.639980 0.000000 27.070000 1.690000 0.000000 \n"
"27.590000 0.619995 0.000000 27.889999 1.840000 0.000000 \n"
"28.530001 2.090000 0.000000 29.010000 2.470000 0.000000 \n"
"30.090000 0.720001 0.000000 29.350000 3.009980 0.000000 \n"
"29.570000 3.720000 0.000000 29.680000 4.630000 0.000000 \n"
"29.719999 5.759980 0.000000 29.719999 6.109990 0.000000 \n"
"5.580020 25.290001 0.000000 6.050020 30.260000 0.000000 \n"
"6.990020 30.280001 0.000000 8.950010 30.379999 0.000000 \n"
"16.790001 0.000000 0.000000 17.719999 0.000000 0.000000 \n"
"19.090000 7.130000 0.000000 29.190001 27.020000 0.000000 \n"
"29.190001 30.379999 0.000000 30.280001 30.320000 0.000000 \n"
"31.190001 30.280001 0.000000 32.150002 30.260000 0.000000 \n"
"32.150002 0.750000 0.000000 33.400002 30.250000 0.000000 \n"
"34.169998 0.720001 0.000000 34.240002 25.250000 0.000000 \n"
"34.240002 25.690001 0.000000 34.270000 26.629999 0.000000 \n"
"34.380001 27.389999 0.000000 34.590000 27.990000 0.000000 \n"
"34.639999 30.260000 0.000000 34.910000 28.459999 0.000000 \n"
"35.349998 28.809999 0.000000 35.599998 30.280001 0.000000 \n"
"35.939999 29.040001 0.000000 36.509998 30.320000 0.000000 \n"
"36.680000 29.190001 0.000000 37.599998 29.280001 0.000000 \n"
"37.599998 30.379999 0.000000 34.770000 5.759980 0.000000 \n"
"34.820000 4.709990 0.000000 34.950001 3.850010 0.000000 \n"
"35.169998 3.169980 0.000000 35.490002 2.639980 0.000000 \n"
"35.919998 2.259980 0.000000 36.470001 2.000000 0.000000 \n"
"36.720001 0.619995 0.000000 37.360001 0.600006 0.000000 \n"
"38.000000 1.819980 0.000000 38.270000 0.579987 0.000000 \n"
"38.270000 1.819980 0.000000 \n"
"POLYGONS 87 348\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 4 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 7 9 10 \n"
"3 11 12 13 \n"
"3 11 13 14 \n"
"3 11 14 10 \n"
"3 10 14 7 \n"
"3 15 16 17 \n"
"3 16 15 18 \n"
"3 16 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 21 20 13 \n"
"3 13 20 22 \n"
"3 13 22 14 \n"
"3 14 22 23 \n"
"3 14 23 24 \n"
"3 14 24 25 \n"
"3 14 25 26 \n"
"3 14 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 27 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 30 32 33 \n"
"3 33 32 34 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 38 40 41 \n"
"3 38 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 42 45 46 \n"
"3 42 46 47 \n"
"3 22 48 23 \n"
"3 48 22 49 \n"
"3 48 49 50 \n"
"3 48 50 51 \n"
"3 48 51 52 \n"
"3 52 51 53 \n"
"3 53 51 54 \n"
"3 53 54 55 \n"
"3 55 54 56 \n"
"3 55 56 47 \n"
"3 47 56 42 \n"
"3 42 56 57 \n"
"3 42 57 58 \n"
"3 42 58 59 \n"
"3 42 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
"3 63 61 64 \n"
"3 64 61 65 \n"
"3 65 61 66 \n"
"3 66 61 67 \n"
"3 67 61 68 \n"
"3 67 68 69 \n"
"3 69 68 70 \n"
"3 70 68 71 \n"
"3 70 71 72 \n"
"3 72 71 73 \n"
"3 72 73 74 \n"
"3 74 73 75 \n"
"3 75 73 76 \n"
"3 62 63 77 \n"
"3 62 77 78 \n"
"3 62 78 79 \n"
"3 62 79 80 \n"
"3 62 80 81 \n"
"3 62 81 82 \n"
"3 62 82 83 \n"
"3 62 83 84 \n"
"3 84 83 85 \n"
"3 85 83 86 \n"
"3 85 86 87 \n"
"3 87 86 88 \n"
;

char *VTK_VECTOR_TEXT_N = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 70 float\n"
"0.139984 30.510000 0.000000 1.120000 29.260000 0.000000 \n"
"0.139984 29.320000 0.000000 1.899990 29.110001 0.000000 \n"
"1.979980 30.469999 0.000000 2.519990 28.860001 0.000000 \n"
"2.880000 30.469999 0.000000 2.989990 28.469999 0.000000 \n"
"3.319980 27.930000 0.000000 3.530000 27.219999 0.000000 \n"
"4.030000 30.469999 0.000000 3.639980 26.309999 0.000000 \n"
"3.679990 25.200001 0.000000 4.649990 0.799988 0.000000 \n"
"5.449980 6.820010 0.000000 5.489990 5.519990 0.000000 \n"
"5.630000 4.449980 0.000000 5.880000 3.600010 0.000000 \n"
"6.039980 0.790009 0.000000 6.250000 2.940000 0.000000 \n"
"6.769990 2.449980 0.000000 7.120000 0.769989 0.000000 \n"
"7.449980 2.120000 0.000000 8.130000 0.739990 0.000000 \n"
"8.299990 1.910000 0.000000 9.349980 0.709991 0.000000 \n"
"9.349980 1.810000 0.000000 0.000000 0.709991 0.000000 \n"
"0.000000 1.730010 0.000000 0.989990 1.840000 0.000000 \n"
"1.220000 0.739990 0.000000 1.789980 2.060000 0.000000 \n"
"2.229980 0.769989 0.000000 2.429990 2.410000 0.000000 \n"
"2.919980 2.899990 0.000000 3.280000 3.560000 0.000000 \n"
"3.289980 0.790009 0.000000 3.509980 4.399990 0.000000 \n"
"3.639980 5.449980 0.000000 3.679990 6.730010 0.000000 \n"
"5.449980 25.420000 0.000000 7.929990 30.510000 0.000000 \n"
"27.549999 8.459990 0.000000 28.350000 0.000000 0.000000 \n"
"27.549999 25.110001 0.000000 23.870001 30.510000 0.000000 \n"
"24.920000 29.250000 0.000000 23.870001 29.360001 0.000000 \n"
"25.260000 30.459999 0.000000 25.760000 29.080000 0.000000 \n"
"26.370001 30.440001 0.000000 26.400000 28.809999 0.000000 \n"
"26.879999 28.410000 0.000000 27.200001 27.879999 0.000000 \n"
"27.520000 26.250000 0.000000 28.520000 30.420000 0.000000 \n"
"27.410000 27.160000 0.000000 29.320000 0.000000 0.000000 \n"
"29.500000 25.330000 0.000000 29.549999 26.430000 0.000000 \n"
"29.670000 27.320000 0.000000 29.900000 28.010000 0.000000 \n"
"30.240000 28.540001 0.000000 30.700001 30.440001 0.000000 \n"
"30.719999 28.910000 0.000000 31.350000 29.150000 0.000000 \n"
"31.790001 30.459999 0.000000 32.169998 29.280001 0.000000 \n"
"33.169998 29.320000 0.000000 33.169998 30.510000 0.000000 \n"

"POLYGONS 68 272\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 8 6 9 \n"
"3 9 6 10 \n"
"3 9 10 11 \n"
"3 11 10 12 \n"
"3 13 14 15 \n"
"3 13 15 16 \n"
"3 13 16 17 \n"
"3 13 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 18 20 21 \n"
"3 21 20 22 \n"
"3 21 22 23 \n"
"3 23 22 24 \n"
"3 23 24 25 \n"
"3 25 24 26 \n"
"3 27 28 29 \n"
"3 27 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 32 34 35 \n"
"3 32 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 39 12 10 \n"
"3 39 10 13 \n"
"3 39 13 38 \n"
"3 38 13 36 \n"
"3 10 14 13 \n"
"3 14 10 40 \n"
"3 40 10 41 \n"
"3 40 41 42 \n"
"3 40 42 43 \n"
"3 43 42 44 \n"
"3 45 46 47 \n"
"3 46 45 48 \n"
"3 46 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 52 50 53 \n"
"3 54 43 44 \n"
"3 43 54 55 \n"
"3 55 54 56 \n"
"3 55 56 53 \n"
"3 55 53 50 \n"
"3 55 57 43 \n"
"3 57 55 58 \n"
"3 58 55 59 \n"
"3 59 55 60 \n"
"3 60 55 61 \n"
"3 61 55 62 \n"
"3 62 55 63 \n"
"3 62 63 64 \n"
"3 64 63 65 \n"
"3 65 63 66 \n"
"3 65 66 67 \n"
"3 67 66 68 \n"
"3 68 66 69 \n"
;

char *VTK_VECTOR_TEXT_O = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 64 float\n"
"0.309998 18.790001 0.000000 0.339996 12.350000 0.000000 \n"
"0.000000 15.550000 0.000000 1.220000 21.760000 0.000000 \n"
"1.320010 9.399990 0.000000 2.670010 24.410000 0.000000 \n"
"2.890010 6.759980 0.000000 4.610020 26.700001 0.000000 \n"
"4.980010 4.470000 0.000000 6.149990 16.830000 0.000000 \n"
"6.320010 19.709999 0.000000 6.790010 22.270000 0.000000 \n"
"6.980010 28.559999 0.000000 7.570010 24.480000 0.000000 \n"
"8.640010 26.340000 0.000000 9.730010 29.959999 0.000000 \n"
"9.970000 27.809999 0.000000 11.570000 28.879999 0.000000 \n"
"12.810000 30.830000 0.000000 13.420000 29.540001 0.000000 \n"
"15.500000 29.760000 0.000000 16.160000 31.139999 0.000000 \n"
"17.790001 29.469999 0.000000 19.580000 30.840000 0.000000 \n"
"19.879999 28.610001 0.000000 21.740000 27.250000 0.000000 \n"
"22.700001 29.969999 0.000000 23.340000 25.420000 0.000000 \n"
"24.650000 23.170000 0.000000 25.490000 28.580000 0.000000 \n"
"25.620001 20.549999 0.000000 26.230000 17.610001 0.000000 \n"
"27.889999 26.719999 0.000000 26.440001 14.400000 0.000000 \n"
"6.370000 13.610000 0.000000 6.970000 10.660000 0.000000 \n"
"7.530000 2.599980 0.000000 7.950010 8.030000 0.000000 \n"
"9.250000 5.769990 0.000000 10.480000 1.190000 0.000000 \n"
"10.850000 3.919980 0.000000 12.710000 2.539980 0.000000 \n"
"13.780000 0.309998 0.000000 14.810000 1.679990 0.000000 \n"
"17.090000 1.379970 0.000000 17.360001 0.000000 0.000000 \n"
"19.160000 1.599980 0.000000 20.570000 0.299988 0.000000 \n"
"21.000000 2.280000 0.000000 22.600000 3.370000 0.000000 \n"
"23.490000 1.149990 0.000000 23.940001 4.859990 0.000000 \n"
"25.010000 6.729980 0.000000 25.790001 8.959990 0.000000 \n"
"26.080000 2.519990 0.000000 26.270000 11.520000 0.000000 \n"
"28.290001 4.370000 0.000000 29.850000 24.450001 0.000000 \n"
"30.090000 6.639980 0.000000 31.320000 21.809999 0.000000 \n"
"31.430000 9.310000 0.000000 32.230000 18.860001 0.000000 \n"
"32.259998 12.320000 0.000000 32.549999 15.640000 0.000000 \n"

"POLYGONS 64 256\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 9 7 10 \n"
"3 10 7 11 \n"
"3 11 7 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 14 12 15 \n"
"3 14 15 16 \n"
"3 16 15 17 \n"
"3 17 15 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 20 18 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 25 23 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 28 26 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 31 29 32 \n"
"3 31 32 33 \n"
"3 8 9 34 \n"
"3 8 34 35 \n"
"3 8 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 39 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 47 49 50 \n"
"3 50 49 51 \n"
"3 50 51 52 \n"
"3 50 52 53 \n"
"3 50 53 54 \n"
"3 54 53 55 \n"
"3 54 55 33 \n"
"3 54 33 32 \n"
"3 54 32 56 \n"
"3 56 32 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
;

char *VTK_VECTOR_TEXT_P = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 78 float\n"
"0.000000 0.000000 0.000000 0.000000 1.020020 0.000000 \n"
"0.439972 1.060000 0.000000 1.530000 0.050018 0.000000 \n"
"1.829990 1.280000 0.000000 2.729980 1.940000 0.000000 \n"
"2.810000 0.080017 0.000000 3.019990 2.470000 0.000000 \n"
"3.220000 3.160000 0.000000 4.159970 0.080017 0.000000 \n"
"3.329990 4.010010 0.000000 3.359990 5.050020 0.000000 \n"
"3.359990 24.709999 0.000000 0.000000 29.799999 0.000000 \n"
"0.439972 28.740000 0.000000 0.000000 28.740000 0.000000 \n"
"1.829990 28.510000 0.000000 5.889980 0.089996 0.000000 \n"
"3.329990 25.740000 0.000000 6.459990 29.620001 0.000000 \n"
"3.220000 26.600000 0.000000 3.019990 27.299999 0.000000 \n"
"2.729980 27.840000 0.000000 7.439970 29.629999 0.000000 \n"
"7.639980 0.080017 0.000000 8.259980 29.639999 0.000000 \n"
"8.319980 5.050020 0.000000 8.359990 4.020020 0.000000 \n"
"8.470000 3.179990 0.000000 8.949980 1.959990 0.000000 \n"
"9.000000 0.080017 0.000000 9.840000 1.280000 0.000000 \n"
"10.290000 0.050018 0.000000 11.200000 1.060000 0.000000 \n"
"11.820000 0.000000 0.000000 11.820000 1.020020 0.000000 \n"
"8.319980 13.680000 0.000000 8.319980 15.360000 0.000000 \n"
"9.209990 15.220000 0.000000 9.299990 13.640000 0.000000 \n"
"9.889980 15.130000 0.000000 10.600000 13.600000 0.000000 \n"
"11.160000 15.050000 0.000000 11.510000 13.590000 0.000000 \n"
"12.410000 15.160000 0.000000 13.520000 15.460000 0.000000 \n"
"13.970000 13.720000 0.000000 14.490000 15.960000 0.000000 \n"
"15.300000 16.639999 0.000000 15.960000 17.490000 0.000000 \n"
"16.110001 14.100000 0.000000 16.430000 18.490000 0.000000 \n"
"16.730000 19.650000 0.000000 17.930000 14.740000 0.000000 \n"
"16.830000 20.950001 0.000000 8.319980 28.340000 0.000000 \n"
"9.389980 28.389999 0.000000 9.609990 29.670000 0.000000 \n"
"11.030000 28.250000 0.000000 11.820000 29.709999 0.000000 \n"
"12.490000 27.870001 0.000000 13.760000 27.240000 0.000000 \n"
"14.200000 29.580000 0.000000 14.830000 26.389999 0.000000 \n"
"15.690000 25.320000 0.000000 16.270000 29.190001 0.000000 \n"
"16.309999 24.049999 0.000000 16.690001 22.590000 0.000000 \n"
"18.040001 28.530001 0.000000 19.430000 15.610000 0.000000 \n"
"19.500000 27.629999 0.000000 20.610001 16.740000 0.000000 \n"
"20.650000 26.469999 0.000000 21.459999 18.100000 0.000000 \n"
"21.480000 25.059999 0.000000 21.969999 19.690001 0.000000 \n"
"21.969999 23.410000 0.000000 22.139999 21.520000 0.000000 \n"

"POLYGONS 78 312\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 3 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 6 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 13 14 15 \n"
"3 14 13 16 \n"
"3 12 17 9 \n"
"3 17 12 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 19 21 22 \n"
"3 19 22 16 \n"
"3 19 16 13 \n"
"3 17 19 23 \n"
"3 17 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 24 26 27 \n"
"3 24 27 28 \n"
"3 24 28 29 \n"
"3 24 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 43 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 46 48 49 \n"
"3 46 49 50 \n"
"3 50 49 51 \n"
"3 50 51 52 \n"
"3 50 52 53 \n"
"3 53 52 54 \n"
"3 25 36 26 \n"
"3 36 25 37 \n"
"3 37 25 55 \n"
"3 55 25 56 \n"
"3 56 25 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 61 59 62 \n"
"3 61 62 63 \n"
"3 63 62 64 \n"
"3 64 62 65 \n"
"3 64 65 66 \n"
"3 66 65 67 \n"
"3 67 65 54 \n"
"3 54 65 53 \n"
"3 53 65 68 \n"
"3 53 68 69 \n"
"3 69 68 70 \n"
"3 69 70 71 \n"
"3 71 70 72 \n"
"3 71 72 73 \n"
"3 73 72 74 \n"
"3 73 74 75 \n"
"3 75 74 76 \n"
"3 75 76 77 \n"
;

char *VTK_VECTOR_TEXT_Q = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 81 float\n"
"20.680000 9.220000 0.000000 19.400000 10.720000 0.000000 \n"
"21.219999 11.360000 0.000000 22.809999 12.410000 0.000000 \n"
"23.330000 9.950010 0.000000 24.150000 13.830000 0.000000 \n"
"25.230000 15.620000 0.000000 25.700001 11.080000 0.000000 \n"
"26.010000 17.750000 0.000000 26.500000 20.200001 0.000000 \n"
"27.770000 12.580000 0.000000 26.660000 22.950001 0.000000 \n"
"5.970030 12.550000 0.000000 6.200010 25.910000 0.000000 \n"
"6.420040 22.680000 0.000000 7.040040 19.730000 0.000000 \n"
"8.030030 17.100000 0.000000 8.429990 11.070000 0.000000 \n"
"9.360050 14.850000 0.000000 10.990000 13.020000 0.000000 \n"
"11.240000 9.970000 0.000000 12.890000 11.650000 0.000000 \n"
"14.390000 9.260010 0.000000 15.030000 10.800000 0.000000 \n"
"15.150000 7.110020 0.000000 16.219999 5.280000 0.000000 \n"
"17.360001 10.500000 0.000000 17.610001 3.760010 0.000000 \n"
"19.379999 2.510010 0.000000 21.280001 7.420010 0.000000 \n"
"21.530001 1.520020 0.000000 21.969999 5.910000 0.000000 \n"
"22.799999 4.679990 0.000000 23.790001 3.670010 0.000000 \n"
"24.100000 0.790009 0.000000 25.000000 2.880000 0.000000 \n"
"26.459999 2.260010 0.000000 27.110001 0.290009 0.000000 \n"
"28.209999 1.780000 0.000000 30.290001 1.420010 0.000000 \n"
"30.600000 0.000000 0.000000 0.260010 21.620001 0.000000 \n"
"0.000000 24.540001 0.000000 0.309998 27.780001 0.000000 \n"
"1.010010 18.940001 0.000000 1.220030 30.760000 0.000000 \n"
"2.230040 16.510000 0.000000 2.650020 33.430000 0.000000 \n"
"3.890010 14.370000 0.000000 4.570010 35.730000 0.000000 \n"
"6.370000 28.730000 0.000000 6.860050 31.240000 0.000000 \n"
"6.920040 37.610001 0.000000 7.650020 33.430000 0.000000 \n"
"8.739990 35.270000 0.000000 9.640010 39.020000 0.000000 \n"
"10.090000 36.740002 0.000000 11.690000 37.820000 0.000000 \n"
"12.680000 39.910000 0.000000 13.530000 38.480000 0.000000 \n"
"15.590000 38.709999 0.000000 15.990000 40.220001 0.000000 \n"
"17.910000 38.410000 0.000000 19.510000 39.910000 0.000000 \n"
"20.030001 37.529999 0.000000 21.920000 36.130001 0.000000 \n"
"22.730000 39.029999 0.000000 23.530001 34.250000 0.000000 \n"
"24.850000 31.940001 0.000000 25.600000 37.619999 0.000000 \n"
"25.830000 29.260000 0.000000 26.450001 26.240000 0.000000 \n"
"28.059999 35.740002 0.000000 29.520000 14.410000 0.000000 \n"
"30.059999 33.430000 0.000000 30.930000 16.540001 0.000000 \n"
"31.559999 30.740000 0.000000 31.959999 18.940001 0.000000 \n"
"32.490002 27.730000 0.000000 32.599998 21.590000 0.000000 \n"
"32.820000 24.450001 0.000000 \n"
"POLYGONS 81 324\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 4 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 7 9 10 \n"
"3 10 9 11 \n"
"3 12 13 14 \n"
"3 12 14 15 \n"
"3 12 15 16 \n"
"3 12 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 17 19 20 \n"
"3 20 19 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 25 23 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 28 26 1 \n"
"3 28 1 0 \n"
"3 28 0 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 30 32 33 \n"
"3 30 33 34 \n"
"3 34 33 35 \n"
"3 34 35 36 \n"
"3 34 36 37 \n"
"3 37 36 38 \n"
"3 37 38 39 \n"
"3 37 39 40 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 48 49 12 \n"
"3 12 49 13 \n"
"3 13 49 50 \n"
"3 50 49 51 \n"
"3 51 49 52 \n"
"3 51 52 53 \n"
"3 53 52 54 \n"
"3 54 52 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 57 55 58 \n"
"3 57 58 59 \n"
"3 59 58 60 \n"
"3 60 58 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
"3 62 63 64 \n"
"3 64 63 65 \n"
"3 65 63 66 \n"
"3 65 66 67 \n"
"3 67 66 68 \n"
"3 68 66 69 \n"
"3 68 69 70 \n"
"3 70 69 71 \n"
"3 71 69 10 \n"
"3 71 10 11 \n"
"3 10 69 72 \n"
"3 10 72 73 \n"
"3 73 72 74 \n"
"3 73 74 75 \n"
"3 75 74 76 \n"
"3 75 76 77 \n"
"3 77 76 78 \n"
"3 77 78 79 \n"
"3 79 78 80 \n"
;

char *VTK_VECTOR_TEXT_R = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 110 float\n"
"0.049988 30.110001 0.000000 0.450012 29.049999 0.000000 \n"
"0.049988 29.049999 0.000000 1.859990 28.809999 0.000000 \n"
"4.519960 30.020000 0.000000 2.760010 28.129999 0.000000 \n"
"3.039980 27.590000 0.000000 3.229980 26.910000 0.000000 \n"
"3.339970 26.049999 0.000000 3.370000 25.020000 0.000000 \n"
"0.000000 0.309998 0.000000 0.000000 1.330020 0.000000 \n"
"0.450012 1.370000 0.000000 0.899963 0.309998 0.000000 \n"
"1.549990 0.309998 0.000000 1.839970 1.590000 0.000000 \n"
"2.739990 2.250000 0.000000 3.370000 5.360020 0.000000 \n"
"3.330020 4.320010 0.000000 6.159970 0.350006 0.000000 \n"
"3.219970 3.470000 0.000000 3.029970 2.780000 0.000000 \n"
"7.380000 30.059999 0.000000 8.510010 6.200010 0.000000 \n"
"8.539980 4.920010 0.000000 8.649960 3.899990 0.000000 \n"
"8.870000 3.110020 0.000000 9.219970 2.510010 0.000000 \n"
"9.719970 2.080020 0.000000 10.390000 1.799990 0.000000 \n"
"10.810000 0.309998 0.000000 11.270000 1.630000 0.000000 \n"
"11.450000 0.309998 0.000000 12.360000 0.309998 0.000000 \n"
"12.360000 1.549990 0.000000 8.510010 14.260000 0.000000 \n"
"8.510010 15.670000 0.000000 8.510010 28.830000 0.000000 \n"
"9.049990 30.120001 0.000000 9.370000 28.850000 0.000000 \n"
"9.789980 28.870001 0.000000 10.940000 30.200001 0.000000 \n"
"11.460000 28.740000 0.000000 12.510000 30.240000 0.000000 \n"
"12.940000 28.360001 0.000000 13.780000 30.240000 0.000000 \n"
"14.210000 27.730000 0.000000 15.270000 26.860001 0.000000 \n"
"15.740000 30.110001 0.000000 16.120001 25.780001 0.000000 \n"
"16.730000 24.480000 0.000000 17.100000 22.990000 0.000000 \n"
"17.480000 29.709999 0.000000 17.230000 21.299999 0.000000 \n"
"16.610001 15.140000 0.000000 16.260000 17.790001 0.000000 \n"
"16.809999 18.760000 0.000000 17.129999 19.930000 0.000000 \n"
"18.000000 15.630000 0.000000 19.010000 29.070000 0.000000 \n"
"19.219999 16.240000 0.000000 20.260000 16.990000 0.000000 \n"
"20.290001 28.190001 0.000000 21.120001 17.860001 0.000000 \n"
"21.309999 27.080000 0.000000 21.799999 18.860001 0.000000 \n"
"22.059999 25.760000 0.000000 22.290001 19.969999 0.000000 \n"
"22.520000 24.240000 0.000000 22.580000 21.200001 0.000000 \n"
"22.680000 22.540001 0.000000 9.450010 15.670000 0.000000 \n"
"9.519960 14.210000 0.000000 9.839970 15.670000 0.000000 \n"
"10.310000 14.120000 0.000000 11.500000 13.590000 0.000000 \n"
"11.640000 15.760000 0.000000 12.000000 13.080000 0.000000 \n"
"12.500000 12.340000 0.000000 13.060000 11.330000 0.000000 \n"
"13.180000 16.000000 0.000000 13.730000 10.010000 0.000000 \n"
"14.450000 16.420000 0.000000 14.970000 7.549990 0.000000 \n"
"15.480000 17.010000 0.000000 16.020000 5.600010 0.000000 \n"
"16.920000 4.110020 0.000000 17.680000 3.049990 0.000000 \n"
"17.770000 13.700000 0.000000 18.450001 12.520000 0.000000 \n"
"18.910000 11.650000 0.000000 19.020000 1.750000 0.000000 \n"
"19.490000 10.540000 0.000000 20.600000 8.410000 0.000000 \n"
"20.680000 8.260010 0.000000 20.700001 0.790009 0.000000 \n"
"20.920000 7.810000 0.000000 21.330000 7.070010 0.000000 \n"
"21.879999 6.019990 0.000000 22.620001 4.709990 0.000000 \n"
"22.639999 0.200012 0.000000 23.280001 3.670010 0.000000 \n"
"23.900000 2.850010 0.000000 24.520000 2.239990 0.000000 \n"
"24.760000 0.000000 0.000000 25.870001 1.519990 0.000000 \n"
"26.010000 0.049988 0.000000 26.700001 0.130005 0.000000 \n"
"27.590000 0.260010 0.000000 27.590000 1.280000 0.000000 \n"

"POLYGONS 110 440\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 7 4 8 \n"
"3 8 4 9 \n"
"3 10 11 12 \n"
"3 10 12 13 \n"
"3 13 12 14 \n"
"3 14 12 15 \n"
"3 14 15 16 \n"
"3 17 9 4 \n"
"3 17 4 18 \n"
"3 18 4 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 21 19 16 \n"
"3 16 19 14 \n"
"3 19 4 22 \n"
"3 19 22 23 \n"
"3 19 23 24 \n"
"3 19 24 25 \n"
"3 19 25 26 \n"
"3 19 26 27 \n"
"3 19 27 28 \n"
"3 19 28 29 \n"
"3 19 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 32 31 33 \n"
"3 33 31 34 \n"
"3 22 35 23 \n"
"3 35 22 36 \n"
"3 36 22 37 \n"
"3 37 22 38 \n"
"3 37 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 46 45 47 \n"
"3 47 45 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 50 48 51 \n"
"3 51 48 52 \n"
"3 51 52 53 \n"
"3 54 55 56 \n"
"3 54 56 57 \n"
"3 54 57 58 \n"
"3 58 57 53 \n"
"3 58 53 52 \n"
"3 58 52 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 61 59 62 \n"
"3 61 62 63 \n"
"3 63 62 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 65 66 67 \n"
"3 67 66 68 \n"
"3 67 68 69 \n"
"3 69 68 70 \n"
"3 35 36 71 \n"
"3 35 71 72 \n"
"3 72 71 73 \n"
"3 72 73 74 \n"
"3 74 73 75 \n"
"3 75 73 76 \n"
"3 75 76 77 \n"
"3 77 76 78 \n"
"3 78 76 79 \n"
"3 79 76 80 \n"
"3 79 80 81 \n"
"3 81 80 82 \n"
"3 81 82 83 \n"
"3 83 82 84 \n"
"3 83 84 85 \n"
"3 85 84 55 \n"
"3 85 55 54 \n"
"3 85 54 86 \n"
"3 86 54 87 \n"
"3 87 54 88 \n"
"3 87 88 89 \n"
"3 87 89 90 \n"
"3 87 90 91 \n"
"3 91 90 92 \n"
"3 91 92 93 \n"
"3 91 93 94 \n"
"3 91 94 95 \n"
"3 95 94 96 \n"
"3 95 96 97 \n"
"3 95 97 98 \n"
"3 95 98 99 \n"
"3 95 99 100 \n"
"3 100 99 101 \n"
"3 100 101 102 \n"
"3 100 102 103 \n"
"3 100 103 104 \n"
"3 104 103 105 \n"
"3 104 105 106 \n"
"3 106 105 107 \n"
"3 107 105 108 \n"
"3 108 105 109 \n"
;

char *VTK_VECTOR_TEXT_S = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 89 float\n"
"4.290040 24.980000 0.000000 4.430050 15.520000 0.000000 \n"
"3.020020 16.590000 0.000000 4.560000 23.540001 0.000000 \n"
"4.970030 22.879999 0.000000 5.600040 22.200001 0.000000 \n"
"6.190000 14.400000 0.000000 6.510010 21.469999 0.000000 \n"
"7.730040 20.650000 0.000000 8.320010 13.200000 0.000000 \n"
"9.310000 19.690001 0.000000 10.940000 11.780000 0.000000 \n"
"11.290000 18.559999 0.000000 12.880000 10.600000 0.000000 \n"
"13.460000 17.290001 0.000000 14.160000 9.429990 0.000000 \n"
"14.880000 8.190000 0.000000 15.100000 6.780000 0.000000 \n"
"15.210000 16.139999 0.000000 0.270020 21.000000 0.000000 \n"
"0.180054 22.280001 0.000000 0.360046 24.190001 0.000000 \n"
"0.580017 19.809999 0.000000 0.910034 25.910000 0.000000 \n"
"1.120000 18.709999 0.000000 1.790040 27.420000 0.000000 \n"
"1.930050 17.639999 0.000000 2.980040 28.700001 0.000000 \n"
"4.400020 25.959999 0.000000 4.450010 29.730000 0.000000 \n"
"4.690000 26.850000 0.000000 5.170040 27.650000 0.000000 \n"
"5.800050 28.340000 0.000000 6.190000 30.500000 0.000000 \n"
"6.570010 28.900000 0.000000 7.470030 29.320000 0.000000 \n"
"8.170040 30.969999 0.000000 8.470030 29.580000 0.000000 \n"
"9.560000 29.680000 0.000000 10.360000 31.139999 0.000000 \n"
"10.990100 29.559999 0.000000 11.760000 31.090000 0.000000 \n"
"12.290000 29.209999 0.000000 13.340000 30.959999 0.000000 \n"
"13.440000 28.639999 0.000000 14.450000 27.850000 0.000000 \n"
"15.130000 30.730000 0.000000 15.300000 26.850000 0.000000 \n"
"15.990100 25.639999 0.000000 16.520000 24.230000 0.000000 \n"
"16.870001 22.629999 0.000000 17.180099 30.379999 0.000000 \n"
"17.889999 30.250000 0.000000 18.330000 22.680000 0.000000 \n"
"0.000000 8.679990 0.000000 1.240050 0.979980 0.000000 \n"
"0.309998 1.199980 0.000000 1.420040 8.819980 0.000000 \n"
"1.860050 7.299990 0.000000 2.520020 5.909970 0.000000 \n"
"3.370000 4.679990 0.000000 3.840030 0.509979 0.000000 \n"
"4.380000 3.629970 0.000000 5.540040 2.769990 0.000000 \n"
"5.900020 0.209991 0.000000 6.810000 2.129970 0.000000 \n"
"8.170040 1.729980 0.000000 9.300050 0.000000 0.000000 \n"
"9.610050 1.599980 0.000000 10.760000 1.699980 0.000000 \n"
"11.430100 0.169983 0.000000 11.810000 1.979980 0.000000 \n"
"12.750000 2.440000 0.000000 13.350000 0.659973 0.000000 \n"
"13.550000 3.060000 0.000000 14.200000 3.819980 0.000000 \n"
"14.690000 4.699980 0.000000 15.030000 1.440000 0.000000 \n"
"14.990100 5.690000 0.000000 16.459999 2.489990 0.000000 \n"
"16.590000 15.060000 0.000000 17.610001 3.799990 0.000000 \n"
"17.620001 14.000000 0.000000 18.360001 12.910000 0.000000 \n"
"18.469999 5.349980 0.000000 18.840000 11.760000 0.000000 \n"
"18.990101 7.099980 0.000000 19.100000 10.480000 0.000000 \n"
"19.170000 9.039980 0.000000 \n"
"POLYGONS 87 348\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 1 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 6 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 11 10 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 16 14 17 \n"
"3 17 14 18 \n"
"3 19 20 21 \n"
"3 19 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 26 27 2 \n"
"3 2 27 0 \n"
"3 0 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 31 29 32 \n"
"3 32 29 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 35 33 36 \n"
"3 35 36 37 \n"
"3 37 36 38 \n"
"3 38 36 39 \n"
"3 38 39 40 \n"
"3 40 39 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 45 43 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 48 46 49 \n"
"3 49 46 50 \n"
"3 50 46 51 \n"
"3 50 51 52 \n"
"3 50 52 53 \n"
"3 54 55 56 \n"
"3 55 54 57 \n"
"3 55 57 58 \n"
"3 55 58 59 \n"
"3 55 59 60 \n"
"3 55 60 61 \n"
"3 61 60 62 \n"
"3 61 62 63 \n"
"3 61 63 64 \n"
"3 64 63 65 \n"
"3 64 65 66 \n"
"3 64 66 67 \n"
"3 67 66 68 \n"
"3 67 68 69 \n"
"3 67 69 70 \n"
"3 70 69 71 \n"
"3 70 71 72 \n"
"3 70 72 73 \n"
"3 73 72 74 \n"
"3 73 74 75 \n"
"3 73 75 76 \n"
"3 73 76 77 \n"
"3 77 76 78 \n"
"3 77 78 17 \n"
"3 77 17 79 \n"
"3 79 17 18 \n"
"3 79 18 80 \n"
"3 79 80 81 \n"
"3 81 80 82 \n"
"3 81 82 83 \n"
"3 81 83 84 \n"
"3 84 83 85 \n"
"3 84 85 86 \n"
"3 86 85 87 \n"
"3 86 87 88 \n"
;

char *VTK_VECTOR_TEXT_T = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 59 float\n"
"0.449951 29.799999 0.000000 1.509950 21.610001 0.000000 \n"
"0.000000 21.610001 0.000000 1.750000 23.150000 0.000000 \n"
"2.069950 24.410000 0.000000 2.279970 29.770000 0.000000 \n"
"2.509950 25.430000 0.000000 3.079960 26.209999 0.000000 \n"
"3.799990 26.780001 0.000000 3.879940 29.750000 0.000000 \n"
"4.689940 27.170000 0.000000 5.759950 27.389999 0.000000 \n"
"6.769960 29.730000 0.000000 7.049990 27.459999 0.000000 \n"
"9.799990 29.709999 0.000000 10.850000 27.459999 0.000000 \n"
"11.590000 29.709999 0.000000 15.220000 0.080017 0.000000 \n"
"16.170000 5.050020 0.000000 16.200001 4.010010 0.000000 \n"
"16.309999 3.160000 0.000000 16.500000 2.470000 0.000000 \n"
"16.590000 0.059998 0.000000 16.780001 1.940000 0.000000 \n"
"17.660000 1.280000 0.000000 17.889999 0.029999 0.000000 \n"
"19.049999 1.060000 0.000000 19.439899 0.000000 0.000000 \n"
"19.439899 1.020020 0.000000 7.489990 0.000000 0.000000 \n"
"7.489990 1.020020 0.000000 7.979980 1.060000 0.000000 \n"
"9.029970 0.029999 0.000000 9.359990 1.280000 0.000000 \n"
"10.240000 1.940000 0.000000 10.330000 0.059998 0.000000 \n"
"10.530000 2.470000 0.000000 10.710000 3.160000 0.000000 \n"
"10.850000 5.050020 0.000000 11.700000 0.080017 0.000000 \n"
"10.819900 4.010010 0.000000 13.470000 0.089996 0.000000 \n"
"13.689900 29.709999 0.000000 16.170000 27.459999 0.000000 \n"
"16.799999 29.709999 0.000000 19.500000 29.719999 0.000000 \n"
"19.709999 27.459999 0.000000 21.170000 27.389999 0.000000 \n"
"21.780001 29.730000 0.000000 22.379900 27.180000 0.000000 \n"
"23.370001 26.799999 0.000000 23.650000 29.760000 0.000000 \n"
"24.139999 26.230000 0.000000 24.740000 25.440001 0.000000 \n"
"25.189899 24.430000 0.000000 26.969999 29.799999 0.000000 \n"
"25.490000 23.160000 0.000000 25.689899 21.610001 0.000000 \n"
"27.150000 21.610001 0.000000 \n"
"POLYGONS 57 228\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 4 0 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 8 5 9 \n"
"3 8 9 10 \n"
"3 10 9 11 \n"
"3 11 9 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 17 18 19 \n"
"3 17 19 20 \n"
"3 17 20 21 \n"
"3 17 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 22 24 25 \n"
"3 25 24 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 29 30 31 \n"
"3 29 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 32 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 38 15 16 \n"
"3 38 16 39 \n"
"3 38 39 40 \n"
"3 40 39 37 \n"
"3 37 39 35 \n"
"3 16 41 39 \n"
"3 41 16 42 \n"
"3 41 42 17 \n"
"3 17 42 18 \n"
"3 18 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 43 45 46 \n"
"3 46 45 47 \n"
"3 47 45 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 50 48 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 53 51 54 \n"
"3 54 51 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 57 55 58 \n"
;

char *VTK_VECTOR_TEXT_U = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 86 float\n"
"3.549990 25.020000 0.000000 3.750000 10.900000 0.000000 \n"
"3.549990 14.210000 0.000000 0.000000 30.639999 0.000000 \n"
"1.029970 29.430000 0.000000 0.000000 29.580000 0.000000 \n"
"1.839970 29.219999 0.000000 2.000000 30.570000 0.000000 \n"
"2.469970 28.930000 0.000000 2.919980 28.510000 0.000000 \n"
"3.229980 27.940001 0.000000 3.510010 30.530001 0.000000 \n"
"3.419980 27.190001 0.000000 3.519960 26.230000 0.000000 \n"
"4.370000 8.030000 0.000000 5.399960 5.590000 0.000000 \n"
"6.159970 30.510000 0.000000 6.839970 3.579990 0.000000 \n"
"8.679990 2.019990 0.000000 8.820010 12.570000 0.000000 \n"
"8.820010 25.020000 0.000000 8.839970 26.280001 0.000000 \n"
"8.929990 27.280001 0.000000 9.099980 28.049999 0.000000 \n"
"9.399960 28.620001 0.000000 9.829960 29.020000 0.000000 \n"
"10.440000 29.299999 0.000000 10.720000 30.600000 0.000000 \n"
"11.240000 29.490000 0.000000 12.270000 29.620001 0.000000 \n"
"12.270000 30.639999 0.000000 23.299999 30.639999 0.000000 \n"
"24.410000 29.440001 0.000000 23.299999 29.540001 0.000000 \n"
"24.790001 30.570000 0.000000 25.299999 29.280001 0.000000 \n"
"25.940001 30.530001 0.000000 25.969999 29.000000 0.000000 \n"
"26.459999 28.580000 0.000000 26.799999 27.969999 0.000000 \n"
"27.990000 30.510000 0.000000 27.010000 27.139999 0.000000 \n"
"27.139999 26.049999 0.000000 27.200001 24.660000 0.000000 \n"
"27.330000 20.010000 0.000000 27.370001 14.700000 0.000000 \n"
"8.959960 10.090000 0.000000 9.409970 7.910000 0.000000 \n"
"10.140000 6.060000 0.000000 10.930000 0.899994 0.000000 \n"
"11.150000 4.530000 0.000000 12.440000 3.329990 0.000000 \n"
"13.570000 0.220001 0.000000 14.010000 2.459990 0.000000 \n"
"15.840000 1.940000 0.000000 16.610001 0.000000 0.000000 \n"
"17.940001 1.769990 0.000000 19.629999 0.209991 0.000000 \n"
"20.230000 1.950010 0.000000 22.180000 2.489990 0.000000 \n"
"22.200001 0.860016 0.000000 23.799999 3.399990 0.000000 \n"
"24.340000 1.970000 0.000000 25.110001 4.709990 0.000000 \n"
"26.049999 3.560000 0.000000 26.120001 6.410000 0.000000 \n"
"26.820000 8.510010 0.000000 27.240000 11.040000 0.000000 \n"
"27.370001 5.649990 0.000000 27.370001 13.990000 0.000000 \n"
"28.290001 8.250000 0.000000 28.850000 11.400000 0.000000 \n"
"29.059999 15.100000 0.000000 29.100000 19.350000 0.000000 \n"
"29.139999 23.379999 0.000000 29.200001 25.110001 0.000000 \n"
"29.320000 26.500000 0.000000 29.530001 27.559999 0.000000 \n"
"29.860001 28.350000 0.000000 30.059999 30.530001 0.000000 \n"
"30.320000 28.900000 0.000000 30.930000 29.260000 0.000000 \n"
"31.219999 30.570000 0.000000 31.730000 29.459999 0.000000 \n"
"32.730000 29.540001 0.000000 32.730000 30.639999 0.000000 \n"

"POLYGONS 84 336\n"
"3 0 1 2 \n"
"3 3 4 5 \n"
"3 4 3 6 \n"
"3 6 3 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 9 7 10 \n"
"3 10 7 11 \n"
"3 10 11 12 \n"
"3 12 11 13 \n"
"3 13 11 0 \n"
"3 0 11 1 \n"
"3 1 11 14 \n"
"3 14 11 15 \n"
"3 15 11 16 \n"
"3 15 16 17 \n"
"3 17 16 18 \n"
"3 18 16 19 \n"
"3 19 16 20 \n"
"3 20 16 21 \n"
"3 21 16 22 \n"
"3 22 16 23 \n"
"3 23 16 24 \n"
"3 24 16 25 \n"
"3 25 16 26 \n"
"3 26 16 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 29 27 30 \n"
"3 31 32 33 \n"
"3 32 31 34 \n"
"3 32 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 37 36 38 \n"
"3 38 36 39 \n"
"3 39 36 40 \n"
"3 39 40 41 \n"
"3 41 40 42 \n"
"3 42 40 43 \n"
"3 43 40 44 \n"
"3 44 40 45 \n"
"3 18 19 46 \n"
"3 18 46 47 \n"
"3 18 47 48 \n"
"3 18 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 49 51 52 \n"
"3 52 51 53 \n"
"3 52 53 54 \n"
"3 52 54 55 \n"
"3 55 54 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 57 58 59 \n"
"3 57 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
"3 62 63 64 \n"
"3 64 63 65 \n"
"3 64 65 66 \n"
"3 64 66 67 \n"
"3 64 67 68 \n"
"3 68 67 69 \n"
"3 68 69 40 \n"
"3 40 69 45 \n"
"3 40 70 68 \n"
"3 70 40 71 \n"
"3 71 40 72 \n"
"3 72 40 73 \n"
"3 73 40 74 \n"
"3 74 40 75 \n"
"3 75 40 76 \n"
"3 76 40 77 \n"
"3 77 40 78 \n"
"3 78 40 79 \n"
"3 78 79 80 \n"
"3 80 79 81 \n"
"3 81 79 82 \n"
"3 81 82 83 \n"
"3 83 82 84 \n"
"3 84 82 85 \n"
;

char *VTK_VECTOR_TEXT_V = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 51 float\n"
"8.673000 30.170000 0.000000 9.987000 28.090000 0.000000 \n"
"9.787000 27.150000 0.000000 10.219000 30.190001 0.000000 \n"
"10.623000 28.740000 0.000000 11.682000 30.230000 0.000000 \n"
"11.749000 29.129999 0.000000 13.419000 29.270000 0.000000 \n"
"13.419000 30.290001 0.000000 22.851999 29.230000 0.000000 \n"
"22.851999 30.290001 0.000000 24.098000 30.230000 0.000000 \n"
"24.166000 29.110001 0.000000 25.028000 28.799999 0.000000 \n"
"25.149000 30.190001 0.000000 25.499001 28.230000 0.000000 \n"
"26.259001 30.170000 0.000000 25.642000 27.370001 0.000000 \n"
"0.000000 30.290001 0.000000 1.603000 29.010000 0.000000 \n"
"0.000000 29.360001 0.000000 1.736000 30.230000 0.000000 \n"
"2.757000 28.280001 0.000000 3.194000 30.190001 0.000000 \n"
"3.259000 27.680000 0.000000 3.762000 26.879999 0.000000 \n"
"4.301000 25.850000 0.000000 4.727000 30.170000 0.000000 \n"
"4.916000 24.540001 0.000000 6.687000 30.160000 0.000000 \n"
"9.898000 26.280001 0.000000 10.275000 25.240000 0.000000 \n"
"16.120001 0.000000 0.000000 17.049999 0.000000 0.000000 \n"
"18.423000 6.639980 0.000000 25.155001 25.160000 0.000000 \n"
"25.531000 26.430000 0.000000 27.014999 24.309999 0.000000 \n"
"27.607000 25.719999 0.000000 27.679001 30.160000 0.000000 \n"
"28.148001 26.820000 0.000000 28.677000 27.660000 0.000000 \n"
"29.118999 30.170000 0.000000 29.235001 28.280001 0.000000 \n"
"29.861000 28.709999 0.000000 30.231001 30.190001 0.000000 \n"
"30.596001 28.990000 0.000000 31.285000 30.230000 0.000000 \n"
"31.479000 29.150000 0.000000 32.550999 29.230000 0.000000 \n"
"32.550999 30.290001 0.000000 \n"
"POLYGONS 49 196\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 12 11 13 \n"
"3 13 11 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 18 19 20 \n"
"3 19 18 21 \n"
"3 19 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 25 23 26 \n"
"3 26 23 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 28 29 0 \n"
"3 28 0 2 \n"
"3 28 2 30 \n"
"3 28 30 31 \n"
"3 28 31 32 \n"
"3 32 31 33 \n"
"3 33 31 34 \n"
"3 33 34 35 \n"
"3 36 17 16 \n"
"3 36 16 37 \n"
"3 36 37 35 \n"
"3 35 37 33 \n"
"3 16 38 37 \n"
"3 38 16 39 \n"
"3 38 39 40 \n"
"3 40 39 41 \n"
"3 41 39 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 44 42 45 \n"
"3 44 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 49 47 50 \n"
;

char *VTK_VECTOR_TEXT_W = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 55 float\n"
"9.167000 27.190001 0.000000 7.836000 30.260000 0.000000 \n"
"9.212000 30.280001 0.000000 9.324000 28.190001 0.000000 \n"
"9.859000 28.840000 0.000000 10.654000 30.320000 0.000000 \n"
"10.868000 29.190001 0.000000 12.445000 29.320000 0.000000 \n"
"12.445000 30.379999 0.000000 0.000000 30.379999 0.000000 \n"
"1.507000 29.100000 0.000000 0.000000 29.320000 0.000000 \n"
"1.791000 30.320000 0.000000 2.557000 28.430000 0.000000 \n"
"2.996990 27.850000 0.000000 3.238000 30.280001 0.000000 \n"
"3.425000 27.040001 0.000000 3.876000 25.980000 0.000000 \n"
"4.384000 24.629999 0.000000 4.627000 30.260000 0.000000 \n"
"6.244000 30.250000 0.000000 9.260990 26.309999 0.000000 \n"
"9.522000 25.330000 0.000000 13.375000 0.000000 0.000000 \n"
"14.305000 0.000000 0.000000 15.678000 8.239990 0.000000 \n"
"21.569000 21.660000 0.000000 22.849001 30.910000 0.000000 \n"
"23.559000 30.910000 0.000000 29.499001 0.000000 0.000000 \n"
"30.518999 0.000000 0.000000 31.759001 8.019990 0.000000 \n"
"36.889000 25.020000 0.000000 38.438999 23.650000 0.000000 \n"
"37.148998 26.160000 0.000000 37.249001 27.190001 0.000000 \n"
"34.238998 29.320000 0.000000 34.238998 30.379999 0.000000 \n"
"35.598999 30.320000 0.000000 35.598999 29.120001 0.000000 \n"
"36.539001 28.719999 0.000000 36.709000 30.280001 0.000000 \n"
"37.078999 28.090000 0.000000 38.999001 25.260000 0.000000 \n"
"39.019001 30.250000 0.000000 39.499001 26.520000 0.000000 \n"
"39.988998 27.480000 0.000000 40.519001 28.190001 0.000000 \n"
"41.109001 28.680000 0.000000 41.289001 30.280001 0.000000 \n"
"41.819000 28.990000 0.000000 42.389000 30.320000 0.000000 \n"
"42.688999 29.180000 0.000000 43.758999 29.280001 0.000000 \n"
"43.758999 30.379999 0.000000 \n"
"POLYGONS 53 212\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 4 2 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 9 10 11 \n"
"3 10 9 12 \n"
"3 10 12 13 \n"
"3 13 12 14 \n"
"3 14 12 15 \n"
"3 14 15 16 \n"
"3 16 15 17 \n"
"3 17 15 18 \n"
"3 18 15 19 \n"
"3 18 19 20 \n"
"3 18 20 1 \n"
"3 18 1 0 \n"
"3 18 0 21 \n"
"3 18 21 22 \n"
"3 18 22 23 \n"
"3 23 22 24 \n"
"3 24 22 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 26 28 29 \n"
"3 29 28 30 \n"
"3 30 28 31 \n"
"3 30 31 32 \n"
"3 30 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 40 41 42 \n"
"3 42 41 35 \n"
"3 35 41 33 \n"
"3 33 41 43 \n"
"3 43 41 44 \n"
"3 43 44 45 \n"
"3 45 44 46 \n"
"3 46 44 47 \n"
"3 47 44 48 \n"
"3 48 44 49 \n"
"3 48 49 50 \n"
"3 50 49 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 53 51 54 \n"
;

char *VTK_VECTOR_TEXT_X = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 99 float\n"
"0.000000 0.000000 0.000000 0.000000 1.060000 0.000000 \n"
"1.150000 1.170010 0.000000 1.300000 0.029999 0.000000 \n"
"2.150010 1.380000 0.000000 2.380000 0.059998 0.000000 \n"
"3.070010 1.760010 0.000000 3.510010 0.080017 0.000000 \n"
"3.990010 2.360020 0.000000 4.960010 0.089996 0.000000 \n"
"4.990010 3.239990 0.000000 6.170000 4.470000 0.000000 \n"
"6.430010 0.080017 0.000000 7.570010 0.059998 0.000000 \n"
"7.590000 6.120000 0.000000 7.660000 2.260010 0.000000 \n"
"7.780000 1.800020 0.000000 8.160000 1.459990 0.000000 \n"
"8.660000 0.029999 0.000000 8.870000 1.220000 0.000000 \n"
"9.960010 0.000000 0.000000 9.960010 1.060000 0.000000 \n"
"10.930000 29.700001 0.000000 11.470000 27.670000 0.000000 \n"
"11.290000 26.969999 0.000000 12.000000 28.200001 0.000000 \n"
"12.420000 29.740000 0.000000 12.920000 28.559999 0.000000 \n"
"14.210000 28.740000 0.000000 14.210000 29.799999 0.000000 \n"
"7.730000 2.670010 0.000000 7.970000 3.200010 0.000000 \n"
"8.370000 3.860020 0.000000 8.940000 4.649990 0.000000 \n"
"9.340000 8.239990 0.000000 13.860000 13.810000 0.000000 \n"
"14.880000 12.270000 0.000000 18.510000 0.000000 0.000000 \n"
"18.510000 1.060000 0.000000 19.870001 1.179990 0.000000 \n"
"20.240000 0.040009 0.000000 20.740000 1.440000 0.000000 \n"
"21.200001 1.860020 0.000000 23.049999 0.140015 0.000000 \n"
"21.340000 2.480010 0.000000 21.650000 29.799999 0.000000 \n"
"22.860001 28.490000 0.000000 21.650000 28.700001 0.000000 \n"
"23.219999 29.730000 0.000000 23.650000 28.190001 0.000000 \n"
"24.090000 27.770000 0.000000 24.430000 29.690001 0.000000 \n"
"24.219999 27.190001 0.000000 18.330000 16.209999 0.000000 \n"
"17.450001 17.670000 0.000000 22.980000 24.930000 0.000000 \n"
"23.620001 25.799999 0.000000 23.910000 23.030001 0.000000 \n"
"24.000000 26.379999 0.000000 25.240000 24.620001 0.000000 \n"
"26.139999 25.670000 0.000000 26.570000 29.670000 0.000000 \n"
"26.920000 26.500000 0.000000 28.280001 27.650000 0.000000 \n"
"28.709999 29.690001 0.000000 29.680000 28.309999 0.000000 \n"
"29.910000 29.730000 0.000000 31.480000 28.700001 0.000000 \n"
"31.480000 29.799999 0.000000 0.480003 29.799999 0.000000 \n"
"2.080000 28.330000 0.000000 0.480003 28.700001 0.000000 \n"
"2.270000 29.740000 0.000000 3.490010 27.570000 0.000000 \n"
"3.770000 29.700001 0.000000 4.880000 26.299999 0.000000 \n"
"5.340000 29.680000 0.000000 6.370000 24.440001 0.000000 \n"
"7.350010 29.670000 0.000000 7.660000 22.580000 0.000000 \n"
"9.360000 29.680000 0.000000 11.530000 25.959999 0.000000 \n"
"12.260000 24.750000 0.000000 19.700001 5.530000 0.000000 \n"
"20.430000 4.500000 0.000000 20.940001 3.660000 0.000000 \n"
"21.240000 2.989990 0.000000 25.370001 0.170013 0.000000 \n"
"25.510000 6.149990 0.000000 26.459999 4.850010 0.000000 \n"
"27.299999 3.800020 0.000000 27.670000 0.140015 0.000000 \n"
"28.059999 2.980010 0.000000 28.790001 2.340000 0.000000 \n"
"30.340000 1.520020 0.000000 30.549999 0.040009 0.000000 \n"
"31.290001 0.020019 0.000000 32.279999 0.000000 0.000000 \n"
"32.279999 1.060000 0.000000 \n"
"POLYGONS 97 388\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 12 11 13 \n"
"3 13 11 14 \n"
"3 13 14 15 \n"
"3 13 15 16 \n"
"3 13 16 17 \n"
"3 13 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 22 23 24 \n"
"3 23 22 25 \n"
"3 25 22 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 28 26 29 \n"
"3 14 30 15 \n"
"3 30 14 31 \n"
"3 31 14 32 \n"
"3 32 14 33 \n"
"3 33 14 34 \n"
"3 33 34 35 \n"
"3 33 35 36 \n"
"3 37 38 39 \n"
"3 37 39 40 \n"
"3 40 39 41 \n"
"3 40 41 42 \n"
"3 40 42 43 \n"
"3 43 42 44 \n"
"3 45 46 47 \n"
"3 46 45 48 \n"
"3 46 48 49 \n"
"3 49 48 50 \n"
"3 50 48 51 \n"
"3 50 51 52 \n"
"3 53 54 55 \n"
"3 53 55 56 \n"
"3 53 56 57 \n"
"3 57 56 58 \n"
"3 57 58 52 \n"
"3 57 52 51 \n"
"3 57 51 59 \n"
"3 59 51 60 \n"
"3 60 51 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
"3 63 61 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 65 66 67 \n"
"3 67 66 68 \n"
"3 69 70 71 \n"
"3 70 69 72 \n"
"3 70 72 73 \n"
"3 73 72 74 \n"
"3 73 74 75 \n"
"3 75 74 76 \n"
"3 75 76 77 \n"
"3 77 76 78 \n"
"3 77 78 79 \n"
"3 79 78 80 \n"
"3 79 80 22 \n"
"3 79 22 24 \n"
"3 79 24 81 \n"
"3 79 81 82 \n"
"3 79 82 35 \n"
"3 35 82 36 \n"
"3 36 82 54 \n"
"3 36 54 53 \n"
"3 36 53 83 \n"
"3 83 53 84 \n"
"3 84 53 85 \n"
"3 85 53 86 \n"
"3 86 53 43 \n"
"3 86 43 44 \n"
"3 53 87 43 \n"
"3 87 53 88 \n"
"3 87 88 89 \n"
"3 87 89 90 \n"
"3 87 90 91 \n"
"3 91 90 92 \n"
"3 91 92 93 \n"
"3 91 93 94 \n"
"3 91 94 95 \n"
"3 95 94 96 \n"
"3 96 94 97 \n"
"3 97 94 98 \n"
;

char *VTK_VECTOR_TEXT_Y = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 74 float\n"
"0.000000 29.799999 0.000000 1.670000 28.480000 0.000000 \n"
"0.000000 28.740000 0.000000 1.680010 29.760000 0.000000 \n"
"2.890000 27.770000 0.000000 3.440000 27.150000 0.000000 \n"
"3.770000 29.700001 0.000000 4.000000 26.299999 0.000000 \n"
"4.610000 25.190001 0.000000 5.320010 23.780001 0.000000 \n"
"5.460010 29.660000 0.000000 8.110000 29.620001 0.000000 \n"
"10.060000 26.700001 0.000000 10.280000 25.549999 0.000000 \n"
"10.600000 24.740000 0.000000 11.070000 23.690001 0.000000 \n"
"11.650000 10.670000 0.000000 11.650000 22.410000 0.000000 \n"
"10.220000 27.620001 0.000000 10.770000 28.209999 0.000000 \n"
"11.790000 28.549999 0.000000 13.380000 28.700001 0.000000 \n"
"13.380000 29.799999 0.000000 7.620010 0.000000 0.000000 \n"
"7.620010 1.060000 0.000000 8.780000 1.120000 0.000000 \n"
"9.210010 0.040009 0.000000 9.710010 1.260010 0.000000 \n"
"10.410000 1.510010 0.000000 10.930000 1.880000 0.000000 \n"
"11.650000 5.220000 0.000000 14.130000 0.130005 0.000000 \n"
"11.620000 4.060000 0.000000 11.510000 3.130000 0.000000 \n"
"11.290000 2.410000 0.000000 16.080000 13.020000 0.000000 \n"
"16.740000 5.220000 0.000000 16.780001 4.080020 0.000000 \n"
"16.889999 3.179990 0.000000 16.990000 0.100006 0.000000 \n"
"17.110001 2.470000 0.000000 17.459999 1.950010 0.000000 \n"
"17.969999 1.570010 0.000000 18.580000 0.050018 0.000000 \n"
"18.650000 1.310000 0.000000 19.530001 1.149990 0.000000 \n"
"20.639999 0.000000 0.000000 20.639999 1.060000 0.000000 \n"
"19.490000 28.740000 0.000000 19.490000 29.799999 0.000000 \n"
"20.670000 29.740000 0.000000 20.730000 28.580000 0.000000 \n"
"21.549999 28.200001 0.000000 21.650000 29.700001 0.000000 \n"
"22.000000 27.570000 0.000000 22.680000 29.680000 0.000000 \n"
"22.150000 26.660000 0.000000 16.740000 10.670000 0.000000 \n"
"17.049999 11.200000 0.000000 20.290001 17.580000 0.000000 \n"
"21.350000 23.910000 0.000000 21.950001 25.430000 0.000000 \n"
"23.520000 23.870001 0.000000 24.010000 29.670000 0.000000 \n"
"24.250000 25.240000 0.000000 24.870001 26.309999 0.000000 \n"
"25.340000 29.680000 0.000000 25.430000 27.129999 0.000000 \n"
"25.950001 27.730000 0.000000 26.379999 29.700001 0.000000 \n"
"27.070000 28.420000 0.000000 27.360001 29.740000 0.000000 \n"
"28.520000 28.700001 0.000000 28.520000 29.799999 0.000000 \n"

"POLYGONS 72 288\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 5 3 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 8 6 9 \n"
"3 9 6 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 9 12 13 \n"
"3 9 13 14 \n"
"3 9 14 15 \n"
"3 9 15 16 \n"
"3 16 15 17 \n"
"3 11 18 12 \n"
"3 18 11 19 \n"
"3 19 11 20 \n"
"3 20 11 21 \n"
"3 21 11 22 \n"
"3 23 24 25 \n"
"3 23 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 26 28 29 \n"
"3 30 16 17 \n"
"3 30 17 31 \n"
"3 30 31 32 \n"
"3 32 31 33 \n"
"3 33 31 34 \n"
"3 34 31 29 \n"
"3 29 31 26 \n"
"3 31 17 35 \n"
"3 31 35 36 \n"
"3 31 36 37 \n"
"3 31 37 38 \n"
"3 31 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 39 41 42 \n"
"3 39 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 43 45 46 \n"
"3 46 45 47 \n"
"3 48 49 50 \n"
"3 48 50 51 \n"
"3 51 50 52 \n"
"3 52 50 53 \n"
"3 52 53 54 \n"
"3 54 53 55 \n"
"3 54 55 56 \n"
"3 35 57 36 \n"
"3 57 35 58 \n"
"3 58 35 59 \n"
"3 59 35 60 \n"
"3 59 60 61 \n"
"3 61 56 55 \n"
"3 61 55 62 \n"
"3 61 62 59 \n"
"3 62 55 63 \n"
"3 62 63 64 \n"
"3 64 63 65 \n"
"3 65 63 66 \n"
"3 65 66 67 \n"
"3 67 66 68 \n"
"3 68 66 69 \n"
"3 68 69 70 \n"
"3 70 69 71 \n"
"3 70 71 72 \n"
"3 72 71 73 \n"
;

char *VTK_VECTOR_TEXT_Z = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 42 float\n"
"1.460010 29.799999 0.000000 2.650010 21.559999 0.000000 \n"
"1.150010 21.559999 0.000000 2.840010 23.200001 0.000000 \n"
"3.140000 24.520000 0.000000 3.200010 29.760000 0.000000 \n"
"3.550000 25.570000 0.000000 4.120010 26.370001 0.000000 \n"
"4.720000 29.730000 0.000000 4.860000 26.940001 0.000000 \n"
"5.810000 27.320000 0.000000 6.980010 27.520000 0.000000 \n"
"7.470000 29.690001 0.000000 8.410000 27.590000 0.000000 \n"
"10.360000 29.670000 0.000000 12.080000 29.670000 0.000000 \n"
"14.080000 29.670000 0.000000 16.080000 29.670000 0.000000 \n"
"17.790001 29.670000 0.000000 18.950001 27.590000 0.000000 \n"
"20.670000 29.690001 0.000000 7.570010 2.080020 0.000000 \n"
"13.150000 0.130005 0.000000 3.270000 0.040009 0.000000 \n"
"17.870001 0.100006 0.000000 18.549999 2.080020 0.000000 \n"
"20.100000 2.149990 0.000000 21.400000 2.390010 0.000000 \n"
"22.469999 2.820010 0.000000 22.980000 0.040009 0.000000 \n"
"23.340000 3.440000 0.000000 24.020000 4.280000 0.000000 \n"
"24.370001 0.020019 0.000000 24.540001 5.370000 0.000000 \n"
"24.930000 6.709990 0.000000 25.200001 8.320010 0.000000 \n"
"26.299999 0.000000 0.000000 26.700001 8.320010 0.000000 \n"
"0.000000 0.000000 0.000000 23.410000 29.730000 0.000000 \n"
"24.950001 29.760000 0.000000 26.700001 29.799999 0.000000 \n"

"POLYGONS 40 160\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 4 0 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 10 8 11 \n"
"3 11 8 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 13 15 16 \n"
"3 13 16 17 \n"
"3 13 17 18 \n"
"3 13 18 19 \n"
"3 19 18 20 \n"
"3 21 22 23 \n"
"3 22 21 24 \n"
"3 24 21 25 \n"
"3 24 25 26 \n"
"3 24 26 27 \n"
"3 24 27 28 \n"
"3 24 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 29 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 32 34 35 \n"
"3 32 35 36 \n"
"3 36 35 37 \n"
"3 38 21 23 \n"
"3 21 38 19 \n"
"3 21 19 20 \n"
"3 21 20 39 \n"
"3 21 39 40 \n"
"3 21 40 41 \n"
;

char *VTK_VECTOR_TEXT_a = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 84 float\n"
"0.380005 12.880000 0.000000 0.259995 13.860000 0.000000 \n"
"0.419998 14.740000 0.000000 0.559998 12.350000 0.000000 \n"
"0.839996 11.640000 0.000000 0.869995 15.590000 0.000000 \n"
"1.590000 16.379999 0.000000 2.569990 17.090000 0.000000 \n"
"4.340000 18.020000 0.000000 5.050000 15.720000 0.000000 \n"
"5.149990 14.870000 0.000000 5.330000 14.330000 0.000000 \n"
"5.620000 13.590000 0.000000 0.089996 3.560000 0.000000 \n"
"0.000000 4.420010 0.000000 0.149994 5.600010 0.000000 \n"
"0.360001 2.780000 0.000000 0.600006 6.630000 0.000000 \n"
"0.789993 2.080020 0.000000 1.380000 1.489990 0.000000 \n"
"1.380000 7.540010 0.000000 2.509990 8.330020 0.000000 \n"
"2.929990 0.649994 0.000000 4.000000 9.010010 0.000000 \n"
"4.910000 0.350006 0.000000 5.050000 5.350010 0.000000 \n"
"5.130000 6.100010 0.000000 5.380000 6.760010 0.000000 \n"
"5.800000 7.360020 0.000000 5.860000 9.600010 0.000000 \n"
"6.410000 7.890010 0.000000 7.210010 8.360020 0.000000 \n"
"8.130000 10.100000 0.000000 8.200000 8.769990 0.000000 \n"
"9.399990 9.120000 0.000000 10.800000 9.429990 0.000000 \n"
"10.800000 10.540000 0.000000 5.240010 4.290010 0.000000 \n"
"5.800000 3.450010 0.000000 6.289990 0.470001 0.000000 \n"
"6.649990 2.890010 0.000000 7.690000 0.860016 0.000000 \n"
"7.750000 2.700010 0.000000 9.190000 1.550020 0.000000 \n"
"9.240010 2.929990 0.000000 10.800000 3.630000 0.000000 \n"
"10.800000 4.070010 0.000000 10.800000 4.780000 0.000000 \n"
"10.800000 5.399990 0.000000 10.800000 13.190000 0.000000 \n"
"10.890000 2.560000 0.000000 15.320000 5.970000 0.000000 \n"
"15.260000 12.470000 0.000000 15.320000 10.050000 0.000000 \n"
"5.210010 16.500000 0.000000 5.660000 17.100000 0.000000 \n"
"6.210010 18.709999 0.000000 6.370000 17.490000 0.000000 \n"
"7.300000 17.620001 0.000000 8.080000 19.150000 0.000000 \n"
"8.140000 17.559999 0.000000 8.860000 17.360001 0.000000 \n"
"9.460010 17.030001 0.000000 9.830000 19.299999 0.000000 \n"
"9.950000 16.549999 0.000000 10.330000 15.940000 0.000000 \n"
"10.590000 15.170000 0.000000 11.100000 1.200010 0.000000 \n"
"11.260000 19.200001 0.000000 10.750000 14.260000 0.000000 \n"
"11.510000 0.000000 0.000000 12.440000 18.850000 0.000000 \n"
"13.400000 18.230000 0.000000 14.140000 17.320000 0.000000 \n"
"14.460000 1.320010 0.000000 14.680000 16.070000 0.000000 \n"
"15.050000 14.470000 0.000000 15.360000 4.519990 0.000000 \n"
"15.530000 3.640010 0.000000 15.880000 3.209990 0.000000 \n"
"16.469999 3.100010 0.000000 16.940001 3.160000 0.000000 \n"
"17.670000 2.519990 0.000000 17.670000 3.450010 0.000000 \n"

"POLYGONS 84 336\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 4 2 5 \n"
"3 4 5 6 \n"
"3 4 6 7 \n"
"3 4 7 8 \n"
"3 4 8 9 \n"
"3 4 9 10 \n"
"3 4 10 11 \n"
"3 4 11 12 \n"
"3 13 14 15 \n"
"3 13 15 16 \n"
"3 16 15 17 \n"
"3 16 17 18 \n"
"3 18 17 19 \n"
"3 19 17 20 \n"
"3 19 20 21 \n"
"3 19 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 25 23 26 \n"
"3 26 23 27 \n"
"3 27 23 28 \n"
"3 28 23 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 31 29 32 \n"
"3 31 32 33 \n"
"3 33 32 34 \n"
"3 34 32 35 \n"
"3 35 32 36 \n"
"3 24 25 37 \n"
"3 24 37 38 \n"
"3 24 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 45 46 47 \n"
"3 45 47 48 \n"
"3 45 48 35 \n"
"3 45 35 36 \n"
"3 45 36 49 \n"
"3 45 49 50 \n"
"3 45 50 43 \n"
"3 51 52 53 \n"
"3 8 54 9 \n"
"3 54 8 55 \n"
"3 55 8 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 58 56 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 61 59 62 \n"
"3 62 59 63 \n"
"3 62 63 64 \n"
"3 64 63 65 \n"
"3 65 63 66 \n"
"3 49 67 50 \n"
"3 67 49 68 \n"
"3 68 49 69 \n"
"3 68 69 66 \n"
"3 68 66 63 \n"
"3 68 70 67 \n"
"3 70 68 71 \n"
"3 70 71 72 \n"
"3 70 72 73 \n"
"3 70 73 74 \n"
"3 74 73 75 \n"
"3 74 75 76 \n"
"3 74 76 52 \n"
"3 74 52 51 \n"
"3 74 51 77 \n"
"3 74 77 78 \n"
"3 74 78 79 \n"
"3 74 79 80 \n"
"3 74 80 81 \n"
"3 74 81 82 \n"
"3 82 81 83 \n"
;

char *VTK_VECTOR_TEXT_b = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 62 float\n"
"0.000000 30.430000 0.000000 0.580002 29.410000 0.000000 \n"
"0.000000 29.370001 0.000000 1.370000 29.280001 0.000000 \n"
"3.120000 31.080000 0.000000 1.879990 28.820000 0.000000 \n"
"2.140000 27.950001 0.000000 2.209990 26.580000 0.000000 \n"
"2.209990 9.389980 0.000000 2.179990 7.139980 0.000000 \n"
"3.950000 0.979980 0.000000 2.049990 5.250000 0.000000 \n"
"1.420000 1.780000 0.000000 4.780000 31.620001 0.000000 \n"
"6.209990 0.429993 0.000000 6.909990 2.439970 0.000000 \n"
"6.909990 16.260000 0.000000 6.909990 17.629999 0.000000 \n"
"6.909990 32.419998 0.000000 7.780000 16.719999 0.000000 \n"
"8.489990 17.000000 0.000000 8.670000 18.500000 0.000000 \n"
"9.879990 17.190001 0.000000 10.200000 19.070000 0.000000 \n"
"11.170000 17.000000 0.000000 11.600000 19.389999 0.000000 \n"
"12.380000 16.480000 0.000000 13.020000 19.490000 0.000000 \n"
"13.480000 15.660000 0.000000 14.440000 14.570000 0.000000 \n"
"14.700000 19.340000 0.000000 15.230000 13.250000 0.000000 \n"
"15.830000 11.750000 0.000000 16.200001 18.900000 0.000000 \n"
"16.209999 10.100000 0.000000 16.340000 8.329990 0.000000 \n"
"17.510000 18.190001 0.000000 7.730000 1.849980 0.000000 \n"
"8.269990 0.109985 0.000000 8.500000 1.470000 0.000000 \n"
"9.310000 1.259980 0.000000 10.230000 0.000000 0.000000 \n"
"10.230000 1.199980 0.000000 11.510000 1.340000 0.000000 \n"
"12.450000 0.209991 0.000000 12.680000 1.729980 0.000000 \n"
"13.720000 2.370000 0.000000 14.460000 0.809998 0.000000 \n"
"14.610000 3.220000 0.000000 15.340000 4.259980 0.000000 \n"
"15.890000 5.479980 0.000000 16.240000 1.780000 0.000000 \n"
"16.219999 6.840000 0.000000 17.760000 3.079990 0.000000 \n"
"18.610001 17.219999 0.000000 19.000000 4.679990 0.000000 \n"
"19.500000 16.000000 0.000000 19.910000 6.560000 0.000000 \n"
"20.139999 14.560000 0.000000 20.490000 8.689970 0.000000 \n"
"20.549999 12.900000 0.000000 20.680000 11.030000 0.000000 \n"

"POLYGONS 62 248\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 8 7 4 \n"
"3 8 4 9 \n"
"3 9 4 10 \n"
"3 9 10 11 \n"
"3 11 10 12 \n"
"3 10 4 13 \n"
"3 10 13 14 \n"
"3 14 13 15 \n"
"3 15 13 16 \n"
"3 16 13 17 \n"
"3 17 13 18 \n"
"3 17 19 16 \n"
"3 19 17 20 \n"
"3 20 17 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 29 27 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 35 33 36 \n"
"3 14 15 37 \n"
"3 14 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 38 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 44 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 47 49 50 \n"
"3 47 50 51 \n"
"3 51 50 52 \n"
"3 51 52 35 \n"
"3 51 35 36 \n"
"3 51 36 53 \n"
"3 53 36 54 \n"
"3 53 54 55 \n"
"3 55 54 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 57 58 59 \n"
"3 59 58 60 \n"
"3 59 60 61 \n"
;

char *VTK_VECTOR_TEXT_c = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 53 float\n"
"4.270020 17.969999 0.000000 4.960020 12.960000 0.000000 \n"
"4.870030 11.470000 0.000000 5.240020 14.300000 0.000000 \n"
"5.680020 15.470000 0.000000 6.000000 18.820000 0.000000 \n"
"6.290010 16.459999 0.000000 7.040010 17.260000 0.000000 \n"
"7.930020 17.850000 0.000000 7.960020 19.350000 0.000000 \n"
"8.960020 18.209999 0.000000 10.100000 18.330000 0.000000 \n"
"10.140000 19.530001 0.000000 11.090000 18.260000 0.000000 \n"
"11.960000 18.049999 0.000000 12.740000 17.690001 0.000000 \n"
"13.250000 19.250000 0.000000 13.420000 17.180000 0.000000 \n"
"14.020000 16.500000 0.000000 14.520000 15.660000 0.000000 \n"
"14.960000 14.650000 0.000000 16.120001 18.330000 0.000000 \n"
"15.320000 13.460000 0.000000 16.430000 13.550000 0.000000 \n"
"0.170013 7.590000 0.000000 0.000000 9.699980 0.000000 \n"
"0.190002 11.810000 0.000000 0.670013 5.699980 0.000000 \n"
"0.730011 13.720000 0.000000 1.480010 4.040010 0.000000 \n"
"1.610020 15.400000 0.000000 2.580020 2.639980 0.000000 \n"
"2.790010 16.820000 0.000000 3.960020 1.519990 0.000000 \n"
"5.010010 9.510010 0.000000 5.400020 7.669980 0.000000 \n"
"5.590000 0.690002 0.000000 6.010010 5.989990 0.000000 \n"
"6.830020 4.519990 0.000000 7.450010 0.169983 0.000000 \n"
"7.810000 3.310000 0.000000 8.930020 2.380000 0.000000 \n"
"9.520020 0.000000 0.000000 10.160000 1.799990 0.000000 \n"
"11.110000 0.079987 0.000000 11.470000 1.590000 0.000000 \n"
"12.610000 0.359985 0.000000 12.750000 1.760010 0.000000 \n"
"13.950000 2.320010 0.000000 14.230000 0.880005 0.000000 \n"
"15.180000 3.329990 0.000000 16.160000 1.679990 0.000000 \n"
"16.559999 4.870000 0.000000 \n"
"POLYGONS 51 204\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 4 0 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 8 5 9 \n"
"3 8 9 10 \n"
"3 10 9 11 \n"
"3 11 9 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 14 12 15 \n"
"3 15 12 16 \n"
"3 15 16 17 \n"
"3 17 16 18 \n"
"3 18 16 19 \n"
"3 19 16 20 \n"
"3 20 16 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 24 25 26 \n"
"3 24 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 33 32 0 \n"
"3 33 0 2 \n"
"3 33 2 34 \n"
"3 33 34 35 \n"
"3 33 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 39 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 46 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
;

char *VTK_VECTOR_TEXT_d = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 70 float\n"
"4.140010 18.280001 0.000000 5.000000 13.110000 0.000000 \n"
"4.910000 11.560000 0.000000 5.240020 14.520000 0.000000 \n"
"5.630000 15.760000 0.000000 5.750000 19.219999 0.000000 \n"
"6.150020 16.820000 0.000000 6.810000 17.670000 0.000000 \n"
"7.540010 19.809999 0.000000 7.570010 18.290001 0.000000 \n"
"8.430020 18.690001 0.000000 9.390010 18.820000 0.000000 \n"
"9.480010 20.010000 0.000000 10.480000 18.700001 0.000000 \n"
"11.560000 19.820000 0.000000 11.560000 18.330000 0.000000 \n"
"12.620000 17.730000 0.000000 13.640000 16.920000 0.000000 \n"
"13.640000 19.260000 0.000000 0.160004 7.760010 0.000000 \n"
"0.000000 9.700010 0.000000 0.190002 11.800000 0.000000 \n"
"0.619995 5.980010 0.000000 0.730011 13.760000 0.000000 \n"
"1.360020 4.399990 0.000000 1.600010 15.510000 0.000000 \n"
"2.340000 3.040010 0.000000 2.740020 17.030001 0.000000 \n"
"3.550020 1.919980 0.000000 4.950010 1.100010 0.000000 \n"
"5.030000 9.730010 0.000000 5.360020 8.060000 0.000000 \n"
"5.900020 6.560000 0.000000 6.520020 0.579987 0.000000 \n"
"6.610020 5.280000 0.000000 7.480010 4.230010 0.000000 \n"
"8.240020 0.399994 0.000000 8.500000 3.450010 0.000000 \n"
"9.650020 2.959990 0.000000 9.680020 0.519989 0.000000 \n"
"10.890000 2.790010 0.000000 11.020000 0.889984 0.000000 \n"
"12.320000 1.549990 0.000000 12.350000 2.989990 0.000000 \n"
"13.640000 2.519990 0.000000 13.640000 3.760010 0.000000 \n"
"13.640000 27.100000 0.000000 13.880000 1.090000 0.000000 \n"
"11.290000 30.860001 0.000000 11.910000 29.850000 0.000000 \n"
"11.290000 29.799999 0.000000 12.760000 29.730000 0.000000 \n"
"14.390000 0.000000 0.000000 14.580000 31.590000 0.000000 \n"
"13.560000 28.459999 0.000000 13.290000 29.299999 0.000000 \n"
"15.680000 0.579987 0.000000 16.309999 32.130001 0.000000 \n"
"17.150000 1.179990 0.000000 18.200001 7.130000 0.000000 \n"
"18.200001 32.810001 0.000000 18.209999 5.970000 0.000000 \n"
"18.240000 5.049990 0.000000 18.299999 4.359990 0.000000 \n"
"18.400000 3.859990 0.000000 18.740000 3.320010 0.000000 \n"
"19.350000 3.190000 0.000000 19.730000 3.209990 0.000000 \n"
"20.370001 3.410000 0.000000 20.549999 2.389980 0.000000 \n"

"POLYGONS 70 280\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 4 0 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 10 8 11 \n"
"3 11 8 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 16 14 17 \n"
"3 17 14 18 \n"
"3 19 20 21 \n"
"3 19 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 28 27 0 \n"
"3 28 0 2 \n"
"3 28 2 29 \n"
"3 29 2 30 \n"
"3 29 30 31 \n"
"3 29 31 32 \n"
"3 29 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 33 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 41 40 42 \n"
"3 42 40 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 44 45 17 \n"
"3 44 17 18 \n"
"3 44 18 46 \n"
"3 44 46 47 \n"
"3 48 49 50 \n"
"3 49 48 51 \n"
"3 46 52 47 \n"
"3 52 46 53 \n"
"3 53 46 54 \n"
"3 53 54 55 \n"
"3 53 55 51 \n"
"3 53 51 48 \n"
"3 53 56 52 \n"
"3 56 53 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 59 57 60 \n"
"3 58 59 61 \n"
"3 58 61 62 \n"
"3 58 62 63 \n"
"3 58 63 64 \n"
"3 58 64 65 \n"
"3 58 65 66 \n"
"3 58 66 67 \n"
"3 58 67 68 \n"
"3 58 68 69 \n"
;

char *VTK_VECTOR_TEXT_e = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 60 float\n"
"0.170013 11.850000 0.000000 0.180023 7.709990 0.000000 \n"
"0.000000 9.790010 0.000000 0.649994 13.730000 0.000000 \n"
"0.720001 5.829990 0.000000 1.420010 15.390000 0.000000 \n"
"1.580020 4.160000 0.000000 2.460020 16.820000 0.000000 \n"
"2.740020 2.729980 0.000000 3.740020 17.980000 0.000000 \n"
"4.170010 1.579990 0.000000 4.960020 11.960000 0.000000 \n"
"5.040010 13.450000 0.000000 5.230010 14.740000 0.000000 \n"
"5.230010 18.850000 0.000000 5.520020 15.830000 0.000000 \n"
"5.920010 16.719999 0.000000 6.420010 17.410000 0.000000 \n"
"6.920010 19.389999 0.000000 7.050020 17.900000 0.000000 \n"
"7.780000 18.190001 0.000000 8.640010 18.290001 0.000000 \n"
"8.770020 19.570000 0.000000 9.430020 18.200001 0.000000 \n"
"10.120000 17.930000 0.000000 10.640000 19.430000 0.000000 \n"
"10.710000 17.480000 0.000000 11.190000 16.850000 0.000000 \n"
"11.560000 16.040001 0.000000 11.830000 15.060000 0.000000 \n"
"12.280000 19.000000 0.000000 11.990000 13.900000 0.000000 \n"
"12.050000 12.580000 0.000000 5.050020 10.630000 0.000000 \n"
"5.220000 8.720000 0.000000 5.620000 6.970000 0.000000 \n"
"5.850010 0.720001 0.000000 6.220000 5.410000 0.000000 \n"
"7.010010 4.070010 0.000000 7.740020 0.179993 0.000000 \n"
"7.970000 2.970000 0.000000 9.060000 2.149990 0.000000 \n"
"9.830020 0.000000 0.000000 10.280000 1.639980 0.000000 \n"
"11.600000 1.459990 0.000000 11.830000 0.130005 0.000000 \n"
"12.910000 1.699980 0.000000 13.690000 0.529999 0.000000 \n"
"14.190000 2.399990 0.000000 15.410000 1.199980 0.000000 \n"
"15.460000 3.570010 0.000000 16.740000 5.229980 0.000000 \n"
"16.959999 2.130000 0.000000 12.050000 11.960000 0.000000 \n"
"13.680000 18.290001 0.000000 14.840000 17.290001 0.000000 \n"
"15.750000 16.030001 0.000000 16.410000 14.490000 0.000000 \n"
"16.809999 12.690000 0.000000 16.959999 10.630000 0.000000 \n"

"POLYGONS 60 240\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 8 9 10 \n"
"3 10 9 11 \n"
"3 11 9 12 \n"
"3 12 9 13 \n"
"3 13 9 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 16 14 17 \n"
"3 17 14 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 20 18 21 \n"
"3 21 18 22 \n"
"3 21 22 23 \n"
"3 23 22 24 \n"
"3 24 22 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 27 25 28 \n"
"3 28 25 29 \n"
"3 29 25 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 10 11 33 \n"
"3 10 33 34 \n"
"3 10 34 35 \n"
"3 10 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 39 40 41 \n"
"3 39 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 49 51 52 \n"
"3 33 11 53 \n"
"3 53 32 30 \n"
"3 53 30 54 \n"
"3 53 54 55 \n"
"3 53 55 56 \n"
"3 53 56 57 \n"
"3 53 57 58 \n"
"3 53 58 33 \n"
"3 33 58 59 \n"
;

char *VTK_VECTOR_TEXT_f = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 62 float\n"
"0.839996 18.549999 0.000000 3.010010 16.920000 0.000000 \n"
"0.000000 16.920000 0.000000 3.010010 18.549999 0.000000 \n"
"6.830020 0.080017 0.000000 7.620030 4.959990 0.000000 \n"
"7.630000 3.830020 0.000000 7.680020 2.959990 0.000000 \n"
"7.800020 2.300020 0.000000 7.970000 0.080017 0.000000 \n"
"8.020020 1.820010 0.000000 8.350010 1.489990 0.000000 \n"
"8.830020 1.270020 0.000000 9.040010 0.050018 0.000000 \n"
"9.480010 1.120000 0.000000 10.320000 0.000000 0.000000 \n"
"10.320000 1.020020 0.000000 7.620030 18.549999 0.000000 \n"
"13.330000 16.920000 0.000000 7.620030 16.920000 0.000000 \n"
"14.120000 18.549999 0.000000 0.440002 1.020020 0.000000 \n"
"1.710020 0.050018 0.000000 0.440002 0.000000 0.000000 \n"
"1.800020 1.220000 0.000000 2.570010 1.780000 0.000000 \n"
"2.780000 0.080017 0.000000 2.790010 2.260010 0.000000 \n"
"2.930020 2.920010 0.000000 2.990020 3.780000 0.000000 \n"
"3.010010 4.870000 0.000000 3.010010 20.680000 0.000000 \n"
"3.150020 23.190001 0.000000 3.580020 25.379999 0.000000 \n"
"3.910000 0.080017 0.000000 4.300020 27.250000 0.000000 \n"
"5.280000 28.780001 0.000000 5.360020 0.089996 0.000000 \n"
"6.550020 29.980000 0.000000 7.620030 24.309999 0.000000 \n"
"7.660000 25.770000 0.000000 7.810000 27.010000 0.000000 \n"
"8.050020 28.040001 0.000000 8.070010 30.840000 0.000000 \n"
"8.400020 28.860001 0.000000 8.870030 29.480000 0.000000 \n"
"9.450010 29.910000 0.000000 9.860020 31.360001 0.000000 \n"
"10.150000 30.160000 0.000000 10.980000 30.240000 0.000000 \n"
"11.780000 30.170000 0.000000 11.910000 31.530001 0.000000 \n"
"12.470000 29.950001 0.000000 13.070000 29.580000 0.000000 \n"
"13.570000 29.059999 0.000000 13.770000 31.410000 0.000000 \n"
"13.980000 28.389999 0.000000 14.310000 27.549999 0.000000 \n"
"14.550000 26.570000 0.000000 15.850000 31.000000 0.000000 \n"
"14.700000 25.420000 0.000000 15.990000 25.420000 0.000000 \n"

"POLYGONS 60 240\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 4 5 6 \n"
"3 4 6 7 \n"
"3 4 7 8 \n"
"3 4 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 9 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 17 18 19 \n"
"3 18 17 20 \n"
"3 21 22 23 \n"
"3 22 21 24 \n"
"3 22 24 25 \n"
"3 22 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 26 28 29 \n"
"3 30 1 3 \n"
"3 30 3 31 \n"
"3 30 31 32 \n"
"3 30 32 33 \n"
"3 30 33 29 \n"
"3 29 33 34 \n"
"3 29 34 26 \n"
"3 34 33 35 \n"
"3 34 35 36 \n"
"3 34 36 37 \n"
"3 37 36 38 \n"
"3 37 38 4 \n"
"3 4 38 5 \n"
"3 5 38 19 \n"
"3 19 38 17 \n"
"3 17 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 41 38 42 \n"
"3 42 38 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 45 43 46 \n"
"3 46 43 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 49 47 50 \n"
"3 50 47 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 53 51 54 \n"
"3 54 51 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 57 55 58 \n"
"3 58 55 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
;

char *VTK_VECTOR_TEXT_g = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 124 float\n"
"0.149994 4.170010 0.000000 0.000000 5.270020 0.000000 \n"
"0.260010 6.670010 0.000000 0.600006 3.160000 0.000000 \n"
"1.040010 7.800020 0.000000 1.329990 2.260010 0.000000 \n"
"2.290010 1.490020 0.000000 2.329990 8.640010 0.000000 \n"
"3.480010 0.860016 0.000000 3.489990 4.870030 0.000000 \n"
"3.489990 4.960020 0.000000 3.709990 6.110020 0.000000 \n"
"4.109990 9.170010 0.000000 4.329990 6.990020 0.000000 \n"
"0.390015 20.090000 0.000000 0.309998 21.170000 0.000000 \n"
"0.450012 22.490000 0.000000 0.630005 19.120001 0.000000 \n"
"0.869995 23.709999 0.000000 1.040010 18.260000 0.000000 \n"
"1.540010 24.799999 0.000000 1.620000 17.500000 0.000000 \n"
"2.399990 16.840000 0.000000 2.429990 25.740000 0.000000 \n"
"3.370000 16.260000 0.000000 3.519990 26.520000 0.000000 \n"
"4.549990 15.760000 0.000000 4.790010 27.100000 0.000000 \n"
"4.910000 22.240000 0.000000 5.190000 19.860001 0.000000 \n"
"5.510010 18.840000 0.000000 5.929990 15.330000 0.000000 \n"
"5.950010 17.969999 0.000000 6.470000 14.190000 0.000000 \n"
"6.149990 13.330000 0.000000 6.480010 17.250000 0.000000 \n"
"6.920010 14.620000 0.000000 7.100010 16.709999 0.000000 \n"
"7.609990 15.100000 0.000000 7.790010 16.370001 0.000000 \n"
"8.540010 16.260000 0.000000 9.560000 15.220000 0.000000 \n"
"9.660000 16.559999 0.000000 10.510000 17.420000 0.000000 \n"
"11.250000 15.510000 0.000000 11.050000 18.760000 0.000000 \n"
"11.250000 20.510000 0.000000 3.620000 4.090030 0.000000 \n"
"3.920010 3.380000 0.000000 4.870000 0.400024 0.000000 \n"
"5.010010 2.220000 0.000000 6.429990 0.100006 0.000000 \n"
"6.630000 1.470000 0.000000 8.140010 0.000000 0.000000 \n"
"8.679990 1.200010 0.000000 10.170000 0.120026 0.000000 \n"
"10.860000 1.460020 0.000000 11.990000 0.480011 0.000000 \n"
"12.550000 2.200010 0.000000 13.180000 2.730010 0.000000 \n"
"13.600000 1.050020 0.000000 13.650000 3.350010 0.000000 \n"
"13.940000 4.050020 0.000000 14.040000 4.830020 0.000000 \n"
"14.970000 1.820010 0.000000 14.390000 24.490000 0.000000 \n"
"14.770000 17.410000 0.000000 13.850000 16.600000 0.000000 \n"
"15.120000 23.549999 0.000000 15.420000 18.389999 0.000000 \n"
"15.600000 22.680000 0.000000 15.810000 19.540001 0.000000 \n"
"15.860000 21.799999 0.000000 15.940000 20.860001 0.000000 \n"
"1.940000 10.980000 0.000000 1.810000 11.740000 0.000000 \n"
"2.019990 12.720000 0.000000 2.350010 10.320000 0.000000 \n"
"2.709990 13.580000 0.000000 3.060000 9.730010 0.000000 \n"
"3.980010 14.420000 0.000000 4.859990 14.860000 0.000000 \n"
"5.290010 7.550020 0.000000 6.329990 12.650000 0.000000 \n"
"6.549990 7.750000 0.000000 7.000000 12.200000 0.000000 \n"
"7.570010 12.040000 0.000000 8.200010 7.700010 0.000000 \n"
"8.340000 11.910000 0.000000 9.320010 11.800000 0.000000 \n"
"9.660000 7.550020 0.000000 10.540000 11.690000 0.000000 \n"
"10.940000 7.310030 0.000000 12.020000 6.970000 0.000000 \n"
"12.300000 11.510000 0.000000 12.880000 6.550020 0.000000 \n"
"13.510000 6.050020 0.000000 13.790000 11.220000 0.000000 \n"
"13.900000 5.480010 0.000000 15.000000 10.800000 0.000000 \n"
"15.970000 10.260000 0.000000 16.080000 2.780000 0.000000 \n"
"16.690001 9.580020 0.000000 16.900000 3.910000 0.000000 \n"
"17.200001 8.750000 0.000000 17.400000 5.190000 0.000000 \n"
"17.480000 7.760010 0.000000 17.580000 6.600010 0.000000 \n"
"5.109990 23.920000 0.000000 5.679990 25.219999 0.000000 \n"
"6.209990 27.469999 0.000000 6.560000 26.059999 0.000000 \n"
"7.700010 26.350000 0.000000 7.750000 27.590000 0.000000 \n"
"8.410000 26.240000 0.000000 9.079990 25.900000 0.000000 \n"
"9.679990 25.370001 0.000000 9.980010 27.340000 0.000000 \n"
"10.200000 24.660000 0.000000 10.970000 22.799999 0.000000 \n"
"12.040000 26.530001 0.000000 12.680000 15.970000 0.000000 \n"
"17.219999 24.490000 0.000000 18.070000 26.440001 0.000000 \n"

"POLYGONS 126 504\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 9 7 10 \n"
"3 10 7 11 \n"
"3 11 7 12 \n"
"3 11 12 13 \n"
"3 14 15 16 \n"
"3 14 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 21 20 22 \n"
"3 22 20 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 26 28 29 \n"
"3 26 29 30 \n"
"3 26 30 31 \n"
"3 31 30 32 \n"
"3 32 33 34 \n"
"3 33 32 35 \n"
"3 33 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 38 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 8 9 47 \n"
"3 8 47 48 \n"
"3 8 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 51 52 53 \n"
"3 53 52 54 \n"
"3 53 54 55 \n"
"3 55 54 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 57 58 59 \n"
"3 57 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 60 62 63 \n"
"3 60 63 64 \n"
"3 65 66 67 \n"
"3 66 65 68 \n"
"3 66 68 69 \n"
"3 69 68 70 \n"
"3 69 70 71 \n"
"3 71 70 72 \n"
"3 71 72 73 \n"
"3 74 75 76 \n"
"3 74 76 77 \n"
"3 77 76 78 \n"
"3 77 78 79 \n"
"3 79 78 80 \n"
"3 79 80 12 \n"
"3 12 80 13 \n"
"3 13 80 81 \n"
"3 13 81 82 \n"
"3 82 81 31 \n"
"3 82 31 34 \n"
"3 34 31 32 \n"
"3 82 34 83 \n"
"3 82 83 84 \n"
"3 84 83 85 \n"
"3 84 85 86 \n"
"3 84 86 87 \n"
"3 87 86 88 \n"
"3 87 88 89 \n"
"3 87 89 90 \n"
"3 90 89 91 \n"
"3 90 91 92 \n"
"3 92 91 93 \n"
"3 93 91 94 \n"
"3 93 94 95 \n"
"3 95 94 96 \n"
"3 96 94 97 \n"
"3 96 97 98 \n"
"3 98 97 63 \n"
"3 63 97 64 \n"
"3 64 97 99 \n"
"3 64 99 100 \n"
"3 64 100 101 \n"
"3 101 100 102 \n"
"3 101 102 103 \n"
"3 103 102 104 \n"
"3 103 104 105 \n"
"3 105 104 106 \n"
"3 105 106 107 \n"
"3 27 108 28 \n"
"3 108 27 109 \n"
"3 109 27 110 \n"
"3 109 110 111 \n"
"3 111 110 112 \n"
"3 112 110 113 \n"
"3 112 113 114 \n"
"3 114 113 115 \n"
"3 115 113 116 \n"
"3 116 113 117 \n"
"3 116 117 118 \n"
"3 118 117 119 \n"
"3 119 117 120 \n"
"3 119 120 46 \n"
"3 46 120 44 \n"
"3 44 120 121 \n"
"3 121 120 67 \n"
"3 67 120 65 \n"
"3 65 120 122 \n"
"3 122 120 123 \n"
;

char *VTK_VECTOR_TEXT_h = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 84 float\n"
"0.000000 0.000000 0.000000 0.000000 1.020020 0.000000 \n"
"1.259980 1.200010 0.000000 1.269990 0.050018 0.000000 \n"
"1.989990 1.660000 0.000000 2.319980 0.080017 0.000000 \n"
"2.329990 2.580020 0.000000 2.409970 3.280000 0.000000 \n"
"2.439970 4.160000 0.000000 2.439970 5.399990 0.000000 \n"
"2.439970 25.900000 0.000000 3.439970 0.080017 0.000000 \n"
"0.139984 29.930000 0.000000 0.619995 28.740000 0.000000 \n"
"0.139984 28.740000 0.000000 1.539980 28.629999 0.000000 \n"
"1.899990 30.160000 0.000000 2.099980 28.219999 0.000000 \n"
"2.370000 27.360001 0.000000 3.489990 30.490000 0.000000 \n"
"4.879970 0.089996 0.000000 5.169980 30.980000 0.000000 \n"
"6.299990 0.080017 0.000000 7.179990 4.160000 0.000000 \n"
"7.179990 14.120000 0.000000 7.179990 15.360000 0.000000 \n"
"7.179990 31.709999 0.000000 7.199980 3.310000 0.000000 \n"
"7.269990 2.630000 0.000000 7.409970 0.080017 0.000000 \n"
"7.629970 1.709990 0.000000 8.409970 1.230010 0.000000 \n"
"8.479980 0.050018 0.000000 9.750000 0.000000 0.000000 \n"
"9.750000 1.020020 0.000000 12.050000 0.000000 0.000000 \n"
"12.050000 1.020020 0.000000 13.340000 1.220000 0.000000 \n"
"13.500000 0.050018 0.000000 13.770000 1.480010 0.000000 \n"
"14.090000 1.880000 0.000000 14.310000 2.450010 0.000000 \n"
"14.650000 0.100006 0.000000 14.440000 3.230010 0.000000 \n"
"14.510000 4.250000 0.000000 14.530000 5.530000 0.000000 \n"
"14.530000 11.330000 0.000000 19.480000 13.060000 0.000000 \n"
"19.490000 4.580020 0.000000 19.490000 3.940000 0.000000 \n"
"19.490000 5.030000 0.000000 19.490000 5.310000 0.000000 \n"
"19.490000 5.399990 0.000000 19.530001 10.670000 0.000000 \n"
"19.530001 10.980000 0.000000 8.370000 14.960000 0.000000 \n"
"9.030000 16.889999 0.000000 9.500000 15.560000 0.000000 \n"
"10.600000 15.910000 0.000000 10.840000 17.950001 0.000000 \n"
"11.700000 16.030001 0.000000 12.490000 15.980000 0.000000 \n"
"12.620000 18.570000 0.000000 13.130000 15.830000 0.000000 \n"
"13.620000 15.550000 0.000000 13.990000 15.110000 0.000000 \n"
"14.250000 14.490000 0.000000 14.400000 18.770000 0.000000 \n"
"14.420000 13.680000 0.000000 14.500000 12.630000 0.000000 \n"
"15.780000 18.690001 0.000000 16.900000 18.410000 0.000000 \n"
"16.920000 0.130005 0.000000 17.790001 17.910000 0.000000 \n"
"18.480000 17.150000 0.000000 18.969999 16.110001 0.000000 \n"
"19.190001 0.100006 0.000000 19.299999 14.760000 0.000000 \n"
"19.590000 2.520020 0.000000 19.940001 1.630000 0.000000 \n"
"20.350000 0.050018 0.000000 20.650000 1.170010 0.000000 \n"
"21.790001 0.000000 0.000000 21.790001 1.020020 0.000000 \n"

"POLYGONS 82 328\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 5 7 8 \n"
"3 8 9 10 \n"
"3 8 10 11 \n"
"3 8 11 5 \n"
"3 12 13 14 \n"
"3 13 12 15 \n"
"3 15 12 16 \n"
"3 15 16 17 \n"
"3 17 16 18 \n"
"3 18 16 19 \n"
"3 18 19 10 \n"
"3 10 19 11 \n"
"3 11 19 20 \n"
"3 20 19 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 23 21 24 \n"
"3 24 21 25 \n"
"3 25 21 26 \n"
"3 22 23 27 \n"
"3 22 27 28 \n"
"3 22 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 29 31 32 \n"
"3 32 31 33 \n"
"3 33 31 34 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 38 40 41 \n"
"3 38 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 42 44 45 \n"
"3 42 45 46 \n"
"3 47 48 49 \n"
"3 48 47 50 \n"
"3 50 47 51 \n"
"3 51 47 52 \n"
"3 52 47 53 \n"
"3 53 47 54 \n"
"3 25 55 24 \n"
"3 55 25 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 58 56 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 61 59 62 \n"
"3 61 62 63 \n"
"3 63 62 64 \n"
"3 64 62 65 \n"
"3 65 62 66 \n"
"3 66 62 67 \n"
"3 66 67 68 \n"
"3 68 67 69 \n"
"3 69 67 46 \n"
"3 46 67 70 \n"
"3 46 70 42 \n"
"3 42 70 71 \n"
"3 42 71 72 \n"
"3 72 71 73 \n"
"3 72 73 74 \n"
"3 72 74 75 \n"
"3 72 75 76 \n"
"3 76 75 77 \n"
"3 76 77 47 \n"
"3 76 47 49 \n"
"3 76 49 78 \n"
"3 76 78 79 \n"
"3 76 79 80 \n"
"3 80 79 81 \n"
"3 80 81 82 \n"
"3 82 81 83 \n"
;

char *VTK_VECTOR_TEXT_i = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 49 float\n"
"0.000000 16.650000 0.000000 1.380000 15.500000 0.000000 \n"
"0.000000 15.590000 0.000000 1.509980 17.110001 0.000000 \n"
"2.169980 15.130000 0.000000 2.530000 14.300000 0.000000 \n"
"3.169980 17.680000 0.000000 2.600010 13.660000 0.000000 \n"
"2.620000 12.840000 0.000000 0.000000 1.060000 0.000000 \n"
"1.239990 0.029999 0.000000 0.000000 0.000000 0.000000 \n"
"1.310000 1.270020 0.000000 2.109990 1.870000 0.000000 \n"
"2.280000 0.059998 0.000000 2.350010 2.370000 0.000000 \n"
"2.509980 3.030000 0.000000 2.590000 3.870000 0.000000 \n"
"2.620000 4.910000 0.000000 3.370000 0.080017 0.000000 \n"
"4.790010 0.089996 0.000000 5.000000 18.389999 0.000000 \n"
"6.179990 0.080017 0.000000 7.000000 4.470000 0.000000 \n"
"7.000000 19.219999 0.000000 1.979980 24.629999 0.000000 \n"
"1.780000 25.680000 0.000000 1.979980 26.750000 0.000000 \n"
"2.560000 23.770000 0.000000 2.560000 27.620001 0.000000 \n"
"3.419980 23.190001 0.000000 3.419980 28.209999 0.000000 \n"
"4.479980 22.980000 0.000000 4.479980 28.430000 0.000000 \n"
"5.540010 23.190001 0.000000 5.560000 28.209999 0.000000 \n"
"6.410000 23.770000 0.000000 6.429990 27.620001 0.000000 \n"
"7.009980 24.629999 0.000000 7.009980 26.750000 0.000000 \n"
"7.220000 25.680000 0.000000 7.019990 3.570010 0.000000 \n"
"7.079990 2.860020 0.000000 7.280000 0.059998 0.000000 \n"
"7.440000 1.890010 0.000000 8.220000 1.350010 0.000000 \n"
"8.320010 0.029999 0.000000 9.570010 0.000000 0.000000 \n"
"9.570010 1.060000 0.000000 \n"
"POLYGONS 45 180\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 5 3 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 9 10 11 \n"
"3 10 9 12 \n"
"3 10 12 13 \n"
"3 10 13 14 \n"
"3 14 13 15 \n"
"3 14 15 16 \n"
"3 14 16 17 \n"
"3 18 8 6 \n"
"3 18 6 17 \n"
"3 17 6 19 \n"
"3 17 19 14 \n"
"3 6 20 19 \n"
"3 20 6 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 23 21 24 \n"
"3 25 26 27 \n"
"3 25 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 34 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 22 23 41 \n"
"3 22 41 42 \n"
"3 22 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 43 45 46 \n"
"3 46 45 47 \n"
"3 47 45 48 \n"
;

char *VTK_VECTOR_TEXT_j = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 51 float\n"
"0.000000 0.709991 0.000000 0.000000 5.090000 0.000000 \n"
"0.970001 5.090000 0.000000 1.260010 3.399990 0.000000 \n"
"1.679990 2.260010 0.000000 1.970000 0.169983 0.000000 \n"
"2.280000 1.620000 0.000000 3.100010 1.419980 0.000000 \n"
"3.669980 0.000000 0.000000 3.910000 1.600010 0.000000 \n"
"4.440000 2.209990 0.000000 5.079990 0.130005 0.000000 \n"
"4.729980 3.340000 0.000000 4.820010 5.090000 0.000000 \n"
"4.820010 21.260000 0.000000 2.519990 25.150000 0.000000 \n"
"3.359990 24.139999 0.000000 2.519990 24.049999 0.000000 \n"
"3.979980 25.520000 0.000000 4.109990 24.030001 0.000000 \n"
"4.560000 23.629999 0.000000 5.250000 25.910000 0.000000 \n"
"4.769990 22.750000 0.000000 4.810000 22.090000 0.000000 \n"
"6.290010 0.519989 0.000000 6.679990 26.440001 0.000000 \n"
"7.290010 1.179990 0.000000 7.549990 26.799999 0.000000 \n"
"8.100010 2.120000 0.000000 8.590000 27.230000 0.000000 \n"
"8.729980 3.329990 0.000000 9.169980 4.840000 0.000000 \n"
"9.429990 6.630000 0.000000 9.519990 8.720000 0.000000 \n"
"9.519990 27.680000 0.000000 4.510010 33.080002 0.000000 \n"
"4.290010 34.139999 0.000000 4.510010 35.200001 0.000000 \n"
"5.100010 32.209999 0.000000 5.100010 36.060001 0.000000 \n"
"5.970000 31.610001 0.000000 5.970000 36.639999 0.000000 \n"
"7.040010 31.400000 0.000000 7.040010 36.849998 0.000000 \n"
"8.090000 31.610001 0.000000 8.090000 36.639999 0.000000 \n"
"8.949980 32.189999 0.000000 8.949980 36.060001 0.000000 \n"
"9.530000 33.060001 0.000000 9.530000 35.200001 0.000000 \n"
"9.739990 34.139999 0.000000 \n"
"POLYGONS 47 188\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 0 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 5 7 8 \n"
"3 8 7 9 \n"
"3 8 9 10 \n"
"3 8 10 11 \n"
"3 11 10 12 \n"
"3 11 12 13 \n"
"3 11 13 14 \n"
"3 15 16 17 \n"
"3 16 15 18 \n"
"3 16 18 19 \n"
"3 19 18 20 \n"
"3 20 18 21 \n"
"3 20 21 22 \n"
"3 22 21 23 \n"
"3 23 21 14 \n"
"3 14 21 11 \n"
"3 11 21 24 \n"
"3 24 21 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 31 29 32 \n"
"3 32 29 33 \n"
"3 33 29 34 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 40 39 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 48 49 50 \n"
;

char *VTK_VECTOR_TEXT_k = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 83 float\n"
"0.000000 1.018980 0.000000 1.213000 0.032989 0.000000 \n"
"0.000000 0.000000 0.000000 1.291200 1.254000 0.000000 \n"
"2.059300 1.837980 0.000000 2.231000 0.061005 0.000000 \n"
"2.286100 2.328000 0.000000 2.428900 2.987000 0.000000 \n"
"2.503100 3.840000 0.000000 3.307000 0.080994 0.000000 \n"
"2.524400 4.915990 0.000000 2.524400 26.174000 0.000000 \n"
"0.000000 29.540001 0.000000 0.708599 28.431999 0.000000 \n"
"0.000000 28.431999 0.000000 1.608900 28.341000 0.000000 \n"
"2.164500 28.000999 0.000000 3.338100 30.275999 0.000000 \n"
"2.446200 27.311001 0.000000 4.694400 0.088989 0.000000 \n"
"5.138000 30.891001 0.000000 6.088800 0.080994 0.000000 \n"
"7.174500 3.720000 0.000000 7.174500 8.902010 0.000000 \n"
"7.174500 10.496000 0.000000 7.174500 31.709999 0.000000 \n"
"7.180000 0.061005 0.000000 7.253400 2.476990 0.000000 \n"
"7.573100 1.711000 0.000000 8.213200 0.032989 0.000000 \n"
"8.258100 1.285000 0.000000 9.433100 0.000000 0.000000 \n"
"9.433100 1.062990 0.000000 11.337500 18.468000 0.000000 \n"
"12.169900 17.287001 0.000000 11.337500 17.405001 0.000000 \n"
"12.430800 18.434999 0.000000 12.749100 17.056000 0.000000 \n"
"13.087500 16.701000 0.000000 13.341500 18.407000 0.000000 \n"
"13.197500 16.209000 0.000000 12.223200 12.843000 0.000000 \n"
"12.123600 14.643000 0.000000 12.632300 15.167000 0.000000 \n"
"12.754700 13.286000 0.000000 12.963600 15.586000 0.000000 \n"
"14.134400 14.444000 0.000000 14.301900 18.386999 0.000000 \n"
"15.256200 15.350000 0.000000 15.544700 18.379000 0.000000 \n"
"16.177601 16.037001 0.000000 16.794399 18.386999 0.000000 \n"
"16.956400 16.541000 0.000000 17.770100 18.407000 0.000000 \n"
"18.316099 17.135000 0.000000 19.796301 17.405001 0.000000 \n"
"19.796301 18.468000 0.000000 7.794500 10.983000 0.000000 \n"
"8.547400 9.919980 0.000000 9.272800 12.183000 0.000000 \n"
"10.469700 13.176000 0.000000 11.411300 13.987000 0.000000 \n"
"12.001800 4.340000 0.000000 12.666100 3.233000 0.000000 \n"
"13.192000 11.188000 0.000000 13.346300 2.079990 0.000000 \n"
"13.723400 1.317990 0.000000 13.811300 10.184000 0.000000 \n"
"13.950400 0.000000 0.000000 14.243700 9.497990 0.000000 \n"
"14.791900 8.635990 0.000000 15.716300 0.078003 0.000000 \n"
"16.584801 0.087006 0.000000 16.961901 5.182010 0.000000 \n"
"17.714800 0.088989 0.000000 17.936199 3.631990 0.000000 \n"
"18.782499 2.419010 0.000000 18.819901 0.087006 0.000000 \n"
"19.558201 1.639010 0.000000 19.680000 0.078003 0.000000 \n"
"20.408701 1.190000 0.000000 21.479200 0.000000 0.000000 \n"
"21.479200 0.973999 0.000000 \n"
"POLYGONS 81 324\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 5 7 8 \n"
"3 5 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 12 13 14 \n"
"3 13 12 15 \n"
"3 15 12 16 \n"
"3 16 12 17 \n"
"3 16 17 18 \n"
"3 18 17 11 \n"
"3 11 17 9 \n"
"3 9 17 19 \n"
"3 19 17 20 \n"
"3 19 20 21 \n"
"3 21 20 22 \n"
"3 22 20 23 \n"
"3 23 20 24 \n"
"3 24 20 25 \n"
"3 22 26 21 \n"
"3 26 22 27 \n"
"3 26 27 28 \n"
"3 26 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 33 34 35 \n"
"3 34 33 36 \n"
"3 34 36 37 \n"
"3 37 36 38 \n"
"3 38 36 39 \n"
"3 38 39 40 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 44 43 45 \n"
"3 44 45 40 \n"
"3 44 40 46 \n"
"3 46 40 39 \n"
"3 46 39 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 48 49 50 \n"
"3 50 49 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 52 53 54 \n"
"3 54 53 55 \n"
"3 55 53 56 \n"
"3 23 24 57 \n"
"3 23 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 58 60 61 \n"
"3 58 61 62 \n"
"3 62 61 42 \n"
"3 62 42 41 \n"
"3 62 41 63 \n"
"3 63 41 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 66 64 67 \n"
"3 66 67 68 \n"
"3 68 67 69 \n"
"3 68 69 70 \n"
"3 68 70 71 \n"
"3 71 70 72 \n"
"3 72 70 73 \n"
"3 72 73 74 \n"
"3 74 73 75 \n"
"3 74 75 76 \n"
"3 74 76 77 \n"
"3 77 76 78 \n"
"3 77 78 79 \n"
"3 79 78 80 \n"
"3 79 80 81 \n"
"3 81 80 82 \n"
;

char *VTK_VECTOR_TEXT_l = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 30 float\n"
"0.000000 1.020020 0.000000 1.239990 0.040009 0.000000 \n"
"0.000000 0.000000 0.000000 1.340000 1.170010 0.000000 \n"
"2.170010 1.620000 0.000000 2.750000 3.890010 0.000000 \n"
"2.750000 5.179990 0.000000 2.750000 26.209999 0.000000 \n"
"3.209990 0.100006 0.000000 2.609990 2.500000 0.000000 \n"
"0.000000 29.889999 0.000000 0.139984 28.780001 0.000000 \n"
"0.000000 28.780001 0.000000 1.510010 28.700001 0.000000 \n"
"2.299990 28.350000 0.000000 3.350010 30.420000 0.000000 \n"
"2.660000 27.570000 0.000000 4.870000 0.130005 0.000000 \n"
"5.079990 30.910000 0.000000 6.540010 0.100006 0.000000 \n"
"7.130000 4.510010 0.000000 7.130000 31.620001 0.000000 \n"
"7.160000 3.580020 0.000000 7.239990 2.830020 0.000000 \n"
"7.639980 1.800020 0.000000 8.420010 1.250000 0.000000 \n"
"8.510010 0.040009 0.000000 9.000000 0.040009 0.000000 \n"
"9.700010 0.000000 0.000000 9.700010 1.020020 0.000000 \n"

"POLYGONS 28 112\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 5 6 7 \n"
"3 5 7 8 \n"
"3 5 8 9 \n"
"3 9 8 4 \n"
"3 4 8 1 \n"
"3 10 11 12 \n"
"3 11 10 13 \n"
"3 13 10 14 \n"
"3 14 10 15 \n"
"3 14 15 16 \n"
"3 16 15 7 \n"
"3 7 15 8 \n"
"3 8 15 17 \n"
"3 17 15 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 20 18 21 \n"
"3 19 20 22 \n"
"3 19 22 23 \n"
"3 19 23 24 \n"
"3 19 24 25 \n"
"3 19 25 26 \n"
"3 26 25 27 \n"
"3 27 25 28 \n"
"3 28 25 29 \n"
;

char *VTK_VECTOR_TEXT_m = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 118 float\n"
"0.000000 0.000000 0.000000 0.000000 1.060000 0.000000 \n"
"1.130000 1.149990 0.000000 1.240020 0.040009 0.000000 \n"
"1.860020 1.480010 0.000000 2.250000 2.090000 0.000000 \n"
"2.390010 3.050020 0.000000 2.390010 3.810000 0.000000 \n"
"2.390010 13.150000 0.000000 3.130000 0.100006 0.000000 \n"
"0.089996 16.559999 0.000000 0.660004 15.510000 0.000000 \n"
"0.089996 15.450000 0.000000 0.970001 15.540000 0.000000 \n"
"1.720000 15.460000 0.000000 2.340000 14.380000 0.000000 \n"
"3.390010 17.610001 0.000000 2.149990 15.110000 0.000000 \n"
"4.690000 0.130005 0.000000 5.050020 18.299999 0.000000 \n"
"6.250000 0.100006 0.000000 6.950010 15.630000 0.000000 \n"
"7.000000 19.219999 0.000000 7.000000 3.320010 0.000000 \n"
"7.110020 2.260010 0.000000 7.450010 1.610020 0.000000 \n"
"8.140010 1.239990 0.000000 8.149990 0.040009 0.000000 \n"
"9.300020 0.000000 0.000000 9.300020 1.060000 0.000000 \n"
"11.780000 0.000000 0.000000 11.780000 1.060000 0.000000 \n"
"12.960000 1.220000 0.000000 12.990000 0.050018 0.000000 \n"
"13.660000 1.660000 0.000000 14.000000 0.080017 0.000000 \n"
"14.000000 2.550020 0.000000 14.080000 4.030000 0.000000 \n"
"15.070000 0.080017 0.000000 14.080000 12.620000 0.000000 \n"
"7.000000 4.470000 0.000000 7.000000 14.390000 0.000000 \n"
"7.480010 15.990000 0.000000 8.360020 15.230000 0.000000 \n"
"8.670010 16.790001 0.000000 9.460020 15.770000 0.000000 \n"
"9.660000 17.440001 0.000000 10.400000 16.070000 0.000000 \n"
"11.240000 18.299999 0.000000 11.290000 16.160000 0.000000 \n"
"12.510000 15.950000 0.000000 12.550000 18.709999 0.000000 \n"
"13.390000 15.290000 0.000000 13.910000 18.820000 0.000000 \n"
"13.910000 14.180000 0.000000 15.530000 18.629999 0.000000 \n"
"16.430000 0.089996 0.000000 16.830000 18.040001 0.000000 \n"
"17.790001 0.080017 0.000000 17.830000 17.040001 0.000000 \n"
"18.559999 15.630000 0.000000 18.780001 3.630000 0.000000 \n"
"18.840000 2.360020 0.000000 18.860001 0.080017 0.000000 \n"
"19.150000 1.610020 0.000000 19.840000 1.239990 0.000000 \n"
"19.870001 0.050018 0.000000 21.080000 0.000000 0.000000 \n"
"21.080000 1.060000 0.000000 18.780001 14.350000 0.000000 \n"
"20.049999 15.200000 0.000000 20.549999 17.059999 0.000000 \n"
"21.170000 15.770000 0.000000 22.209999 16.100000 0.000000 \n"
"22.340000 18.030001 0.000000 23.209999 16.209999 0.000000 \n"
"23.980000 18.590000 0.000000 24.490000 16.000000 0.000000 \n"
"25.340000 15.320000 0.000000 25.549999 18.770000 0.000000 \n"
"25.809999 14.080000 0.000000 25.920000 13.210000 0.000000 \n"
"26.900000 18.680000 0.000000 25.950001 12.180000 0.000000 \n"
"30.549999 14.810000 0.000000 30.740000 3.980010 0.000000 \n"
"30.740000 3.850010 0.000000 30.740000 4.330020 0.000000 \n"
"30.740000 4.880000 0.000000 30.740000 5.670010 0.000000 \n"
"30.760000 13.230000 0.000000 30.780001 7.700010 0.000000 \n"
"30.820000 9.390010 0.000000 30.820000 10.030000 0.000000 \n"
"30.820000 11.330000 0.000000 23.650000 0.000000 0.000000 \n"
"23.650000 1.060000 0.000000 24.850000 1.170010 0.000000 \n"
"24.889999 0.029999 0.000000 25.549999 1.610020 0.000000 \n"
"25.920000 0.059998 0.000000 25.870001 2.550020 0.000000 \n"
"25.930000 3.260010 0.000000 25.950001 4.160000 0.000000 \n"
"27.000000 0.080017 0.000000 28.020000 18.389999 0.000000 \n"
"28.389999 0.089996 0.000000 28.930000 17.870001 0.000000 \n"
"29.650000 17.110001 0.000000 29.780001 0.080017 0.000000 \n"
"30.180000 16.100000 0.000000 30.830000 2.470000 0.000000 \n"
"30.860001 0.059998 0.000000 31.200001 1.620000 0.000000 \n"
"31.889999 0.029999 0.000000 31.930000 1.200010 0.000000 \n"
"33.130001 0.000000 0.000000 33.130001 1.060000 0.000000 \n"

"POLYGONS 116 464\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 6 7 8 \n"
"3 6 8 9 \n"
"3 6 9 5 \n"
"3 5 9 3 \n"
"3 10 11 12 \n"
"3 11 10 13 \n"
"3 13 10 14 \n"
"3 15 9 8 \n"
"3 9 15 16 \n"
"3 16 15 17 \n"
"3 16 17 14 \n"
"3 16 14 10 \n"
"3 16 18 9 \n"
"3 18 16 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 21 19 22 \n"
"3 20 21 23 \n"
"3 20 23 24 \n"
"3 20 24 25 \n"
"3 20 25 26 \n"
"3 20 26 27 \n"
"3 27 26 28 \n"
"3 28 26 29 \n"
"3 30 31 32 \n"
"3 30 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 38 37 39 \n"
"3 21 40 23 \n"
"3 40 21 41 \n"
"3 41 21 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 50 48 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 52 53 54 \n"
"3 54 53 39 \n"
"3 39 53 38 \n"
"3 38 53 55 \n"
"3 38 55 56 \n"
"3 56 55 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 58 60 61 \n"
"3 58 61 62 \n"
"3 58 62 63 \n"
"3 63 62 64 \n"
"3 63 64 65 \n"
"3 63 65 66 \n"
"3 66 65 67 \n"
"3 67 65 68 \n"
"3 60 69 61 \n"
"3 69 60 70 \n"
"3 70 60 71 \n"
"3 70 71 72 \n"
"3 72 71 73 \n"
"3 73 71 74 \n"
"3 73 74 75 \n"
"3 75 74 76 \n"
"3 75 76 77 \n"
"3 77 76 78 \n"
"3 78 76 79 \n"
"3 78 79 80 \n"
"3 80 79 81 \n"
"3 81 79 82 \n"
"3 81 82 83 \n"
"3 84 85 86 \n"
"3 85 84 87 \n"
"3 87 84 88 \n"
"3 88 84 89 \n"
"3 89 84 90 \n"
"3 89 90 91 \n"
"3 91 90 92 \n"
"3 92 90 93 \n"
"3 93 90 94 \n"
"3 95 96 97 \n"
"3 95 97 98 \n"
"3 98 97 99 \n"
"3 98 99 100 \n"
"3 100 99 101 \n"
"3 100 101 102 \n"
"3 100 102 103 \n"
"3 100 103 82 \n"
"3 82 103 83 \n"
"3 82 104 100 \n"
"3 104 82 105 \n"
"3 104 105 106 \n"
"3 106 105 107 \n"
"3 106 107 108 \n"
"3 106 108 109 \n"
"3 109 108 110 \n"
"3 109 110 84 \n"
"3 109 84 86 \n"
"3 109 86 111 \n"
"3 109 111 112 \n"
"3 112 111 113 \n"
"3 112 113 114 \n"
"3 114 113 115 \n"
"3 114 115 116 \n"
"3 116 115 117 \n"
;

char *VTK_VECTOR_TEXT_n = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 82 float\n"
"0.000000 16.559999 0.000000 0.559998 15.400000 0.000000 \n"
"0.000000 15.360000 0.000000 0.879974 15.410000 0.000000 \n"
"1.560000 17.000000 0.000000 1.629970 15.300000 0.000000 \n"
"2.099980 14.940000 0.000000 2.359990 14.250000 0.000000 \n"
"2.889980 17.450001 0.000000 2.429990 13.150000 0.000000 \n"
"0.000000 1.060000 0.000000 1.190000 0.040009 0.000000 \n"
"0.000000 0.000000 0.000000 1.289980 1.190000 0.000000 \n"
"2.030000 1.640010 0.000000 2.429990 4.380000 0.000000 \n"
"2.419980 3.399990 0.000000 3.090000 0.100006 0.000000 \n"
"2.359990 2.640010 0.000000 2.229980 2.060000 0.000000 \n"
"4.289980 18.049999 0.000000 4.780000 0.130005 0.000000 \n"
"6.109990 18.910000 0.000000 6.449980 0.100006 0.000000 \n"
"6.819980 3.810000 0.000000 6.819980 14.120000 0.000000 \n"
"6.819980 15.360000 0.000000 6.819980 19.219999 0.000000 \n"
"6.929990 2.459990 0.000000 7.349980 1.640010 0.000000 \n"
"8.199980 1.209990 0.000000 8.410000 0.040009 0.000000 \n"
"8.910000 0.040009 0.000000 9.609990 0.000000 0.000000 \n"
"9.609990 1.060000 0.000000 12.040000 0.000000 0.000000 \n"
"12.040000 1.060000 0.000000 13.190000 1.190000 0.000000 \n"
"13.280000 0.040009 0.000000 13.950000 1.640010 0.000000 \n"
"14.370000 2.440000 0.000000 14.520000 3.670010 0.000000 \n"
"14.520000 4.600010 0.000000 14.520000 11.690000 0.000000 \n"
"15.400000 0.080017 0.000000 19.250000 12.890000 0.000000 \n"
"19.260000 4.989990 0.000000 19.260000 4.340000 0.000000 \n"
"19.260000 6.239990 0.000000 19.309999 8.320010 0.000000 \n"
"19.309999 9.350010 0.000000 19.309999 9.989990 0.000000 \n"
"19.309999 10.800000 0.000000 7.949980 14.980000 0.000000 \n"
"8.910000 16.900000 0.000000 9.049990 15.580000 0.000000 \n"
"10.160000 15.920000 0.000000 10.830000 17.990000 0.000000 \n"
"11.290000 16.030001 0.000000 12.590000 18.650000 0.000000 \n"
"12.790000 15.800000 0.000000 13.340000 15.500000 0.000000 \n"
"13.790000 15.050000 0.000000 14.120000 14.460000 0.000000 \n"
"14.210000 18.860001 0.000000 14.350000 13.710000 0.000000 \n"
"14.480000 12.790000 0.000000 15.540000 18.770000 0.000000 \n"
"16.629999 18.459999 0.000000 16.910000 0.089996 0.000000 \n"
"17.520000 17.910000 0.000000 18.200001 17.110001 0.000000 \n"
"18.469999 0.080017 0.000000 18.709999 16.020000 0.000000 \n"
"19.049999 14.620000 0.000000 19.309999 3.100010 0.000000 \n"
"19.440001 2.100010 0.000000 19.820000 1.500000 0.000000 \n"
"20.570000 1.179990 0.000000 20.590000 0.040009 0.000000 \n"
"21.830000 0.000000 0.000000 21.830000 1.060000 0.000000 \n"

"POLYGONS 80 320\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 7 4 8 \n"
"3 7 8 9 \n"
"3 10 11 12 \n"
"3 11 10 13 \n"
"3 11 13 14 \n"
"3 15 9 8 \n"
"3 15 8 16 \n"
"3 16 8 17 \n"
"3 16 17 18 \n"
"3 18 17 19 \n"
"3 19 17 14 \n"
"3 14 17 11 \n"
"3 17 8 20 \n"
"3 17 20 21 \n"
"3 21 20 22 \n"
"3 21 22 23 \n"
"3 23 22 24 \n"
"3 24 22 25 \n"
"3 25 22 26 \n"
"3 26 22 27 \n"
"3 23 24 28 \n"
"3 23 28 29 \n"
"3 23 29 30 \n"
"3 23 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 33 30 34 \n"
"3 35 36 37 \n"
"3 35 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 41 44 40 \n"
"3 40 44 38 \n"
"3 45 46 47 \n"
"3 46 45 48 \n"
"3 48 45 49 \n"
"3 49 45 50 \n"
"3 50 45 51 \n"
"3 51 45 52 \n"
"3 26 53 25 \n"
"3 53 26 54 \n"
"3 53 54 55 \n"
"3 55 54 56 \n"
"3 56 54 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 61 59 62 \n"
"3 62 59 63 \n"
"3 63 59 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 66 64 44 \n"
"3 66 44 43 \n"
"3 44 64 67 \n"
"3 44 67 68 \n"
"3 44 68 69 \n"
"3 69 68 70 \n"
"3 69 70 71 \n"
"3 69 71 72 \n"
"3 72 71 73 \n"
"3 72 73 74 \n"
"3 72 74 45 \n"
"3 72 45 47 \n"
"3 72 47 75 \n"
"3 72 75 76 \n"
"3 72 76 77 \n"
"3 72 77 78 \n"
"3 72 78 79 \n"
"3 79 78 80 \n"
"3 80 78 81 \n"
;

char *VTK_VECTOR_TEXT_o = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 65 float\n"
"4.060000 18.020000 0.000000 4.850010 14.210000 0.000000 \n"
"4.790010 13.060000 0.000000 5.050020 15.220000 0.000000 \n"
"5.360020 16.090000 0.000000 5.680020 18.889999 0.000000 \n"
"5.800020 16.820000 0.000000 6.350010 17.389999 0.000000 \n"
"7.010010 17.809999 0.000000 7.520020 19.430000 0.000000 \n"
"7.770020 18.070000 0.000000 8.640010 18.150000 0.000000 \n"
"9.530000 19.610001 0.000000 9.830020 17.930000 0.000000 \n"
"10.940000 17.280001 0.000000 11.550000 19.420000 0.000000 \n"
"11.940000 16.250000 0.000000 12.810000 14.890000 0.000000 \n"
"13.420000 18.850000 0.000000 13.530000 13.230000 0.000000 \n"
"14.070000 11.310000 0.000000 14.410000 9.190000 0.000000 \n"
"15.100000 17.940001 0.000000 14.530000 6.899990 0.000000 \n"
"0.180023 7.640010 0.000000 0.000000 9.739990 0.000000 \n"
"0.180023 11.830000 0.000000 0.680023 5.750000 0.000000 \n"
"0.710022 13.730000 0.000000 1.490020 4.090000 0.000000 \n"
"1.550020 15.410000 0.000000 2.590000 2.679990 0.000000 \n"
"2.670010 16.850000 0.000000 3.950010 1.540010 0.000000 \n"
"4.830020 12.800000 0.000000 5.000000 10.360000 0.000000 \n"
"5.370000 8.170010 0.000000 5.550020 0.700012 0.000000 \n"
"5.920010 6.239990 0.000000 6.640010 4.610020 0.000000 \n"
"7.370000 0.179993 0.000000 7.510010 3.290010 0.000000 \n"
"8.520020 2.310000 0.000000 9.390010 0.000000 0.000000 \n"
"9.649990 1.709990 0.000000 10.900000 1.500000 0.000000 \n"
"11.510000 0.179993 0.000000 11.750000 1.580020 0.000000 \n"
"12.490000 1.830020 0.000000 13.120000 2.250000 0.000000 \n"
"13.440000 0.700012 0.000000 13.630000 2.840000 0.000000 \n"
"14.020000 3.600010 0.000000 14.310000 4.530000 0.000000 \n"
"14.470000 5.630000 0.000000 15.150000 1.540010 0.000000 \n"
"16.559999 16.740000 0.000000 16.610001 2.679990 0.000000 \n"
"17.750000 15.260000 0.000000 17.790001 4.070010 0.000000 \n"
"18.639999 13.560000 0.000000 18.670000 5.709990 0.000000 \n"
"19.209999 11.660000 0.000000 19.209999 7.560000 0.000000 \n"
"19.400000 9.610020 0.000000 \n"
"POLYGONS 65 260\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 4 0 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 7 5 8 \n"
"3 8 5 9 \n"
"3 8 9 10 \n"
"3 10 9 11 \n"
"3 11 9 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 14 12 15 \n"
"3 14 15 16 \n"
"3 16 15 17 \n"
"3 17 15 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 20 18 21 \n"
"3 21 18 22 \n"
"3 21 22 23 \n"
"3 24 25 26 \n"
"3 24 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 33 32 0 \n"
"3 33 0 2 \n"
"3 33 2 34 \n"
"3 33 34 35 \n"
"3 33 35 36 \n"
"3 33 36 37 \n"
"3 37 36 38 \n"
"3 37 38 39 \n"
"3 37 39 40 \n"
"3 40 39 41 \n"
"3 40 41 42 \n"
"3 40 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 43 45 46 \n"
"3 46 45 47 \n"
"3 46 47 48 \n"
"3 46 48 49 \n"
"3 46 49 50 \n"
"3 50 49 51 \n"
"3 50 51 52 \n"
"3 50 52 53 \n"
"3 54 23 22 \n"
"3 54 22 55 \n"
"3 54 55 53 \n"
"3 53 55 50 \n"
"3 55 22 56 \n"
"3 55 56 57 \n"
"3 57 56 58 \n"
"3 57 58 59 \n"
"3 59 58 60 \n"
"3 59 60 61 \n"
"3 61 60 62 \n"
"3 61 62 63 \n"
"3 63 62 64 \n"
;

char *VTK_VECTOR_TEXT_p = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 79 float\n"
"0.000000 0.979980 0.000000 1.320010 0.049988 0.000000 \n"
"0.000000 0.000000 0.000000 1.359990 1.130000 0.000000 \n"
"2.149960 1.560000 0.000000 2.419980 0.079987 0.000000 \n"
"2.519960 2.410000 0.000000 2.609990 3.810000 0.000000 \n"
"3.560000 0.089996 0.000000 2.609990 21.750000 0.000000 \n"
"0.000000 25.020000 0.000000 1.109990 24.090000 0.000000 \n"
"0.000000 23.959999 0.000000 1.870000 23.990000 0.000000 \n"
"2.149960 25.670000 0.000000 2.320010 23.629999 0.000000 \n"
"2.549990 22.920000 0.000000 3.899960 26.290001 0.000000 \n"
"5.000000 0.089996 0.000000 5.500000 26.969999 0.000000 \n"
"6.509950 0.089996 0.000000 7.169980 4.209990 0.000000 \n"
"7.169980 8.500000 0.000000 7.169980 10.670000 0.000000 \n"
"7.169980 24.010000 0.000000 7.169980 25.200001 0.000000 \n"
"7.169980 27.809999 0.000000 7.199950 3.340000 0.000000 \n"
"7.279970 2.649990 0.000000 7.699950 0.079987 0.000000 \n"
"7.719970 1.709990 0.000000 8.649960 1.209990 0.000000 \n"
"8.849980 0.049988 0.000000 9.349980 1.069980 0.000000 \n"
"10.230000 0.000000 0.000000 10.230000 0.979980 0.000000 \n"
"8.219970 9.970000 0.000000 9.190000 9.479980 0.000000 \n"
"9.310000 8.009980 0.000000 10.130000 9.209990 0.000000 \n"
"11.070000 9.120000 0.000000 11.200000 7.880000 0.000000 \n"
"12.230000 9.250000 0.000000 13.270000 9.609990 0.000000 \n"
"13.270000 8.090000 0.000000 14.190000 10.200000 0.000000 \n"
"14.960000 10.990000 0.000000 15.180000 8.669980 0.000000 \n"
"15.590000 11.980000 0.000000 16.049999 13.140000 0.000000 \n"
"16.330000 14.470000 0.000000 16.879999 9.600010 0.000000 \n"
"16.430000 15.940000 0.000000 8.060000 24.490000 0.000000 \n"
"8.839970 24.820000 0.000000 8.909970 26.230000 0.000000 \n"
"10.320000 25.070000 0.000000 10.370000 26.900000 0.000000 \n"
"11.570000 24.889999 0.000000 11.700000 27.260000 0.000000 \n"
"12.730000 24.360001 0.000000 13.060000 27.370001 0.000000 \n"
"13.770000 23.540001 0.000000 14.670000 22.430000 0.000000 \n"
"14.759900 27.190001 0.000000 15.410000 21.090000 0.000000 \n"
"15.960000 19.540001 0.000000 16.309999 17.809999 0.000000 \n"
"16.320000 26.680000 0.000000 17.700001 25.860001 0.000000 \n"
"18.350000 10.840000 0.000000 18.900000 24.760000 0.000000 \n"
"19.549999 12.350000 0.000000 19.870001 23.420000 0.000000 \n"
"20.450001 14.110000 0.000000 20.600000 21.860001 0.000000 \n"
"21.020000 16.070000 0.000000 21.059999 20.110001 0.000000 \n"
"21.209999 18.200001 0.000000 \n"
"POLYGONS 79 316\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 5 7 8 \n"
"3 8 7 9 \n"
"3 10 11 12 \n"
"3 11 10 13 \n"
"3 13 10 14 \n"
"3 13 14 15 \n"
"3 15 14 16 \n"
"3 16 14 17 \n"
"3 16 17 9 \n"
"3 9 17 8 \n"
"3 8 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 21 19 22 \n"
"3 22 19 23 \n"
"3 23 19 24 \n"
"3 24 19 25 \n"
"3 25 19 26 \n"
"3 20 21 27 \n"
"3 20 27 28 \n"
"3 20 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 29 31 32 \n"
"3 32 31 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 22 23 36 \n"
"3 22 36 37 \n"
"3 22 37 38 \n"
"3 38 37 39 \n"
"3 38 39 40 \n"
"3 38 40 41 \n"
"3 41 40 42 \n"
"3 41 42 43 \n"
"3 41 43 44 \n"
"3 44 43 45 \n"
"3 44 45 46 \n"
"3 44 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 47 49 50 \n"
"3 47 50 51 \n"
"3 51 50 52 \n"
"3 25 53 24 \n"
"3 53 25 54 \n"
"3 54 25 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
"3 63 61 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 66 64 67 \n"
"3 67 64 68 \n"
"3 67 68 52 \n"
"3 52 68 51 \n"
"3 51 68 69 \n"
"3 51 69 70 \n"
"3 70 69 71 \n"
"3 70 71 72 \n"
"3 72 71 73 \n"
"3 72 73 74 \n"
"3 74 73 75 \n"
"3 74 75 76 \n"
"3 76 75 77 \n"
"3 76 77 78 \n"
;

char *VTK_VECTOR_TEXT_q = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 71 float\n"
"0.179993 15.810000 0.000000 0.000000 17.670000 0.000000 \n"
"0.179993 19.610001 0.000000 0.669983 14.080000 0.000000 \n"
"0.690002 21.410000 0.000000 1.460020 12.520000 0.000000 \n"
"1.489990 23.030001 0.000000 2.500000 11.160000 0.000000 \n"
"2.560000 24.450001 0.000000 3.760010 10.030000 0.000000 \n"
"3.859990 25.610001 0.000000 4.960020 19.620001 0.000000 \n"
"5.090030 17.790001 0.000000 5.220030 9.179990 0.000000 \n"
"5.429990 16.100000 0.000000 5.979980 14.560000 0.000000 \n"
"6.700010 13.230000 0.000000 6.820010 8.649990 0.000000 \n"
"7.580020 12.130000 0.000000 8.549990 8.459990 0.000000 \n"
"8.590030 11.290000 0.000000 9.700010 10.770000 0.000000 \n"
"9.820010 8.549990 0.000000 10.900000 10.590000 0.000000 \n"
"11.040000 8.840000 0.000000 12.290000 10.830000 0.000000 \n"
"12.290000 9.380000 0.000000 13.690000 10.190000 0.000000 \n"
"13.690000 11.600000 0.000000 10.940000 1.019990 0.000000 \n"
"12.240000 0.029999 0.000000 10.940000 0.000000 0.000000 \n"
"12.330000 1.250000 0.000000 13.160000 1.850010 0.000000 \n"
"13.330000 0.059998 0.000000 13.410000 2.350010 0.000000 \n"
"13.580000 3.000000 0.000000 13.660000 3.840000 0.000000 \n"
"13.690000 4.870000 0.000000 13.690000 24.090000 0.000000 \n"
"14.470000 0.079987 0.000000 5.039980 20.980000 0.000000 \n"
"5.280030 22.209999 0.000000 5.349980 26.490000 0.000000 \n"
"5.659970 23.280001 0.000000 6.179990 24.190001 0.000000 \n"
"6.810000 24.920000 0.000000 7.000000 27.040001 0.000000 \n"
"7.560000 25.459999 0.000000 8.409970 25.790001 0.000000 \n"
"8.770020 27.240000 0.000000 9.349980 25.910000 0.000000 \n"
"10.130000 27.150000 0.000000 10.290000 25.820000 0.000000 \n"
"11.270000 25.520000 0.000000 11.500000 26.850000 0.000000 \n"
"12.370000 24.959999 0.000000 13.030000 26.290001 0.000000 \n"
"14.880000 25.420000 0.000000 15.950000 0.089996 0.000000 \n"
"17.420000 0.079987 0.000000 18.250000 4.209990 0.000000 \n"
"18.250000 5.399990 0.000000 18.250000 27.059999 0.000000 \n"
"18.389999 2.789980 0.000000 18.570000 0.059998 0.000000 \n"
"18.820000 1.870000 0.000000 19.639999 1.310000 0.000000 \n"
"19.650000 0.029999 0.000000 20.950001 0.000000 0.000000 \n"
"20.950001 1.019990 0.000000 \n"
"POLYGONS 71 284\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 9 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 13 15 16 \n"
"3 13 16 17 \n"
"3 17 16 18 \n"
"3 17 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 19 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 27 25 28 \n"
"3 29 30 31 \n"
"3 30 29 32 \n"
"3 30 32 33 \n"
"3 30 33 34 \n"
"3 34 33 35 \n"
"3 34 35 36 \n"
"3 34 36 37 \n"
"3 38 27 28 \n"
"3 38 28 39 \n"
"3 38 39 40 \n"
"3 38 40 37 \n"
"3 37 40 34 \n"
"3 10 41 11 \n"
"3 41 10 42 \n"
"3 42 10 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 45 43 46 \n"
"3 46 43 47 \n"
"3 46 47 48 \n"
"3 48 47 49 \n"
"3 49 47 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 51 52 53 \n"
"3 53 52 54 \n"
"3 54 52 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 56 57 39 \n"
"3 39 57 58 \n"
"3 39 58 40 \n"
"3 40 58 59 \n"
"3 59 58 60 \n"
"3 60 58 61 \n"
"3 61 58 62 \n"
"3 62 58 63 \n"
"3 60 61 64 \n"
"3 60 64 65 \n"
"3 65 64 66 \n"
"3 65 66 67 \n"
"3 65 67 68 \n"
"3 68 67 69 \n"
"3 69 67 70 \n"
;

char *VTK_VECTOR_TEXT_r = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 49 float\n"
"0.000000 16.690001 0.000000 0.609985 15.600000 0.000000 \n"
"0.000000 15.500000 0.000000 1.060000 15.630000 0.000000 \n"
"1.459960 17.040001 0.000000 1.739990 15.530000 0.000000 \n"
"2.159970 15.180000 0.000000 3.029970 17.530001 0.000000 \n"
"2.370000 14.470000 0.000000 2.429990 13.330000 0.000000 \n"
"0.000000 1.060000 0.000000 1.149960 0.040009 0.000000 \n"
"0.000000 0.000000 0.000000 1.229980 1.260010 0.000000 \n"
"1.979980 1.780000 0.000000 2.429990 4.429990 0.000000 \n"
"2.409970 3.510010 0.000000 3.039980 0.100006 0.000000 \n"
"2.339970 2.780000 0.000000 4.729980 0.130005 0.000000 \n"
"4.880000 18.230000 0.000000 6.339970 0.100006 0.000000 \n"
"6.989990 4.649990 0.000000 6.989990 12.090000 0.000000 \n"
"6.989990 13.810000 0.000000 7.169980 19.170000 0.000000 \n"
"7.039980 3.670010 0.000000 7.120000 2.459990 0.000000 \n"
"7.450010 1.720000 0.000000 8.179990 1.300020 0.000000 \n"
"8.279970 0.040009 0.000000 9.429990 0.000000 0.000000 \n"
"9.429990 1.060000 0.000000 7.719970 15.090000 0.000000 \n"
"7.890010 13.160000 0.000000 8.440000 16.150000 0.000000 \n"
"8.890010 13.970000 0.000000 9.169980 17.030001 0.000000 \n"
"9.919980 17.719999 0.000000 9.929990 14.480000 0.000000 \n"
"10.980000 14.660000 0.000000 11.540000 18.590000 0.000000 \n"
"11.770000 14.550000 0.000000 12.360000 14.230000 0.000000 \n"
"12.790000 13.670000 0.000000 13.100000 12.840000 0.000000 \n"
"13.410000 18.860001 0.000000 14.210000 12.840000 0.000000 \n"
"14.210000 18.820000 0.000000 \n"
"POLYGONS 47 188\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 10 11 12 \n"
"3 11 10 13 \n"
"3 11 13 14 \n"
"3 15 9 7 \n"
"3 15 7 16 \n"
"3 16 7 17 \n"
"3 16 17 18 \n"
"3 18 17 14 \n"
"3 14 17 11 \n"
"3 7 19 17 \n"
"3 19 7 20 \n"
"3 19 20 21 \n"
"3 21 20 22 \n"
"3 22 20 23 \n"
"3 23 20 24 \n"
"3 24 20 25 \n"
"3 21 22 26 \n"
"3 21 26 27 \n"
"3 21 27 28 \n"
"3 21 28 29 \n"
"3 21 29 30 \n"
"3 30 29 31 \n"
"3 31 29 32 \n"
"3 23 24 33 \n"
"3 23 33 34 \n"
"3 34 33 35 \n"
"3 34 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 40 41 42 \n"
"3 42 41 43 \n"
"3 43 41 44 \n"
"3 44 41 45 \n"
"3 45 41 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
;

char *VTK_VECTOR_TEXT_s = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 65 float\n"
"0.130005 15.190000 0.000000 0.270020 12.130000 0.000000 \n"
"0.000000 13.950000 0.000000 0.500000 16.309999 0.000000 \n"
"1.109990 17.280001 0.000000 1.140010 10.580000 0.000000 \n"
"1.840030 9.850010 0.000000 1.940000 18.090000 0.000000 \n"
"2.729980 9.140010 0.000000 2.979980 18.740000 0.000000 \n"
"3.760010 15.850000 0.000000 3.820010 8.429990 0.000000 \n"
"3.910030 15.000000 0.000000 4.440000 14.240000 0.000000 \n"
"5.140010 7.700010 0.000000 5.450010 13.450000 0.000000 \n"
"6.950010 6.769990 0.000000 7.039980 12.530000 0.000000 \n"
"8.229980 6.050020 0.000000 8.770020 11.600000 0.000000 \n"
"9.039980 5.380000 0.000000 9.479980 4.679990 0.000000 \n"
"9.609990 3.890010 0.000000 10.150000 10.780000 0.000000 \n"
"4.000000 16.770000 0.000000 4.200010 19.219999 0.000000 \n"
"4.660030 17.530001 0.000000 5.609990 19.520000 0.000000 \n"
"5.609990 18.049999 0.000000 6.780030 18.240000 0.000000 \n"
"7.169980 19.610001 0.000000 8.410030 17.940001 0.000000 \n"
"9.650020 19.430000 0.000000 9.750000 17.090000 0.000000 \n"
"10.750000 15.740000 0.000000 11.340000 13.950000 0.000000 \n"
"12.360000 18.910000 0.000000 12.530000 13.990000 0.000000 \n"
"0.000000 1.190000 0.000000 0.090027 5.840000 0.000000 \n"
"1.419980 5.840000 0.000000 1.710020 4.739990 0.000000 \n"
"2.080020 3.800020 0.000000 2.539980 3.019990 0.000000 \n"
"3.090030 2.380000 0.000000 3.160030 0.300018 0.000000 \n"
"4.500000 1.550020 0.000000 6.109990 0.000000 0.000000 \n"
"6.330020 1.280000 0.000000 7.609990 0.110016 0.000000 \n"
"7.690000 1.459990 0.000000 8.720030 1.989990 0.000000 \n"
"8.970030 0.440002 0.000000 9.380000 2.810000 0.000000 \n"
"10.180000 0.959991 0.000000 11.220000 1.670010 0.000000 \n"
"11.230000 10.020000 0.000000 12.030000 9.300020 0.000000 \n"
"12.050000 2.550020 0.000000 12.590000 8.570010 0.000000 \n"
"12.680000 3.560000 0.000000 12.950000 7.800020 0.000000 \n"
"13.060000 4.709990 0.000000 13.140000 6.950010 0.000000 \n"
"13.200000 5.970000 0.000000 \n"
"POLYGONS 63 252\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 6 7 8 \n"
"3 8 7 9 \n"
"3 8 9 10 \n"
"3 8 10 11 \n"
"3 11 10 12 \n"
"3 11 12 13 \n"
"3 11 13 14 \n"
"3 14 13 15 \n"
"3 14 15 16 \n"
"3 16 15 17 \n"
"3 16 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 21 19 22 \n"
"3 22 19 23 \n"
"3 9 24 10 \n"
"3 24 9 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 29 27 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 31 32 33 \n"
"3 33 32 34 \n"
"3 34 32 35 \n"
"3 35 32 36 \n"
"3 35 36 37 \n"
"3 38 39 40 \n"
"3 38 40 41 \n"
"3 38 41 42 \n"
"3 38 42 43 \n"
"3 38 43 44 \n"
"3 38 44 45 \n"
"3 45 44 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 49 51 52 \n"
"3 52 51 53 \n"
"3 52 53 22 \n"
"3 52 22 54 \n"
"3 54 22 23 \n"
"3 54 23 55 \n"
"3 55 23 56 \n"
"3 55 56 57 \n"
"3 55 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
"3 62 63 64 \n"
;

char *VTK_VECTOR_TEXT_t = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 32 float\n"
"3.449950 17.450001 0.000000 3.510010 5.389980 0.000000 \n"
"3.449950 7.310000 0.000000 0.000000 17.450001 0.000000 \n"
"0.000000 18.379999 0.000000 2.070010 19.580000 0.000000 \n"
"3.719970 3.810000 0.000000 3.940000 21.000000 0.000000 \n"
"4.089970 2.540010 0.000000 4.639950 1.560000 0.000000 \n"
"5.389950 0.839996 0.000000 5.839970 22.840000 0.000000 \n"
"6.339970 0.359985 0.000000 6.880000 23.969999 0.000000 \n"
"7.539980 0.079987 0.000000 8.010010 6.470000 0.000000 \n"
"8.010010 17.450001 0.000000 8.010010 19.180000 0.000000 \n"
"8.010010 25.290001 0.000000 8.130000 4.810000 0.000000 \n"
"8.500000 3.720000 0.000000 8.989990 0.000000 0.000000 \n"
"9.159970 0.000000 0.000000 9.190000 3.109990 0.000000 \n"
"10.220000 2.919980 0.000000 10.870000 3.000000 0.000000 \n"
"11.490000 3.250000 0.000000 12.170000 3.729980 0.000000 \n"
"13.010000 4.470000 0.000000 13.770000 3.410000 0.000000 \n"
"13.010000 17.450001 0.000000 13.770000 19.180000 0.000000 \n"

"POLYGONS 30 120\n"
"3 0 1 2 \n"
"3 3 4 5 \n"
"3 3 5 0 \n"
"3 0 6 1 \n"
"3 6 0 7 \n"
"3 7 0 5 \n"
"3 7 8 6 \n"
"3 8 7 9 \n"
"3 9 7 10 \n"
"3 10 7 11 \n"
"3 10 11 12 \n"
"3 12 11 13 \n"
"3 12 13 14 \n"
"3 14 13 15 \n"
"3 15 13 16 \n"
"3 16 13 17 \n"
"3 17 13 18 \n"
"3 14 15 19 \n"
"3 14 19 20 \n"
"3 14 20 21 \n"
"3 21 20 22 \n"
"3 22 20 23 \n"
"3 22 23 24 \n"
"3 22 24 25 \n"
"3 22 25 26 \n"
"3 22 26 27 \n"
"3 22 27 28 \n"
"3 22 28 29 \n"
"3 17 30 16 \n"
"3 30 17 31 \n"
;

char *VTK_VECTOR_TEXT_u = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 64 float\n"
"2.389950 9.120000 0.000000 2.409970 7.290010 0.000000 \n"
"2.389950 8.769990 0.000000 2.439940 11.560000 0.000000 \n"
"2.449950 6.030000 0.000000 2.479980 13.730000 0.000000 \n"
"2.500000 4.989990 0.000000 2.479980 13.860000 0.000000 \n"
"7.310000 6.910000 0.000000 6.560000 18.820000 0.000000 \n"
"7.310000 19.090000 0.000000 0.000000 16.959999 0.000000 \n"
"0.309998 15.940000 0.000000 0.000000 15.940000 0.000000 \n"
"1.379940 15.860000 0.000000 2.039980 15.530000 0.000000 \n"
"2.569950 4.160000 0.000000 3.009950 17.629999 0.000000 \n"
"2.389950 14.900000 0.000000 3.099980 2.450010 0.000000 \n"
"4.179990 1.139980 0.000000 4.620000 18.129999 0.000000 \n"
"5.709960 0.290009 0.000000 7.349980 5.870000 0.000000 \n"
"7.489990 4.989990 0.000000 7.620000 0.000000 0.000000 \n"
"8.060000 3.669980 0.000000 9.049990 2.899990 0.000000 \n"
"9.189940 0.179993 0.000000 10.500000 2.660000 0.000000 \n"
"10.910000 0.730011 0.000000 11.439900 2.739990 0.000000 \n"
"12.379900 3.000000 0.000000 12.740000 1.639980 0.000000 \n"
"13.439900 3.480010 0.000000 14.660000 2.919980 0.000000 \n"
"14.700000 4.209990 0.000000 14.710000 2.000000 0.000000 \n"
"14.700000 13.770000 0.000000 12.090000 16.959999 0.000000 \n"
"12.540000 15.990000 0.000000 12.090000 15.940000 0.000000 \n"
"13.200000 16.030001 0.000000 13.800000 17.350000 0.000000 \n"
"13.939900 15.930000 0.000000 14.400000 15.570000 0.000000 \n"
"14.640000 14.870000 0.000000 14.810000 1.280000 0.000000 \n"
"15.189900 0.040009 0.000000 15.290000 17.740000 0.000000 \n"
"15.990000 0.350006 0.000000 16.759899 18.209999 0.000000 \n"
"17.709999 0.899994 0.000000 18.430000 18.820000 0.000000 \n"
"19.100000 1.299990 0.000000 19.219999 4.739990 0.000000 \n"
"19.219999 19.090000 0.000000 19.280001 3.750000 0.000000 \n"
"19.469999 3.070010 0.000000 19.799999 2.690000 0.000000 \n"
"20.290001 2.570010 0.000000 20.650000 2.600010 0.000000 \n"
"21.350000 2.790010 0.000000 21.480000 1.820010 0.000000 \n"

"POLYGONS 62 248\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 4 3 5 \n"
"3 4 5 6 \n"
"3 6 5 7 \n"
"3 8 9 10 \n"
"3 11 12 13 \n"
"3 12 11 14 \n"
"3 14 11 15 \n"
"3 7 16 6 \n"
"3 16 7 17 \n"
"3 17 7 18 \n"
"3 17 18 15 \n"
"3 17 15 11 \n"
"3 17 19 16 \n"
"3 19 17 20 \n"
"3 20 17 21 \n"
"3 20 21 22 \n"
"3 22 21 9 \n"
"3 22 9 8 \n"
"3 22 8 23 \n"
"3 22 23 24 \n"
"3 22 24 25 \n"
"3 25 24 26 \n"
"3 25 26 27 \n"
"3 25 27 28 \n"
"3 28 27 29 \n"
"3 28 29 30 \n"
"3 30 29 31 \n"
"3 30 31 32 \n"
"3 30 32 33 \n"
"3 33 32 34 \n"
"3 33 34 35 \n"
"3 35 34 36 \n"
"3 35 36 37 \n"
"3 37 36 38 \n"
"3 39 40 41 \n"
"3 40 39 42 \n"
"3 42 39 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 45 43 46 \n"
"3 38 47 37 \n"
"3 47 38 48 \n"
"3 48 38 49 \n"
"3 49 38 46 \n"
"3 49 46 43 \n"
"3 49 50 48 \n"
"3 50 49 51 \n"
"3 50 51 52 \n"
"3 52 51 53 \n"
"3 52 53 54 \n"
"3 54 53 55 \n"
"3 55 53 56 \n"
"3 54 55 57 \n"
"3 54 57 58 \n"
"3 54 58 59 \n"
"3 54 59 60 \n"
"3 54 60 61 \n"
"3 54 61 62 \n"
"3 54 62 63 \n"
;

char *VTK_VECTOR_TEXT_v = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 50 float\n"
"6.719970 19.160000 0.000000 8.079960 17.320000 0.000000 \n"
"7.969970 16.780001 0.000000 8.429990 17.719999 0.000000 \n"
"8.679990 19.219999 0.000000 9.039980 18.020000 0.000000 \n"
"9.919980 18.200001 0.000000 9.919980 19.260000 0.000000 \n"
"12.800000 19.260000 0.000000 13.930000 18.070000 0.000000 \n"
"12.800000 18.200001 0.000000 14.460000 19.190001 0.000000 \n"
"14.680000 17.790001 0.000000 15.100000 17.330000 0.000000 \n"
"15.270000 19.180000 0.000000 15.230000 16.650000 0.000000 \n"
"0.000000 18.200001 0.000000 0.000000 19.260000 0.000000 \n"
"0.719971 19.240000 0.000000 1.169980 17.879999 0.000000 \n"
"1.239990 19.219999 0.000000 2.019960 17.309999 0.000000 \n"
"2.750000 16.299999 0.000000 3.120000 15.570000 0.000000 \n"
"3.269960 19.160000 0.000000 3.539980 14.660000 0.000000 \n"
"4.959960 19.129999 0.000000 8.009950 16.370001 0.000000 \n"
"8.169980 15.820000 0.000000 8.489990 14.970000 0.000000 \n"
"9.029970 13.680000 0.000000 10.050000 0.000000 0.000000 \n"
"10.759900 0.000000 0.000000 12.000000 6.690000 0.000000 \n"
"12.430000 7.810000 0.000000 12.780000 8.739990 0.000000 \n"
"13.420000 10.630000 0.000000 14.530000 13.860000 0.000000 \n"
"14.860000 14.930000 0.000000 15.080000 15.690000 0.000000 \n"
"16.299999 19.170000 0.000000 16.610001 14.610000 0.000000 \n"
"17.020000 15.610000 0.000000 17.319901 19.180000 0.000000 \n"
"17.370001 16.379999 0.000000 18.000000 17.400000 0.000000 \n"
"18.129900 19.190001 0.000000 18.740000 17.930000 0.000000 \n"
"19.799999 18.200001 0.000000 19.799999 19.260000 0.000000 \n"

"POLYGONS 48 192\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 8 9 10 \n"
"3 9 8 11 \n"
"3 9 11 12 \n"
"3 12 11 13 \n"
"3 13 11 14 \n"
"3 13 14 15 \n"
"3 16 17 18 \n"
"3 16 18 19 \n"
"3 19 18 20 \n"
"3 19 20 21 \n"
"3 21 20 22 \n"
"3 22 20 23 \n"
"3 23 20 24 \n"
"3 23 24 25 \n"
"3 25 24 26 \n"
"3 25 26 0 \n"
"3 25 0 2 \n"
"3 25 2 27 \n"
"3 25 27 28 \n"
"3 25 28 29 \n"
"3 25 29 30 \n"
"3 25 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 32 33 34 \n"
"3 32 34 35 \n"
"3 32 35 36 \n"
"3 32 36 37 \n"
"3 32 37 38 \n"
"3 32 38 39 \n"
"3 32 39 40 \n"
"3 40 39 15 \n"
"3 40 15 14 \n"
"3 40 41 32 \n"
"3 41 40 42 \n"
"3 42 40 43 \n"
"3 42 43 44 \n"
"3 44 43 45 \n"
"3 45 43 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 48 46 49 \n"
;

char *VTK_VECTOR_TEXT_w = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 64 float\n"
"8.005000 19.240000 0.000000 8.167000 17.370001 0.000000 \n"
"8.016000 16.700001 0.000000 8.630000 17.850000 0.000000 \n"
"9.156000 19.260000 0.000000 9.417000 18.150000 0.000000 \n"
"10.540000 18.290001 0.000000 10.540000 19.309999 0.000000 \n"
"23.738001 18.250000 0.000000 23.738001 19.309999 0.000000 \n"
"24.771000 19.260000 0.000000 25.042999 18.150000 0.000000 \n"
"25.625999 19.240000 0.000000 25.841000 17.959999 0.000000 \n"
"26.240999 17.639999 0.000000 26.521999 19.230000 0.000000 \n"
"26.351000 17.139999 0.000000 0.000000 19.309999 0.000000 \n"
"1.229000 17.980000 0.000000 0.000000 18.290001 0.000000 \n"
"1.359000 19.260000 0.000000 2.159000 17.260000 0.000000 \n"
"2.502000 19.240000 0.000000 2.590000 16.660000 0.000000 \n"
"3.039000 15.850000 0.000000 3.539000 14.800000 0.000000 \n"
"3.712000 19.230000 0.000000 4.119000 13.470000 0.000000 \n"
"5.270000 19.219999 0.000000 6.804000 19.230000 0.000000 \n"
"8.116000 16.010000 0.000000 8.315000 15.470000 0.000000 \n"
"8.680000 14.620000 0.000000 9.832000 0.000000 0.000000 \n"
"10.319000 0.000000 0.000000 11.780000 7.130000 0.000000 \n"
"15.500000 12.670000 0.000000 16.872999 19.760000 0.000000 \n"
"17.448999 19.760000 0.000000 20.771000 0.000000 0.000000 \n"
"21.125000 0.000000 0.000000 22.808001 6.690000 0.000000 \n"
"23.073999 7.490020 0.000000 23.313999 8.100010 0.000000 \n"
"23.638000 8.960020 0.000000 24.045000 10.070000 0.000000 \n"
"24.535000 11.430000 0.000000 25.010000 12.780000 0.000000 \n"
"25.375999 13.850000 0.000000 25.643999 14.640000 0.000000 \n"
"25.819000 15.150000 0.000000 26.089001 15.990000 0.000000 \n"
"27.191999 14.270000 0.000000 26.250999 16.510000 0.000000 \n"
"27.679001 15.330000 0.000000 27.679001 19.219999 0.000000 \n"
"28.127001 16.180000 0.000000 28.837000 19.230000 0.000000 \n"
"29.025000 17.350000 0.000000 29.733000 19.240000 0.000000 \n"
"30.113001 17.980000 0.000000 30.587999 19.260000 0.000000 \n"
"31.621000 18.250000 0.000000 31.621000 19.309999 0.000000 \n"

"POLYGONS 62 248\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 3 0 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 6 4 7 \n"
"3 8 9 10 \n"
"3 8 10 11 \n"
"3 11 10 12 \n"
"3 11 12 13 \n"
"3 13 12 14 \n"
"3 14 12 15 \n"
"3 14 15 16 \n"
"3 17 18 19 \n"
"3 18 17 20 \n"
"3 18 20 21 \n"
"3 21 20 22 \n"
"3 21 22 23 \n"
"3 23 22 24 \n"
"3 24 22 25 \n"
"3 25 22 26 \n"
"3 25 26 27 \n"
"3 27 26 28 \n"
"3 27 28 29 \n"
"3 27 29 0 \n"
"3 27 0 2 \n"
"3 27 2 30 \n"
"3 27 30 31 \n"
"3 27 31 32 \n"
"3 27 32 33 \n"
"3 33 32 34 \n"
"3 34 32 35 \n"
"3 34 35 36 \n"
"3 36 35 37 \n"
"3 36 37 38 \n"
"3 36 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 40 41 42 \n"
"3 40 42 43 \n"
"3 40 43 44 \n"
"3 40 44 45 \n"
"3 40 45 46 \n"
"3 40 46 47 \n"
"3 40 47 48 \n"
"3 40 48 49 \n"
"3 40 49 50 \n"
"3 40 50 51 \n"
"3 40 51 52 \n"
"3 52 51 53 \n"
"3 52 53 16 \n"
"3 52 16 15 \n"
"3 52 15 54 \n"
"3 54 15 55 \n"
"3 54 55 56 \n"
"3 56 55 57 \n"
"3 56 57 58 \n"
"3 58 57 59 \n"
"3 58 59 60 \n"
"3 60 59 61 \n"
"3 60 61 62 \n"
"3 62 61 63 \n"
;

char *VTK_VECTOR_TEXT_x = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 116 float\n"
"0.000000 0.000000 0.000000 0.000000 1.100010 0.000000 \n"
"1.491000 1.360020 0.000000 1.915000 0.080017 0.000000 \n"
"2.762000 2.030000 0.000000 2.840000 0.080017 0.000000 \n"
"3.465000 2.640010 0.000000 4.030000 0.089996 0.000000 \n"
"4.291000 3.489990 0.000000 5.195000 0.080017 0.000000 \n"
"5.300990 4.630000 0.000000 5.713000 2.209990 0.000000 \n"
"5.824000 1.790010 0.000000 6.106000 0.080017 0.000000 \n"
"6.200000 1.489990 0.000000 6.909000 1.280000 0.000000 \n"
"8.016000 0.000000 0.000000 8.016000 1.100010 0.000000 \n"
"0.309998 18.549999 0.000000 1.550990 17.160000 0.000000 \n"
"0.309998 17.490000 0.000000 1.668000 18.530001 0.000000 \n"
"2.668000 16.459999 0.000000 2.807000 18.520000 0.000000 \n"
"3.835000 15.250000 0.000000 4.003000 18.510000 0.000000 \n"
"4.491000 14.400000 0.000000 5.226000 13.370000 0.000000 \n"
"5.536000 18.510000 0.000000 6.864000 11.110000 0.000000 \n"
"7.069000 18.510000 0.000000 7.509000 10.190000 0.000000 \n"
"7.933000 9.570010 0.000000 8.271000 18.520000 0.000000 \n"
"8.636000 8.500000 0.000000 8.990000 16.469999 0.000000 \n"
"9.087000 16.900000 0.000000 9.400000 17.200001 0.000000 \n"
"9.422000 18.530001 0.000000 9.962000 17.410000 0.000000 \n"
"10.806000 17.530001 0.000000 10.806000 18.549999 0.000000 \n"
"13.286000 18.549999 0.000000 14.247000 17.340000 0.000000 \n"
"13.286000 17.490000 0.000000 14.891000 17.120001 0.000000 \n"
"15.129000 18.480000 0.000000 15.254000 16.830000 0.000000 \n"
"15.368000 16.430000 0.000000 16.007999 18.469999 0.000000 \n"
"5.923000 2.840000 0.000000 6.236000 3.310000 0.000000 \n"
"6.554000 6.110020 0.000000 6.731990 3.940000 0.000000 \n"
"7.926990 5.399990 0.000000 8.193000 8.010010 0.000000 \n"
"8.331000 8.170010 0.000000 8.337000 5.899990 0.000000 \n"
"9.078990 6.770020 0.000000 9.109000 15.980000 0.000000 \n"
"9.444000 15.280000 0.000000 9.477000 7.260010 0.000000 \n"
"9.962000 14.400000 0.000000 10.277000 6.160000 0.000000 \n"
"10.629000 13.420000 0.000000 10.924000 5.250000 0.000000 \n"
"11.434000 4.489990 0.000000 11.559000 12.130000 0.000000 \n"
"11.664000 11.970000 0.000000 11.819000 3.870000 0.000000 \n"
"11.869000 11.650000 0.000000 12.135000 12.010000 0.000000 \n"
"12.267000 12.180000 0.000000 12.274000 2.959990 0.000000 \n"
"12.400000 2.340000 0.000000 12.710000 10.450000 0.000000 \n"
"13.197000 11.020000 0.000000 13.419000 13.510000 0.000000 \n"
"14.482000 14.880000 0.000000 14.919000 15.440000 0.000000 \n"
"15.190000 15.850000 0.000000 15.368000 13.510000 0.000000 \n"
"16.107000 14.330000 0.000000 16.667999 14.970000 0.000000 \n"
"17.055000 15.400000 0.000000 17.139000 18.459999 0.000000 \n"
"17.271999 15.630000 0.000000 18.035999 16.360001 0.000000 \n"
"18.270000 18.469999 0.000000 18.868999 16.920000 0.000000 \n"
"19.149000 18.480000 0.000000 19.729000 17.270000 0.000000 \n"
"20.989000 17.490000 0.000000 20.989000 18.549999 0.000000 \n"
"10.496000 0.000000 0.000000 10.496000 1.100010 0.000000 \n"
"11.335000 1.209990 0.000000 11.908000 0.050018 0.000000 \n"
"11.930000 1.440000 0.000000 12.283000 1.820010 0.000000 \n"
"13.087000 0.080017 0.000000 14.332000 0.080017 0.000000 \n"
"14.375000 7.910000 0.000000 15.899000 5.649990 0.000000 \n"
"15.943000 0.089996 0.000000 17.157000 3.870000 0.000000 \n"
"17.554001 0.080017 0.000000 17.646999 3.209990 0.000000 \n"
"18.025000 2.739990 0.000000 18.698999 2.050020 0.000000 \n"
"18.799000 0.080017 0.000000 19.409000 1.590000 0.000000 \n"
"19.979000 0.050018 0.000000 20.268999 1.280000 0.000000 \n"
"21.389000 0.000000 0.000000 21.389000 1.060000 0.000000 \n"

"POLYGONS 114 456\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 3 2 4 \n"
"3 3 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 9 8 10 \n"
"3 9 10 11 \n"
"3 9 11 12 \n"
"3 9 12 13 \n"
"3 13 12 14 \n"
"3 13 14 15 \n"
"3 13 15 16 \n"
"3 16 15 17 \n"
"3 18 19 20 \n"
"3 19 18 21 \n"
"3 19 21 22 \n"
"3 22 21 23 \n"
"3 22 23 24 \n"
"3 24 23 25 \n"
"3 24 25 26 \n"
"3 26 25 27 \n"
"3 27 25 28 \n"
"3 27 28 29 \n"
"3 29 28 30 \n"
"3 29 30 31 \n"
"3 31 30 32 \n"
"3 32 30 33 \n"
"3 32 33 34 \n"
"3 34 33 35 \n"
"3 35 33 36 \n"
"3 36 33 37 \n"
"3 37 33 38 \n"
"3 37 38 39 \n"
"3 39 38 40 \n"
"3 40 38 41 \n"
"3 42 43 44 \n"
"3 43 42 45 \n"
"3 45 42 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 48 46 49 \n"
"3 10 50 11 \n"
"3 50 10 51 \n"
"3 51 10 52 \n"
"3 51 52 53 \n"
"3 53 52 54 \n"
"3 54 52 55 \n"
"3 54 55 56 \n"
"3 54 56 57 \n"
"3 57 56 34 \n"
"3 57 34 58 \n"
"3 58 34 35 \n"
"3 58 35 59 \n"
"3 58 59 60 \n"
"3 58 60 61 \n"
"3 61 60 62 \n"
"3 61 62 63 \n"
"3 63 62 64 \n"
"3 63 64 65 \n"
"3 65 64 66 \n"
"3 66 64 67 \n"
"3 66 67 68 \n"
"3 66 68 69 \n"
"3 69 68 70 \n"
"3 69 70 71 \n"
"3 69 71 72 \n"
"3 69 72 73 \n"
"3 73 72 74 \n"
"3 74 72 75 \n"
"3 75 72 76 \n"
"3 76 72 77 \n"
"3 76 77 78 \n"
"3 76 78 79 \n"
"3 76 79 80 \n"
"3 76 80 81 \n"
"3 81 80 48 \n"
"3 81 48 49 \n"
"3 81 49 82 \n"
"3 82 49 83 \n"
"3 83 49 84 \n"
"3 84 49 85 \n"
"3 84 85 86 \n"
"3 86 85 87 \n"
"3 87 85 88 \n"
"3 87 88 89 \n"
"3 89 88 90 \n"
"3 89 90 91 \n"
"3 91 90 92 \n"
"3 92 90 93 \n"
"3 94 95 96 \n"
"3 94 96 97 \n"
"3 97 96 98 \n"
"3 97 98 99 \n"
"3 97 99 74 \n"
"3 97 74 100 \n"
"3 100 74 75 \n"
"3 100 75 101 \n"
"3 101 75 102 \n"
"3 101 102 103 \n"
"3 101 103 104 \n"
"3 104 103 105 \n"
"3 104 105 106 \n"
"3 106 105 107 \n"
"3 106 107 108 \n"
"3 106 108 109 \n"
"3 106 109 110 \n"
"3 110 109 111 \n"
"3 110 111 112 \n"
"3 112 111 113 \n"
"3 112 113 114 \n"
"3 114 113 115 \n"
;

char *VTK_VECTOR_TEXT_y = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 86 float\n"
"1.600000 5.450010 0.000000 2.500000 0.150024 0.000000 \n"
"1.730000 0.309998 0.000000 2.790000 5.450010 0.000000 \n"
"3.090000 4.200010 0.000000 3.110000 0.059998 0.000000 \n"
"3.620000 3.350010 0.000000 4.300000 0.000000 0.000000 \n"
"4.380000 2.860020 0.000000 5.410000 2.710020 0.000000 \n"
"5.700000 0.120026 0.000000 6.720000 2.940000 0.000000 \n"
"6.920000 0.570007 0.000000 7.290000 3.270020 0.000000 \n"
"7.820000 3.790010 0.000000 8.060000 1.480010 0.000000 \n"
"8.350000 4.530000 0.000000 8.900000 5.510010 0.000000 \n"
"9.180000 2.980010 0.000000 9.490000 6.770020 0.000000 \n"
"9.759990 4.000000 0.000000 10.140000 8.330020 0.000000 \n"
"10.380000 5.210020 0.000000 8.130000 27.080000 0.000000 \n"
"8.579990 25.240000 0.000000 8.460000 24.590000 0.000000 \n"
"8.970000 25.700001 0.000000 9.290000 27.100000 0.000000 \n"
"9.660000 25.980000 0.000000 10.670000 26.090000 0.000000 \n"
"10.670000 27.150000 0.000000 0.000000 26.129999 0.000000 \n"
"0.000000 27.150000 0.000000 1.390000 27.100000 0.000000 \n"
"1.450000 25.809999 0.000000 2.040000 25.420000 0.000000 \n"
"2.550000 27.080000 0.000000 2.610000 24.770000 0.000000 \n"
"3.230000 23.780001 0.000000 3.780000 27.070000 0.000000 \n"
"3.960000 22.360001 0.000000 4.850000 20.430000 0.000000 \n"
"5.360000 27.059999 0.000000 5.980000 17.900000 0.000000 \n"
"6.920000 27.070000 0.000000 7.970000 13.250000 0.000000 \n"
"8.579990 23.879999 0.000000 8.790000 11.400000 0.000000 \n"
"8.950000 22.740000 0.000000 9.370000 10.060000 0.000000 \n"
"9.600000 21.129999 0.000000 9.740000 9.230010 0.000000 \n"
"9.880000 8.910000 0.000000 10.540000 19.000000 0.000000 \n"
"11.020000 6.640010 0.000000 11.720000 8.300020 0.000000 \n"
"12.050000 15.550000 0.000000 12.160000 15.320000 0.000000 \n"
"12.400000 14.750000 0.000000 12.480000 10.210000 0.000000 \n"
"12.570000 15.260000 0.000000 12.670000 15.590000 0.000000 \n"
"13.300000 12.380000 0.000000 13.440000 17.709999 0.000000 \n"
"14.070000 19.480000 0.000000 14.200000 14.840000 0.000000 \n"
"14.570000 20.920000 0.000000 14.950000 22.080000 0.000000 \n"
"15.190000 17.590000 0.000000 15.230000 22.980000 0.000000 \n"
"15.410000 23.670000 0.000000 15.550000 24.540001 0.000000 \n"
"16.700001 21.840000 0.000000 13.240000 27.150000 0.000000 \n"
"14.290000 25.930000 0.000000 13.240000 26.090000 0.000000 \n"
"15.010000 25.629999 0.000000 15.420000 25.180000 0.000000 \n"
"16.830000 27.110001 0.000000 17.139999 23.000000 0.000000 \n"
"17.540001 23.920000 0.000000 17.930000 24.650000 0.000000 \n"
"18.320000 25.190001 0.000000 19.230000 25.850000 0.000000 \n"
"20.420000 26.090000 0.000000 20.420000 27.150000 0.000000 \n"

"POLYGONS 84 336\n"
"3 0 1 2 \n"
"3 1 0 3 \n"
"3 1 3 4 \n"
"3 1 4 5 \n"
"3 5 4 6 \n"
"3 5 6 7 \n"
"3 7 6 8 \n"
"3 7 8 9 \n"
"3 7 9 10 \n"
"3 10 9 11 \n"
"3 10 11 12 \n"
"3 12 11 13 \n"
"3 12 13 14 \n"
"3 12 14 15 \n"
"3 15 14 16 \n"
"3 15 16 17 \n"
"3 15 17 18 \n"
"3 18 17 19 \n"
"3 18 19 20 \n"
"3 20 19 21 \n"
"3 20 21 22 \n"
"3 23 24 25 \n"
"3 24 23 26 \n"
"3 26 23 27 \n"
"3 26 27 28 \n"
"3 28 27 29 \n"
"3 29 27 30 \n"
"3 31 32 33 \n"
"3 31 33 34 \n"
"3 34 33 35 \n"
"3 35 33 36 \n"
"3 35 36 37 \n"
"3 37 36 38 \n"
"3 38 36 39 \n"
"3 38 39 40 \n"
"3 40 39 41 \n"
"3 41 39 42 \n"
"3 41 42 43 \n"
"3 43 42 44 \n"
"3 43 44 45 \n"
"3 45 44 23 \n"
"3 45 23 25 \n"
"3 45 25 46 \n"
"3 45 46 47 \n"
"3 47 46 48 \n"
"3 47 48 49 \n"
"3 49 48 50 \n"
"3 49 50 51 \n"
"3 51 50 52 \n"
"3 52 50 21 \n"
"3 21 50 22 \n"
"3 22 50 53 \n"
"3 22 53 54 \n"
"3 54 53 55 \n"
"3 55 53 56 \n"
"3 55 56 57 \n"
"3 55 57 58 \n"
"3 55 58 59 \n"
"3 59 58 60 \n"
"3 59 60 61 \n"
"3 59 61 62 \n"
"3 62 61 63 \n"
"3 62 63 64 \n"
"3 62 64 65 \n"
"3 65 64 66 \n"
"3 65 66 67 \n"
"3 65 67 68 \n"
"3 68 67 69 \n"
"3 68 69 70 \n"
"3 68 70 71 \n"
"3 68 71 72 \n"
"3 73 74 75 \n"
"3 74 73 76 \n"
"3 77 72 71 \n"
"3 72 77 78 \n"
"3 78 77 76 \n"
"3 78 76 73 \n"
"3 78 79 72 \n"
"3 79 78 80 \n"
"3 80 78 81 \n"
"3 81 78 82 \n"
"3 82 78 83 \n"
"3 83 78 84 \n"
"3 84 78 85 \n"
;

char *VTK_VECTOR_TEXT_z = 
"# vtk DataFile Version 1.0\n"
"vtk output\n"
"ASCII\n"
"DATASET POLYDATA\n"
"POINTS 27 float\n"
"0.000000 0.000000 0.000000 0.000000 0.790009 0.000000 \n"
"5.939990 1.550020 0.000000 8.460000 1.550020 0.000000 \n"
"10.350000 1.610020 0.000000 11.920000 1.820010 0.000000 \n"
"17.010000 0.000000 0.000000 13.200000 2.200010 0.000000 \n"
"14.200000 2.770020 0.000000 14.970000 3.540010 0.000000 \n"
"15.530000 4.540010 0.000000 15.910000 5.790010 0.000000 \n"
"16.120001 7.300020 0.000000 17.320000 7.300020 0.000000 \n"
"1.329990 18.549999 0.000000 2.259990 11.780000 0.000000 \n"
"0.889999 11.910000 0.000000 2.460000 13.150000 0.000000 \n"
"2.770000 14.280000 0.000000 3.210000 15.200000 0.000000 \n"
"3.800000 15.910000 0.000000 4.550000 16.430000 0.000000 \n"
"5.480000 16.780001 0.000000 6.600000 16.990000 0.000000 \n"
"7.930000 17.049999 0.000000 11.160000 17.049999 0.000000 \n"
"17.629999 18.549999 0.000000 \n"
"POLYGONS 25 100\n"
"3 0 1 2 \n"
"3 0 2 3 \n"
"3 0 3 4 \n"
"3 0 4 5 \n"
"3 0 5 6 \n"
"3 6 5 7 \n"
"3 6 7 8 \n"
"3 6 8 9 \n"
"3 6 9 10 \n"
"3 6 10 11 \n"
"3 6 11 12 \n"
"3 6 12 13 \n"
"3 14 15 16 \n"
"3 15 14 17 \n"
"3 17 14 18 \n"
"3 18 14 19 \n"
"3 19 14 20 \n"
"3 20 14 21 \n"
"3 21 14 22 \n"
"3 22 14 23 \n"
"3 23 14 24 \n"
"3 24 14 25 \n"
"3 25 14 26 \n"
"3 2 1 25 \n"
"3 2 25 26 \n"
;

// Description:
// Construct object with no string set and backing enabled.
vtkVectorText::vtkVectorText()
{
  this->Text = NULL;
  
  this->Letters[0] = VTK_VECTOR_TEXT_0;
  this->Letters[1] = VTK_VECTOR_TEXT_1;
  this->Letters[2] = VTK_VECTOR_TEXT_2;
  this->Letters[3] = VTK_VECTOR_TEXT_3;
  this->Letters[4] = VTK_VECTOR_TEXT_4;
  this->Letters[5] = VTK_VECTOR_TEXT_5;
  this->Letters[6] = VTK_VECTOR_TEXT_6;
  this->Letters[7] = VTK_VECTOR_TEXT_7;
  this->Letters[8] = VTK_VECTOR_TEXT_8;
  this->Letters[9] = VTK_VECTOR_TEXT_9;
  
  this->Letters[10] = VTK_VECTOR_TEXT_A;
  this->Letters[11] = VTK_VECTOR_TEXT_B;
  this->Letters[12] = VTK_VECTOR_TEXT_C;
  this->Letters[13] = VTK_VECTOR_TEXT_D;
  this->Letters[14] = VTK_VECTOR_TEXT_E;
  this->Letters[15] = VTK_VECTOR_TEXT_F;
  this->Letters[16] = VTK_VECTOR_TEXT_G;
  this->Letters[17] = VTK_VECTOR_TEXT_H;
  this->Letters[18] = VTK_VECTOR_TEXT_I;
  this->Letters[19] = VTK_VECTOR_TEXT_J;
  this->Letters[20] = VTK_VECTOR_TEXT_K;
  this->Letters[21] = VTK_VECTOR_TEXT_L;
  this->Letters[22] = VTK_VECTOR_TEXT_M;
  this->Letters[23] = VTK_VECTOR_TEXT_N;
  this->Letters[24] = VTK_VECTOR_TEXT_O;
  this->Letters[25] = VTK_VECTOR_TEXT_P;
  this->Letters[26] = VTK_VECTOR_TEXT_Q;
  this->Letters[27] = VTK_VECTOR_TEXT_R;
  this->Letters[28] = VTK_VECTOR_TEXT_S;
  this->Letters[29] = VTK_VECTOR_TEXT_T;
  this->Letters[30] = VTK_VECTOR_TEXT_U;
  this->Letters[31] = VTK_VECTOR_TEXT_V;
  this->Letters[32] = VTK_VECTOR_TEXT_W;
  this->Letters[33] = VTK_VECTOR_TEXT_X;
  this->Letters[34] = VTK_VECTOR_TEXT_Y;
  this->Letters[35] = VTK_VECTOR_TEXT_Z;
  this->Letters[36] = VTK_VECTOR_TEXT_a;
  this->Letters[37] = VTK_VECTOR_TEXT_b;
  this->Letters[38] = VTK_VECTOR_TEXT_c;
  this->Letters[39] = VTK_VECTOR_TEXT_d;
  this->Letters[40] = VTK_VECTOR_TEXT_e;
  this->Letters[41] = VTK_VECTOR_TEXT_f;
  this->Letters[42] = VTK_VECTOR_TEXT_g;
  this->Letters[43] = VTK_VECTOR_TEXT_h;
  this->Letters[44] = VTK_VECTOR_TEXT_i;
  this->Letters[45] = VTK_VECTOR_TEXT_j;
  this->Letters[46] = VTK_VECTOR_TEXT_k;
  this->Letters[47] = VTK_VECTOR_TEXT_l;
  this->Letters[48] = VTK_VECTOR_TEXT_m;
  this->Letters[49] = VTK_VECTOR_TEXT_n;
  this->Letters[50] = VTK_VECTOR_TEXT_o;
  this->Letters[51] = VTK_VECTOR_TEXT_p;
  this->Letters[52] = VTK_VECTOR_TEXT_q;
  this->Letters[53] = VTK_VECTOR_TEXT_r;
  this->Letters[54] = VTK_VECTOR_TEXT_s;
  this->Letters[55] = VTK_VECTOR_TEXT_t;
  this->Letters[56] = VTK_VECTOR_TEXT_u;
  this->Letters[57] = VTK_VECTOR_TEXT_v;
  this->Letters[58] = VTK_VECTOR_TEXT_w;
  this->Letters[59] = VTK_VECTOR_TEXT_x;
  this->Letters[60] = VTK_VECTOR_TEXT_y;
  this->Letters[61] = VTK_VECTOR_TEXT_z;
}

void vtkVectorText::Execute()
{
  float xpos = 0;
  int idx;
  vtkTransformPolyFilter *tpf = new vtkTransformPolyFilter();
  vtkTransform trans;
  vtkPolyReader *polyRead = new vtkPolyReader();
  vtkPolyData *output=(vtkPolyData *)this->Output;
  vtkPolyData *input;
  vtkPoints *p;
  vtkFloatPoints *newPoints;
  vtkCellArray *inPolys, *newPolys;
  int ptOffset = 0;
  int npts, i, *pts;
  int pos = 0;
  float *bounds;
  int lineCount = 0;
  
  // Set things up; allocate memory
  newPoints = new vtkFloatPoints();
  newPolys = new vtkCellArray;

  tpf->SetInput(polyRead->GetOutput());
  tpf->SetTransform(&trans);
  polyRead->ReadFromInputStringOn();
  
  // Create Text
  while (this->Text[pos])
    {
    switch (this->Text[pos])
      {
      case 32: 
	trans.Translate(xpos,0,0);
	xpos = 15.0;
	break;
	
      case 10:
	lineCount++;
	trans.Identity();
	trans.Translate(0,-40.0*lineCount,0);
	xpos = 0;
	break;
	
      default:
	idx = -1;
	if ((this->Text[pos] > 47) && (this->Text[pos] < 58)) 
	  {
	  idx = this->Text[pos] - 48;
	  }
	if ((this->Text[pos] > 64) && (this->Text[pos] < 91)) 
	  {
	  idx = this->Text[pos] - 55;
	  }
	if ((this->Text[pos] > 96) && (this->Text[pos] < 123)) 
	  {
	  idx = this->Text[pos] - 61;
	  }
	// if we have a valid character
	if (idx >= 0)
	  {
	  // set up the data
	  polyRead->SetInputString(Letters[idx]);
	  
	  // create a transform filter
	  trans.Translate(xpos,0,0);
	  // handle special characters
	  switch (idx) 
	    {
	    case 42: case 51: case 52: case 60:
	      trans.Translate(0,-8,0); break;
	    case 26: trans.Translate(0,-10,0); break;
	    }
	  tpf->Update();
	  
	  // add the result to our output
	  input = tpf->GetOutput();
	  p = input->GetPoints();
	  inPolys = input->GetPolys();
	  
	  for (i = 0; i < p->GetNumberOfPoints(); i++)
	    {
	    newPoints->InsertNextPoint(p->GetPoint(i));
	    }
	  for (inPolys->InitTraversal(); inPolys->GetNextCell(npts,pts); )
	    {
	    newPolys->InsertNextCell(npts);
	    for (i=0; i < npts; i++) 
	      newPolys->InsertCellPoint(pts[i]+ptOffset);
	    }
	  ptOffset += p->GetNumberOfPoints();
	  bounds = input->GetBounds();
	  xpos = (bounds[1] - bounds[0] + 3.0);
	  // handle special characters
	  switch (idx) 
	    {
	    case 42: case 51: case 52: case 60:
	      trans.Translate(0,8,0); break;
	    case 26: trans.Translate(0,10,0); break;
	    }
	  }
	break;
      }
    pos++;
    }
  
  //
  // Update ourselves and release memory
  //
  output->SetPoints(newPoints);
  newPoints->Delete();
  
  output->SetPolys(newPolys);
  newPolys->Delete();
}
  
void vtkVectorText::PrintSelf(ostream& os, vtkIndent indent)
{
  vtkPolySource::PrintSelf(os,indent);

  os << indent << "Text: " << (this->Text ? this->Text : "(none)") << "\n";
}
