/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: LineoutCommonPluginInfo.C
// ************************************************************************* //

#include <LineoutPluginInfo.h>
#include <LineoutAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtMeshMetaData.h>
#include <avtSubsetsMetaData.h>
#include <avtScalarMetaData.h>
#include <avtVectorMetaData.h>
#include <avtTensorMetaData.h>
#include <avtSymmetricTensorMetaData.h>
#include <avtArrayMetaData.h>
#include <avtMaterialMetaData.h>
#include <avtSpeciesMetaData.h>
#include <avtCurveMetaData.h>
#include <avtLabelMetaData.h>

// ****************************************************************************
//  Method: LineoutCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineoutCommonPluginInfo::AllocAttributes()
{
    return new LineoutAttributes;
}

// ****************************************************************************
//  Method: LineoutCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Lineout attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void 
LineoutCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((LineoutAttributes *) to) = *((LineoutAttributes *) from);
}
// ****************************************************************************
//  Method: LineoutCommonPluginInfo::GetCreatedExpressions
//
//  Purpose:
//      Gets the expressions created by this operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//    Brad Whitlock, Wed Jul 27 11:31:54 PDT 2011
//    Use std::string instead of sprintf and insert <> in case the variable
//    name has some punctuation.
//
// ****************************************************************************

ExpressionList * 
LineoutCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md)
{
    std::string opLineout("operators/Lineout/"),
                exPrefix("cell_constant("), exSuffix(", 0.)"),
                lAngleBracket("<"), rAngleBracket(">");
    ExpressionList *el = new ExpressionList;
    int numScalars = md->GetNumScalars();
    for (int i = 0 ; i < numScalars ; i++)
    {
        const avtScalarMetaData *mmd = md->GetScalar(i);
        {
            Expression e2;
            e2.SetName(opLineout + mmd->name);
            e2.SetType(Expression::CurveMeshVar);
            e2.SetFromOperator(true);
            e2.SetOperatorName("Lineout");
            e2.SetDefinition(exPrefix + lAngleBracket + mmd->name + rAngleBracket + exSuffix);
            el->AddExpressions(e2);
        }
    }
    const ExpressionList &oldEL = md->GetExprList();
    for (int i = 0 ; i < oldEL.GetNumExpressions() ; i++)
    {
        const Expression &e = oldEL.GetExpressions(i);
        if (e.GetType() == Expression::ScalarMeshVar)
        {
            {
                Expression e2;
                e2.SetName(opLineout + e.GetName());
                e2.SetType(Expression::CurveMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("Lineout");
                e2.SetDefinition(exPrefix + e.GetName() + exSuffix);
                el->AddExpressions(e2);
            }
        }
    }
    return el;
}

// ****************************************************************************
// Method: LineoutCommonPluginInfo::GetVariableTypes
//
// Purpose: 
//   Indicates that if the Lineout operator is present in the selected plot
//   then the GUI's variable menu should include scalars.
//
// Returns:    The allowable variable types for the Lineout operator.
//
// Programmer: Brad Whitlock
// Creation:   Tue Apr 25 16:51:05 PST 2006
//
// Modifications:
//   
// ****************************************************************************

int
LineoutCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}

// ****************************************************************************
// Method: LineoutCommonPluginInfo::GetVariableMask
//
// Purpose: 
//   Returns a mask that lets the Lineout operator eliminate certain variable
//   types from the variable menu.
//
// Programmer: Brad Whitlock
// Creation:   Tue Apr 25 16:52:08 PST 2006
//
// Modifications:
//   
// ****************************************************************************

int
LineoutCommonPluginInfo::GetVariableMask() const
{
    return VAR_CATEGORY_SCALAR;
}

// ****************************************************************************
// Method: LineoutCommonPluginInfo::GetUserSelectable
//
// Purpose: 
//   Indicates that the Lineout operator cannot be selected in the GUI.
//
// Programmer: Brad Whitlock
// Creation:   Tue Apr 25 17:04:25 PST 2006
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutCommonPluginInfo::GetUserSelectable() const
{
    return false;
}

