/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: LagrangianCommonPluginInfo.C
// ************************************************************************* //

#include <LagrangianPluginInfo.h>
#include <LagrangianAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtMeshMetaData.h>
#include <avtSubsetsMetaData.h>
#include <avtScalarMetaData.h>
#include <avtVectorMetaData.h>
#include <avtTensorMetaData.h>
#include <avtSymmetricTensorMetaData.h>
#include <avtArrayMetaData.h>
#include <avtMaterialMetaData.h>
#include <avtSpeciesMetaData.h>
#include <avtCurveMetaData.h>
#include <avtLabelMetaData.h>

// ****************************************************************************
//  Method: LagrangianCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LagrangianCommonPluginInfo::AllocAttributes()
{
    return new LagrangianAttributes;
}

// ****************************************************************************
//  Method: LagrangianCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Lagrangian attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void 
LagrangianCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((LagrangianAttributes *) to) = *((LagrangianAttributes *) from);
}

// ****************************************************************************
//  Method: LagrangianCommonPluginInfo::GetCreatedExpressions
//
//  Purpose:
//      Gets the expressions created by this operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

ExpressionList * 
LagrangianCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md)
{
    int i;
    char name[1024], defn[1024];
    ExpressionList *el = new ExpressionList;
    int numVectors = md->GetNumVectors();
    for (i = 0 ; i < numVectors ; i++)
    {
        const avtVectorMetaData *mmd = md->GetVector(i);
        {
            Expression e2;
            sprintf(name, "operators/Lagrangian/%s", mmd->name.c_str());
            e2.SetName(name);
            e2.SetType(Expression::CurveMeshVar);
            e2.SetFromOperator(true);
            e2.SetOperatorName("Lagrangian");
            sprintf(defn, "cell_constant(<%s>, 0.)", mmd->name.c_str());
            e2.SetDefinition(defn);
            el->AddExpressions(e2);
        }
    }
    const ExpressionList &oldEL = md->GetExprList();
    for (i = 0 ; i < oldEL.GetNumExpressions() ; i++)
    {
        const Expression &e = oldEL.GetExpressions(i);
        if (e.GetType() == Expression::VectorMeshVar)
        {
            {
                if (e.GetFromOperator())
                    continue; // weird ordering behavior otherwise
                Expression e2;
                sprintf(name, "operators/Lagrangian/%s", e.GetName().c_str());
                e2.SetName(name);
                e2.SetType(Expression::CurveMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("Lagrangian");
                sprintf(defn, "cell_constant(<%s>, 0.)", e.GetName().c_str());
                e2.SetDefinition(defn);
                el->AddExpressions(e2);
            }
        }
    }
    return el;
}

