/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: ParallelCoordinatesGUIPluginInfo.C
// ************************************************************************* //

#include <ParallelCoordinatesPluginInfo.h>
#include <ParallelCoordinatesAttributes.h>
#include <QApplication>
#include <QvisParallelCoordinatesPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(ParallelCoordinates,GUI)

// ****************************************************************************
//  Method: ParallelCoordinatesGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ParallelCoordinatesGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Parallel Coordinates"));
}


// ****************************************************************************
//  Method: ParallelCoordinatesGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ParallelCoordinatesGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisParallelCoordinatesPlotWindow(type, (ParallelCoordinatesAttributes *)attr,
        caption, shortName, notepad);
}
// ****************************************************************************
// Method:ParallelCoordinatesGUIPluginInfo::CreatePluginWizard
//
// Purpose:
//   Creates a ParallelCoordinates plot wizard and returns a pointer to it.
//
// Arguments:
//   attr        : Attributes that should be used for the plot.
//   parent      : Wizard's parent widget.
//   plotVarName : Name of the plot's variable
//   plotVarType : Data type of the plot's variable
//   name        : Name of the wizard
//
// Returns:    A pointer to the new wizard
//
// Note:
//
// Programmer: Mark Blair
// Creation:   Wed Jun 21 19:02:00 PDT 2006
//
// Modifications:
//    Jeremy Meredith, Thu Feb  7 12:58:15 EST 2008
//    A wizard is needed because you can't reset the default plot attributes
//    without a wizard's accept action having been called.  If you don't, then
//    you'll have the wrong number of axes defined in the plot attributes.
//    As such, I extended the wizard to support a "no-op" mode.
//
//    Cyrus Harrison, Mon Jul 21 08:33:47 PDT 2008
//    Initial Qt4 Port.
//
//    Cyrus Harrison, Mon Jul 21 08:33:47 PDT 2008
//    Pass metadata & expression list to the QWizard constructor.
//
//    Cyrus Harrison, Thu Jul  8 08:59:35 PDT 2010
//    Do not use wizard if the user selected an array variable.
//
// ****************************************************************************
#include <QvisParallelCoordinatesPlotWizard.h>
#include <Expression.h>
#include <avtDatabaseMetaData.h>
#include <ViewerMethods.h>

QvisWizard *
ParallelCoordinatesGUIPluginInfo::CreatePluginWizard(AttributeSubject *attr,
    QWidget *parent, const std::string &varName, const avtDatabaseMetaData *md,
    const ExpressionList *expList)
{
    bool showWizard  = true;
    if (md->GetScalar(varName) == NULL)
    {
        int expressionCount = expList->GetNumExpressions();
        int expNum;

        for (expNum = 0; expNum < expressionCount; expNum++)
        {
            if (expList->GetExpressions(expNum).GetName() == varName)
            {
                if (expList->GetExpressions(expNum).GetType() ==
                    Expression::ScalarMeshVar)
                    break;
            }
        }
        if (expNum >= expressionCount)
            showWizard = false;
    }

    // use wizard if we are starting with a scalar.
    if(showWizard)
        return (new QvisParallelCoordinatesPlotWizard(attr, parent, varName,md,expList));
    else
    {
        // setup para coords plot of array var without wizard
        stringVector saxisNames;
        stringVector vaxisNames;
        doubleVector extMins;
        doubleVector extMaxs;
        saxisNames.push_back(varName);
        vaxisNames.push_back(varName);
        extMins.push_back(-1e+37);
        extMaxs.push_back(+1e+37);
        ParallelCoordinatesAttributes *pcoord_atts =(ParallelCoordinatesAttributes *)attr;

        pcoord_atts->SetScalarAxisNames(saxisNames);
        pcoord_atts->SetVisualAxisNames(vaxisNames);
        pcoord_atts->SetExtentMinima(extMins);
        pcoord_atts->SetExtentMaxima(extMaxs);
        return NULL;
    }

}


// ****************************************************************************
//  Method: ParallelCoordinatesGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <ParallelCoordinates.xpm>
const char **
ParallelCoordinatesGUIPluginInfo::XPMIconData() const
{
    return ParallelCoordinates_xpm;
}

