/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: LineSamplerViewerEnginePluginInfo.C
// ************************************************************************* //

#include <LineSamplerPluginInfo.h>
#include <LineSamplerAttributes.h>

//
// Storage for static data elements.
//
LineSamplerAttributes *LineSamplerViewerEnginePluginInfo::clientAtts = NULL;
LineSamplerAttributes *LineSamplerViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LineSamplerViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
LineSamplerViewerEnginePluginInfo::InitializeGlobalObjects()
{
    LineSamplerViewerEnginePluginInfo::clientAtts  = new LineSamplerAttributes;
    LineSamplerViewerEnginePluginInfo::defaultAtts = new LineSamplerAttributes;
}

// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineSamplerViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineSamplerViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSamplerViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LineSamplerAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSamplerViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
  std::cerr << __FILE__ << "  " << __LINE__ << "  " << "SHOULD NOT BE CALLED" << std::endl;

//    *(LineSamplerAttributes *)atts = *clientAtts;
}


// Just do this stuff in the viewer version.
#if !defined(ELineSamplerOperator_ser_EXPORTS) && !defined(ELineSamplerOperator_par_EXPORTS) && !defined(VISIT_STATIC)
#include <ViewerBase.h>
#include <ViewerMessaging.h>
#include <ViewerText.h>
#endif

// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSamplerViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts,
                                           const bool activeOperator,
                                           const bool applyToAll)
{
  LineSamplerAttributes aTmp = *clientAtts;

  if( applyToAll )
  {
    // Allow the user to set the instance (up to 5 are allowed). Only
    // apply to all if the instances match otherwise skip it.
    if( (*(LineSamplerAttributes *)atts).GetInstanceId() !=
        (*clientAtts).GetInstanceId() )
      return;

    // If needed save off the old values so they are not changed.
    if( (*(LineSamplerAttributes *)atts).GetDonotApplyToAll() )
    {
      LineSamplerAttributes::ViewDimension oldViewDim =
        (*(LineSamplerAttributes *)atts).GetViewDimension();

      LineSamplerAttributes::ViewGeometry oldViewGeom =
        (*(LineSamplerAttributes *)atts).GetViewGeometry();

// Just do this stuff in the viewer version.
#if !defined(ELineSamplerOperator_ser_EXPORTS) && !defined(ELineSamplerOperator_par_EXPORTS) && !defined(VISIT_STATIC)
      LineSamplerAttributes::ViewDimension newViewDim =
        (*clientAtts).GetViewDimension();
      LineSamplerAttributes::ViewGeometry newViewGeom =
        (*clientAtts).GetViewGeometry();

      if( activeOperator && 
          (newViewDim != oldViewDim ||
           newViewGeom != oldViewGeom) )
      {
        ViewerBase vb;

        ViewerText msg("You are attemping to change the 'View dimension' "
                    "or the 'View geometry' while the 'Apply to all windows' "
                    "and/or the 'Apply operators to all plots' and the "
                    "'Do not apply to all' are all checked. This setting "
                    "is a conflict. The 'View dimension' and  'View geometry' "
                    "will not be changed.");

        vb.GetViewerMessaging()->Warning(msg);
      }
#endif

      *(LineSamplerAttributes *)atts = *clientAtts;

      (*(LineSamplerAttributes *)atts).SetViewDimension( oldViewDim );
      (*(LineSamplerAttributes *)atts).SetViewGeometry( oldViewGeom );
    }
    else // No restriction on the apply operation.
    {
      *(LineSamplerAttributes *)atts = *clientAtts;
    }
  }
  else // Not applying to all
  {
    *(LineSamplerAttributes *)atts = *clientAtts;
  }
}


// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSamplerViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(LineSamplerAttributes*)atts = *defaultAtts;
    else
        *(LineSamplerAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSamplerViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: LineSamplerViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LineSamplerViewerEnginePluginInfo::GetMenuName() const
{
    return "LineSampler";
}

