/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                              avtSTLWriter.C                               //
// ************************************************************************* //

#include <avtSTLWriter.h>

#include <vector>

#include <vtkAlgorithm.h>
#include <vtkAppendPolyData.h>
#include <vtkDataSet.h>
#include <vtkGeometryFilter.h>
#include <vtkDataSetWriter.h>
#include <vtkPolyDataReader.h>
#include <vtkPolyDataWriter.h>
#include <vtkCharArray.h>
#include <vtkPolyData.h>
#include <vtkSTLWriter.h>
#include <vtkTriangleFilter.h>

#include <avtDatabaseMetaData.h>
#include <DBOptionsAttributes.h>

#include <DebugStream.h>
#include <avtParallelContext.h>

using     std::string;
using     std::vector;


// ****************************************************************************
//  Method: avtSTLWriter constructor
//
//  Programmer: jfavre -- generated by xml2avt
//  Creation:   Fri Jan 27 14:13:01 PST 2012
//
//  Modifications:
//    Brad Whitlock, Fri Jan 27 09:56:06 PST 2012
//    Added polydatas.
//
// ****************************************************************************

avtSTLWriter::avtSTLWriter(DBOptionsAttributes *atts) : avtDatabaseWriter()
{
    doBinary = atts->GetBool("Binary format");
}

// ****************************************************************************
//  Method: avtSTLWriter::OpenFile
//
//  Purpose:
//      Does no actual work.  Just records the stem name for the files.
//
//  Programmer: jfavre -- generated by xml2avt
//  Creation:   Fri Jan 27 14:13:01 PST 2012
//
// ****************************************************************************

void
avtSTLWriter::OpenFile(const string &stemname, int numblocks)
{
    stem = stemname;
}

// ****************************************************************************
//  Method: avtSTLWriter::WriteHeaders
//
//  Purpose:
//      Writes out a VisIt file to tie the STL files together.
//
//  Programmer: jfavre -- generated by xml2avt
//  Creation:   Fri Jan 27 14:13:01 PST 2012
//
// ****************************************************************************

void
avtSTLWriter::WriteHeaders(const avtDatabaseMetaData *md,
                           const vector<string> &scalars,
                           const vector<string> &vectors,
                           const vector<string> &materials)
{
    // WRITE OUT HEADER INFO
}

// ****************************************************************************
//  Method: avtSTLWriter::WriteChunk
//
//  Purpose:
//      This writes out one chunk of an avtDataset.
//
//  Programmer: jfavre -- generated by xml2avt
//  Creation:   Fri Jan 27 14:13:01 PST 2012
//
//  Modifications:
//    Brad Whitlock, Fri Jan 27 09:29:26 PST 2012
//    Save the polydata so we can combine it all into one dataset. We do any
//    conversion to polydata and then to triangles before saving the polydata.
//
//    Brad Whitlock, Tue Sep  8 17:04:07 PDT 2015
//    Rely on base class for geometry consolidation. This method will only
//    be called on group leaders.
//
// ****************************************************************************

void
avtSTLWriter::WriteChunk(vtkDataSet *ds, int chunk)
{
    std::string filename;
    if(writeContext.GroupSize() > 1)
    {
        char ext[20];
        SNPRINTF(ext, 20, ".%d.stl", writeContext.GroupRank());
        filename = stem + ext;
    }
    else
        filename = stem + ".stl";

    vtkSTLWriter *writer = vtkSTLWriter::New();   
    writer->SetFileName(filename.c_str());
    if(doBinary)
        writer->SetFileTypeToBinary();

    writer->SetInputData(ds);
    writer->Update();
    writer->Delete();
}

// ****************************************************************************
//  Method: avtSTLWriter::CloseFile
//
//  Purpose:
//      Closes the file.  This does nothing in this case.
//
//  Programmer: jfavre -- generated by xml2avt
//  Creation:   Fri Jan 27 14:13:01 PST 2012
//
//  Modifications:
//  
// ****************************************************************************

void
avtSTLWriter::CloseFile(void)
{
}

// ****************************************************************************
// Method: avtSTLWriter::CreateTrianglePolyData
//
// Purpose:
//   Tell VisIt's export that we'll want triangles.
//
// Returns:    True
//
// Programmer: Brad Whitlock
// Creation:   Tue Sep  8 17:00:23 PDT 2015
//
// Modifications:
//
// ****************************************************************************

bool
avtSTLWriter::CreateTrianglePolyData() const
{
    return true;
}

// ****************************************************************************
//  Method: avtTecplotWriter::GetCombineMode
//
//  Purpose:
//     Provides a hint to the export mechanism to tell it how to combine data.
//
//  Note: We combine geometry because STL tools will want 1 file.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Sep  8 15:36:45 PDT 2015
//
// ****************************************************************************

avtDatabaseWriter::CombineMode
avtSTLWriter::GetCombineMode(const std::string &) const
{
    return CombineAll;
}
