# Change Log
All notable changes to this project will be documented in this file. This project adheres to [Semantic Versioning](http://semver.org/).

## [v3.1.1](https://github.com/nlohmann/json/releases/tag/v3.1.1) (2018-02-12)
[Full Changelog](https://github.com/nlohmann/json/compare/v3.1.0...v3.1.1)

- Updation of child object isn't reflected in parent Object [\#968](https://github.com/nlohmann/json/issues/968)
- How to add user defined C++ path to sublime text  [\#966](https://github.com/nlohmann/json/issues/966)
- fast number parsing [\#965](https://github.com/nlohmann/json/issues/965)
- With non-unique keys, later stored entries are not taken into account anymore [\#963](https://github.com/nlohmann/json/issues/963)
- Timeout \(OSS-Fuzz 6034\) [\#962](https://github.com/nlohmann/json/issues/962)
- Incorrect parsing of indefinite length CBOR strings. [\#961](https://github.com/nlohmann/json/issues/961)
- Reload a json file at runtime without emptying my std::ifstream [\#959](https://github.com/nlohmann/json/issues/959)
- Split headers should be part of the release [\#956](https://github.com/nlohmann/json/issues/956)
- Coveralls shows no coverage data [\#953](https://github.com/nlohmann/json/issues/953)
- Feature request: Implicit conversion to bool [\#951](https://github.com/nlohmann/json/issues/951)
- converting json to vector of type with templated constructor [\#924](https://github.com/nlohmann/json/issues/924)
- No structured bindings support? [\#901](https://github.com/nlohmann/json/issues/901)
- \[Request\] Macro generating from\_json\(\) and to\_json\(\) [\#895](https://github.com/nlohmann/json/issues/895)
- basic\_json::value throws exception instead of returning default value [\#871](https://github.com/nlohmann/json/issues/871)

- Fix constraints on from\_json\(CompatibleArrayType\) [\#969](https://github.com/nlohmann/json/pull/969) ([theodelrieu](https://github.com/theodelrieu))
- Make coveralls watch the include folder [\#957](https://github.com/nlohmann/json/pull/957) ([theodelrieu](https://github.com/theodelrieu))
- Fix links in README.md [\#955](https://github.com/nlohmann/json/pull/955) ([patrikhuber](https://github.com/patrikhuber))
- Add a note about installing the library with cget [\#954](https://github.com/nlohmann/json/pull/954) ([pfultz2](https://github.com/pfultz2))

## [v3.1.0](https://github.com/nlohmann/json/releases/tag/v3.1.0) (2018-02-01)
[Full Changelog](https://github.com/nlohmann/json/compare/v3.0.1...v3.1.0)

- Order of the elements in JSON object [\#952](https://github.com/nlohmann/json/issues/952)
- I have a proposal [\#949](https://github.com/nlohmann/json/issues/949)
- VERSION define\(s\) [\#948](https://github.com/nlohmann/json/issues/948)
- v3.0.1 compile error in icc 16.0.4 [\#947](https://github.com/nlohmann/json/issues/947)
- Use in VS2017 15.5.5 [\#946](https://github.com/nlohmann/json/issues/946)
- Process for reporting Security Bugs? [\#945](https://github.com/nlohmann/json/issues/945)
- Please expose a NLOHMANN\_JSON\_VERSION macro [\#943](https://github.com/nlohmann/json/issues/943)
- Change header include directory to nlohmann/json [\#942](https://github.com/nlohmann/json/issues/942)
- string\_type in binary\_reader [\#941](https://github.com/nlohmann/json/issues/941)
- compile error with clang 5.0 -std=c++1z and no string\_view [\#939](https://github.com/nlohmann/json/issues/939)
- Allow overriding JSON\_THROW to something else than abort\(\) [\#938](https://github.com/nlohmann/json/issues/938)
- Handle invalid string in Json file [\#937](https://github.com/nlohmann/json/issues/937)
- Unused variable 'kMinExp' [\#935](https://github.com/nlohmann/json/issues/935)
- yytext is already defined [\#933](https://github.com/nlohmann/json/issues/933)
- Equality operator fails [\#931](https://github.com/nlohmann/json/issues/931)
- use in visual studio 2015 [\#929](https://github.com/nlohmann/json/issues/929)
- Relative includes of json\_fwd.hpp in detail/meta.hpp. \[Develop branch\] [\#928](https://github.com/nlohmann/json/issues/928)
- GCC 7.x issue [\#926](https://github.com/nlohmann/json/issues/926)
- json\_fwd.hpp not installed [\#923](https://github.com/nlohmann/json/issues/923)
- Use Google Benchmarks [\#921](https://github.com/nlohmann/json/issues/921)
- Move class json\_pointer to separate file [\#920](https://github.com/nlohmann/json/issues/920)
- Unable to locate 'to\_json\(\)' and 'from\_json\(\)' methods in the same namespace [\#917](https://github.com/nlohmann/json/issues/917)
- \[answered\]Read key1 from .value example  [\#914](https://github.com/nlohmann/json/issues/914)
- Don't use `define private public` in test files [\#913](https://github.com/nlohmann/json/issues/913)
- value\(\) template argument type deduction [\#912](https://github.com/nlohmann/json/issues/912)
- Installation path is incorrect [\#910](https://github.com/nlohmann/json/issues/910)
- H [\#909](https://github.com/nlohmann/json/issues/909)
- Build failure using clang 5 [\#908](https://github.com/nlohmann/json/issues/908)
- Amalgate [\#907](https://github.com/nlohmann/json/issues/907)
- Update documentation and tests wrt. split headers [\#906](https://github.com/nlohmann/json/issues/906)
- Lib not working on ubuntu 16.04 [\#905](https://github.com/nlohmann/json/issues/905)
- Problem when writing to file. [\#904](https://github.com/nlohmann/json/issues/904)
- C2864 error when compiling with VS2015 and VS 2017 [\#903](https://github.com/nlohmann/json/issues/903)
- \[json.exception.type\_error.304\] cannot use at\(\) with object [\#902](https://github.com/nlohmann/json/issues/902)
- How do I forward nlohmann::json declaration? [\#899](https://github.com/nlohmann/json/issues/899)
- How to effectively store binary data? [\#898](https://github.com/nlohmann/json/issues/898)
- How to get the length of a JSON string without retrieving its std::string? [\#897](https://github.com/nlohmann/json/issues/897)
- Regression Tests Failure using "ctest" [\#887](https://github.com/nlohmann/json/issues/887)
- Discuss: add JSON Merge Patch \(RFC 7396\)? [\#877](https://github.com/nlohmann/json/issues/877)
- Discuss: replace static "iterator\_wrapper" function with "items" member function [\#874](https://github.com/nlohmann/json/issues/874)
- Make optional user-data available in from\_json [\#864](https://github.com/nlohmann/json/issues/864)
- Casting to std::string not working in VS2015 [\#861](https://github.com/nlohmann/json/issues/861)
- Sequential reading of JSON arrays [\#851](https://github.com/nlohmann/json/issues/851)
- Idea: Handle Multimaps Better [\#816](https://github.com/nlohmann/json/issues/816)
- Floating point rounding [\#777](https://github.com/nlohmann/json/issues/777)
- Loss of precision when serializing \<double\> [\#360](https://github.com/nlohmann/json/issues/360)

- Templatize std::string in binary\_reader \#941 [\#950](https://github.com/nlohmann/json/pull/950) ([kaidokert](https://github.com/kaidokert))
- fix cmake install directory \(for real this time\) [\#944](https://github.com/nlohmann/json/pull/944) ([theodelrieu](https://github.com/theodelrieu))
- Allow overriding THROW/CATCH/TRY macros with no-exceptions \#938 [\#940](https://github.com/nlohmann/json/pull/940) ([kaidokert](https://github.com/kaidokert))
- Removed compiler warning about unused variable 'kMinExp' [\#936](https://github.com/nlohmann/json/pull/936) ([zerodefect](https://github.com/zerodefect))
- Fix a typo in README.md [\#930](https://github.com/nlohmann/json/pull/930) ([Pipeliner](https://github.com/Pipeliner))
- Howto installation of json\_fwd.hpp \(fixes \#923\) [\#925](https://github.com/nlohmann/json/pull/925) ([zerodefect](https://github.com/zerodefect))
- fix sfinae on basic\_json UDT constructor [\#919](https://github.com/nlohmann/json/pull/919) ([theodelrieu](https://github.com/theodelrieu))
- Floating-point formatting [\#915](https://github.com/nlohmann/json/pull/915) ([abolz](https://github.com/abolz))
- Fix/cmake install [\#911](https://github.com/nlohmann/json/pull/911) ([theodelrieu](https://github.com/theodelrieu))
- fix link to the documentation of the emplace function [\#900](https://github.com/nlohmann/json/pull/900) ([Dobiasd](https://github.com/Dobiasd))
- JSON Merge Patch \(RFC 7396\) [\#876](https://github.com/nlohmann/json/pull/876) ([nlohmann](https://github.com/nlohmann))
- Refactor/split it [\#700](https://github.com/nlohmann/json/pull/700) ([theodelrieu](https://github.com/theodelrieu))

## [v3.0.1](https://github.com/nlohmann/json/releases/tag/v3.0.1) (2017-12-29)
[Full Changelog](https://github.com/nlohmann/json/compare/v3.0.0...v3.0.1)

- Problem parsing array to global vector [\#896](https://github.com/nlohmann/json/issues/896)
- Invalid RFC6902 copy operation succeeds [\#894](https://github.com/nlohmann/json/issues/894)
- How to rename a key during looping? [\#893](https://github.com/nlohmann/json/issues/893)
- clang++-6.0 \(6.0.0-svn321357-1\) warning [\#892](https://github.com/nlohmann/json/issues/892)
- Make json.hpp aware of the modules TS? [\#891](https://github.com/nlohmann/json/issues/891)
- All enum values not handled in switch cases. \( -Wswitch-enum \) [\#889](https://github.com/nlohmann/json/issues/889)
- JSON Pointer resolve failure resulting in incorrect exception code [\#888](https://github.com/nlohmann/json/issues/888)
- Unexpected nested arrays from std::vector [\#886](https://github.com/nlohmann/json/issues/886)
- erase multiple elements from a json object [\#884](https://github.com/nlohmann/json/issues/884)
- Container function overview in Doxygen is not updated [\#883](https://github.com/nlohmann/json/issues/883)
- How to use this for binary file uploads [\#881](https://github.com/nlohmann/json/issues/881)
- Allow setting JSON\_BuildTests=OFF from parent CMakeLists.txt [\#846](https://github.com/nlohmann/json/issues/846)
- Unit test fails for local-independent str-to-num [\#845](https://github.com/nlohmann/json/issues/845)
- Another idea about type support [\#774](https://github.com/nlohmann/json/issues/774)

- Includes CTest module/adds BUILD\_TESTING option [\#885](https://github.com/nlohmann/json/pull/885) ([TinyTinni](https://github.com/TinyTinni))
- Fix MSVC warning C4819 [\#882](https://github.com/nlohmann/json/pull/882) ([erengy](https://github.com/erengy))
- Merge branch 'develop' into coverity\_scan [\#880](https://github.com/nlohmann/json/pull/880) ([nlohmann](https://github.com/nlohmann))
- :wrench: Fix up a few more effc++ items [\#858](https://github.com/nlohmann/json/pull/858) ([mattismyname](https://github.com/mattismyname))

## [v3.0.0](https://github.com/nlohmann/json/releases/tag/v3.0.0) (2017-12-17)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.1.1...v3.0.0)

- unicode strings [\#878](https://github.com/nlohmann/json/issues/878)
- Visual Studio 2017 15.5 C++17 std::allocator deprecations [\#872](https://github.com/nlohmann/json/issues/872)
- Typo "excpetion" [\#869](https://github.com/nlohmann/json/issues/869)
- Explicit array example in README.md incorrect [\#867](https://github.com/nlohmann/json/issues/867)
- why don't you release this from Feb. ? [\#865](https://github.com/nlohmann/json/issues/865)
- json::parse throws std::invalid\_argument when processing string generated by json::dump\(\) [\#863](https://github.com/nlohmann/json/issues/863)
- code analysis: potential bug? [\#859](https://github.com/nlohmann/json/issues/859)
- MSVC2017, 15.5 new issues.   [\#857](https://github.com/nlohmann/json/issues/857)
- very basic: fetching string value/content without quotes [\#853](https://github.com/nlohmann/json/issues/853)
- Ambiguous function call to get with pointer type and constant json object in VS2015 \(15.4.4\) [\#852](https://github.com/nlohmann/json/issues/852)
- How to put  object in the array as a member? [\#850](https://github.com/nlohmann/json/issues/850)
- misclick, please ignore [\#849](https://github.com/nlohmann/json/issues/849)
- Make XML great again. [\#847](https://github.com/nlohmann/json/issues/847)
- Converting to array not working [\#843](https://github.com/nlohmann/json/issues/843)
- Iteration weirdness [\#842](https://github.com/nlohmann/json/issues/842)
- Use reference or pointer as Object value [\#841](https://github.com/nlohmann/json/issues/841)
- Ambiguity in parsing nested maps [\#840](https://github.com/nlohmann/json/issues/840)
- could not find from\_json\(\) method in T's namespace [\#839](https://github.com/nlohmann/json/issues/839)
- Incorrect parse error with binary data in keys? [\#838](https://github.com/nlohmann/json/issues/838)
- using dump\(\) when std::wstring is StringType with VS2017 [\#836](https://github.com/nlohmann/json/issues/836)
- Show the path of the currently parsed value when an error occurs [\#835](https://github.com/nlohmann/json/issues/835)
- Repetitive data type while reading [\#833](https://github.com/nlohmann/json/issues/833)
- Storing multiple types inside map [\#831](https://github.com/nlohmann/json/issues/831)
- Application terminating [\#830](https://github.com/nlohmann/json/issues/830)
- Missing CMake hunter package? [\#828](https://github.com/nlohmann/json/issues/828)
- std::map\<std::string, std::string\> from json object yields C2665: 'std::pair\<const \_Kty,\_Ty\>::pair': none of the 2 overloads could convert all the argument types [\#827](https://github.com/nlohmann/json/issues/827)
- object.dump gives quoted string, want to use .dump\(\) to generate javascripts. [\#826](https://github.com/nlohmann/json/issues/826)
- Assertion failed on \["NoExistKey"\] of an not existing key of const json& [\#825](https://github.com/nlohmann/json/issues/825)
- vs2015 error : static member will remain uninitialized at runtime but use in constant-expressions is supported [\#824](https://github.com/nlohmann/json/issues/824)
- Code Checking Warnings from json.hpp on VS2017 Community [\#821](https://github.com/nlohmann/json/issues/821)
- Missing iostream in try online [\#820](https://github.com/nlohmann/json/issues/820)
- Floating point value loses decimal point during dump [\#818](https://github.com/nlohmann/json/issues/818)
- Conan package for the library [\#817](https://github.com/nlohmann/json/issues/817)
- stream error  [\#815](https://github.com/nlohmann/json/issues/815)
- Link error when using find\(\) on the latest commit [\#814](https://github.com/nlohmann/json/issues/814)
- ABI issue with json object between 2 shared libraries [\#813](https://github.com/nlohmann/json/issues/813)
- scan\_string\(\) return token\_type::parse\_error; when parse ansi file [\#812](https://github.com/nlohmann/json/issues/812)
- segfault when using fifo\_map with json [\#810](https://github.com/nlohmann/json/issues/810)
- This shit is shit  [\#809](https://github.com/nlohmann/json/issues/809)
- \_finite and \_isnan are no members of "std" [\#808](https://github.com/nlohmann/json/issues/808)
- how to print out the line which causing exception? [\#806](https://github.com/nlohmann/json/issues/806)
- {} uses copy constructor, while = does not [\#805](https://github.com/nlohmann/json/issues/805)
- json.hpp:8955: multiple definition of function that is not defined twice or more. [\#804](https://github.com/nlohmann/json/issues/804)
- \[question\] to\_json for base and derived class [\#803](https://github.com/nlohmann/json/issues/803)
- Misleading error message - unexpected '"' - on incorrect utf-8 symbol [\#802](https://github.com/nlohmann/json/issues/802)
- json data = std::string\_view\("hi"\); doesn't work? [\#801](https://github.com/nlohmann/json/issues/801)
- Thread safety of parse\(\) [\#800](https://github.com/nlohmann/json/issues/800)
- Numbers as strings [\#799](https://github.com/nlohmann/json/issues/799)
- Tests failing on arm [\#797](https://github.com/nlohmann/json/issues/797)
- Using your library \(without modification\) in another library [\#796](https://github.com/nlohmann/json/issues/796)
- Iterating over sub-object [\#794](https://github.com/nlohmann/json/issues/794)
- how to get the json object again from which printed by the method of dump\(\) [\#792](https://github.com/nlohmann/json/issues/792)
- ppa to include source [\#791](https://github.com/nlohmann/json/issues/791)
- Different include paths in macOS and Ubuntu [\#790](https://github.com/nlohmann/json/issues/790)
- Missing break after line 12886 in switch/case [\#789](https://github.com/nlohmann/json/issues/789)
- All unit tests fail? [\#787](https://github.com/nlohmann/json/issues/787)
- More use of move semantics in deserialization [\#786](https://github.com/nlohmann/json/issues/786)
- warning C4706 - Visual Studio 2017 \(/W4\) [\#784](https://github.com/nlohmann/json/issues/784)
- Compile error in clang 5.0 [\#782](https://github.com/nlohmann/json/issues/782)
- Error Installing appium\_lib with Ruby v2.4.2 Due to JSON [\#781](https://github.com/nlohmann/json/issues/781)
- ::get\<int\>\(\) fails in new\(er\) release \[MSVC\] [\#780](https://github.com/nlohmann/json/issues/780)
- Type Conversion [\#779](https://github.com/nlohmann/json/issues/779)
- Segfault on nested parsing [\#778](https://github.com/nlohmann/json/issues/778)
- Build warnings: shadowing exception id [\#776](https://github.com/nlohmann/json/issues/776)
- multi-level JSON support. [\#775](https://github.com/nlohmann/json/issues/775)
- SIGABRT on dump\(\) [\#773](https://github.com/nlohmann/json/issues/773)
- \[Question\] Custom StringType template parameter \(possibility for a KeyType template parameter\) [\#772](https://github.com/nlohmann/json/issues/772)
- constexpr ALL the Things! [\#771](https://github.com/nlohmann/json/issues/771)
- error: ‘BasicJsonType’ in namespace ‘::’ does not name a type [\#770](https://github.com/nlohmann/json/issues/770)
- Program calls abort function [\#769](https://github.com/nlohmann/json/issues/769)
- \[Question\] Floating point resolution config during dump\(\) ? [\#768](https://github.com/nlohmann/json/issues/768)
- make check - no test ran [\#767](https://github.com/nlohmann/json/issues/767)
- The library cannot work properly with custom allocator based containers [\#766](https://github.com/nlohmann/json/issues/766)
- Documentation or feature request. [\#763](https://github.com/nlohmann/json/issues/763)
- warnings in msvc about mix/max macro while windows.h is used in the project [\#762](https://github.com/nlohmann/json/issues/762)
- std::signbit ambiguous [\#761](https://github.com/nlohmann/json/issues/761)
- How to use value for std::experimental::optional type? [\#760](https://github.com/nlohmann/json/issues/760)
- Cannot load json file properly [\#759](https://github.com/nlohmann/json/issues/759)
- Compilation error with unordered\_map\< int, int \> [\#758](https://github.com/nlohmann/json/issues/758)
- CBOR string [\#757](https://github.com/nlohmann/json/issues/757)
- Proposal: out\_of\_range should be a subclass of std::out\_of\_range [\#756](https://github.com/nlohmann/json/issues/756)
- Compiling with icpc [\#755](https://github.com/nlohmann/json/issues/755)
- Getter is setting the value to null if the key does not exist [\#754](https://github.com/nlohmann/json/issues/754)
- parsing works sometimes and crashes others [\#752](https://github.com/nlohmann/json/issues/752)
- Static\_assert failed "incompatible pointer type" with Xcode [\#751](https://github.com/nlohmann/json/issues/751)
- user-defined literal operator not found [\#750](https://github.com/nlohmann/json/issues/750)
- getting clean string from it.key\(\) [\#748](https://github.com/nlohmann/json/issues/748)
- Best method for exploring and obtaining values of nested json objects when the names are not known beforehand? [\#747](https://github.com/nlohmann/json/issues/747)
- null char at the end of string [\#746](https://github.com/nlohmann/json/issues/746)
- Incorrect sample for operator \>\> in docs [\#745](https://github.com/nlohmann/json/issues/745)
- User-friendly documentation [\#744](https://github.com/nlohmann/json/issues/744)
- Retrieve all values that match a json path [\#743](https://github.com/nlohmann/json/issues/743)
- Compilation issue with gcc 7.2 [\#742](https://github.com/nlohmann/json/issues/742)
- CMake target nlohmann\_json does not have src into its interface includes [\#741](https://github.com/nlohmann/json/issues/741)
- Error when serializing empty json: type must be string, but is object [\#740](https://github.com/nlohmann/json/issues/740)
- Conversion error for std::map\<int, std::string\>  [\#739](https://github.com/nlohmann/json/issues/739)
- Dumping Json to file as array [\#738](https://github.com/nlohmann/json/issues/738)
- nesting json objects [\#737](https://github.com/nlohmann/json/issues/737)
- where to find general help? [\#736](https://github.com/nlohmann/json/issues/736)
- Compilation Error on Clang 5.0 Upgrade [\#735](https://github.com/nlohmann/json/issues/735)
- Compilation error with std::map\<std::string, std::string\> on vs 2015 [\#734](https://github.com/nlohmann/json/issues/734)
- Benchmarks for Binary formats [\#733](https://github.com/nlohmann/json/issues/733)
- Move test blobs to a submodule? [\#732](https://github.com/nlohmann/json/issues/732)
- Support \n symbols in json string. [\#731](https://github.com/nlohmann/json/issues/731)
- Project's name is too generic and hard to search for [\#730](https://github.com/nlohmann/json/issues/730)
- Visual Studio 2015 IntelliTrace problems [\#729](https://github.com/nlohmann/json/issues/729)
- How to erase nested objects inside other objects? [\#728](https://github.com/nlohmann/json/issues/728)
- How to prevent alphabetical sorting of data? [\#727](https://github.com/nlohmann/json/issues/727)
- Serialization for CBOR [\#726](https://github.com/nlohmann/json/issues/726)
- Using json Object as value in a map [\#725](https://github.com/nlohmann/json/issues/725)
- std::regex and nlohmann::json value [\#724](https://github.com/nlohmann/json/issues/724)
- Warnings when compiling with VisualStudio 2015 [\#723](https://github.com/nlohmann/json/issues/723)
- Has this lib the unicode \(wstring\) support? [\#722](https://github.com/nlohmann/json/issues/722)
- When will be 3.0 in master? [\#721](https://github.com/nlohmann/json/issues/721)
- Determine the type from error message. [\#720](https://github.com/nlohmann/json/issues/720)
- Compile-Error C2100 \(MS VS2015\) in line 887 json.hpp [\#719](https://github.com/nlohmann/json/issues/719)
- from\_json not working for boost::optional example [\#718](https://github.com/nlohmann/json/issues/718)
- about from\_json and to\_json function [\#717](https://github.com/nlohmann/json/issues/717)
- How to deserialize array with derived objects [\#716](https://github.com/nlohmann/json/issues/716)
- How to detect parse failure? [\#715](https://github.com/nlohmann/json/issues/715)
- Parse throw std::ios\_base::failure exception when failbit set to true [\#714](https://github.com/nlohmann/json/issues/714)
- Is there a way of format just making a pretty print without changing the key's orders ? [\#713](https://github.com/nlohmann/json/issues/713)
- Serialization of array of not same model items [\#712](https://github.com/nlohmann/json/issues/712)
- pointer to json parse vector [\#711](https://github.com/nlohmann/json/issues/711)
- Gtest SEH Exception [\#709](https://github.com/nlohmann/json/issues/709)
- broken from\_json implementation for pair and tuple  [\#707](https://github.com/nlohmann/json/issues/707)
- Unevaluated lambda in assert breaks gcc 7 build [\#705](https://github.com/nlohmann/json/issues/705)
- Issues when adding values to firebase database [\#704](https://github.com/nlohmann/json/issues/704)
- Floating point equality - revisited [\#703](https://github.com/nlohmann/json/issues/703)
- Conversion from valarray\<double\> to json fails to build [\#702](https://github.com/nlohmann/json/issues/702)
- internal compiler error \(gcc7\)  [\#701](https://github.com/nlohmann/json/issues/701)
- One build system to rule them all [\#698](https://github.com/nlohmann/json/issues/698)
- Generated nlohmann\_jsonConfig.cmake does not set JSON\_INCLUDE\_DIR [\#695](https://github.com/nlohmann/json/issues/695)
- support the Chinese language in json string [\#694](https://github.com/nlohmann/json/issues/694)
- NaN problem within develop branch [\#693](https://github.com/nlohmann/json/issues/693)
- Please post example of specialization for boost::filesystem [\#692](https://github.com/nlohmann/json/issues/692)
- Impossible to do an array of composite objects [\#691](https://github.com/nlohmann/json/issues/691)
- How to save json to file? [\#690](https://github.com/nlohmann/json/issues/690)
- my simple json parser [\#689](https://github.com/nlohmann/json/issues/689)
- problem with new struct parsing syntax [\#688](https://github.com/nlohmann/json/issues/688)
- Parse error while parse the json string contains  UTF 8 encoded document bytes string [\#684](https://github.com/nlohmann/json/issues/684)
- \[question\] how to get a string value by pointer [\#683](https://github.com/nlohmann/json/issues/683)
- create json object from string variable [\#681](https://github.com/nlohmann/json/issues/681)
- adl\_serializer and CRTP [\#680](https://github.com/nlohmann/json/issues/680)
- Is there a way to control the precision of serialized floating point numbers? [\#677](https://github.com/nlohmann/json/issues/677)
- Is there a way to get the path of a value? [\#676](https://github.com/nlohmann/json/issues/676)
- Could the parser locate errors to line? [\#675](https://github.com/nlohmann/json/issues/675)
- There is performance inefficiency found by coverity tool json2.1.1/include/nlohmann/json.hpp [\#673](https://github.com/nlohmann/json/issues/673)
- include problem, when cmake on osx [\#672](https://github.com/nlohmann/json/issues/672)
- Operator= ambiguous in C++1z and GCC 7.1.1 [\#670](https://github.com/nlohmann/json/issues/670)
- should't the cmake install target be to nlohman/json.hpp [\#668](https://github.com/nlohmann/json/issues/668)
- deserialise from `std::vector` [\#667](https://github.com/nlohmann/json/issues/667)
- How to iterate? [\#665](https://github.com/nlohmann/json/issues/665)
- could this json lib work on windows? [\#664](https://github.com/nlohmann/json/issues/664)
- How does from\_json work? [\#662](https://github.com/nlohmann/json/issues/662)
- insert\(or merge\) object should replace same key , not ignore [\#661](https://github.com/nlohmann/json/issues/661)
- Why is an object ordering values by Alphabetical Order?  [\#660](https://github.com/nlohmann/json/issues/660)
- Parse method doesn't handle newlines. [\#659](https://github.com/nlohmann/json/issues/659)
- Compilation "note" on GCC 6 ARM [\#658](https://github.com/nlohmann/json/issues/658)
- Adding additional push\_back/operator+= rvalue overloads for JSON object [\#657](https://github.com/nlohmann/json/issues/657)
- dump's parameter "ensure\_ascii" creates too long sequences [\#656](https://github.com/nlohmann/json/issues/656)
- Question: parsing `void \*` [\#655](https://github.com/nlohmann/json/issues/655)
- how should I check a string is valid JSON string ? [\#653](https://github.com/nlohmann/json/issues/653)
- Question: thread safety of read only accesses [\#651](https://github.com/nlohmann/json/issues/651)
- Eclipse: Method 'size' could not be resolved [\#649](https://github.com/nlohmann/json/issues/649)
- Update/Add object fields [\#648](https://github.com/nlohmann/json/issues/648)
- No exception raised for Out Of Range input of numbers [\#647](https://github.com/nlohmann/json/issues/647)
- Package Name [\#646](https://github.com/nlohmann/json/issues/646)
- What is the meaning of operator\[\]\(T\* key\) [\#645](https://github.com/nlohmann/json/issues/645)
- Which is the correct way to json objects as parameters to functions? [\#644](https://github.com/nlohmann/json/issues/644)
- Method to get string representations of values [\#642](https://github.com/nlohmann/json/issues/642)
-  CBOR serialization of a given JSON value does not serialize [\#641](https://github.com/nlohmann/json/issues/641)
- Are we forced to use "-fexceptions" flag in android ndk project [\#640](https://github.com/nlohmann/json/issues/640)
- Comparison of objects containing floats [\#639](https://github.com/nlohmann/json/issues/639)
- 'localeconv' is not supported by NDK for SDK  \<=20 [\#638](https://github.com/nlohmann/json/issues/638)
- \[Question\] cLion integration [\#637](https://github.com/nlohmann/json/issues/637)
- How to construct an iteratable usage in nlohmann json? [\#636](https://github.com/nlohmann/json/issues/636)
- \[Question\] copy assign json-container to vector [\#635](https://github.com/nlohmann/json/issues/635)
- Get size without .dump\(\) [\#634](https://github.com/nlohmann/json/issues/634)
- Segmentation fault when parsing invalid json file [\#633](https://github.com/nlohmann/json/issues/633)
- How to serialize from json to vector\<customType\>? [\#632](https://github.com/nlohmann/json/issues/632)
- no member named 'thousands\_sep' in 'lconv' [\#631](https://github.com/nlohmann/json/issues/631)
- \[Question\] Any fork for \(the unsupported\) Visual Studio 2012 version? [\#628](https://github.com/nlohmann/json/issues/628)
- Dependency injection in serializer [\#627](https://github.com/nlohmann/json/issues/627)
- from\_json for std::array [\#625](https://github.com/nlohmann/json/issues/625)
- Discussion: How to structure the parsing function families [\#623](https://github.com/nlohmann/json/issues/623)
- Question: How to erase subtree [\#622](https://github.com/nlohmann/json/issues/622)
- Insertion into nested json field [\#621](https://github.com/nlohmann/json/issues/621)
- \[Question\] When using this as git submodule, will it clone the whole thing include test data and benchmark? [\#620](https://github.com/nlohmann/json/issues/620)
- Question: return static json object from function [\#618](https://github.com/nlohmann/json/issues/618)
- icc16 error [\#617](https://github.com/nlohmann/json/issues/617)
- \[-Wdeprecated-declarations\] in row `j \>\> ss;` in file `json.hpp:7405:26` and FAILED unit tests with MinGWx64! [\#616](https://github.com/nlohmann/json/issues/616)
- to\_json for pairs, tuples [\#614](https://github.com/nlohmann/json/issues/614)
- Using uninitialized memory 'buf' in line 11173 v2.1.1? [\#613](https://github.com/nlohmann/json/issues/613)
- How to parse multiple same Keys of JSON and save them? [\#612](https://github.com/nlohmann/json/issues/612)
- "Multiple declarations" error when using types defined with `typedef` [\#611](https://github.com/nlohmann/json/issues/611)
- 2.1.1+ breaks compilation of shared\_ptr\<json\> == 0 [\#610](https://github.com/nlohmann/json/issues/610)
- a bug of inheritance ?  [\#608](https://github.com/nlohmann/json/issues/608)
- std::map key conversion with to\_json [\#607](https://github.com/nlohmann/json/issues/607)
- json.hpp:6384:62: error: wrong number of template arguments \(1, should be 2\) [\#606](https://github.com/nlohmann/json/issues/606)
- Incremental parsing: Where's the push version? [\#605](https://github.com/nlohmann/json/issues/605)
- Is there a way to validate the structure of a json object ? [\#604](https://github.com/nlohmann/json/issues/604)
- \[Question\] Issue when using Appveyor when compiling library [\#603](https://github.com/nlohmann/json/issues/603)
- BOM not skipped when using json:parse\(iterator\) [\#602](https://github.com/nlohmann/json/issues/602)
- Use of the binary type in CBOR and Message Pack [\#601](https://github.com/nlohmann/json/issues/601)
- Newbie issue: how does one convert a map in Json back to std::map? [\#600](https://github.com/nlohmann/json/issues/600)
- Plugin system [\#599](https://github.com/nlohmann/json/issues/599)
- Feature request: Comments [\#597](https://github.com/nlohmann/json/issues/597)
- Using custom types for scalars? [\#596](https://github.com/nlohmann/json/issues/596)
- Issues with the arithmetic in iterator and reverse iterator [\#593](https://github.com/nlohmann/json/issues/593)
- not enough examples [\#592](https://github.com/nlohmann/json/issues/592)
- in-class initialization for type 'const T' is not yet implemented [\#591](https://github.com/nlohmann/json/issues/591)
- compiling with gcc 7 -\> error on bool operator \< [\#590](https://github.com/nlohmann/json/issues/590)
- Parsing from stream leads to an array [\#589](https://github.com/nlohmann/json/issues/589)
- Buggy support for binary string data [\#587](https://github.com/nlohmann/json/issues/587)
- C++17's ambiguous conversion [\#586](https://github.com/nlohmann/json/issues/586)
- How does the messagepack encoding/decoding compare to msgpack-cpp in terms of performance? [\#585](https://github.com/nlohmann/json/issues/585)
- is it possible to check existence of a value deep in hierarchy? [\#584](https://github.com/nlohmann/json/issues/584)
- loading from a stream and exceptions [\#582](https://github.com/nlohmann/json/issues/582)
- Visual Studio seems not to have all min\(\) function versions [\#581](https://github.com/nlohmann/json/issues/581)
- Supporting of the json schema [\#580](https://github.com/nlohmann/json/issues/580)
- Stack-overflow \(OSS-Fuzz 1444\) [\#577](https://github.com/nlohmann/json/issues/577)
- Heap-buffer-overflow \(OSS-Fuzz 1400\) [\#575](https://github.com/nlohmann/json/issues/575)
- JSON escape quotes [\#574](https://github.com/nlohmann/json/issues/574)
- error: static\_assert failed [\#573](https://github.com/nlohmann/json/issues/573)
- Storing floats, and round trip serialisation/deserialisation diffs [\#572](https://github.com/nlohmann/json/issues/572)
- JSON.getLong produces inconsistent results [\#571](https://github.com/nlohmann/json/issues/571)
- Request: Object.at\(\) with default return value [\#570](https://github.com/nlohmann/json/issues/570)
- Internal structure gets corrupted while parsing [\#569](https://github.com/nlohmann/json/issues/569)
- create template \<typename Iter\> basic\_json from\_cbor\(Iter begin, Iter end\) [\#568](https://github.com/nlohmann/json/issues/568)
- Need to improve ignores.. [\#567](https://github.com/nlohmann/json/issues/567)
- Conan.io [\#566](https://github.com/nlohmann/json/issues/566)
- contradictory documentation regarding json::find [\#565](https://github.com/nlohmann/json/issues/565)
- Unexpected '\"' in middle of array [\#564](https://github.com/nlohmann/json/issues/564)
- Support parse std::pair to Json object [\#563](https://github.com/nlohmann/json/issues/563)
- json and Microsoft Visual c++ Compiler Nov 2012 CTP [\#562](https://github.com/nlohmann/json/issues/562)
- from\_json declaration order and exceptions [\#561](https://github.com/nlohmann/json/issues/561)
- Tip: Don't upgrade to VS2017 if using json initializer list constructs [\#559](https://github.com/nlohmann/json/issues/559)
- parse error - unexpected end of input [\#558](https://github.com/nlohmann/json/issues/558)
- Cant modify existing numbers inside a json object [\#557](https://github.com/nlohmann/json/issues/557)
- Minimal repository \(current size very large\) [\#556](https://github.com/nlohmann/json/issues/556)
- Better support for SAX style serialize and deserialize in new version? [\#554](https://github.com/nlohmann/json/issues/554)
- Cannot convert from json array to std::array [\#553](https://github.com/nlohmann/json/issues/553)
- Do not define an unnamed namespace in a header file \(DCL59-CPP\) [\#552](https://github.com/nlohmann/json/issues/552)
- Parse error on known good json file [\#551](https://github.com/nlohmann/json/issues/551)
- Warning on Intel compiler \(icc 17\) [\#550](https://github.com/nlohmann/json/issues/550)
- multiple versions of 'vsnprintf' [\#549](https://github.com/nlohmann/json/issues/549)
- illegal indirection [\#548](https://github.com/nlohmann/json/issues/548)
- Ambiguous compare operators with clang-5.0 [\#547](https://github.com/nlohmann/json/issues/547)
- Using tsl::ordered\_map [\#546](https://github.com/nlohmann/json/issues/546)
- Compiler support errors are inconvenient [\#544](https://github.com/nlohmann/json/issues/544)
- Head Elements Sorting [\#543](https://github.com/nlohmann/json/issues/543)
- Duplicate symbols error happens while to\_json/from\_json method implemented inside entity definition header file [\#542](https://github.com/nlohmann/json/issues/542)
- consider adding a bool json::is\_valid\(std::string const&\) non-member function [\#541](https://github.com/nlohmann/json/issues/541)
- Help request [\#539](https://github.com/nlohmann/json/issues/539)
- How to deal with missing keys in `from\_json`? [\#538](https://github.com/nlohmann/json/issues/538)
- recursive from\_msgpack implementation will stack overflow [\#537](https://github.com/nlohmann/json/issues/537)
- Exception objects must be nothrow copy constructible \(ERR60-CPP\) [\#531](https://github.com/nlohmann/json/issues/531)
- Support for multiple root elements [\#529](https://github.com/nlohmann/json/issues/529)
- Port has\_shape from dropbox/json11 [\#528](https://github.com/nlohmann/json/issues/528)
- dump\_float: truncation from ptrdiff\_t to long [\#527](https://github.com/nlohmann/json/issues/527)
- Make exception base class visible in basic\_json [\#525](https://github.com/nlohmann/json/issues/525)
- msgpack unit test failures on ppc64 arch [\#524](https://github.com/nlohmann/json/issues/524)
- How about split the implementation out, and only leave the interface? [\#523](https://github.com/nlohmann/json/issues/523)
- VC++2017 not enough actual parameters for macro 'max' [\#522](https://github.com/nlohmann/json/issues/522)
- crash on empty ifstream [\#521](https://github.com/nlohmann/json/issues/521)
- Suggestion: Support tabs for indentation when serializing to stream. [\#520](https://github.com/nlohmann/json/issues/520)
- Abrt in get\_number \(OSS-Fuzz 885\) [\#519](https://github.com/nlohmann/json/issues/519)
- Abrt on unknown address \(OSS-Fuzz 884\) [\#518](https://github.com/nlohmann/json/issues/518)
- Stack-overflow \(OSS-Fuzz 869\) [\#517](https://github.com/nlohmann/json/issues/517)
- Assertion error \(OSS-Fuzz 868\) [\#516](https://github.com/nlohmann/json/issues/516)
- NaN to json and back [\#515](https://github.com/nlohmann/json/issues/515)
- Comparison of NaN [\#514](https://github.com/nlohmann/json/issues/514)
- why it's not possible to serialize c++11 enums directly [\#513](https://github.com/nlohmann/json/issues/513)
- clang compile error: use of overloaded operator '\<=' is ambiguous   with \(nlohmann::json{{"a", 5}}\)\["a"\] \<= 10 [\#512](https://github.com/nlohmann/json/issues/512)
- Why not also look inside the type for \(static\) to\_json and from\_json funtions? [\#511](https://github.com/nlohmann/json/issues/511)
- Parser issues [\#509](https://github.com/nlohmann/json/issues/509)
- I may not understand [\#507](https://github.com/nlohmann/json/issues/507)
- VS2017 min / max problem for 2.1.1 [\#506](https://github.com/nlohmann/json/issues/506)
- CBOR/MessagePack is not read until the end [\#505](https://github.com/nlohmann/json/issues/505)
- Assertion error \(OSS-Fuzz 856\) [\#504](https://github.com/nlohmann/json/issues/504)
- Return position in parse error exceptions [\#503](https://github.com/nlohmann/json/issues/503)
- conversion from/to C array is not supported [\#502](https://github.com/nlohmann/json/issues/502)
- error C2338: could not find to\_json\(\) method in T's namespace [\#501](https://github.com/nlohmann/json/issues/501)
- Test suite fails in en\_GB.UTF-8 [\#500](https://github.com/nlohmann/json/issues/500)
- cannot use operator\[\] with number [\#499](https://github.com/nlohmann/json/issues/499)
- consider using \_\_cpp\_exceptions and/or \_\_EXCEPTIONS to disable/enable exception support [\#498](https://github.com/nlohmann/json/issues/498)
- Stack-overflow \(OSS-Fuzz issue 814\) [\#497](https://github.com/nlohmann/json/issues/497)
- Using in Unreal Engine - handling custom types conversion [\#495](https://github.com/nlohmann/json/issues/495)
- Conversion from vector\<bool\> to json fails to build [\#494](https://github.com/nlohmann/json/issues/494)
- fill\_line\_buffer incorrectly tests m\_stream for eof but not fail or bad bits [\#493](https://github.com/nlohmann/json/issues/493)
- Compiling with \_GLIBCXX\_DEBUG yields iterator-comparison warnings during tests [\#492](https://github.com/nlohmann/json/issues/492)
- crapy interface [\#491](https://github.com/nlohmann/json/issues/491)
- Fix Visual Studo 2013 builds. [\#490](https://github.com/nlohmann/json/issues/490)
- Failed to compile with -D\_GLIBCXX\_PARALLEL [\#489](https://github.com/nlohmann/json/issues/489)
- Input several field with the same name [\#488](https://github.com/nlohmann/json/issues/488)
- read in .json file yields strange sizes [\#487](https://github.com/nlohmann/json/issues/487)
- json::value\_t can't be a map's key type in VC++ 2015 [\#486](https://github.com/nlohmann/json/issues/486)
- Using fifo\_map [\#485](https://github.com/nlohmann/json/issues/485)
- Cannot get float pointer for value stored as `0` [\#484](https://github.com/nlohmann/json/issues/484)
- byte string support [\#483](https://github.com/nlohmann/json/issues/483)
- For a header-only library you have to clone 214MB [\#482](https://github.com/nlohmann/json/issues/482)
- https://github.com/nlohmann/json\#execute-unit-tests [\#481](https://github.com/nlohmann/json/issues/481)
- Remove deprecated constructor basic\_json\(std::istream&\) [\#480](https://github.com/nlohmann/json/issues/480)
- writing the binary json file? [\#479](https://github.com/nlohmann/json/issues/479)
- CBOR/MessagePack from uint8\_t \* and size [\#478](https://github.com/nlohmann/json/issues/478)
- Streaming binary representations  [\#477](https://github.com/nlohmann/json/issues/477)
- Reuse memory in to\_cbor and to\_msgpack functions [\#476](https://github.com/nlohmann/json/issues/476)
- Error Using JSON Library with arrays C++ [\#475](https://github.com/nlohmann/json/issues/475)
- Moving forward to version 3.0.0 [\#474](https://github.com/nlohmann/json/issues/474)
- Inconsistent behavior in conversion to array type [\#473](https://github.com/nlohmann/json/issues/473)
- Create a \[key:member\_pointer\] map to ease parsing custom types [\#471](https://github.com/nlohmann/json/issues/471)
- MSVC 2015 update 2 [\#469](https://github.com/nlohmann/json/issues/469)
- VS2017 implicit to std::string conversion fix. [\#464](https://github.com/nlohmann/json/issues/464)
- How to make sure a string or string literal is a valid JSON? [\#458](https://github.com/nlohmann/json/issues/458)
- basic\_json templated on a "policy" class [\#456](https://github.com/nlohmann/json/issues/456)
- json::value\(const json\_pointer&, ValueType\) requires exceptions to return the default value. [\#440](https://github.com/nlohmann/json/issues/440)
- is it possible merge two json object [\#428](https://github.com/nlohmann/json/issues/428)
- Is it possible to turn this into a shared library? [\#420](https://github.com/nlohmann/json/issues/420)
- Further thoughts on performance improvements [\#418](https://github.com/nlohmann/json/issues/418)
- nan number stored as null [\#388](https://github.com/nlohmann/json/issues/388)
- Behavior of operator\>\> should more closely resemble that of built-in overloads. [\#367](https://github.com/nlohmann/json/issues/367)
- Request: range-based-for over a json-object to expose .first/.second [\#350](https://github.com/nlohmann/json/issues/350)
- feature wish: JSONPath [\#343](https://github.com/nlohmann/json/issues/343)
- UTF-8/Unicode escape and dump [\#330](https://github.com/nlohmann/json/issues/330)
- Serialized value not always can be parsed. [\#329](https://github.com/nlohmann/json/issues/329)
- Is there a way to forward declare nlohmann::json? [\#314](https://github.com/nlohmann/json/issues/314)
- Exception line [\#301](https://github.com/nlohmann/json/issues/301)
- Do not throw exception when default\_value's type does not match the actual type [\#278](https://github.com/nlohmann/json/issues/278)
- dump\(\) method doesn't work with a custom allocator [\#268](https://github.com/nlohmann/json/issues/268)
- Readme documentation enhancements [\#248](https://github.com/nlohmann/json/issues/248)
- Use user-defined exceptions [\#244](https://github.com/nlohmann/json/issues/244)
- Incorrect C++11 allocator model support [\#161](https://github.com/nlohmann/json/issues/161)

- :white\_check\_mark: re-added tests for algorithms [\#879](https://github.com/nlohmann/json/pull/879) ([nlohmann](https://github.com/nlohmann))
- Overworked library toward 3.0.0 release [\#875](https://github.com/nlohmann/json/pull/875) ([nlohmann](https://github.com/nlohmann))
- :rotating\_light: remove C4996 warnings \#872 [\#873](https://github.com/nlohmann/json/pull/873) ([nlohmann](https://github.com/nlohmann))
- :boom: throwing an exception in case dump encounters a non-UTF-8 string \#838 [\#870](https://github.com/nlohmann/json/pull/870) ([nlohmann](https://github.com/nlohmann))
- :memo: fixing documentation \#867 [\#868](https://github.com/nlohmann/json/pull/868) ([nlohmann](https://github.com/nlohmann))
- iter\_impl template conformance with C++17 [\#860](https://github.com/nlohmann/json/pull/860) ([bogemic](https://github.com/bogemic))
- Std allocator conformance cpp17 [\#856](https://github.com/nlohmann/json/pull/856) ([bogemic](https://github.com/bogemic))
- cmake: use BUILD\_INTERFACE/INSTALL\_INTERFACE [\#855](https://github.com/nlohmann/json/pull/855) ([theodelrieu](https://github.com/theodelrieu))
- to/from\_json: add a MSVC-specific static\_assert to force a stacktrace [\#854](https://github.com/nlohmann/json/pull/854) ([theodelrieu](https://github.com/theodelrieu))
- Add .natvis for MSVC debug view [\#844](https://github.com/nlohmann/json/pull/844) ([TinyTinni](https://github.com/TinyTinni))
- Updated hunter package links [\#829](https://github.com/nlohmann/json/pull/829) ([jowr](https://github.com/jowr))
- Typos README [\#811](https://github.com/nlohmann/json/pull/811) ([Itja](https://github.com/Itja))
- add forwarding references to json\_ref constructor [\#807](https://github.com/nlohmann/json/pull/807) ([theodelrieu](https://github.com/theodelrieu))
- Add transparent comparator and perfect forwarding support to find\(\) and count\(\) [\#795](https://github.com/nlohmann/json/pull/795) ([jseward](https://github.com/jseward))
- Error : 'identifier "size\_t" is undefined' in linux [\#793](https://github.com/nlohmann/json/pull/793) ([sonulohani](https://github.com/sonulohani))
- Fix Visual Studio 2017 warnings [\#788](https://github.com/nlohmann/json/pull/788) ([jseward](https://github.com/jseward))
- Fix warning C4706 on Visual Studio 2017 [\#785](https://github.com/nlohmann/json/pull/785) ([jseward](https://github.com/jseward))
- Set GENERATE\_TAGFILE in Doxyfile [\#783](https://github.com/nlohmann/json/pull/783) ([eld00d](https://github.com/eld00d))
- using more CMake [\#765](https://github.com/nlohmann/json/pull/765) ([nlohmann](https://github.com/nlohmann))
- Simplified istream handing \#367 [\#764](https://github.com/nlohmann/json/pull/764) ([pjkundert](https://github.com/pjkundert))
- Add info for the vcpkg package. [\#753](https://github.com/nlohmann/json/pull/753) ([gregmarr](https://github.com/gregmarr))
- fix from\_json implementation for pair/tuple [\#708](https://github.com/nlohmann/json/pull/708) ([theodelrieu](https://github.com/theodelrieu))
- Update json.hpp [\#686](https://github.com/nlohmann/json/pull/686) ([GoWebProd](https://github.com/GoWebProd))
- Remove duplicate word [\#685](https://github.com/nlohmann/json/pull/685) ([daixtrose](https://github.com/daixtrose))
- To fix compilation issue for intel OSX compiler [\#682](https://github.com/nlohmann/json/pull/682) ([kbthomp1](https://github.com/kbthomp1))
- Digraph warning [\#679](https://github.com/nlohmann/json/pull/679) ([traits](https://github.com/traits))
- massage -\> message [\#678](https://github.com/nlohmann/json/pull/678) ([DmitryKuk](https://github.com/DmitryKuk))
- Fix "not constraint" grammar in docs [\#674](https://github.com/nlohmann/json/pull/674) ([wincent](https://github.com/wincent))
- Add documentation for integration with CMake and hunter [\#671](https://github.com/nlohmann/json/pull/671) ([dan-42](https://github.com/dan-42))
- REFACTOR: rewrite CMakeLists.txt for better inlcude and reuse [\#669](https://github.com/nlohmann/json/pull/669) ([dan-42](https://github.com/dan-42))
- enable\_testing only if the JSON\_BuildTests is ON [\#666](https://github.com/nlohmann/json/pull/666) ([effolkronium](https://github.com/effolkronium))
- Support moving from rvalues in std::initializer\_list [\#663](https://github.com/nlohmann/json/pull/663) ([himikof](https://github.com/himikof))
- add ensure\_ascii parameter to dump. \#330 [\#654](https://github.com/nlohmann/json/pull/654) ([ryanjmulder](https://github.com/ryanjmulder))
- Rename BuildTests to JSON\_BuildTests [\#652](https://github.com/nlohmann/json/pull/652) ([olegendo](https://github.com/olegendo))
- Don't include \<iostream\>, use std::make\_shared [\#650](https://github.com/nlohmann/json/pull/650) ([olegendo](https://github.com/olegendo))
- Refacto/split basic json [\#643](https://github.com/nlohmann/json/pull/643) ([theodelrieu](https://github.com/theodelrieu))
- fix typo in operator\_\_notequal example [\#630](https://github.com/nlohmann/json/pull/630) ([Chocobo1](https://github.com/Chocobo1))
- Fix MSVC warning C4819 [\#629](https://github.com/nlohmann/json/pull/629) ([Chocobo1](https://github.com/Chocobo1))
- \[BugFix\] Add parentheses around std::min [\#626](https://github.com/nlohmann/json/pull/626) ([koemeet](https://github.com/koemeet))
- add pair/tuple conversions [\#624](https://github.com/nlohmann/json/pull/624) ([theodelrieu](https://github.com/theodelrieu))
- remove std::pair support [\#615](https://github.com/nlohmann/json/pull/615) ([theodelrieu](https://github.com/theodelrieu))
- Add pair support, fix CompatibleObject conversions \(fixes \#600\) [\#609](https://github.com/nlohmann/json/pull/609) ([theodelrieu](https://github.com/theodelrieu))
- \#550 Fix iterator related compiling issues for Intel icc [\#598](https://github.com/nlohmann/json/pull/598) ([HenryRLee](https://github.com/HenryRLee))
- Issue \#593 Fix the arithmetic operators in the iterator and reverse iterator [\#595](https://github.com/nlohmann/json/pull/595) ([HenryRLee](https://github.com/HenryRLee))
- fix doxygen error of basic\_json::get\(\) [\#583](https://github.com/nlohmann/json/pull/583) ([zhaohuaxishi](https://github.com/zhaohuaxishi))
- Fixing assignement for iterator wrapper second, and adding unit test [\#579](https://github.com/nlohmann/json/pull/579) ([Type1J](https://github.com/Type1J))
- Adding first and second properties to iteration\_proxy\_internal [\#578](https://github.com/nlohmann/json/pull/578) ([Type1J](https://github.com/Type1J))
- Adding support for Meson. [\#576](https://github.com/nlohmann/json/pull/576) ([Type1J](https://github.com/Type1J))
- add enum class default conversions [\#545](https://github.com/nlohmann/json/pull/545) ([theodelrieu](https://github.com/theodelrieu))
- Properly pop diagnostics [\#540](https://github.com/nlohmann/json/pull/540) ([tinloaf](https://github.com/tinloaf))
- Add Visual Studio 17 image to appveyor build matrix [\#536](https://github.com/nlohmann/json/pull/536) ([vpetrigo](https://github.com/vpetrigo))
- UTF8 encoding enhancement [\#534](https://github.com/nlohmann/json/pull/534) ([TedLyngmo](https://github.com/TedLyngmo))
- Fix typo [\#530](https://github.com/nlohmann/json/pull/530) ([berkus](https://github.com/berkus))
- Make exception base class visible in basic\_json [\#526](https://github.com/nlohmann/json/pull/526) ([krzysztofwos](https://github.com/krzysztofwos))
- :art: Namespace `uint8\_t` from the C++ stdlib [\#510](https://github.com/nlohmann/json/pull/510) ([alex-weej](https://github.com/alex-weej))
- add to\_json method for C arrays [\#508](https://github.com/nlohmann/json/pull/508) ([theodelrieu](https://github.com/theodelrieu))
- Fix -Weffc++ warnings \(GNU 6.3.1\) [\#496](https://github.com/nlohmann/json/pull/496) ([TedLyngmo](https://github.com/TedLyngmo))

## [v2.1.1](https://github.com/nlohmann/json/releases/tag/v2.1.1) (2017-02-25)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.1.0...v2.1.1)

- warning in the library [\#472](https://github.com/nlohmann/json/issues/472)
- How to create an array of Objects? [\#470](https://github.com/nlohmann/json/issues/470)
- \[Bug?\] Cannot get int pointer, but int64\_t works [\#468](https://github.com/nlohmann/json/issues/468)
- Illegal indirection [\#467](https://github.com/nlohmann/json/issues/467)
- in vs can't find linkageId   [\#466](https://github.com/nlohmann/json/issues/466)
- Roundtrip error while parsing "1000000000000000010E5" [\#465](https://github.com/nlohmann/json/issues/465)
- C4996 error and warning with Visual Studio [\#463](https://github.com/nlohmann/json/issues/463)
- Support startIndex for from\_cbor/from\_msgpack [\#462](https://github.com/nlohmann/json/issues/462)
- question: monospace font used in feature slideshow? [\#460](https://github.com/nlohmann/json/issues/460)
- Object.keys\(\) [\#459](https://github.com/nlohmann/json/issues/459)
- Use “, “ as delimiter for json-objects. [\#457](https://github.com/nlohmann/json/issues/457)
- Enum -\> string during serialization and vice versa [\#455](https://github.com/nlohmann/json/issues/455)
- doubles are printed as integers [\#454](https://github.com/nlohmann/json/issues/454)
- Warnings with Visual Studio c++ \(VS2015 Update 3\) [\#453](https://github.com/nlohmann/json/issues/453)
- Heap-buffer-overflow \(OSS-Fuzz issue 585\) [\#452](https://github.com/nlohmann/json/issues/452)
- use of undeclared identifier 'UINT8\_MAX' [\#451](https://github.com/nlohmann/json/issues/451)
- Question on the lifetime managment of objects at the lower levels [\#449](https://github.com/nlohmann/json/issues/449)
- Json should not be constructible with 'json\*' [\#448](https://github.com/nlohmann/json/issues/448)
- Move value\_t to namespace scope [\#447](https://github.com/nlohmann/json/issues/447)
- Typo in README.md [\#446](https://github.com/nlohmann/json/issues/446)
- make check compilation is unneccesarily slow [\#445](https://github.com/nlohmann/json/issues/445)
- Problem in dump\(\) in json.h caused by ss.imbue [\#444](https://github.com/nlohmann/json/issues/444)
- I want to create Windows Application in Visual Studio 2015 c++, and i have a problem [\#443](https://github.com/nlohmann/json/issues/443)
- Implicit conversion issues [\#442](https://github.com/nlohmann/json/issues/442)
- Parsing of floats locale dependent [\#302](https://github.com/nlohmann/json/issues/302)

- Speedup CI builds using cotire [\#461](https://github.com/nlohmann/json/pull/461) ([tusharpm](https://github.com/tusharpm))
- TurpentineDistillery feature/locale independent str to num [\#450](https://github.com/nlohmann/json/pull/450) ([nlohmann](https://github.com/nlohmann))
- README: adjust boost::optional example [\#439](https://github.com/nlohmann/json/pull/439) ([jaredgrubb](https://github.com/jaredgrubb))
- fix \#414 - comparing to 0 literal [\#415](https://github.com/nlohmann/json/pull/415) ([stanmihai4](https://github.com/stanmihai4))

## [v2.1.0](https://github.com/nlohmann/json/releases/tag/v2.1.0) (2017-01-28)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.10...v2.1.0)

- Parsing multiple JSON objects from a string or stream [\#438](https://github.com/nlohmann/json/issues/438)
- Use-of-uninitialized-value \(OSS-Fuzz issue 477\) [\#437](https://github.com/nlohmann/json/issues/437)
- add `reserve` function for array to reserve memory before adding json values into it [\#436](https://github.com/nlohmann/json/issues/436)
- Typo in examples page [\#434](https://github.com/nlohmann/json/issues/434)
- avoid malformed json [\#433](https://github.com/nlohmann/json/issues/433)
- How to add json objects to a map? [\#432](https://github.com/nlohmann/json/issues/432)
- create json instance from raw json \(unsigned char\*\) [\#431](https://github.com/nlohmann/json/issues/431)
- Getting std::invalid\_argument: stream error when following example [\#429](https://github.com/nlohmann/json/issues/429)
- Forward declare-only header? [\#427](https://github.com/nlohmann/json/issues/427)
- Implicit conversion from array to object [\#425](https://github.com/nlohmann/json/issues/425)
- Automatic ordered JSON [\#424](https://github.com/nlohmann/json/issues/424)
- error C4996: 'strerror' when reading file [\#422](https://github.com/nlohmann/json/issues/422)
- Get an error - JSON pointer must be empty or begin with '/' [\#421](https://github.com/nlohmann/json/issues/421)
- size parameter for parse\(\) [\#419](https://github.com/nlohmann/json/issues/419)
- json.hpp forcibly defines GCC\_VERSION [\#417](https://github.com/nlohmann/json/issues/417)
- Use-of-uninitialized-value \(OSS-Fuzz issue 377\) [\#416](https://github.com/nlohmann/json/issues/416)
- comparing to 0 literal [\#414](https://github.com/nlohmann/json/issues/414)
- Single char converted to ASCII code instead of string [\#413](https://github.com/nlohmann/json/issues/413)
- How to know if a string  was parsed as utf-8? [\#406](https://github.com/nlohmann/json/issues/406)
- Overloaded += to add objects to an array makes no sense? [\#404](https://github.com/nlohmann/json/issues/404)
- Finding a value in an array [\#399](https://github.com/nlohmann/json/issues/399)
- add release information in static function [\#397](https://github.com/nlohmann/json/issues/397)
- Optimize memory usage of json objects in combination with binary serialization [\#373](https://github.com/nlohmann/json/issues/373)
- Conversion operators not considered [\#369](https://github.com/nlohmann/json/issues/369)
- Append ".0" to serialized floating\_point values that are digits-only. [\#362](https://github.com/nlohmann/json/issues/362)
- Add a customization point for user-defined types [\#328](https://github.com/nlohmann/json/issues/328)
- Conformance report for reference [\#307](https://github.com/nlohmann/json/issues/307)
- Document the best way to serialize/deserialize user defined types to json [\#298](https://github.com/nlohmann/json/issues/298)
- Add StringView template typename to basic\_json [\#297](https://github.com/nlohmann/json/issues/297)
- \[Improvement\] Add option to remove exceptions [\#296](https://github.com/nlohmann/json/issues/296)
- Performance in miloyip/nativejson-benchmark [\#202](https://github.com/nlohmann/json/issues/202)

- conversion from/to user-defined types [\#435](https://github.com/nlohmann/json/pull/435) ([nlohmann](https://github.com/nlohmann))
- Fix documentation error [\#430](https://github.com/nlohmann/json/pull/430) ([vjon](https://github.com/vjon))
- locale-independent num-to-str [\#378](https://github.com/nlohmann/json/pull/378) ([TurpentineDistillery](https://github.com/TurpentineDistillery))

## [v2.0.10](https://github.com/nlohmann/json/releases/tag/v2.0.10) (2017-01-02)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.9...v2.0.10)

- Heap-buffer-overflow \(OSS-Fuzz issue 367\) [\#412](https://github.com/nlohmann/json/issues/412)
- Heap-buffer-overflow \(OSS-Fuzz issue 366\) [\#411](https://github.com/nlohmann/json/issues/411)
- Use-of-uninitialized-value \(OSS-Fuzz issue 347\) [\#409](https://github.com/nlohmann/json/issues/409)
- Heap-buffer-overflow \(OSS-Fuzz issue 344\) [\#408](https://github.com/nlohmann/json/issues/408)
- Heap-buffer-overflow \(OSS-Fuzz issue 343\) [\#407](https://github.com/nlohmann/json/issues/407)
- Heap-buffer-overflow \(OSS-Fuzz issue 342\) [\#405](https://github.com/nlohmann/json/issues/405)
- strerror throwing error in compiler VS2015 [\#403](https://github.com/nlohmann/json/issues/403)
- json::parse of std::string being underlined by Visual Studio [\#402](https://github.com/nlohmann/json/issues/402)
- Explicitly getting string without .dump\(\)  [\#401](https://github.com/nlohmann/json/issues/401)
- Possible to speed up json::parse? [\#398](https://github.com/nlohmann/json/issues/398)
- the alphabetic order in the code influence console\_output. [\#396](https://github.com/nlohmann/json/issues/396)
- Execute tests with clang sanitizers [\#394](https://github.com/nlohmann/json/issues/394)
- Check if library can be used with ETL [\#361](https://github.com/nlohmann/json/issues/361)

- Feature/clang sanitize [\#410](https://github.com/nlohmann/json/pull/410) ([Daniel599](https://github.com/Daniel599))
- Add Doozer build badge [\#400](https://github.com/nlohmann/json/pull/400) ([andoma](https://github.com/andoma))

## [v2.0.9](https://github.com/nlohmann/json/releases/tag/v2.0.9) (2016-12-16)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.8...v2.0.9)

- \#pragma GCC diagnostic ignored "-Wdocumentation" [\#393](https://github.com/nlohmann/json/issues/393)
- How to parse this json file and write separate sub object as json files? [\#392](https://github.com/nlohmann/json/issues/392)
- Integer-overflow \(OSS-Fuzz issue 267\) [\#389](https://github.com/nlohmann/json/issues/389)
- Implement indefinite-length types from RFC 7049 [\#387](https://github.com/nlohmann/json/issues/387)
- template parameter "T" is not used in declaring the parameter types of function template [\#386](https://github.com/nlohmann/json/issues/386)
- Serializing json instances containing already serialized string values without escaping [\#385](https://github.com/nlohmann/json/issues/385)
- Add test cases from RFC 7049 [\#384](https://github.com/nlohmann/json/issues/384)
- Add a table of contents to the README file [\#383](https://github.com/nlohmann/json/issues/383)
- Update FAQ section in the guidelines for contributing [\#382](https://github.com/nlohmann/json/issues/382)
- Allow for forward declaring nlohmann::json [\#381](https://github.com/nlohmann/json/issues/381)
- Bug in overflow detection when parsing integers [\#380](https://github.com/nlohmann/json/issues/380)
- A unique name to mention the library? [\#377](https://github.com/nlohmann/json/issues/377)
- Support for comments. [\#376](https://github.com/nlohmann/json/issues/376)
- Non-unique keys in objects. [\#375](https://github.com/nlohmann/json/issues/375)
- Request: binary serialization/deserialization [\#358](https://github.com/nlohmann/json/issues/358)

- Replace class iterator and const\_iterator by using a single template class to reduce code. [\#395](https://github.com/nlohmann/json/pull/395) ([Bosswestfalen](https://github.com/Bosswestfalen))
- Clang: quiet a warning [\#391](https://github.com/nlohmann/json/pull/391) ([jaredgrubb](https://github.com/jaredgrubb))
- Fix issue \#380: Signed integer overflow check [\#390](https://github.com/nlohmann/json/pull/390) ([qwename](https://github.com/qwename))

## [v2.0.8](https://github.com/nlohmann/json/releases/tag/v2.0.8) (2016-12-02)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.7...v2.0.8)

- Reading from file [\#374](https://github.com/nlohmann/json/issues/374)
- Compiler warnings? [\#372](https://github.com/nlohmann/json/issues/372)
- docs: how to release a json object in memory? [\#371](https://github.com/nlohmann/json/issues/371)
- crash in dump [\#370](https://github.com/nlohmann/json/issues/370)
- Coverity issue \(FORWARD\_NULL\) in lexer\(std::istream& s\) [\#368](https://github.com/nlohmann/json/issues/368)
- json::parse on failed stream gets stuck [\#366](https://github.com/nlohmann/json/issues/366)
- Performance improvements [\#365](https://github.com/nlohmann/json/issues/365)
- 'to\_string' is not a member of 'std'  [\#364](https://github.com/nlohmann/json/issues/364)
- Optional comment support. [\#363](https://github.com/nlohmann/json/issues/363)
- Crash in dump\(\) from a static object [\#359](https://github.com/nlohmann/json/issues/359)
- json::parse\(...\) vs json j; j.parse\(...\) [\#357](https://github.com/nlohmann/json/issues/357)
- Hi, is there any method to dump  json to string with the insert order rather than alphabets [\#356](https://github.com/nlohmann/json/issues/356)
- Provide an example of reading from an json with only a key that has an array of strings. [\#354](https://github.com/nlohmann/json/issues/354)
- Request: access with default value. [\#353](https://github.com/nlohmann/json/issues/353)
- {} and \[\] causes parser error. [\#352](https://github.com/nlohmann/json/issues/352)
- Reading a JSON file into a JSON object [\#351](https://github.com/nlohmann/json/issues/351)
- Request: 'emplace\_back' [\#349](https://github.com/nlohmann/json/issues/349)
- Is it possible to stream data through the json parser without storing everything in memory? [\#347](https://github.com/nlohmann/json/issues/347)
- pure virtual conversion operator [\#346](https://github.com/nlohmann/json/issues/346)
- Floating point precision lost [\#345](https://github.com/nlohmann/json/issues/345)
- unit-conversions SIGSEGV on armv7hl [\#303](https://github.com/nlohmann/json/issues/303)
- Coverity scan fails [\#299](https://github.com/nlohmann/json/issues/299)
- Using QString as string type [\#274](https://github.com/nlohmann/json/issues/274)

## [v2.0.7](https://github.com/nlohmann/json/releases/tag/v2.0.7) (2016-11-02)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.6...v2.0.7)

- JSON5 [\#348](https://github.com/nlohmann/json/issues/348)
- Check "Parsing JSON is a Minefield" [\#344](https://github.com/nlohmann/json/issues/344)
- Allow hex numbers [\#342](https://github.com/nlohmann/json/issues/342)
- Convert strings to numbers [\#341](https://github.com/nlohmann/json/issues/341)
- ""-operators ignore the length parameter [\#340](https://github.com/nlohmann/json/issues/340)
- JSON into std::tuple [\#339](https://github.com/nlohmann/json/issues/339)
- JSON into vector [\#335](https://github.com/nlohmann/json/issues/335)
- Installing with Homebrew on Mac Errors \(El Capitan\) [\#331](https://github.com/nlohmann/json/issues/331)
- g++ make check results in error [\#312](https://github.com/nlohmann/json/issues/312)
- Cannot convert from 'json' to 'char' [\#276](https://github.com/nlohmann/json/issues/276)
- Please add a Pretty-Print option for arrays to stay always in one line [\#229](https://github.com/nlohmann/json/issues/229)
- Conversion to STL map\<string, vector\<int\>\> gives error [\#220](https://github.com/nlohmann/json/issues/220)
- std::unorderd\_map cannot be used as ObjectType [\#164](https://github.com/nlohmann/json/issues/164)

- fix minor grammar/style issue in README.md [\#336](https://github.com/nlohmann/json/pull/336) ([seeekr](https://github.com/seeekr))

## [v2.0.6](https://github.com/nlohmann/json/releases/tag/v2.0.6) (2016-10-15)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.5...v2.0.6)

- How to handle json files? [\#333](https://github.com/nlohmann/json/issues/333)
- This file requires compiler and library support .... [\#332](https://github.com/nlohmann/json/issues/332)
- Segmentation fault on saving json to file [\#326](https://github.com/nlohmann/json/issues/326)
- parse error - unexpected \<uninitialized\> with 2.0.5 [\#325](https://github.com/nlohmann/json/issues/325)
- Add nested object capability to pointers [\#323](https://github.com/nlohmann/json/issues/323)
- Fix usage examples' comments for std::multiset [\#322](https://github.com/nlohmann/json/issues/322)
- json\_unit runs forever when executed in build directory [\#319](https://github.com/nlohmann/json/issues/319)
- Visual studio 2015 update3 true != TRUE [\#317](https://github.com/nlohmann/json/issues/317)
- releasing single header file in compressed format [\#316](https://github.com/nlohmann/json/issues/316)
- json object from std::ifstream [\#315](https://github.com/nlohmann/json/issues/315)

- make has\_mapped\_type struct friendly [\#324](https://github.com/nlohmann/json/pull/324) ([vpetrigo](https://github.com/vpetrigo))
- Fix usage examples' comments for std::multiset [\#321](https://github.com/nlohmann/json/pull/321) ([vasild](https://github.com/vasild))
- Include dir relocation [\#318](https://github.com/nlohmann/json/pull/318) ([ChristophJud](https://github.com/ChristophJud))
- trivial documentation fix [\#313](https://github.com/nlohmann/json/pull/313) ([5tefan](https://github.com/5tefan))

## [v2.0.5](https://github.com/nlohmann/json/releases/tag/v2.0.5) (2016-09-14)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.4...v2.0.5)

- \[feature request\]: schema validator and comments [\#311](https://github.com/nlohmann/json/issues/311)
- make json\_benchmarks no longer working in 2.0.4 [\#310](https://github.com/nlohmann/json/issues/310)
- Segmentation fault \(core dumped\) [\#309](https://github.com/nlohmann/json/issues/309)
- No matching member function for call to 'get\_impl' [\#308](https://github.com/nlohmann/json/issues/308)

## [v2.0.4](https://github.com/nlohmann/json/releases/tag/v2.0.4) (2016-09-11)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.3...v2.0.4)

- Parsing fails without space at end of file [\#306](https://github.com/nlohmann/json/issues/306)
- json schema validator [\#305](https://github.com/nlohmann/json/issues/305)
- Unused variable warning [\#304](https://github.com/nlohmann/json/issues/304)

## [v2.0.3](https://github.com/nlohmann/json/releases/tag/v2.0.3) (2016-08-31)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.2...v2.0.3)

- warning C4706: assignment within conditional expression [\#295](https://github.com/nlohmann/json/issues/295)
- Strip comments / Minify [\#294](https://github.com/nlohmann/json/issues/294)
- Q: Is it possible to build json tree from already UTF8 encoded values? [\#293](https://github.com/nlohmann/json/issues/293)
- Equality operator results in array when assigned object [\#292](https://github.com/nlohmann/json/issues/292)
- Support for integers not from the range \[-\(2\*\*53\)+1, \(2\*\*53\)-1\] in parser [\#291](https://github.com/nlohmann/json/issues/291)
- Support for iterator-range parsing [\#290](https://github.com/nlohmann/json/issues/290)
- Horribly inconsistent behavior between const/non-const reference in operator \[\] \(\) [\#289](https://github.com/nlohmann/json/issues/289)
- Silently get numbers into smaller types [\#288](https://github.com/nlohmann/json/issues/288)
- Incorrect parsing of large int64\_t numbers [\#287](https://github.com/nlohmann/json/issues/287)
- \[question\]: macro to disable floating point support [\#284](https://github.com/nlohmann/json/issues/284)

- unit-constructor1.cpp: Fix floating point truncation warning [\#300](https://github.com/nlohmann/json/pull/300) ([t-b](https://github.com/t-b))

## [v2.0.2](https://github.com/nlohmann/json/releases/tag/v2.0.2) (2016-07-31)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.1...v2.0.2)

- can function dump\(\)  return string in the order I push in the json object ? [\#286](https://github.com/nlohmann/json/issues/286)
- Error on the Mac: Undefined symbols for architecture x86\_64 [\#285](https://github.com/nlohmann/json/issues/285)
- value\(\) does not work with \_json\_pointer types [\#283](https://github.com/nlohmann/json/issues/283)
- Build error for std::int64 [\#282](https://github.com/nlohmann/json/issues/282)
- strings can't be accessed after dump\(\)-\>parse\(\) - type is lost [\#281](https://github.com/nlohmann/json/issues/281)
- Easy serialization of classes [\#280](https://github.com/nlohmann/json/issues/280)
- recursive data structures [\#277](https://github.com/nlohmann/json/issues/277)
- hexify\(\) function emits conversion warning [\#270](https://github.com/nlohmann/json/issues/270)

- let the makefile choose the correct sed [\#279](https://github.com/nlohmann/json/pull/279) ([murinicanor](https://github.com/murinicanor))
- Update hexify to use array lookup instead of ternary \(\#270\) [\#275](https://github.com/nlohmann/json/pull/275) ([dtoma](https://github.com/dtoma))

## [v2.0.1](https://github.com/nlohmann/json/releases/tag/v2.0.1) (2016-06-28)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.0...v2.0.1)

- Compilation error. [\#273](https://github.com/nlohmann/json/issues/273)
- dump\(\) performance degradation in v2 [\#272](https://github.com/nlohmann/json/issues/272)

- fixed a tiny typo [\#271](https://github.com/nlohmann/json/pull/271) ([feroldi](https://github.com/feroldi))

## [v2.0.0](https://github.com/nlohmann/json/releases/tag/v2.0.0) (2016-06-23)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.1.0...v2.0.0)

- json::diff generates incorrect patch when removing multiple array elements. [\#269](https://github.com/nlohmann/json/issues/269)
- Docs - What does Json\[key\] return? [\#267](https://github.com/nlohmann/json/issues/267)
- Compiler Errors With JSON.hpp [\#265](https://github.com/nlohmann/json/issues/265)
- Throw exception instead of crashing my app [\#264](https://github.com/nlohmann/json/issues/264)
- Ambiguous push\_back and operator+= overloads [\#263](https://github.com/nlohmann/json/issues/263)
- Preseving order of items in json [\#262](https://github.com/nlohmann/json/issues/262)
- '\' char problem in strings [\#261](https://github.com/nlohmann/json/issues/261)
- VS2015 compile fail [\#260](https://github.com/nlohmann/json/issues/260)
- -Wconversion warning [\#259](https://github.com/nlohmann/json/issues/259)
- Maybe a bug [\#258](https://github.com/nlohmann/json/issues/258)
- Few tests failed on Visual C++ 2015 [\#257](https://github.com/nlohmann/json/issues/257)
- Access keys when iteration with new for loop C++11 [\#256](https://github.com/nlohmann/json/issues/256)
- multiline text values [\#255](https://github.com/nlohmann/json/issues/255)
- Error when using json in g++ [\#254](https://github.com/nlohmann/json/issues/254)
- is the release 2.0? [\#253](https://github.com/nlohmann/json/issues/253)
- concatenate objects [\#252](https://github.com/nlohmann/json/issues/252)
- Encoding [\#251](https://github.com/nlohmann/json/issues/251)
- Unable to build example for constructing json object with stringstreams [\#250](https://github.com/nlohmann/json/issues/250)
- Hexadecimal support [\#249](https://github.com/nlohmann/json/issues/249)
- Update long-term goals [\#246](https://github.com/nlohmann/json/issues/246)
- Contribution To This Json Project [\#245](https://github.com/nlohmann/json/issues/245)
- Trouble using parser with initial dictionary [\#243](https://github.com/nlohmann/json/issues/243)
- Unit test fails when doing a CMake out-of-tree build [\#241](https://github.com/nlohmann/json/issues/241)
- -Wconversion warnings [\#239](https://github.com/nlohmann/json/issues/239)
- Additional integration options [\#237](https://github.com/nlohmann/json/issues/237)
- .get\<std::string\>\(\) works for non spaced string but returns as array for spaced/longer strings [\#236](https://github.com/nlohmann/json/issues/236)
- ambiguous overload for 'push\_back' and 'operator+=' [\#235](https://github.com/nlohmann/json/issues/235)
- Can't use basic\_json::iterator as a base iterator for std::move\_iterator [\#233](https://github.com/nlohmann/json/issues/233)
- json object's creation can freezes execution [\#231](https://github.com/nlohmann/json/issues/231)
- Incorrect dumping of parsed numbers with exponents, but without decimal places [\#230](https://github.com/nlohmann/json/issues/230)
- double values are serialized with commas as decimal points [\#228](https://github.com/nlohmann/json/issues/228)
- Move semantics with std::initializer\_list [\#225](https://github.com/nlohmann/json/issues/225)
- replace emplace [\#224](https://github.com/nlohmann/json/issues/224)
- abort during getline in yyfill [\#223](https://github.com/nlohmann/json/issues/223)
- free\(\): invalid pointer error in GCC 5.2.1 [\#221](https://github.com/nlohmann/json/issues/221)
- Error compile Android NDK  error: 'strtof' is not a member of 'std' [\#219](https://github.com/nlohmann/json/issues/219)
- Wrong link in the README.md [\#217](https://github.com/nlohmann/json/issues/217)
- Wide character strings not supported [\#216](https://github.com/nlohmann/json/issues/216)
- Memory allocations using range-based for loops [\#214](https://github.com/nlohmann/json/issues/214)
- would you like to support gcc 4.8.1?  [\#211](https://github.com/nlohmann/json/issues/211)
- Reading concatenated json's from an istream [\#210](https://github.com/nlohmann/json/issues/210)
- Conflicting typedef of ssize\_t on Windows 32 bit when using Boost.Python [\#204](https://github.com/nlohmann/json/issues/204)
- Inconsistency between operator\[\] and push\_back [\#203](https://github.com/nlohmann/json/issues/203)
- Small bugs in json.hpp \(get\_number\) and unit.cpp \(non-standard integer type test\) [\#199](https://github.com/nlohmann/json/issues/199)
- GCC/clang floating point parsing bug in strtod\(\) [\#195](https://github.com/nlohmann/json/issues/195)
- What is within scope? [\#192](https://github.com/nlohmann/json/issues/192)
- Bugs in miloyip/nativejson-benchmark: roundtrips [\#187](https://github.com/nlohmann/json/issues/187)
- Floating point exceptions [\#181](https://github.com/nlohmann/json/issues/181)
- Integer conversion to unsigned [\#178](https://github.com/nlohmann/json/issues/178)
- map string string fails to compile [\#176](https://github.com/nlohmann/json/issues/176)
- In basic\_json::basic\_json\(const CompatibleArrayType& val\), the requirement of CompatibleArrayType is not strict enough. [\#174](https://github.com/nlohmann/json/issues/174)
- Provide a FAQ [\#163](https://github.com/nlohmann/json/issues/163)
- Implicit assignment to std::string fails [\#144](https://github.com/nlohmann/json/issues/144)

- Fix Issue \#265 [\#266](https://github.com/nlohmann/json/pull/266) ([06needhamt](https://github.com/06needhamt))
- Define CMake/CTest tests [\#247](https://github.com/nlohmann/json/pull/247) ([robertmrk](https://github.com/robertmrk))
- Out of tree builds and a few other miscellaneous CMake cleanups. [\#242](https://github.com/nlohmann/json/pull/242) ([ChrisKitching](https://github.com/ChrisKitching))
- Implement additional integration options [\#238](https://github.com/nlohmann/json/pull/238) ([robertmrk](https://github.com/robertmrk))
- make serialization locale-independent [\#232](https://github.com/nlohmann/json/pull/232) ([nlohmann](https://github.com/nlohmann))
- fixes \#223 by updating README.md [\#227](https://github.com/nlohmann/json/pull/227) ([kevin--](https://github.com/kevin--))
- Use namespace std for int64\_t and uint64\_t [\#226](https://github.com/nlohmann/json/pull/226) ([lv-zheng](https://github.com/lv-zheng))
- Added missing cerrno header to fix ERANGE compile error on android [\#222](https://github.com/nlohmann/json/pull/222) ([Teemperor](https://github.com/Teemperor))
- Corrected readme [\#218](https://github.com/nlohmann/json/pull/218) ([Annihil](https://github.com/Annihil))
- Create PULL\_REQUEST\_TEMPLATE.md [\#213](https://github.com/nlohmann/json/pull/213) ([whackashoe](https://github.com/whackashoe))
- fixed noexcept; added constexpr [\#208](https://github.com/nlohmann/json/pull/208) ([nlohmann](https://github.com/nlohmann))
- Add support for afl-fuzz testing [\#207](https://github.com/nlohmann/json/pull/207) ([mykter](https://github.com/mykter))
- replaced ssize\_t occurrences with auto \(addresses \#204\) [\#205](https://github.com/nlohmann/json/pull/205) ([nlohmann](https://github.com/nlohmann))
- Fixed issue \#199 - Small bugs in json.hpp \(get\_number\) and unit.cpp \(non-standard integer type test\) [\#200](https://github.com/nlohmann/json/pull/200) ([twelsby](https://github.com/twelsby))
- Fix broken link [\#197](https://github.com/nlohmann/json/pull/197) ([vog](https://github.com/vog))
- Issue \#195 - update Travis to Trusty due to gcc/clang strtod\(\) bug [\#196](https://github.com/nlohmann/json/pull/196) ([twelsby](https://github.com/twelsby))
- Issue \#178 - Extending support to full uint64\_t/int64\_t range and unsigned type \(updated\) [\#193](https://github.com/nlohmann/json/pull/193) ([twelsby](https://github.com/twelsby))

## [v1.1.0](https://github.com/nlohmann/json/releases/tag/v1.1.0) (2016-01-24)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.0.0...v1.1.0)

- Small error in pull \#185 [\#194](https://github.com/nlohmann/json/issues/194)
- Bugs in miloyip/nativejson-benchmark: floating-point parsing [\#186](https://github.com/nlohmann/json/issues/186)
- Floating point equality [\#185](https://github.com/nlohmann/json/issues/185)
- Unused variables in catch [\#180](https://github.com/nlohmann/json/issues/180)
- Typo in documentation [\#179](https://github.com/nlohmann/json/issues/179)
- JSON performance benchmark comparision [\#177](https://github.com/nlohmann/json/issues/177)
- Since re2c is often ignored in pull requests, it may make sense to make a contributing.md file [\#175](https://github.com/nlohmann/json/issues/175)
- Question about exceptions [\#173](https://github.com/nlohmann/json/issues/173)
- Android? [\#172](https://github.com/nlohmann/json/issues/172)
- Cannot index by key of type static constexpr const char\* [\#171](https://github.com/nlohmann/json/issues/171)
- Add assertions [\#168](https://github.com/nlohmann/json/issues/168)
- MSVC 2015 build fails when attempting to compare object\_t [\#167](https://github.com/nlohmann/json/issues/167)
- Member detector is not portable [\#166](https://github.com/nlohmann/json/issues/166)
- Unnecessary const\_cast [\#162](https://github.com/nlohmann/json/issues/162)
- Question about get\_ref\(\) [\#128](https://github.com/nlohmann/json/issues/128)
- range based for loop for objects [\#83](https://github.com/nlohmann/json/issues/83)
- Consider submitting this to the Boost Library Incubator [\#66](https://github.com/nlohmann/json/issues/66)

- Fixed Issue \#186 - add strto\(f|d|ld\) overload wrappers, "-0.0" special case and FP trailing zero [\#191](https://github.com/nlohmann/json/pull/191) ([twelsby](https://github.com/twelsby))
- Issue \#185 - remove approx\(\) and use \#pragma to kill warnings [\#190](https://github.com/nlohmann/json/pull/190) ([twelsby](https://github.com/twelsby))
- Fixed Issue \#171 - added two extra template overloads of operator\[\] for T\* arguments [\#189](https://github.com/nlohmann/json/pull/189) ([twelsby](https://github.com/twelsby))
- Fixed issue \#167 - removed operator ValueType\(\) condition for VS2015 [\#188](https://github.com/nlohmann/json/pull/188) ([twelsby](https://github.com/twelsby))
- Implementation of get\_ref\(\) [\#184](https://github.com/nlohmann/json/pull/184) ([dariomt](https://github.com/dariomt))
- Fixed some typos in CONTRIBUTING.md [\#182](https://github.com/nlohmann/json/pull/182) ([nibroc](https://github.com/nibroc))

## [v1.0.0](https://github.com/nlohmann/json/releases/tag/v1.0.0) (2015-12-27)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.0.0-rc1...v1.0.0)

- add key name to exception [\#160](https://github.com/nlohmann/json/issues/160)
- Getting member discarding qualifyer [\#159](https://github.com/nlohmann/json/issues/159)
- basic\_json::iterator::value\(\) output includes quotes while basic\_json::iterator::key\(\) doesn't [\#158](https://github.com/nlohmann/json/issues/158)
- Indexing `const basic\_json\<\>` with `const basic\_string\<char\>` [\#157](https://github.com/nlohmann/json/issues/157)
- token\_type\_name\(token\_type t\): not all control paths return a value [\#156](https://github.com/nlohmann/json/issues/156)
- prevent json.hpp from emitting compiler warnings [\#154](https://github.com/nlohmann/json/issues/154)
- json::parse\(string\) does not check utf8 bom [\#152](https://github.com/nlohmann/json/issues/152)
- unsigned 64bit values output as signed [\#151](https://github.com/nlohmann/json/issues/151)
- Wish feature: json5 [\#150](https://github.com/nlohmann/json/issues/150)
- Unable to compile on MSVC 2015 with SDL checking enabled: This function or variable may be unsafe. [\#149](https://github.com/nlohmann/json/issues/149)
- "Json Object" type does not keep object order [\#148](https://github.com/nlohmann/json/issues/148)
- dump\(\)  convert strings encoded by utf-8 to shift-jis on windows 10.  [\#147](https://github.com/nlohmann/json/issues/147)
- Unable to get field names in a json object [\#145](https://github.com/nlohmann/json/issues/145)
- Question: Is the use of incomplete type correct? [\#138](https://github.com/nlohmann/json/issues/138)
- json.hpp:5746:32: error: 'to\_string' is not a member of 'std' [\#136](https://github.com/nlohmann/json/issues/136)
- Bug in basic\_json::operator\[\] const overload [\#135](https://github.com/nlohmann/json/issues/135)
- wrong enable\_if for const pointer \(instead of pointer-to-const\) [\#134](https://github.com/nlohmann/json/issues/134)
- overload of at\(\) with default value [\#133](https://github.com/nlohmann/json/issues/133)
- Splitting source [\#132](https://github.com/nlohmann/json/issues/132)
- Question about get\_ptr\(\) [\#127](https://github.com/nlohmann/json/issues/127)
- Visual Studio 14 Debug assertion failed [\#125](https://github.com/nlohmann/json/issues/125)
- Memory leak in face of exceptions [\#118](https://github.com/nlohmann/json/issues/118)
- Find and Count for arrays [\#117](https://github.com/nlohmann/json/issues/117)
- dynamically constructing an arbitrarily nested object [\#114](https://github.com/nlohmann/json/issues/114)
- Returning any data type [\#113](https://github.com/nlohmann/json/issues/113)
- Compile error with g++ 4.9.3 cygwin 64-bit [\#112](https://github.com/nlohmann/json/issues/112)
- insert json array issue with gcc4.8.2 [\#110](https://github.com/nlohmann/json/issues/110)
- error: unterminated raw string [\#109](https://github.com/nlohmann/json/issues/109)
- vector\<json\> copy constructor really weird [\#108](https://github.com/nlohmann/json/issues/108)
- \[clang-3.6.2\] string/sstream with number to json issue [\#107](https://github.com/nlohmann/json/issues/107)
- maintaining order of keys during iteration [\#106](https://github.com/nlohmann/json/issues/106)
- object field accessors [\#103](https://github.com/nlohmann/json/issues/103)
- v8pp and json [\#95](https://github.com/nlohmann/json/issues/95)
- Wishlist [\#65](https://github.com/nlohmann/json/issues/65)
- Windows/Visual Studio \(through 2013\) is unsupported [\#62](https://github.com/nlohmann/json/issues/62)

- Replace sprintf with hex function, this fixes \#149 [\#153](https://github.com/nlohmann/json/pull/153) ([whackashoe](https://github.com/whackashoe))
- Fix character skipping after a surrogate pair [\#146](https://github.com/nlohmann/json/pull/146) ([robertmrk](https://github.com/robertmrk))
- Detect correctly pointer-to-const [\#137](https://github.com/nlohmann/json/pull/137) ([dariomt](https://github.com/dariomt))
- disabled "CopyAssignable" test for MSVC in Debug mode, see \#125 [\#131](https://github.com/nlohmann/json/pull/131) ([dariomt](https://github.com/dariomt))
- removed stream operator for iterator, resolution for \#125 [\#130](https://github.com/nlohmann/json/pull/130) ([dariomt](https://github.com/dariomt))
- fixed typos in comments for examples [\#129](https://github.com/nlohmann/json/pull/129) ([dariomt](https://github.com/dariomt))
- Remove superfluous inefficiency [\#126](https://github.com/nlohmann/json/pull/126) ([d-frey](https://github.com/d-frey))
- remove invalid parameter '-stdlib=libc++' in CMakeLists.txt [\#124](https://github.com/nlohmann/json/pull/124) ([emvivre](https://github.com/emvivre))
- exception-safe object creation, fixes \#118 [\#122](https://github.com/nlohmann/json/pull/122) ([d-frey](https://github.com/d-frey))
- Fix small oversight. [\#121](https://github.com/nlohmann/json/pull/121) ([ColinH](https://github.com/ColinH))
- Overload parse\(\) to accept an rvalue reference [\#120](https://github.com/nlohmann/json/pull/120) ([silverweed](https://github.com/silverweed))
- Use the right variable name in doc string [\#115](https://github.com/nlohmann/json/pull/115) ([whoshuu](https://github.com/whoshuu))

## [v1.0.0-rc1](https://github.com/nlohmann/json/releases/tag/v1.0.0-rc1) (2015-07-26)
- Finish documenting the public interface in Doxygen [\#102](https://github.com/nlohmann/json/issues/102)
- Binary string causes numbers to be dumped as hex [\#101](https://github.com/nlohmann/json/issues/101)
- failed to iterator json object with reverse\_iterator [\#100](https://github.com/nlohmann/json/issues/100)
- 'noexcept' : unknown override specifier [\#99](https://github.com/nlohmann/json/issues/99)
- json float parsing problem [\#98](https://github.com/nlohmann/json/issues/98)
- Adjust wording to JSON RFC [\#97](https://github.com/nlohmann/json/issues/97)
- 17 MB / 90 MB repo size!? [\#96](https://github.com/nlohmann/json/issues/96)
- static analysis warnings [\#94](https://github.com/nlohmann/json/issues/94)
- reverse\_iterator operator inheritance problem [\#93](https://github.com/nlohmann/json/issues/93)
- init error [\#92](https://github.com/nlohmann/json/issues/92)
- access by \(const\) reference [\#91](https://github.com/nlohmann/json/issues/91)
- is\_integer and is\_float tests [\#90](https://github.com/nlohmann/json/issues/90)
- Nonstandard integer type [\#89](https://github.com/nlohmann/json/issues/89)
- static library build [\#84](https://github.com/nlohmann/json/issues/84)
- lexer::get\_number return NAN [\#82](https://github.com/nlohmann/json/issues/82)
- MinGW have no std::to\_string [\#80](https://github.com/nlohmann/json/issues/80)
- Incorrect behaviour of basic\_json::count method [\#78](https://github.com/nlohmann/json/issues/78)
- Invoking is\_array\(\) function creates "null" value [\#77](https://github.com/nlohmann/json/issues/77)
- dump\(\) / parse\(\) not idempotent [\#76](https://github.com/nlohmann/json/issues/76)
- Handle infinity and NaN cases [\#70](https://github.com/nlohmann/json/issues/70)
- errors in g++-4.8.1 [\#68](https://github.com/nlohmann/json/issues/68)
- Keys when iterating over objects [\#67](https://github.com/nlohmann/json/issues/67)
- Compilation results in tons of warnings [\#64](https://github.com/nlohmann/json/issues/64)
- Complete brief documentation [\#61](https://github.com/nlohmann/json/issues/61)
- Double quotation mark is not parsed correctly [\#60](https://github.com/nlohmann/json/issues/60)
- Get coverage back to 100% [\#58](https://github.com/nlohmann/json/issues/58)
- erase elements using iterators [\#57](https://github.com/nlohmann/json/issues/57)
- Removing item from array [\#56](https://github.com/nlohmann/json/issues/56)
- Serialize/Deserialize like PHP? [\#55](https://github.com/nlohmann/json/issues/55)
- Numbers as keys [\#54](https://github.com/nlohmann/json/issues/54)
- Why are elements alphabetized on key while iterating? [\#53](https://github.com/nlohmann/json/issues/53)
- Document erase, count, and iterators key and value [\#52](https://github.com/nlohmann/json/issues/52)
- Do not use std::to\_string [\#51](https://github.com/nlohmann/json/issues/51)
- Supported compilers [\#50](https://github.com/nlohmann/json/issues/50)
- Confused about iterating through json objects [\#49](https://github.com/nlohmann/json/issues/49)
- Use non-member begin/end [\#48](https://github.com/nlohmann/json/issues/48)
- Erase key [\#47](https://github.com/nlohmann/json/issues/47)
- Key iterator [\#46](https://github.com/nlohmann/json/issues/46)
- Add count member function [\#45](https://github.com/nlohmann/json/issues/45)
- Problem getting vector \(array\) of strings [\#44](https://github.com/nlohmann/json/issues/44)
- Compilation error due to assuming that private=public [\#43](https://github.com/nlohmann/json/issues/43)
- Use of deprecated implicit copy constructor [\#42](https://github.com/nlohmann/json/issues/42)
- Printing attribute names [\#39](https://github.com/nlohmann/json/issues/39)
- dumping a small number\_float just outputs 0.000000 [\#37](https://github.com/nlohmann/json/issues/37)
- find is error [\#32](https://github.com/nlohmann/json/issues/32)
- Avoid using spaces when encoding without pretty print [\#31](https://github.com/nlohmann/json/issues/31)
- Cannot encode long numbers [\#30](https://github.com/nlohmann/json/issues/30)
- segmentation fault when iterating over empty arrays/objects [\#28](https://github.com/nlohmann/json/issues/28)
- Creating an empty array [\#27](https://github.com/nlohmann/json/issues/27)
- Custom allocator support [\#25](https://github.com/nlohmann/json/issues/25)
- make the type of the used string container customizable [\#20](https://github.com/nlohmann/json/issues/20)
- Improper parsing of JSON string "\\" [\#17](https://github.com/nlohmann/json/issues/17)
- create a header-only version [\#16](https://github.com/nlohmann/json/issues/16)
- Don't return "const values" [\#15](https://github.com/nlohmann/json/issues/15)
- Add to\_string overload for indentation [\#13](https://github.com/nlohmann/json/issues/13)
- string parser does not recognize uncompliant strings [\#12](https://github.com/nlohmann/json/issues/12)
- possible double-free in find function [\#11](https://github.com/nlohmann/json/issues/11)
- UTF-8 encoding/deconding/testing [\#10](https://github.com/nlohmann/json/issues/10)
- move code into namespace [\#9](https://github.com/nlohmann/json/issues/9)
- free functions for explicit objects and arrays in initializer lists [\#8](https://github.com/nlohmann/json/issues/8)
- unique\_ptr for ownership [\#7](https://github.com/nlohmann/json/issues/7)
- Add unit tests [\#4](https://github.com/nlohmann/json/issues/4)
- Drop C++98 support [\#3](https://github.com/nlohmann/json/issues/3)
- Test case coverage [\#2](https://github.com/nlohmann/json/issues/2)
- Runtime error in Travis job [\#1](https://github.com/nlohmann/json/issues/1)

- Keyword 'inline' is useless when member functions are defined in headers [\#87](https://github.com/nlohmann/json/pull/87) ([ahamez](https://github.com/ahamez))
- Remove useless typename [\#86](https://github.com/nlohmann/json/pull/86) ([ahamez](https://github.com/ahamez))
- Avoid warning with Xcode's clang [\#85](https://github.com/nlohmann/json/pull/85) ([ahamez](https://github.com/ahamez))
-  Fix typos [\#73](https://github.com/nlohmann/json/pull/73) ([aqnouch](https://github.com/aqnouch))
- Replace `default\_callback` function with `nullptr` and check for null… [\#72](https://github.com/nlohmann/json/pull/72) ([aburgh](https://github.com/aburgh))
- support enum [\#71](https://github.com/nlohmann/json/pull/71) ([likebeta](https://github.com/likebeta))
- Fix performance regression introduced with the parsing callback feature. [\#69](https://github.com/nlohmann/json/pull/69) ([aburgh](https://github.com/aburgh))
- Improve the implementations of the comparission-operators [\#63](https://github.com/nlohmann/json/pull/63) ([Florianjw](https://github.com/Florianjw))
- Fix compilation of json\_unit with GCC 5 [\#59](https://github.com/nlohmann/json/pull/59) ([dkopecek](https://github.com/dkopecek))
- Parse streams incrementally. [\#40](https://github.com/nlohmann/json/pull/40) ([aburgh](https://github.com/aburgh))
- Feature/small float serialization [\#38](https://github.com/nlohmann/json/pull/38) ([jrandall](https://github.com/jrandall))
- template version with re2c scanner [\#36](https://github.com/nlohmann/json/pull/36) ([nlohmann](https://github.com/nlohmann))
- more descriptive documentation in example [\#33](https://github.com/nlohmann/json/pull/33) ([luxe](https://github.com/luxe))
- Fix string conversion under Clang [\#26](https://github.com/nlohmann/json/pull/26) ([wancw](https://github.com/wancw))
- Fixed dumping of strings [\#24](https://github.com/nlohmann/json/pull/24) ([Teemperor](https://github.com/Teemperor))
- Added a remark to the readme that coverage is GCC only for now [\#23](https://github.com/nlohmann/json/pull/23) ([Teemperor](https://github.com/Teemperor))
- Unicode escaping [\#22](https://github.com/nlohmann/json/pull/22) ([Teemperor](https://github.com/Teemperor))
- Implemented the JSON spec for string parsing for everything but the \uXXXX escaping [\#21](https://github.com/nlohmann/json/pull/21) ([Teemperor](https://github.com/Teemperor))
- add the std iterator typedefs to iterator and const\_iterator [\#19](https://github.com/nlohmann/json/pull/19) ([kirkshoop](https://github.com/kirkshoop))
- Fixed escaped quotes [\#18](https://github.com/nlohmann/json/pull/18) ([Teemperor](https://github.com/Teemperor))
- Fix double delete on std::bad\_alloc exception [\#14](https://github.com/nlohmann/json/pull/14) ([elliotgoodrich](https://github.com/elliotgoodrich))
- Added CMake and lcov [\#6](https://github.com/nlohmann/json/pull/6) ([Teemperor](https://github.com/Teemperor))
- Version 2.0 [\#5](https://github.com/nlohmann/json/pull/5) ([nlohmann](https://github.com/nlohmann))



\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*