# Change Log
All notable changes to this project will be documented in this file. This project adheres to [Semantic Versioning](http://semver.org/).

## [v2.0.8](https://github.com/nlohmann/json/releases/tag/v2.0.8) (2016-12-02)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.7...v2.0.8)

- Reading from file [\#374](https://github.com/nlohmann/json/issues/374)
- Compiler warnings? [\#372](https://github.com/nlohmann/json/issues/372)
- docs: how to release a json object in memory? [\#371](https://github.com/nlohmann/json/issues/371)
- crash in dump [\#370](https://github.com/nlohmann/json/issues/370)
- Conversion operators not considered [\#369](https://github.com/nlohmann/json/issues/369)
- Coverity issue \(FORWARD\_NULL\) in lexer\(std::istream& s\) [\#368](https://github.com/nlohmann/json/issues/368)
- json::parse on failed stream gets stuck [\#366](https://github.com/nlohmann/json/issues/366)
- Performance improvements [\#365](https://github.com/nlohmann/json/issues/365)
- 'to\_string' is not a member of 'std'  [\#364](https://github.com/nlohmann/json/issues/364)
- Optional comment support. [\#363](https://github.com/nlohmann/json/issues/363)
- Loss of precision when serializing \<double\> [\#360](https://github.com/nlohmann/json/issues/360)
- Crash in dump\(\) from a static object [\#359](https://github.com/nlohmann/json/issues/359)
- json::parse\(...\) vs json j; j.parse\(...\) [\#357](https://github.com/nlohmann/json/issues/357)
- Hi, is there any method to dump  json to string with the insert order rather than alphabets [\#356](https://github.com/nlohmann/json/issues/356)
- Provide an example of reading from an json with only a key that has an array of strings. [\#354](https://github.com/nlohmann/json/issues/354)
- Request: access with default value. [\#353](https://github.com/nlohmann/json/issues/353)
- {} and \[\] causes parser error. [\#352](https://github.com/nlohmann/json/issues/352)
- Reading a JSON file into a JSON object [\#351](https://github.com/nlohmann/json/issues/351)
- Request: 'emplace\_back' [\#349](https://github.com/nlohmann/json/issues/349)
- Is it possible to stream data through the json parser without storing everything in memory? [\#347](https://github.com/nlohmann/json/issues/347)
- pure virtual conversion operator [\#346](https://github.com/nlohmann/json/issues/346)
- Floating point precision lost [\#345](https://github.com/nlohmann/json/issues/345)
- unit-conversions SIGSEGV on armv7hl [\#303](https://github.com/nlohmann/json/issues/303)
- Coverity scan fails [\#299](https://github.com/nlohmann/json/issues/299)
- Using QString as string type [\#274](https://github.com/nlohmann/json/issues/274)

## [v2.0.7](https://github.com/nlohmann/json/releases/tag/v2.0.7) (2016-11-02)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.6...v2.0.7)

- JSON5 [\#348](https://github.com/nlohmann/json/issues/348)
- Check "Parsing JSON is a Minefield" [\#344](https://github.com/nlohmann/json/issues/344)
- Allow hex numbers [\#342](https://github.com/nlohmann/json/issues/342)
- Convert strings to numbers [\#341](https://github.com/nlohmann/json/issues/341)
- ""-operators ignore the length parameter [\#340](https://github.com/nlohmann/json/issues/340)
- JSON into std::tuple [\#339](https://github.com/nlohmann/json/issues/339)
- JSON into vector [\#335](https://github.com/nlohmann/json/issues/335)
- Installing with Homebrew on Mac Errors \(El Capitan\) [\#331](https://github.com/nlohmann/json/issues/331)
- g++ make check results in error [\#312](https://github.com/nlohmann/json/issues/312)
- Cannot convert from 'json' to 'char' [\#276](https://github.com/nlohmann/json/issues/276)
- Please add a Pretty-Print option for arrays to stay always in one line [\#229](https://github.com/nlohmann/json/issues/229)
- Conversion to STL map\<string, vector\<int\>\> gives error [\#220](https://github.com/nlohmann/json/issues/220)
- std::unorderd\_map cannot be used as ObjectType [\#164](https://github.com/nlohmann/json/issues/164)

- fix minor grammar/style issue in README.md [\#336](https://github.com/nlohmann/json/pull/336) ([seeekr](https://github.com/seeekr))

## [v2.0.6](https://github.com/nlohmann/json/releases/tag/v2.0.6) (2016-10-15)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.5...v2.0.6)

- How to handle json files? [\#333](https://github.com/nlohmann/json/issues/333)
- This file requires compiler and library support .... [\#332](https://github.com/nlohmann/json/issues/332)
- Segmentation fault on saving json to file [\#326](https://github.com/nlohmann/json/issues/326)
- parse error - unexpected \<uninitialized\> with 2.0.5 [\#325](https://github.com/nlohmann/json/issues/325)
- Add nested object capability to pointers [\#323](https://github.com/nlohmann/json/issues/323)
- Fix usage examples' comments for std::multiset [\#322](https://github.com/nlohmann/json/issues/322)
- json\_unit runs forever when executed in build directory [\#319](https://github.com/nlohmann/json/issues/319)
- Visual studio 2015 update3 true != TRUE [\#317](https://github.com/nlohmann/json/issues/317)
- releasing single header file in compressed format [\#316](https://github.com/nlohmann/json/issues/316)
- json object from std::ifstream [\#315](https://github.com/nlohmann/json/issues/315)

- make has\_mapped\_type struct friendly [\#324](https://github.com/nlohmann/json/pull/324) ([vpetrigo](https://github.com/vpetrigo))
- Fix usage examples' comments for std::multiset [\#321](https://github.com/nlohmann/json/pull/321) ([vasild](https://github.com/vasild))
- Include dir relocation [\#318](https://github.com/nlohmann/json/pull/318) ([ChristophJud](https://github.com/ChristophJud))
- trivial documentation fix [\#313](https://github.com/nlohmann/json/pull/313) ([5tefan](https://github.com/5tefan))

## [v2.0.5](https://github.com/nlohmann/json/releases/tag/v2.0.5) (2016-09-14)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.4...v2.0.5)

- \[feature request\]: schema validator and comments [\#311](https://github.com/nlohmann/json/issues/311)
- make json\_benchmarks no longer working in 2.0.4 [\#310](https://github.com/nlohmann/json/issues/310)
- Segmentation fault \(core dumped\) [\#309](https://github.com/nlohmann/json/issues/309)
- No matching member function for call to 'get\_impl' [\#308](https://github.com/nlohmann/json/issues/308)

## [v2.0.4](https://github.com/nlohmann/json/releases/tag/v2.0.4) (2016-09-11)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.3...v2.0.4)

- Parsing fails without space at end of file [\#306](https://github.com/nlohmann/json/issues/306)
- json schema validator [\#305](https://github.com/nlohmann/json/issues/305)
- Unused variable warning [\#304](https://github.com/nlohmann/json/issues/304)

## [v2.0.3](https://github.com/nlohmann/json/releases/tag/v2.0.3) (2016-08-31)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.2...v2.0.3)

- warning C4706: assignment within conditional expression [\#295](https://github.com/nlohmann/json/issues/295)
- Strip comments / Minify [\#294](https://github.com/nlohmann/json/issues/294)
- Q: Is it possible to build json tree from already UTF8 encoded values? [\#293](https://github.com/nlohmann/json/issues/293)
- Equality operator results in array when assigned object [\#292](https://github.com/nlohmann/json/issues/292)
- Support for integers not from the range \[-\(2\*\*53\)+1, \(2\*\*53\)-1\] in parser [\#291](https://github.com/nlohmann/json/issues/291)
- Support for iterator-range parsing [\#290](https://github.com/nlohmann/json/issues/290)
- Horribly inconsistent behavior between const/non-const reference in operator \[\] \(\) [\#289](https://github.com/nlohmann/json/issues/289)
- Silently get numbers into smaller types [\#288](https://github.com/nlohmann/json/issues/288)
- Incorrect parsing of large int64\_t numbers [\#287](https://github.com/nlohmann/json/issues/287)
- \[question\]: macro to disable floating point support [\#284](https://github.com/nlohmann/json/issues/284)

- unit-constructor1.cpp: Fix floating point truncation warning [\#300](https://github.com/nlohmann/json/pull/300) ([t-b](https://github.com/t-b))

## [v2.0.2](https://github.com/nlohmann/json/releases/tag/v2.0.2) (2016-07-31)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.1...v2.0.2)

- can function dump\(\)  return string in the order I push in the json object ? [\#286](https://github.com/nlohmann/json/issues/286)
- Error on the Mac: Undefined symbols for architecture x86\_64 [\#285](https://github.com/nlohmann/json/issues/285)
- value\(\) does not work with \_json\_pointer types [\#283](https://github.com/nlohmann/json/issues/283)
- Build error for std::int64 [\#282](https://github.com/nlohmann/json/issues/282)
- strings can't be accessed after dump\(\)-\>parse\(\) - type is lost [\#281](https://github.com/nlohmann/json/issues/281)
- Easy serialization of classes [\#280](https://github.com/nlohmann/json/issues/280)
- recursive data structures [\#277](https://github.com/nlohmann/json/issues/277)
- hexify\(\) function emits conversion warning [\#270](https://github.com/nlohmann/json/issues/270)

- let the makefile choose the correct sed [\#279](https://github.com/nlohmann/json/pull/279) ([murinicanor](https://github.com/murinicanor))
- Update hexify to use array lookup instead of ternary \(\#270\) [\#275](https://github.com/nlohmann/json/pull/275) ([dtoma](https://github.com/dtoma))

## [v2.0.1](https://github.com/nlohmann/json/releases/tag/v2.0.1) (2016-06-28)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.0...v2.0.1)

- Compilation error. [\#273](https://github.com/nlohmann/json/issues/273)
- dump\(\) performance degradation in v2 [\#272](https://github.com/nlohmann/json/issues/272)

- fixed a tiny typo [\#271](https://github.com/nlohmann/json/pull/271) ([thelostt](https://github.com/thelostt))

## [v2.0.0](https://github.com/nlohmann/json/releases/tag/v2.0.0) (2016-06-23)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.1.0...v2.0.0)

- json::diff generates incorrect patch when removing multiple array elements. [\#269](https://github.com/nlohmann/json/issues/269)
- Docs - What does Json\[key\] return? [\#267](https://github.com/nlohmann/json/issues/267)
- Compiler Errors With JSON.hpp [\#265](https://github.com/nlohmann/json/issues/265)
- Throw exception instead of crashing my app [\#264](https://github.com/nlohmann/json/issues/264)
- Ambiguous push\_back and operator+= overloads [\#263](https://github.com/nlohmann/json/issues/263)
- Preseving order of items in json [\#262](https://github.com/nlohmann/json/issues/262)
- '\' char problem in strings [\#261](https://github.com/nlohmann/json/issues/261)
- VS2015 compile fail [\#260](https://github.com/nlohmann/json/issues/260)
- -Wconversion warning [\#259](https://github.com/nlohmann/json/issues/259)
- Maybe a bug [\#258](https://github.com/nlohmann/json/issues/258)
- Few tests failed on Visual C++ 2015 [\#257](https://github.com/nlohmann/json/issues/257)
- Access keys when iteration with new for loop C++11 [\#256](https://github.com/nlohmann/json/issues/256)
- multiline text values [\#255](https://github.com/nlohmann/json/issues/255)
- Error when using json in g++ [\#254](https://github.com/nlohmann/json/issues/254)
- is the release 2.0? [\#253](https://github.com/nlohmann/json/issues/253)
- concatenate objects [\#252](https://github.com/nlohmann/json/issues/252)
- Encoding [\#251](https://github.com/nlohmann/json/issues/251)
- Unable to build example for constructing json object with stringstreams [\#250](https://github.com/nlohmann/json/issues/250)
- Hexadecimal support [\#249](https://github.com/nlohmann/json/issues/249)
- Update long-term goals [\#246](https://github.com/nlohmann/json/issues/246)
- Contribution To This Json Project [\#245](https://github.com/nlohmann/json/issues/245)
- Trouble using parser with initial dictionary [\#243](https://github.com/nlohmann/json/issues/243)
- Unit test fails when doing a CMake out-of-tree build [\#241](https://github.com/nlohmann/json/issues/241)
- -Wconversion warnings [\#239](https://github.com/nlohmann/json/issues/239)
- Additional integration options [\#237](https://github.com/nlohmann/json/issues/237)
- .get\<std::string\>\(\) works for non spaced string but returns as array for spaced/longer strings [\#236](https://github.com/nlohmann/json/issues/236)
- ambiguous overload for 'push\_back' and 'operator+=' [\#235](https://github.com/nlohmann/json/issues/235)
- Can't use basic\_json::iterator as a base iterator for std::move\_iterator [\#233](https://github.com/nlohmann/json/issues/233)
- json object's creation can freezes execution [\#231](https://github.com/nlohmann/json/issues/231)
- Incorrect dumping of parsed numbers with exponents, but without decimal places [\#230](https://github.com/nlohmann/json/issues/230)
- double values are serialized with commas as decimal points [\#228](https://github.com/nlohmann/json/issues/228)
- Move semantics with std::initializer\_list [\#225](https://github.com/nlohmann/json/issues/225)
- replace emplace [\#224](https://github.com/nlohmann/json/issues/224)
- abort during getline in yyfill [\#223](https://github.com/nlohmann/json/issues/223)
- free\(\): invalid pointer error in GCC 5.2.1 [\#221](https://github.com/nlohmann/json/issues/221)
- Error compile Android NDK  error: 'strtof' is not a member of 'std' [\#219](https://github.com/nlohmann/json/issues/219)
- Wrong link in the README.md [\#217](https://github.com/nlohmann/json/issues/217)
- Wide character strings not supported [\#216](https://github.com/nlohmann/json/issues/216)
- Memory allocations using range-based for loops [\#214](https://github.com/nlohmann/json/issues/214)
- would you like to support gcc 4.8.1?  [\#211](https://github.com/nlohmann/json/issues/211)
- Reading concatenated json's from an istream [\#210](https://github.com/nlohmann/json/issues/210)
- Conflicting typedef of ssize\_t on Windows 32 bit when using Boost.Python [\#204](https://github.com/nlohmann/json/issues/204)
- Inconsistency between operator\[\] and push\_back [\#203](https://github.com/nlohmann/json/issues/203)
- Small bugs in json.hpp \(get\_number\) and unit.cpp \(non-standard integer type test\) [\#199](https://github.com/nlohmann/json/issues/199)
- GCC/clang floating point parsing bug in strtod\(\) [\#195](https://github.com/nlohmann/json/issues/195)
- What is within scope? [\#192](https://github.com/nlohmann/json/issues/192)
- Bugs in miloyip/nativejson-benchmark: roundtrips [\#187](https://github.com/nlohmann/json/issues/187)
- Floating point exceptions [\#181](https://github.com/nlohmann/json/issues/181)
- Integer conversion to unsigned [\#178](https://github.com/nlohmann/json/issues/178)
- map string string fails to compile [\#176](https://github.com/nlohmann/json/issues/176)
- In basic\_json::basic\_json\(const CompatibleArrayType& val\), the requirement of CompatibleArrayType is not strict enough. [\#174](https://github.com/nlohmann/json/issues/174)
- Provide a FAQ [\#163](https://github.com/nlohmann/json/issues/163)
- Implicit assignment to std::string fails [\#144](https://github.com/nlohmann/json/issues/144)

- Fix Issue \#265 [\#266](https://github.com/nlohmann/json/pull/266) ([06needhamt](https://github.com/06needhamt))
- Define CMake/CTest tests [\#247](https://github.com/nlohmann/json/pull/247) ([robertmrk](https://github.com/robertmrk))
- Out of tree builds and a few other miscellaneous CMake cleanups. [\#242](https://github.com/nlohmann/json/pull/242) ([ChrisKitching](https://github.com/ChrisKitching))
- Implement additional integration options [\#238](https://github.com/nlohmann/json/pull/238) ([robertmrk](https://github.com/robertmrk))
- make serialization locale-independent [\#232](https://github.com/nlohmann/json/pull/232) ([nlohmann](https://github.com/nlohmann))
- fixes \#223 by updating README.md [\#227](https://github.com/nlohmann/json/pull/227) ([kevin--](https://github.com/kevin--))
- Use namespace std for int64\_t and uint64\_t [\#226](https://github.com/nlohmann/json/pull/226) ([lv-zheng](https://github.com/lv-zheng))
- Added missing cerrno header to fix ERANGE compile error on android [\#222](https://github.com/nlohmann/json/pull/222) ([Teemperor](https://github.com/Teemperor))
- Corrected readme [\#218](https://github.com/nlohmann/json/pull/218) ([Annihil](https://github.com/Annihil))
- Create PULL\_REQUEST\_TEMPLATE.md [\#213](https://github.com/nlohmann/json/pull/213) ([whackashoe](https://github.com/whackashoe))
- fixed noexcept; added constexpr [\#208](https://github.com/nlohmann/json/pull/208) ([nlohmann](https://github.com/nlohmann))
- Add support for afl-fuzz testing [\#207](https://github.com/nlohmann/json/pull/207) ([mykter](https://github.com/mykter))
- replaced ssize\_t occurrences with auto \(addresses \#204\) [\#205](https://github.com/nlohmann/json/pull/205) ([nlohmann](https://github.com/nlohmann))
- Fixed issue \#199 - Small bugs in json.hpp \(get\_number\) and unit.cpp \(non-standard integer type test\) [\#200](https://github.com/nlohmann/json/pull/200) ([twelsby](https://github.com/twelsby))
- Fix broken link [\#197](https://github.com/nlohmann/json/pull/197) ([vog](https://github.com/vog))
- Issue \#195 - update Travis to Trusty due to gcc/clang strtod\(\) bug [\#196](https://github.com/nlohmann/json/pull/196) ([twelsby](https://github.com/twelsby))
- Issue \#178 - Extending support to full uint64\_t/int64\_t range and unsigned type \(updated\) [\#193](https://github.com/nlohmann/json/pull/193) ([twelsby](https://github.com/twelsby))

## [v1.1.0](https://github.com/nlohmann/json/releases/tag/v1.1.0) (2016-01-24)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.0.0...v1.1.0)

- Small error in pull \#185 [\#194](https://github.com/nlohmann/json/issues/194)
- Bugs in miloyip/nativejson-benchmark: floating-point parsing [\#186](https://github.com/nlohmann/json/issues/186)
- Floating point equality [\#185](https://github.com/nlohmann/json/issues/185)
- Unused variables in catch [\#180](https://github.com/nlohmann/json/issues/180)
- Typo in documentation [\#179](https://github.com/nlohmann/json/issues/179)
- JSON performance benchmark comparision [\#177](https://github.com/nlohmann/json/issues/177)
- Since re2c is often ignored in pull requests, it may make sense to make a contributing.md file [\#175](https://github.com/nlohmann/json/issues/175)
- Question about exceptions [\#173](https://github.com/nlohmann/json/issues/173)
- Android? [\#172](https://github.com/nlohmann/json/issues/172)
- Cannot index by key of type static constexpr const char\* [\#171](https://github.com/nlohmann/json/issues/171)
- Add assertions [\#168](https://github.com/nlohmann/json/issues/168)
- MSVC 2015 build fails when attempting to compare object\_t [\#167](https://github.com/nlohmann/json/issues/167)
- Member detector is not portable [\#166](https://github.com/nlohmann/json/issues/166)
- Unnecessary const\_cast [\#162](https://github.com/nlohmann/json/issues/162)
- Question about get\_ref\(\) [\#128](https://github.com/nlohmann/json/issues/128)
- range based for loop for objects [\#83](https://github.com/nlohmann/json/issues/83)
- Consider submitting this to the Boost Library Incubator [\#66](https://github.com/nlohmann/json/issues/66)

- Fixed Issue \#186 - add strto\(f|d|ld\) overload wrappers, "-0.0" special case and FP trailing zero [\#191](https://github.com/nlohmann/json/pull/191) ([twelsby](https://github.com/twelsby))
- Issue \#185 - remove approx\(\) and use \#pragma to kill warnings [\#190](https://github.com/nlohmann/json/pull/190) ([twelsby](https://github.com/twelsby))
- Fixed Issue \#171 - added two extra template overloads of operator\[\] for T\* arguments [\#189](https://github.com/nlohmann/json/pull/189) ([twelsby](https://github.com/twelsby))
- Fixed issue \#167 - removed operator ValueType\(\) condition for VS2015 [\#188](https://github.com/nlohmann/json/pull/188) ([twelsby](https://github.com/twelsby))
- Implementation of get\_ref\(\) [\#184](https://github.com/nlohmann/json/pull/184) ([dariomt](https://github.com/dariomt))
- Fixed some typos in CONTRIBUTING.md [\#182](https://github.com/nlohmann/json/pull/182) ([nibroc](https://github.com/nibroc))

## [v1.0.0](https://github.com/nlohmann/json/releases/tag/v1.0.0) (2015-12-27)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.0.0-rc1...v1.0.0)

- add key name to exception [\#160](https://github.com/nlohmann/json/issues/160)
- Getting member discarding qualifyer [\#159](https://github.com/nlohmann/json/issues/159)
- basic\_json::iterator::value\(\) output includes quotes while basic\_json::iterator::key\(\) doesn't [\#158](https://github.com/nlohmann/json/issues/158)
- Indexing `const basic\_json\<\>` with `const basic\_string\<char\>` [\#157](https://github.com/nlohmann/json/issues/157)
- token\_type\_name\(token\_type t\): not all control paths return a value [\#156](https://github.com/nlohmann/json/issues/156)
- prevent json.hpp from emitting compiler warnings [\#154](https://github.com/nlohmann/json/issues/154)
- json::parse\(string\) does not check utf8 bom [\#152](https://github.com/nlohmann/json/issues/152)
- unsigned 64bit values output as signed [\#151](https://github.com/nlohmann/json/issues/151)
- Wish feature: json5 [\#150](https://github.com/nlohmann/json/issues/150)
- Unable to compile on MSVC 2015 with SDL checking enabled: This function or variable may be unsafe. [\#149](https://github.com/nlohmann/json/issues/149)
- "Json Object" type does not keep object order [\#148](https://github.com/nlohmann/json/issues/148)
- dump\(\)  convert strings encoded by utf-8 to shift-jis on windows 10.  [\#147](https://github.com/nlohmann/json/issues/147)
- Unable to get field names in a json object [\#145](https://github.com/nlohmann/json/issues/145)
- Question: Is the use of incomplete type correct? [\#138](https://github.com/nlohmann/json/issues/138)
- json.hpp:5746:32: error: 'to\_string' is not a member of 'std' [\#136](https://github.com/nlohmann/json/issues/136)
- Bug in basic\_json::operator\[\] const overload [\#135](https://github.com/nlohmann/json/issues/135)
- wrong enable\_if for const pointer \(instead of pointer-to-const\) [\#134](https://github.com/nlohmann/json/issues/134)
- overload of at\(\) with default value [\#133](https://github.com/nlohmann/json/issues/133)
- Splitting source [\#132](https://github.com/nlohmann/json/issues/132)
- Question about get\_ptr\(\) [\#127](https://github.com/nlohmann/json/issues/127)
- Visual Studio 14 Debug assertion failed [\#125](https://github.com/nlohmann/json/issues/125)
- Memory leak in face of exceptions [\#118](https://github.com/nlohmann/json/issues/118)
- Find and Count for arrays [\#117](https://github.com/nlohmann/json/issues/117)
- dynamically constructing an arbitrarily nested object [\#114](https://github.com/nlohmann/json/issues/114)
- Returning any data type [\#113](https://github.com/nlohmann/json/issues/113)
- Compile error with g++ 4.9.3 cygwin 64-bit [\#112](https://github.com/nlohmann/json/issues/112)
- insert json array issue with gcc4.8.2 [\#110](https://github.com/nlohmann/json/issues/110)
- error: unterminated raw string [\#109](https://github.com/nlohmann/json/issues/109)
- vector\<json\> copy constructor really weird [\#108](https://github.com/nlohmann/json/issues/108)
- \[clang-3.6.2\] string/sstream with number to json issue [\#107](https://github.com/nlohmann/json/issues/107)
- maintaining order of keys during iteration [\#106](https://github.com/nlohmann/json/issues/106)
- object field accessors [\#103](https://github.com/nlohmann/json/issues/103)
- v8pp and json [\#95](https://github.com/nlohmann/json/issues/95)
- Wishlist [\#65](https://github.com/nlohmann/json/issues/65)
- Windows/Visual Studio \(through 2013\) is unsupported [\#62](https://github.com/nlohmann/json/issues/62)

- Replace sprintf with hex function, this fixes \#149 [\#153](https://github.com/nlohmann/json/pull/153) ([whackashoe](https://github.com/whackashoe))
- Fix character skipping after a surrogate pair [\#146](https://github.com/nlohmann/json/pull/146) ([robertmrk](https://github.com/robertmrk))
- Detect correctly pointer-to-const [\#137](https://github.com/nlohmann/json/pull/137) ([dariomt](https://github.com/dariomt))
- disabled "CopyAssignable" test for MSVC in Debug mode, see \#125 [\#131](https://github.com/nlohmann/json/pull/131) ([dariomt](https://github.com/dariomt))
- removed stream operator for iterator, resolution for \#125 [\#130](https://github.com/nlohmann/json/pull/130) ([dariomt](https://github.com/dariomt))
- fixed typos in comments for examples [\#129](https://github.com/nlohmann/json/pull/129) ([dariomt](https://github.com/dariomt))
- Remove superfluous inefficiency [\#126](https://github.com/nlohmann/json/pull/126) ([d-frey](https://github.com/d-frey))
- remove invalid parameter '-stdlib=libc++' in CMakeLists.txt [\#124](https://github.com/nlohmann/json/pull/124) ([emvivre](https://github.com/emvivre))
- exception-safe object creation, fixes \#118 [\#122](https://github.com/nlohmann/json/pull/122) ([d-frey](https://github.com/d-frey))
- Fix small oversight. [\#121](https://github.com/nlohmann/json/pull/121) ([ColinH](https://github.com/ColinH))
- Overload parse\(\) to accept an rvalue reference [\#120](https://github.com/nlohmann/json/pull/120) ([silverweed](https://github.com/silverweed))
- Use the right variable name in doc string [\#115](https://github.com/nlohmann/json/pull/115) ([whoshuu](https://github.com/whoshuu))

## [v1.0.0-rc1](https://github.com/nlohmann/json/releases/tag/v1.0.0-rc1) (2015-07-26)
- Finish documenting the public interface in Doxygen [\#102](https://github.com/nlohmann/json/issues/102)
- Binary string causes numbers to be dumped as hex [\#101](https://github.com/nlohmann/json/issues/101)
- failed to iterator json object with reverse\_iterator [\#100](https://github.com/nlohmann/json/issues/100)
- 'noexcept' : unknown override specifier [\#99](https://github.com/nlohmann/json/issues/99)
- json float parsing problem [\#98](https://github.com/nlohmann/json/issues/98)
- Adjust wording to JSON RFC [\#97](https://github.com/nlohmann/json/issues/97)
- 17 MB / 90 MB repo size!? [\#96](https://github.com/nlohmann/json/issues/96)
- static analysis warnings [\#94](https://github.com/nlohmann/json/issues/94)
- reverse\_iterator operator inheritance problem [\#93](https://github.com/nlohmann/json/issues/93)
- init error [\#92](https://github.com/nlohmann/json/issues/92)
- access by \(const\) reference [\#91](https://github.com/nlohmann/json/issues/91)
- is\_integer and is\_float tests [\#90](https://github.com/nlohmann/json/issues/90)
- Nonstandard integer type [\#89](https://github.com/nlohmann/json/issues/89)
- static library build [\#84](https://github.com/nlohmann/json/issues/84)
- lexer::get\_number return NAN [\#82](https://github.com/nlohmann/json/issues/82)
- MinGW have no std::to\_string [\#80](https://github.com/nlohmann/json/issues/80)
- Incorrect behaviour of basic\_json::count method [\#78](https://github.com/nlohmann/json/issues/78)
- Invoking is\_array\(\) function creates "null" value [\#77](https://github.com/nlohmann/json/issues/77)
- dump\(\) / parse\(\) not idempotent [\#76](https://github.com/nlohmann/json/issues/76)
- Handle infinity and NaN cases [\#70](https://github.com/nlohmann/json/issues/70)
- errors in g++-4.8.1 [\#68](https://github.com/nlohmann/json/issues/68)
- Keys when iterating over objects [\#67](https://github.com/nlohmann/json/issues/67)
- Compilation results in tons of warnings [\#64](https://github.com/nlohmann/json/issues/64)
- Complete brief documentation [\#61](https://github.com/nlohmann/json/issues/61)
- Double quotation mark is not parsed correctly [\#60](https://github.com/nlohmann/json/issues/60)
- Get coverage back to 100% [\#58](https://github.com/nlohmann/json/issues/58)
- erase elements using iterators [\#57](https://github.com/nlohmann/json/issues/57)
- Removing item from array [\#56](https://github.com/nlohmann/json/issues/56)
- Serialize/Deserialize like PHP? [\#55](https://github.com/nlohmann/json/issues/55)
- Numbers as keys [\#54](https://github.com/nlohmann/json/issues/54)
- Why are elements alphabetized on key while iterating? [\#53](https://github.com/nlohmann/json/issues/53)
- Document erase, count, and iterators key and value [\#52](https://github.com/nlohmann/json/issues/52)
- Do not use std::to\_string [\#51](https://github.com/nlohmann/json/issues/51)
- Supported compilers [\#50](https://github.com/nlohmann/json/issues/50)
- Confused about iterating through json objects [\#49](https://github.com/nlohmann/json/issues/49)
- Use non-member begin/end [\#48](https://github.com/nlohmann/json/issues/48)
- Erase key [\#47](https://github.com/nlohmann/json/issues/47)
- Key iterator [\#46](https://github.com/nlohmann/json/issues/46)
- Add count member function [\#45](https://github.com/nlohmann/json/issues/45)
- Problem getting vector \(array\) of strings [\#44](https://github.com/nlohmann/json/issues/44)
- Compilation error due to assuming that private=public [\#43](https://github.com/nlohmann/json/issues/43)
- Use of deprecated implicit copy constructor [\#42](https://github.com/nlohmann/json/issues/42)
- Printing attribute names [\#39](https://github.com/nlohmann/json/issues/39)
- dumping a small number\_float just outputs 0.000000 [\#37](https://github.com/nlohmann/json/issues/37)
- find is error [\#32](https://github.com/nlohmann/json/issues/32)
- Avoid using spaces when encoding without pretty print [\#31](https://github.com/nlohmann/json/issues/31)
- Cannot encode long numbers [\#30](https://github.com/nlohmann/json/issues/30)
- segmentation fault when iterating over empty arrays/objects [\#28](https://github.com/nlohmann/json/issues/28)
- Creating an empty array [\#27](https://github.com/nlohmann/json/issues/27)
- Custom allocator support [\#25](https://github.com/nlohmann/json/issues/25)
- make the type of the used string container customizable [\#20](https://github.com/nlohmann/json/issues/20)
- Improper parsing of JSON string "\\" [\#17](https://github.com/nlohmann/json/issues/17)
- create a header-only version [\#16](https://github.com/nlohmann/json/issues/16)
- Don't return "const values" [\#15](https://github.com/nlohmann/json/issues/15)
- Add to\_string overload for indentation [\#13](https://github.com/nlohmann/json/issues/13)
- string parser does not recognize uncompliant strings [\#12](https://github.com/nlohmann/json/issues/12)
- possible double-free in find function [\#11](https://github.com/nlohmann/json/issues/11)
- UTF-8 encoding/deconding/testing [\#10](https://github.com/nlohmann/json/issues/10)
- move code into namespace [\#9](https://github.com/nlohmann/json/issues/9)
- free functions for explicit objects and arrays in initializer lists [\#8](https://github.com/nlohmann/json/issues/8)
- unique\_ptr for ownership [\#7](https://github.com/nlohmann/json/issues/7)
- Add unit tests [\#4](https://github.com/nlohmann/json/issues/4)
- Drop C++98 support [\#3](https://github.com/nlohmann/json/issues/3)
- Test case coverage [\#2](https://github.com/nlohmann/json/issues/2)
- Runtime error in Travis job [\#1](https://github.com/nlohmann/json/issues/1)

- Keyword 'inline' is useless when member functions are defined in headers [\#87](https://github.com/nlohmann/json/pull/87) ([ahamez](https://github.com/ahamez))
- Remove useless typename [\#86](https://github.com/nlohmann/json/pull/86) ([ahamez](https://github.com/ahamez))
- Avoid warning with Xcode's clang [\#85](https://github.com/nlohmann/json/pull/85) ([ahamez](https://github.com/ahamez))
-  Fix typos [\#73](https://github.com/nlohmann/json/pull/73) ([aqnouch](https://github.com/aqnouch))
- Replace `default\_callback` function with `nullptr` and check for null… [\#72](https://github.com/nlohmann/json/pull/72) ([aburgh](https://github.com/aburgh))
- support enum [\#71](https://github.com/nlohmann/json/pull/71) ([likebeta](https://github.com/likebeta))
- Fix performance regression introduced with the parsing callback feature. [\#69](https://github.com/nlohmann/json/pull/69) ([aburgh](https://github.com/aburgh))
- Improve the implementations of the comparission-operators [\#63](https://github.com/nlohmann/json/pull/63) ([Florianjw](https://github.com/Florianjw))
- Fix compilation of json\_unit with GCC 5 [\#59](https://github.com/nlohmann/json/pull/59) ([dkopecek](https://github.com/dkopecek))
- Parse streams incrementally. [\#40](https://github.com/nlohmann/json/pull/40) ([aburgh](https://github.com/aburgh))
- Feature/small float serialization [\#38](https://github.com/nlohmann/json/pull/38) ([jrandall](https://github.com/jrandall))
- template version with re2c scanner [\#36](https://github.com/nlohmann/json/pull/36) ([nlohmann](https://github.com/nlohmann))
- more descriptive documentation in example [\#33](https://github.com/nlohmann/json/pull/33) ([luxe](https://github.com/luxe))
- Fix string conversion under Clang [\#26](https://github.com/nlohmann/json/pull/26) ([wancw](https://github.com/wancw))
- Fixed dumping of strings [\#24](https://github.com/nlohmann/json/pull/24) ([Teemperor](https://github.com/Teemperor))
- Added a remark to the readme that coverage is GCC only for now [\#23](https://github.com/nlohmann/json/pull/23) ([Teemperor](https://github.com/Teemperor))
- Unicode escaping [\#22](https://github.com/nlohmann/json/pull/22) ([Teemperor](https://github.com/Teemperor))
- Implemented the JSON spec for string parsing for everything but the \uXXXX escaping [\#21](https://github.com/nlohmann/json/pull/21) ([Teemperor](https://github.com/Teemperor))
- add the std iterator typedefs to iterator and const\_iterator [\#19](https://github.com/nlohmann/json/pull/19) ([kirkshoop](https://github.com/kirkshoop))
- Fixed escaped quotes [\#18](https://github.com/nlohmann/json/pull/18) ([Teemperor](https://github.com/Teemperor))
- Fix double delete on std::bad\_alloc exception [\#14](https://github.com/nlohmann/json/pull/14) ([elliotgoodrich](https://github.com/elliotgoodrich))
- Added CMake and lcov [\#6](https://github.com/nlohmann/json/pull/6) ([Teemperor](https://github.com/Teemperor))
- Version 2.0 [\#5](https://github.com/nlohmann/json/pull/5) ([nlohmann](https://github.com/nlohmann))



\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*