if (superbuild_is_64bit)
  set(tbb_archdir intel64)
else ()
  set(tbb_archdir ia32)
endif ()

if (NOT MSVC_VERSION VERSION_GREATER 1500)
  message(FATAL_ERROR "At least Visual Studio 10.0 is required")
elseif (NOT MSVC_VERSION VERSION_GREATER 1600)
  set(tbb_vsdir vc10)
elseif (NOT MSVC_VERSION VERSION_GREATER 1700)
  set(tbb_vsdir vc11)
elseif (NOT MSVC_VERSION VERSION_GREATER 1800)
  set(tbb_vsdir vc12)
elseif (tbb_enabled)
  message(FATAL_ERROR "tbb does not support your Visual Studio compiler; please use a system version.")
endif ()

set(tbb_libdir lib/${tbb_archdir}/${tbb_vsdir})
include(tbb.common)
