if(CMAKE_SYSTEM_NAME STREQUAL "AIX")
  if(NOT sla MATCHES [[/libsla\.a]])
    message(FATAL_ERROR "sla library does not look like an archive:\n ${sla}")
  endif()
  execute_process(COMMAND ar t ${sla} OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE sla_members)
  if(NOT sla_members MATCHES [[^libsla\.so]])
    message(FATAL_ERROR "sla library archive does not have expected members:\n ${sla_members}")
  endif()
endif()
