/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.terrain;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.vecmath.Color4b;
import org.j3d.util.interpolator.ColorInterpolator;

public class HeightImageCreator {
    private static final byte[] BLACK_BYTES = new byte[]{0, 0, 0, -1};
    private static final byte[] WHITE_BYTES = new byte[]{-1, -1, -1, -1};
    private Color4b minColor;
    private Color4b maxColor;
    private boolean hasAlpha;
    private ColorInterpolator interpolator;

    public HeightImageCreator() {
        this(null, null);
    }

    public HeightImageCreator(Color4b color4b, Color4b color4b2) {
        this.minColor = color4b == null ? new Color4b(BLACK_BYTES) : new Color4b(color4b);
        this.maxColor = color4b2 == null ? new Color4b(WHITE_BYTES) : new Color4b(color4b2);
        this.reconstructInterpolator();
    }

    public void setColorRange(Color4b color4b, Color4b color4b2) {
        if (color4b == null) {
            this.minColor.set(BLACK_BYTES);
        } else {
            this.minColor.set(color4b);
        }
        if (color4b2 == null) {
            this.maxColor.set(WHITE_BYTES);
        } else {
            this.maxColor.set(color4b2);
        }
        this.reconstructInterpolator();
    }

    public BufferedImage createGreyScaleImage(float[][] fArray) {
        if (fArray == null) {
            throw new NullPointerException("Data reference is null");
        }
        int n = fArray[0].length;
        int n2 = fArray.length;
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        float[] fArray2 = this.findHeightRange(fArray);
        float f = fArray2[0];
        float f2 = fArray2[1];
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                int n5 = (int)((fArray[i][j] - f) * 255.0f / f2);
                byArray[n4++] = (byte)n5;
            }
        }
        WritableRaster writableRaster = Raster.createPackedRaster(0, n, n2, 1, 8, null);
        writableRaster.setDataElements(0, 0, n, n2, byArray);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public BufferedImage createColorImage(float[][] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (fArray == null) {
            throw new NullPointerException("Data reference is null");
        }
        int n5 = fArray[0].length;
        int n6 = fArray.length;
        int n7 = n5 * n6;
        if (this.hasAlpha) {
            n4 = 4;
            n3 = 2;
        } else {
            n4 = 3;
            n3 = 1;
        }
        byte[] byArray = new byte[n7 * n4];
        int n8 = 0;
        float[] fArray2 = this.findHeightRange(fArray);
        float f = fArray2[0];
        float f2 = fArray2[1];
        if (this.hasAlpha) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                for (n = 0; n < fArray[n2].length; ++n) {
                    float f3 = (fArray[n2][n] - f) / f2;
                    float[] fArray3 = this.interpolator.floatRGBValue(f3);
                    byArray[n8++] = (byte)(fArray3[3] * 255.0f);
                    byArray[n8++] = (byte)(fArray3[0] * 255.0f);
                    byArray[n8++] = (byte)(fArray3[1] * 255.0f);
                    byArray[n8++] = (byte)(fArray3[2] * 255.0f);
                }
            }
        } else {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                for (n = 0; n < fArray[n2].length; ++n) {
                    float f4 = (fArray[n2][n] - f) / f2;
                    float[] fArray4 = this.interpolator.floatRGBValue(f4);
                    byArray[n8++] = (byte)(fArray4[0] * 255.0f);
                    byArray[n8++] = (byte)(fArray4[1] * 255.0f);
                    byArray[n8++] = (byte)(fArray4[2] * 255.0f);
                }
            }
        }
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n5, n6, n4, null);
        writableRaster.setDataElements(0, 0, n5, n6, byArray);
        BufferedImage bufferedImage = new BufferedImage(n5, n6, n3);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private void reconstructInterpolator() {
        this.hasAlpha = (this.minColor.w & 0xFF) != 255 || (this.maxColor.w & 0xFF) != 255;
        this.interpolator = new ColorInterpolator(2);
        float f = (float)(this.minColor.x & 0xFF) / 255.0f;
        float f2 = (float)(this.minColor.y & 0xFF) / 255.0f;
        float f3 = (float)(this.minColor.z & 0xFF) / 255.0f;
        float f4 = (float)(this.minColor.w & 0xFF) / 255.0f;
        this.interpolator.addRGBKeyFrame(0.0f, f, f2, f3, f4);
        f = (float)(this.maxColor.x & 0xFF) / 255.0f;
        f2 = (float)(this.maxColor.y & 0xFF) / 255.0f;
        f3 = (float)(this.maxColor.z & 0xFF) / 255.0f;
        f4 = (float)(this.maxColor.w & 0xFF) / 255.0f;
        this.interpolator.addRGBKeyFrame(1.0f, f, f2, f3, f4);
    }

    private float[] findHeightRange(float[][] fArray) {
        float f = fArray[0][0];
        float f2 = fArray[0][0];
        int n = fArray.length;
        while (--n >= 0) {
            int n2 = fArray[n].length;
            while (--n2 >= 0) {
                f = f > fArray[n][n2] ? fArray[n][n2] : f;
                f2 = f2 < fArray[n][n2] ? fArray[n][n2] : f2;
            }
        }
        float[] fArray2 = new float[]{f, f2 - f};
        return fArray2;
    }
}

