#ifndef XDMFATTRIBUTE_HPP_
#define XDMFATTRIBUTE_HPP_

// Includes
#include "XdmfAttributeCenter.hpp"
#include "XdmfAttributeType.hpp"
#include "XdmfDataItem.hpp"

/**
 * @brief Handles computed values attached to an XdmfGrid.
 *
 * XdmfAttribute contains two properties that should be set, XdmfAttributeCenter and XdmfAttributeType.
 * XdmfAttribute is a subclass of XdmfDataItem, meaning it contains an XdmfArray to store values.
 */
class XdmfAttribute : public XdmfDataItem {

public:

	XdmfNewMacro(XdmfAttribute);

	/**
	 * Get the XdmfAttributeCenter associated with this attribute.
	 *
	 * @return XdmfAttributeCenter of the attribute.
	 */
	XdmfAttributeCenter getAttributeCenter() const;

	/**
	 * Get the XdmfAttributeType associated with this attribute.
	 *
	 * @return XdmfAttributeType of the attribute.
	 */
	XdmfAttributeType getAttributeType() const;

	/**
	 * Get the name of the attribute.
	 *
	 * @return a string containing the name of the attribute.
	 */
	std::string getName() const;

	virtual std::string printSelf() const;

	/**
	 * Set the XdmfAttributeCenter associated with this attribute.
	 *
	 * @param attributeCenter the XdmfAttributeCenter to set.
	 */
	void setAttributeCenter(const XdmfAttributeCenter & attributeCenter);

	/**
	 * Set the XdmfAttributeType associated with this attribute.
	 *
	 * @param attributeType XdmfAttributeType to set.
	 */
	void setAttributeType(const XdmfAttributeType & attributeType);

	/**
	 * Set the name of the attribute.
	 *
	 * @param name a string containing the name to set.
	 */
	void setName(const std::string & name);

	void write(boost::shared_ptr<XdmfVisitor> visitor) const;

protected:

	XdmfAttribute();
	virtual ~XdmfAttribute();

private:

	XdmfAttribute(const XdmfAttribute & attribute);  // Not implemented.
	void operator=(const XdmfAttribute & attribute);  // Not implemented.

	std::string mName;
	XdmfAttributeType mAttributeType;
	XdmfAttributeCenter mAttributeCenter;
};

#endif /* XDMFATTRIBUTE_HPP_ */
