/*
 * globals.c: definition and handling of the set of global variables
 *            of the library
 *
 * The bottom of this file is automatically generated by build_glob.py
 * based on the description file global.data
 *
 * See Copyright for the status of this software.
 *
 * Gary Pennington <Gary.Pennington@uk.sun.com>
 * daniel@veillard.com
 */

#define IN_LIBXML
#include "libxml.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <string.h>

#include <libxml/globals.h>
#include <libxml/xmlmemory.h>
#include <libxml/threads.h>

/* #define DEBUG_GLOBALS */

/*
 * Helpful Macro
 */
#ifdef LIBXML_THREAD_ENABLED
#define IS_MAIN_THREAD (xmlIsMainThread())
#else
#define IS_MAIN_THREAD 1
#endif

/*
 * Mutex to protect "ForNewThreads" variables
 */
static xmlMutexPtr xmlThrDefMutex = NULL;

/**
 * xmlInitGlobals:
 *
 * Additional initialisation for multi-threading
 */
void xmlInitGlobals(void)
{
    xmlThrDefMutex = xmlNewMutex();
}

/**
 * xmlCleanupGlobals:
 *
 * Additional cleanup for multi-threading
 */
void xmlCleanupGlobals(void)
{
    if (xmlThrDefMutex != NULL) {
        xmlFreeMutex(xmlThrDefMutex);
        xmlThrDefMutex = NULL;
    }
}

/************************************************************************
 *                                                                      *
 *      All the user accessible global variables of the library         *
 *                                                                      *
 ************************************************************************/

/*
 * Memory allocation routines
 */
#undef  xmlFree
#undef  xmlMalloc
#undef  xmlMallocAtomic
#undef  xmlMemStrdup
#undef  xmlRealloc

#if defined(DEBUG_MEMORY_LOCATION) || defined(DEBUG_MEMORY)
xmlFreeFunc vtk_libxml2_xmlFree = (xmlFreeFunc) xmlMemFree;
xmlMallocFunc vtk_libxml2_xmlMalloc = (xmlMallocFunc) xmlMemMalloc;
xmlMallocFunc vtk_libxml2_xmlMallocAtomic = (xmlMallocFunc) xmlMemMalloc;
xmlReallocFunc vtk_libxml2_xmlRealloc = (xmlReallocFunc) xmlMemRealloc;
xmlStrdupFunc vtk_libxml2_xmlMemStrdup = (xmlStrdupFunc) xmlMemoryStrdup;
#else
/**
 * xmlFree:
 * @mem: an already allocated block of memory
 *
 * The variable holding the libxml free() implementation
 */
xmlFreeFunc vtk_libxml2_xmlFree = (xmlFreeFunc) free;
/**
 * xmlMalloc:
 * @size:  the size requested in bytes
 *
 * The variable holding the libxml malloc() implementation
 *
 * Returns a pointer to the newly allocated block or NULL in case of error
 */
xmlMallocFunc vtk_libxml2_xmlMalloc = (xmlMallocFunc) malloc;
/**
 * xmlMallocAtomic:
 * @size:  the size requested in bytes
 *
 * The variable holding the libxml malloc() implementation for atomic
 * data (i.e. blocks not containings pointers), useful when using a
 * garbage collecting allocator.
 *
 * Returns a pointer to the newly allocated block or NULL in case of error
 */
xmlMallocFunc vtk_libxml2_xmlMallocAtomic = (xmlMallocFunc) malloc;
/**
 * xmlRealloc:
 * @mem: an already allocated block of memory
 * @size:  the new size requested in bytes
 *
 * The variable holding the libxml realloc() implementation
 *
 * Returns a pointer to the newly reallocated block or NULL in case of error
 */
xmlReallocFunc vtk_libxml2_xmlRealloc = (xmlReallocFunc) realloc;
/**
 * xmlMemStrdup:
 * @str: a zero terminated string
 *
 * The variable holding the libxml strdup() implementation
 *
 * Returns the copy of the string or NULL in case of error
 */
xmlStrdupFunc vtk_libxml2_xmlMemStrdup = (xmlStrdupFunc) xmlStrdup;
#endif /* DEBUG_MEMORY_LOCATION || DEBUG_MEMORY */

#include <libxml/threads.h>
#include <libxml/globals.h>
#include <libxml/SAX.h>

#undef  docbDefaultSAXHandler
#undef  htmlDefaultSAXHandler
#undef  oldXMLWDcompatibility
#undef  xmlBufferAllocScheme
#undef  xmlDefaultBufferSize
#undef  xmlDefaultSAXHandler
#undef  xmlDefaultSAXLocator
#undef  xmlDoValidityCheckingDefaultValue
#undef  xmlGenericError
#undef  xmlStructuredError
#undef  xmlGenericErrorContext
#undef  xmlGetWarningsDefaultValue
#undef  xmlIndentTreeOutput
#undef  xmlTreeIndentString
#undef  xmlKeepBlanksDefaultValue
#undef  xmlLineNumbersDefaultValue
#undef  xmlLoadExtDtdDefaultValue
#undef  xmlParserDebugEntities
#undef  xmlParserVersion
#undef  xmlPedanticParserDefaultValue
#undef  xmlSaveNoEmptyTags
#undef  xmlSubstituteEntitiesDefaultValue
#undef  xmlRegisterNodeDefaultValue
#undef  xmlDeregisterNodeDefaultValue
#undef  xmlLastError

#undef  xmlParserInputBufferCreateFilenameValue
#undef  xmlOutputBufferCreateFilenameValue

/**
 * xmlParserVersion:
 *
 * Constant string describing the internal version of the library
 */
const char *vtk_libxml2_xmlParserVersion = LIBXML_VERSION_STRING LIBXML_VERSION_EXTRA;

/**
 * xmlBufferAllocScheme:
 *
 * Global setting, default allocation policy for buffers, default is
 * XML_BUFFER_ALLOC_EXACT
 */
xmlBufferAllocationScheme vtk_libxml2_xmlBufferAllocScheme = XML_BUFFER_ALLOC_EXACT;
static xmlBufferAllocationScheme xmlBufferAllocSchemeThrDef = XML_BUFFER_ALLOC_EXACT;
/**
 * xmlDefaultBufferSize:
 *
 * Global setting, default buffer size. Default value is BASE_BUFFER_SIZE
 */
int vtk_libxml2_xmlDefaultBufferSize = BASE_BUFFER_SIZE;
static int xmlDefaultBufferSizeThrDef = BASE_BUFFER_SIZE;

/*
 * Parser defaults
 */

/**
 * oldXMLWDcompatibility:
 *
 * Global setting, DEPRECATED.
 */
int vtk_libxml2_oldXMLWDcompatibility = 0; /* DEPRECATED */
/**
 * xmlParserDebugEntities:
 *
 * Global setting, asking the parser to print out debugging informations.
 * while handling entities.
 * Disabled by default
 */
int vtk_libxml2_xmlParserDebugEntities = 0;
static int xmlParserDebugEntitiesThrDef = 0;
/**
 * xmlDoValidityCheckingDefaultValue:
 *
 * Global setting, indicate that the parser should work in validating mode.
 * Disabled by default.
 */
int vtk_libxml2_xmlDoValidityCheckingDefaultValue = 0;
static int xmlDoValidityCheckingDefaultValueThrDef = 0;
/**
 * xmlGetWarningsDefaultValue:
 *
 * Global setting, indicate that the parser should provide warnings.
 * Activated by default.
 */
int vtk_libxml2_xmlGetWarningsDefaultValue = 1;
static int xmlGetWarningsDefaultValueThrDef = 1;
/**
 * xmlLoadExtDtdDefaultValue:
 *
 * Global setting, indicate that the parser should load DTD while not
 * validating.
 * Disabled by default.
 */
int vtk_libxml2_xmlLoadExtDtdDefaultValue = 0;
static int xmlLoadExtDtdDefaultValueThrDef = 0;
/**
 * xmlPedanticParserDefaultValue:
 *
 * Global setting, indicate that the parser be pedantic
 * Disabled by default.
 */
int vtk_libxml2_xmlPedanticParserDefaultValue = 0;
static int xmlPedanticParserDefaultValueThrDef = 0;
/**
 * xmlLineNumbersDefaultValue:
 *
 * Global setting, indicate that the parser should store the line number
 * in the content field of elements in the DOM tree. 
 * Disabled by default since this may not be safe for old classes of
 * applicaton.
 */
int vtk_libxml2_xmlLineNumbersDefaultValue = 0;
static int xmlLineNumbersDefaultValueThrDef = 0;
/**
 * xmlKeepBlanksDefaultValue:
 *
 * Global setting, indicate that the parser should keep all blanks
 * nodes found in the content
 * Activated by default, this is actually needed to have the parser
 * conformant to the XML Recommendation, however the option is kept
 * for some applications since this was libxml1 default behaviour.
 */
int vtk_libxml2_xmlKeepBlanksDefaultValue = 1;
static int xmlKeepBlanksDefaultValueThrDef = 1;
/**
 * xmlSubstituteEntitiesDefaultValue:
 *
 * Global setting, indicate that the parser should not generate entity
 * references but replace them with the actual content of the entity
 * Disabled by default, this should be activated when using XPath since
 * the XPath data model requires entities replacement and the XPath
 * engine does not handle entities references transparently.
 */
int vtk_libxml2_xmlSubstituteEntitiesDefaultValue = 0;
static int xmlSubstituteEntitiesDefaultValueThrDef = 0;

xmlRegisterNodeFunc vtk_libxml2_xmlRegisterNodeDefaultValue = NULL;
static xmlRegisterNodeFunc xmlRegisterNodeDefaultValueThrDef = NULL;
xmlDeregisterNodeFunc vtk_libxml2_xmlDeregisterNodeDefaultValue = NULL;
static xmlDeregisterNodeFunc xmlDeregisterNodeDefaultValueThrDef = NULL;

xmlParserInputBufferCreateFilenameFunc vtk_libxml2_xmlParserInputBufferCreateFilenameValue = NULL;
static xmlParserInputBufferCreateFilenameFunc xmlParserInputBufferCreateFilenameValueThrDef = NULL;

xmlOutputBufferCreateFilenameFunc vtk_libxml2_xmlOutputBufferCreateFilenameValue = NULL;
static xmlOutputBufferCreateFilenameFunc xmlOutputBufferCreateFilenameValueThrDef = NULL;

/*
 * Error handling
 */

/* xmlGenericErrorFunc xmlGenericError = xmlGenericErrorDefaultFunc; */
/* Must initialize xmlGenericError in xmlInitParser */
void XMLCDECL xmlGenericErrorDefaultFunc        (void *ctx ATTRIBUTE_UNUSED,
                                 const char *msg,
                                 ...);
/**
 * xmlGenericError:
 *
 * Global setting: function used for generic error callbacks
 */
xmlGenericErrorFunc vtk_libxml2_xmlGenericError = xmlGenericErrorDefaultFunc;
static xmlGenericErrorFunc xmlGenericErrorThrDef = xmlGenericErrorDefaultFunc;
/**
 * xmlStructuredError:
 *
 * Global setting: function used for structured error callbacks
 */
xmlStructuredErrorFunc vtk_libxml2_xmlStructuredError = NULL;
static xmlStructuredErrorFunc xmlStructuredErrorThrDef = NULL;
/**
 * xmlGenericErrorContext:
 *
 * Global setting passed to generic error callbacks
 */
void *vtk_libxml2_xmlGenericErrorContext = NULL;
static void *xmlGenericErrorContextThrDef = NULL;
xmlError vtk_libxml2_xmlLastError = {0}; /* Init avoids common block on Mac */

/*
 * output defaults
 */
/**
 * xmlIndentTreeOutput:
 *
 * Global setting, asking the serializer to indent the output tree by default
 * Enabled by default
 */
int vtk_libxml2_xmlIndentTreeOutput = 1;
static int xmlIndentTreeOutputThrDef = 1;

/**
 * xmlTreeIndentString:
 *
 * The string used to do one-level indent. By default is equal to "  " (two spaces)
 */
const char *vtk_libxml2_xmlTreeIndentString = "  ";
static const char *xmlTreeIndentStringThrDef = "  ";

/**
 * xmlSaveNoEmptyTags:
 *
 * Global setting, asking the serializer to not output empty tags
 * as <empty/> but <empty></empty>. those two forms are undistinguishable
 * once parsed.
 * Disabled by default
 */
int vtk_libxml2_xmlSaveNoEmptyTags = 0;
static int xmlSaveNoEmptyTagsThrDef = 0;

#ifdef LIBXML_SAX1_ENABLED
/**
 * xmlDefaultSAXHandler:
 *
 * Default SAX version1 handler for XML, builds the DOM tree
 */
xmlSAXHandlerV1 vtk_libxml2_xmlDefaultSAXHandler = {
    xmlSAX2InternalSubset,
    xmlSAX2IsStandalone,
    xmlSAX2HasInternalSubset,
    xmlSAX2HasExternalSubset,
    xmlSAX2ResolveEntity,
    xmlSAX2GetEntity,
    xmlSAX2EntityDecl,
    xmlSAX2NotationDecl,
    xmlSAX2AttributeDecl,
    xmlSAX2ElementDecl,
    xmlSAX2UnparsedEntityDecl,
    xmlSAX2SetDocumentLocator,
    xmlSAX2StartDocument,
    xmlSAX2EndDocument,
    xmlSAX2StartElement,
    xmlSAX2EndElement,
    xmlSAX2Reference,
    xmlSAX2Characters,
    xmlSAX2Characters,
    xmlSAX2ProcessingInstruction,
    xmlSAX2Comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    xmlSAX2GetParameterEntity,
    xmlSAX2CDataBlock,
    xmlSAX2ExternalSubset,
    0,
};
#endif /* LIBXML_SAX1_ENABLED */

/**
 * xmlDefaultSAXLocator:
 *
 * The default SAX Locator
 * { getPublicId, getSystemId, getLineNumber, getColumnNumber}
 */
xmlSAXLocator vtk_libxml2_xmlDefaultSAXLocator = {
    xmlSAX2GetPublicId,
    xmlSAX2GetSystemId,
    xmlSAX2GetLineNumber,
    xmlSAX2GetColumnNumber
};

#ifdef LIBXML_HTML_ENABLED
/**
 * htmlDefaultSAXHandler:
 *
 * Default old SAX v1 handler for HTML, builds the DOM tree
 */
xmlSAXHandlerV1 vtk_libxml2_htmlDefaultSAXHandler = {
    xmlSAX2InternalSubset,
    NULL,
    NULL,
    NULL,
    NULL,
    xmlSAX2GetEntity,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    xmlSAX2SetDocumentLocator,
    xmlSAX2StartDocument,
    xmlSAX2EndDocument,
    xmlSAX2StartElement,
    xmlSAX2EndElement,
    NULL,
    xmlSAX2Characters,
    xmlSAX2IgnorableWhitespace,
    xmlSAX2ProcessingInstruction,
    xmlSAX2Comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    xmlSAX2GetParameterEntity,
    xmlSAX2CDataBlock,
    NULL,
    0,
};
#endif /* LIBXML_HTML_ENABLED */

#ifdef LIBXML_DOCB_ENABLED
/**
 * docbDefaultSAXHandler:
 *
 * Default old SAX v1 handler for SGML DocBook, builds the DOM tree
 */
xmlSAXHandlerV1 vtk_libxml2_docbDefaultSAXHandler = {
    xmlSAX2InternalSubset,
    xmlSAX2IsStandalone,
    xmlSAX2HasInternalSubset,
    xmlSAX2HasExternalSubset,
    xmlSAX2ResolveEntity,
    xmlSAX2GetEntity,
    xmlSAX2EntityDecl,
    NULL,
    NULL,
    NULL,
    NULL,
    xmlSAX2SetDocumentLocator,
    xmlSAX2StartDocument,
    xmlSAX2EndDocument,
    xmlSAX2StartElement,
    xmlSAX2EndElement,
    xmlSAX2Reference,
    xmlSAX2Characters,
    xmlSAX2IgnorableWhitespace,
    NULL,
    xmlSAX2Comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    xmlSAX2GetParameterEntity,
    NULL,
    NULL,
    0,
};
#endif /* LIBXML_DOCB_ENABLED */

/**
 * xmlInitializeGlobalState:
 * @gs: a pointer to a newly allocated global state
 *
 * xmlInitializeGlobalState() initialize a global state with all the
 * default values of the library.
 */
void
xmlInitializeGlobalState(xmlGlobalStatePtr gs)
{
#ifdef DEBUG_GLOBALS
    fprintf(stderr, "Initializing globals at %lu for thread %d\n",
            (unsigned long) gs, xmlGetThreadId());
#endif

    /*
     * Perform initialization as required by libxml
     */
    if (xmlThrDefMutex == NULL)
        xmlInitGlobals();

    xmlMutexLock(xmlThrDefMutex);

#if defined(LIBXML_DOCB_ENABLED) && defined(LIBXML_LEGACY_ENABLED) && defined(LIBXML_SAX1_ENABLED)
    initdocbDefaultSAXHandler(&gs->docbDefaultSAXHandler);
#endif
#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_LEGACY_ENABLED)
    inithtmlDefaultSAXHandler(&gs->htmlDefaultSAXHandler);
#endif

    gs->oldXMLWDcompatibility = 0;
    gs->xmlBufferAllocScheme = xmlBufferAllocSchemeThrDef;
    gs->xmlDefaultBufferSize = xmlDefaultBufferSizeThrDef;
#if defined(LIBXML_SAX1_ENABLED) && defined(LIBXML_LEGACY_ENABLED)
    initxmlDefaultSAXHandler(&gs->xmlDefaultSAXHandler, 1);
#endif /* LIBXML_SAX1_ENABLED */
    gs->xmlDefaultSAXLocator.getPublicId = xmlSAX2GetPublicId;
    gs->xmlDefaultSAXLocator.getSystemId = xmlSAX2GetSystemId;
    gs->xmlDefaultSAXLocator.getLineNumber = xmlSAX2GetLineNumber;
    gs->xmlDefaultSAXLocator.getColumnNumber = xmlSAX2GetColumnNumber;
    gs->xmlDoValidityCheckingDefaultValue = 
         xmlDoValidityCheckingDefaultValueThrDef;
#if defined(DEBUG_MEMORY_LOCATION) | defined(DEBUG_MEMORY)
    gs->xmlFree = (xmlFreeFunc) vtk_libxml2_xmlMemFree;
    gs->xmlMalloc = (xmlMallocFunc) vtk_libxml2_xmlMemMalloc;
    gs->xmlMallocAtomic = (xmlMallocFunc) vtk_libxml2_xmlMemMalloc;
    gs->xmlRealloc = (xmlReallocFunc) vtk_libxml2_xmlMemRealloc;
    gs->xmlMemStrdup = (xmlStrdupFunc) vtk_libxml2_xmlMemoryStrdup;
#else
    gs->xmlFree = (xmlFreeFunc) free;
    gs->xmlMalloc = (xmlMallocFunc) malloc;
    gs->xmlMallocAtomic = (xmlMallocFunc) malloc;
    gs->xmlRealloc = (xmlReallocFunc) realloc;
    gs->xmlMemStrdup = (xmlStrdupFunc) xmlStrdup;
#endif
    gs->xmlGetWarningsDefaultValue = xmlGetWarningsDefaultValueThrDef;
    gs->xmlIndentTreeOutput = xmlIndentTreeOutputThrDef;
    gs->xmlTreeIndentString = xmlTreeIndentStringThrDef;
    gs->xmlKeepBlanksDefaultValue = xmlKeepBlanksDefaultValueThrDef;
    gs->xmlLineNumbersDefaultValue = xmlLineNumbersDefaultValueThrDef;
    gs->xmlLoadExtDtdDefaultValue = xmlLoadExtDtdDefaultValueThrDef;
    gs->xmlParserDebugEntities = xmlParserDebugEntitiesThrDef;
    gs->xmlParserVersion = LIBXML_VERSION_STRING;
    gs->xmlPedanticParserDefaultValue = xmlPedanticParserDefaultValueThrDef;
    gs->xmlSaveNoEmptyTags = xmlSaveNoEmptyTagsThrDef;
    gs->xmlSubstituteEntitiesDefaultValue = 
        xmlSubstituteEntitiesDefaultValueThrDef;

    gs->xmlGenericError = xmlGenericErrorThrDef;
    gs->xmlStructuredError = xmlStructuredErrorThrDef;
    gs->xmlGenericErrorContext = xmlGenericErrorContextThrDef;
    gs->xmlRegisterNodeDefaultValue = xmlRegisterNodeDefaultValueThrDef;
    gs->xmlDeregisterNodeDefaultValue = xmlDeregisterNodeDefaultValueThrDef;

        gs->xmlParserInputBufferCreateFilenameValue = xmlParserInputBufferCreateFilenameValueThrDef;
        gs->xmlOutputBufferCreateFilenameValue = xmlOutputBufferCreateFilenameValueThrDef;
    memset(&gs->xmlLastError, 0, sizeof(xmlError));

    xmlMutexUnlock(xmlThrDefMutex);
}

#define docbDefaultSAXHandler vtk_libxml2_docbDefaultSAXHandler
#define htmlDefaultSAXHandler vtk_libxml2_htmlDefaultSAXHandler
#define xmlLastError vtk_libxml2_xmlLastError
#define oldXMLWDcompatibility vtk_libxml2_oldXMLWDcompatibility
#define xmlBufferAllocScheme vtk_libxml2_xmlBufferAllocScheme
#define xmlDefaultBufferSize vtk_libxml2_xmlDefaultBufferSize
#define xmlDefaultSAXHandler vtk_libxml2_xmlDefaultSAXHandler
#define xmlDefaultSAXLocator vtk_libxml2_xmlDefaultSAXLocator
#define xmlDoValidityCheckingDefaultValue vtk_libxml2_xmlDoValidityCheckingDefaultValue
#define xmlGenericError vtk_libxml2_xmlGenericError
#define xmlStructuredError vtk_libxml2_xmlStructuredError
#define xmlGenericErrorContext vtk_libxml2_xmlGenericErrorContext
#define xmlGetWarningsDefaultValue vtk_libxml2_xmlGetWarningsDefaultValue
#define xmlIndentTreeOutput vtk_libxml2_xmlIndentTreeOutput
#define xmlTreeIndentString vtk_libxml2_xmlTreeIndentString
#define xmlKeepBlanksDefaultValue vtk_libxml2_xmlKeepBlanksDefaultValue
#define xmlLineNumbersDefaultValue vtk_libxml2_xmlLineNumbersDefaultValue
#define xmlLoadExtDtdDefaultValue vtk_libxml2_xmlLoadExtDtdDefaultValue
#define xmlParserDebugEntities vtk_libxml2_xmlParserDebugEntities
#define xmlParserVersion vtk_libxml2_xmlParserVersion
#define xmlPedanticParserDefaultValue vtk_libxml2_xmlPedanticParserDefaultValue
#define xmlSaveNoEmptyTags vtk_libxml2_xmlSaveNoEmptyTags
#define xmlSubstituteEntitiesDefaultValue vtk_libxml2_xmlSubstituteEntitiesDefaultValue
#define xmlRegisterNodeDefaultValue vtk_libxml2_xmlRegisterNodeDefaultValue
#define xmlDeregisterNodeDefaultValue vtk_libxml2_xmlDeregisterNodeDefaultValue
#define xmlParserInputBufferCreateFilenameValue vtk_libxml2_xmlParserInputBufferCreateFilenameValue
#define xmlOutputBufferCreateFilenameValue vtk_libxml2_xmlOutputBufferCreateFilenameValue

#define xmlMalloc vtk_libxml2_xmlMalloc
#define xmlMallocAtomic vtk_libxml2_xmlMallocAtomic
#define xmlRealloc vtk_libxml2_xmlRealloc
#define xmlFree vtk_libxml2_xmlFree
#define xmlMemStrdup vtk_libxml2_xmlMemStrdup

/**
 * DOC_DISABLE : we ignore missing doc for the xmlThrDef functions,
 *               those are really internal work
 */
void
xmlThrDefSetGenericErrorFunc(void *ctx, xmlGenericErrorFunc handler) {
    xmlMutexLock(xmlThrDefMutex);
    xmlGenericErrorContextThrDef = ctx;
    if (handler != NULL)
        xmlGenericErrorThrDef = handler;
    else
        xmlGenericErrorThrDef = xmlGenericErrorDefaultFunc;
    xmlMutexUnlock(xmlThrDefMutex);
}

void
xmlThrDefSetStructuredErrorFunc(void *ctx, xmlStructuredErrorFunc handler) {
    xmlMutexLock(xmlThrDefMutex);
    xmlGenericErrorContextThrDef = ctx;
    xmlStructuredErrorThrDef = handler;
    xmlMutexUnlock(xmlThrDefMutex);
}

/**
 * xmlRegisterNodeDefault:
 * @func: function pointer to the new RegisterNodeFunc
 *
 * Registers a callback for node creation
 *
 * Returns the old value of the registration function
 */
xmlRegisterNodeFunc
xmlRegisterNodeDefault(xmlRegisterNodeFunc func)
{
    xmlRegisterNodeFunc old = xmlRegisterNodeDefaultValue;
    
    __xmlRegisterCallbacks = 1;
    xmlRegisterNodeDefaultValue = func;
    return(old);
}

xmlRegisterNodeFunc
xmlThrDefRegisterNodeDefault(xmlRegisterNodeFunc func)
{
    xmlRegisterNodeFunc old;
    
    xmlMutexLock(xmlThrDefMutex);
    old = xmlRegisterNodeDefaultValueThrDef;
    
    __xmlRegisterCallbacks = 1;
    xmlRegisterNodeDefaultValueThrDef = func;
    xmlMutexUnlock(xmlThrDefMutex);

    return(old);
}

/**
 * xmlDeregisterNodeDefault:
 * @func: function pointer to the new DeregisterNodeFunc
 *
 * Registers a callback for node destruction
 *
 * Returns the previous value of the deregistration function
 */
xmlDeregisterNodeFunc
xmlDeregisterNodeDefault(xmlDeregisterNodeFunc func)
{
    xmlDeregisterNodeFunc old = xmlDeregisterNodeDefaultValue;
    
    __xmlRegisterCallbacks = 1;
    xmlDeregisterNodeDefaultValue = func;
    return(old);
}

xmlDeregisterNodeFunc
xmlThrDefDeregisterNodeDefault(xmlDeregisterNodeFunc func)
{
    xmlDeregisterNodeFunc old;

    xmlMutexLock(xmlThrDefMutex);
    old = xmlDeregisterNodeDefaultValueThrDef;
    
    __xmlRegisterCallbacks = 1;
    xmlDeregisterNodeDefaultValueThrDef = func;
    xmlMutexUnlock(xmlThrDefMutex);

    return(old);
}

xmlParserInputBufferCreateFilenameFunc
xmlThrDefParserInputBufferCreateFilenameDefault(xmlParserInputBufferCreateFilenameFunc func)
{
    xmlParserInputBufferCreateFilenameFunc old;
    
    xmlMutexLock(xmlThrDefMutex);
    old = xmlParserInputBufferCreateFilenameValueThrDef;
    if (old == NULL) {
                old = __xmlParserInputBufferCreateFilename;
        }

    xmlParserInputBufferCreateFilenameValueThrDef = func;
    xmlMutexUnlock(xmlThrDefMutex);

    return(old);
}

xmlOutputBufferCreateFilenameFunc
xmlThrDefOutputBufferCreateFilenameDefault(xmlOutputBufferCreateFilenameFunc func)
{
    xmlOutputBufferCreateFilenameFunc old;
    
    xmlMutexLock(xmlThrDefMutex);
    old = xmlOutputBufferCreateFilenameValueThrDef;
#ifdef LIBXML_OUTPUT_ENABLED
    if (old == NULL) {
                old = __xmlOutputBufferCreateFilename;
        }
#endif
    xmlOutputBufferCreateFilenameValueThrDef = func;
    xmlMutexUnlock(xmlThrDefMutex);

    return(old);
}

#ifdef LIBXML_DOCB_ENABLED
#undef  docbDefaultSAXHandler
xmlSAXHandlerV1 *
__docbDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_docbDefaultSAXHandler);
    else
        return (&xmlGetGlobalState()->docbDefaultSAXHandler);
}
#endif

#ifdef LIBXML_HTML_ENABLED
#undef  htmlDefaultSAXHandler
xmlSAXHandlerV1 *
__htmlDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_htmlDefaultSAXHandler);
    else
        return (&xmlGetGlobalState()->htmlDefaultSAXHandler);
}
#endif

#undef xmlLastError
xmlError *
__xmlLastError(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlLastError);
    else
        return (&xmlGetGlobalState()->xmlLastError);
}

/*
 * The following memory routines were apparently lost at some point,
 * and were re-inserted at this point on June 10, 2004.  Hope it's
 * the right place for them :-)
 */
#if defined(LIBXML_THREAD_ALLOC_ENABLED) && defined(LIBXML_THREAD_ENABLED)
#undef xmlMalloc
xmlMallocFunc *
__xmlMalloc(void){
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlMalloc);
    else
        return (&xmlGetGlobalState()->xmlMalloc);
}

#undef xmlMallocAtomic
xmlMallocFunc *
__xmlMallocAtomic(void){
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlMallocAtomic);
    else
        return (&xmlGetGlobalState()->xmlMallocAtomic);
}

#undef xmlRealloc
xmlReallocFunc *
__xmlRealloc(void){
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlRealloc);
    else
        return (&xmlGetGlobalState()->xmlRealloc);
}

#undef xmlFree
xmlFreeFunc *
__xmlFree(void){
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlFree);
    else
        return (&xmlGetGlobalState()->xmlFree);
}

xmlStrdupFunc *
__xmlMemStrdup(void){
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlMemStrdup);
    else
        return (&xmlGetGlobalState()->xmlMemStrdup);
}

#endif

/*
 * Everything starting from the line below is
 * Automatically generated by build_glob.py.
 * Do not modify the previous line.
 */


#undef  oldXMLWDcompatibility
int *
__oldXMLWDcompatibility(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_oldXMLWDcompatibility);
    else
        return (&xmlGetGlobalState()->oldXMLWDcompatibility);
}

#undef  xmlBufferAllocScheme
xmlBufferAllocationScheme *
__xmlBufferAllocScheme(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlBufferAllocScheme);
    else
        return (&xmlGetGlobalState()->xmlBufferAllocScheme);
}
xmlBufferAllocationScheme xmlThrDefBufferAllocScheme(xmlBufferAllocationScheme v) {
    xmlBufferAllocationScheme ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlBufferAllocSchemeThrDef;
    xmlBufferAllocSchemeThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlDefaultBufferSize
int *
__xmlDefaultBufferSize(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlDefaultBufferSize);
    else
        return (&xmlGetGlobalState()->xmlDefaultBufferSize);
}
int xmlThrDefDefaultBufferSize(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlDefaultBufferSizeThrDef;
    xmlDefaultBufferSizeThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#ifdef LIBXML_SAX1_ENABLED
#undef  xmlDefaultSAXHandler
xmlSAXHandlerV1 *
__xmlDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlDefaultSAXHandler);
    else
        return (&xmlGetGlobalState()->xmlDefaultSAXHandler);
}
#endif /* LIBXML_SAX1_ENABLED */

#undef  xmlDefaultSAXLocator
xmlSAXLocator *
__xmlDefaultSAXLocator(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlDefaultSAXLocator);
    else
        return (&xmlGetGlobalState()->xmlDefaultSAXLocator);
}

#undef  xmlDoValidityCheckingDefaultValue
int *
__xmlDoValidityCheckingDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlDoValidityCheckingDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlDoValidityCheckingDefaultValue);
}
int xmlThrDefDoValidityCheckingDefaultValue(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlDoValidityCheckingDefaultValueThrDef;
    xmlDoValidityCheckingDefaultValueThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlGenericError
xmlGenericErrorFunc *
__xmlGenericError(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlGenericError);
    else
        return (&xmlGetGlobalState()->xmlGenericError);
}

#undef  xmlStructuredError
xmlStructuredErrorFunc *
__xmlStructuredError(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlStructuredError);
    else
        return (&xmlGetGlobalState()->xmlStructuredError);
}

#undef  xmlGenericErrorContext
void * *
__xmlGenericErrorContext(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlGenericErrorContext);
    else
        return (&xmlGetGlobalState()->xmlGenericErrorContext);
}

#undef  xmlGetWarningsDefaultValue
int *
__xmlGetWarningsDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlGetWarningsDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlGetWarningsDefaultValue);
}
int xmlThrDefGetWarningsDefaultValue(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlGetWarningsDefaultValueThrDef;
    xmlGetWarningsDefaultValueThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlIndentTreeOutput
int *
__xmlIndentTreeOutput(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlIndentTreeOutput);
    else
        return (&xmlGetGlobalState()->xmlIndentTreeOutput);
}
int xmlThrDefIndentTreeOutput(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlIndentTreeOutputThrDef;
    xmlIndentTreeOutputThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef xmlTreeIndentString
const char * *
__xmlTreeIndentString(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlTreeIndentString);
    else
        return (&xmlGetGlobalState()->xmlTreeIndentString);
}
const char * xmlThrDefTreeIndentString(const char * v) {
    const char * ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlTreeIndentStringThrDef;
    xmlTreeIndentStringThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlKeepBlanksDefaultValue
int *
__xmlKeepBlanksDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlKeepBlanksDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlKeepBlanksDefaultValue);
}
int xmlThrDefKeepBlanksDefaultValue(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlKeepBlanksDefaultValueThrDef;
    xmlKeepBlanksDefaultValueThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlLineNumbersDefaultValue
int *
__xmlLineNumbersDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlLineNumbersDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlLineNumbersDefaultValue);
}
int xmlThrDefLineNumbersDefaultValue(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlLineNumbersDefaultValueThrDef;
    xmlLineNumbersDefaultValueThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlLoadExtDtdDefaultValue
int *
__xmlLoadExtDtdDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlLoadExtDtdDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlLoadExtDtdDefaultValue);
}
int xmlThrDefLoadExtDtdDefaultValue(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlLoadExtDtdDefaultValueThrDef;
    xmlLoadExtDtdDefaultValueThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlParserDebugEntities
int *
__xmlParserDebugEntities(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlParserDebugEntities);
    else
        return (&xmlGetGlobalState()->xmlParserDebugEntities);
}
int xmlThrDefParserDebugEntities(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlParserDebugEntitiesThrDef;
    xmlParserDebugEntitiesThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlParserVersion
const char * *
__xmlParserVersion(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlParserVersion);
    else
        return (&xmlGetGlobalState()->xmlParserVersion);
}

#undef  xmlPedanticParserDefaultValue
int *
__xmlPedanticParserDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlPedanticParserDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlPedanticParserDefaultValue);
}
int xmlThrDefPedanticParserDefaultValue(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlPedanticParserDefaultValueThrDef;
    xmlPedanticParserDefaultValueThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlSaveNoEmptyTags
int *
__xmlSaveNoEmptyTags(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlSaveNoEmptyTags);
    else
        return (&xmlGetGlobalState()->xmlSaveNoEmptyTags);
}
int xmlThrDefSaveNoEmptyTags(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlSaveNoEmptyTagsThrDef;
    xmlSaveNoEmptyTagsThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlSubstituteEntitiesDefaultValue
int *
__xmlSubstituteEntitiesDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlSubstituteEntitiesDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlSubstituteEntitiesDefaultValue);
}
int xmlThrDefSubstituteEntitiesDefaultValue(int v) {
    int ret;
    xmlMutexLock(xmlThrDefMutex);
    ret = xmlSubstituteEntitiesDefaultValueThrDef;
    xmlSubstituteEntitiesDefaultValueThrDef = v;
    xmlMutexUnlock(xmlThrDefMutex);
    return ret;
}

#undef  xmlRegisterNodeDefaultValue
xmlRegisterNodeFunc *
__xmlRegisterNodeDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlRegisterNodeDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlRegisterNodeDefaultValue);
}

#undef  xmlDeregisterNodeDefaultValue
xmlDeregisterNodeFunc *
__xmlDeregisterNodeDefaultValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlDeregisterNodeDefaultValue);
    else
        return (&xmlGetGlobalState()->xmlDeregisterNodeDefaultValue);
}

#undef  xmlParserInputBufferCreateFilenameValue
xmlParserInputBufferCreateFilenameFunc *
__xmlParserInputBufferCreateFilenameValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlParserInputBufferCreateFilenameValue);
    else
        return (&xmlGetGlobalState()->xmlParserInputBufferCreateFilenameValue);
}

#undef  xmlOutputBufferCreateFilenameValue
xmlOutputBufferCreateFilenameFunc *
__xmlOutputBufferCreateFilenameValue(void) {
    if (IS_MAIN_THREAD)
        return (&vtk_libxml2_xmlOutputBufferCreateFilenameValue);
    else
        return (&xmlGetGlobalState()->xmlOutputBufferCreateFilenameValue);
}

#define bottom_globals
#include "elfgcchack.h"
