/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyDataBinningAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyDataBinningAttributes
//
// Purpose: 
//   The attributes for the DataBinning operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a DataBinningAttributes.
//
struct DataBinningAttributesObject
{
    PyObject_HEAD
    DataBinningAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewDataBinningAttributes(int);

std::string
PyDataBinningAttributes_ToString(const DataBinningAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *numDimensions_names = "One, Two, Three";
    switch (atts->GetNumDimensions())
    {
      case DataBinningAttributes::One:
          SNPRINTF(tmpStr, 1000, "%snumDimensions = %sOne  # %s\n", prefix, prefix, numDimensions_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Two:
          SNPRINTF(tmpStr, 1000, "%snumDimensions = %sTwo  # %s\n", prefix, prefix, numDimensions_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Three:
          SNPRINTF(tmpStr, 1000, "%snumDimensions = %sThree  # %s\n", prefix, prefix, numDimensions_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *dim1BinBasedOn_names = "X, Y, Z, Variable";
    switch (atts->GetDim1BinBasedOn())
    {
      case DataBinningAttributes::X:
          SNPRINTF(tmpStr, 1000, "%sdim1BinBasedOn = %sX  # %s\n", prefix, prefix, dim1BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Y:
          SNPRINTF(tmpStr, 1000, "%sdim1BinBasedOn = %sY  # %s\n", prefix, prefix, dim1BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Z:
          SNPRINTF(tmpStr, 1000, "%sdim1BinBasedOn = %sZ  # %s\n", prefix, prefix, dim1BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Variable:
          SNPRINTF(tmpStr, 1000, "%sdim1BinBasedOn = %sVariable  # %s\n", prefix, prefix, dim1BinBasedOn_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sdim1Var = \"%s\"\n", prefix, atts->GetDim1Var().c_str());
    str += tmpStr;
    if(atts->GetDim1SpecifyRange())
        SNPRINTF(tmpStr, 1000, "%sdim1SpecifyRange = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdim1SpecifyRange = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim1MinRange = %g\n", prefix, atts->GetDim1MinRange());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim1MaxRange = %g\n", prefix, atts->GetDim1MaxRange());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim1NumBins = %d\n", prefix, atts->GetDim1NumBins());
    str += tmpStr;
    const char *dim2BinBasedOn_names = "X, Y, Z, Variable";
    switch (atts->GetDim2BinBasedOn())
    {
      case DataBinningAttributes::X:
          SNPRINTF(tmpStr, 1000, "%sdim2BinBasedOn = %sX  # %s\n", prefix, prefix, dim2BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Y:
          SNPRINTF(tmpStr, 1000, "%sdim2BinBasedOn = %sY  # %s\n", prefix, prefix, dim2BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Z:
          SNPRINTF(tmpStr, 1000, "%sdim2BinBasedOn = %sZ  # %s\n", prefix, prefix, dim2BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Variable:
          SNPRINTF(tmpStr, 1000, "%sdim2BinBasedOn = %sVariable  # %s\n", prefix, prefix, dim2BinBasedOn_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sdim2Var = \"%s\"\n", prefix, atts->GetDim2Var().c_str());
    str += tmpStr;
    if(atts->GetDim2SpecifyRange())
        SNPRINTF(tmpStr, 1000, "%sdim2SpecifyRange = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdim2SpecifyRange = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim2MinRange = %g\n", prefix, atts->GetDim2MinRange());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim2MaxRange = %g\n", prefix, atts->GetDim2MaxRange());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim2NumBins = %d\n", prefix, atts->GetDim2NumBins());
    str += tmpStr;
    const char *dim3BinBasedOn_names = "X, Y, Z, Variable";
    switch (atts->GetDim3BinBasedOn())
    {
      case DataBinningAttributes::X:
          SNPRINTF(tmpStr, 1000, "%sdim3BinBasedOn = %sX  # %s\n", prefix, prefix, dim3BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Y:
          SNPRINTF(tmpStr, 1000, "%sdim3BinBasedOn = %sY  # %s\n", prefix, prefix, dim3BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Z:
          SNPRINTF(tmpStr, 1000, "%sdim3BinBasedOn = %sZ  # %s\n", prefix, prefix, dim3BinBasedOn_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Variable:
          SNPRINTF(tmpStr, 1000, "%sdim3BinBasedOn = %sVariable  # %s\n", prefix, prefix, dim3BinBasedOn_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sdim3Var = \"%s\"\n", prefix, atts->GetDim3Var().c_str());
    str += tmpStr;
    if(atts->GetDim3SpecifyRange())
        SNPRINTF(tmpStr, 1000, "%sdim3SpecifyRange = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdim3SpecifyRange = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim3MinRange = %g\n", prefix, atts->GetDim3MinRange());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim3MaxRange = %g\n", prefix, atts->GetDim3MaxRange());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdim3NumBins = %d\n", prefix, atts->GetDim3NumBins());
    str += tmpStr;
    const char *outOfBoundsBehavior_names = "Clamp, Discard";
    switch (atts->GetOutOfBoundsBehavior())
    {
      case DataBinningAttributes::Clamp:
          SNPRINTF(tmpStr, 1000, "%soutOfBoundsBehavior = %sClamp  # %s\n", prefix, prefix, outOfBoundsBehavior_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Discard:
          SNPRINTF(tmpStr, 1000, "%soutOfBoundsBehavior = %sDiscard  # %s\n", prefix, prefix, outOfBoundsBehavior_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *reductionOperator_names = "Average, Minimum, Maximum, StandardDeviation, Variance, "
        "Sum, Count, RMS, PDF";
    switch (atts->GetReductionOperator())
    {
      case DataBinningAttributes::Average:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sAverage  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Minimum:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sMinimum  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Maximum:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sMaximum  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::StandardDeviation:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sStandardDeviation  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Variance:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sVariance  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Sum:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sSum  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::Count:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sCount  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::RMS:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sRMS  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::PDF:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sPDF  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svarForReduction = \"%s\"\n", prefix, atts->GetVarForReduction().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%semptyVal = %g\n", prefix, atts->GetEmptyVal());
    str += tmpStr;
    const char *outputType_names = "OutputOnBins, OutputOnInputMesh";
    switch (atts->GetOutputType())
    {
      case DataBinningAttributes::OutputOnBins:
          SNPRINTF(tmpStr, 1000, "%soutputType = %sOutputOnBins  # %s\n", prefix, prefix, outputType_names);
          str += tmpStr;
          break;
      case DataBinningAttributes::OutputOnInputMesh:
          SNPRINTF(tmpStr, 1000, "%soutputType = %sOutputOnInputMesh  # %s\n", prefix, prefix, outputType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetRemoveEmptyValFromCurve())
        SNPRINTF(tmpStr, 1000, "%sremoveEmptyValFromCurve = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sremoveEmptyValFromCurve = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
DataBinningAttributes_Notify(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_SetNumDimensions(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numDimensions in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNumDimensions(DataBinningAttributes::NumDimensions(ival));
    else
    {
        fprintf(stderr, "An invalid numDimensions value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "One, Two, Three.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetNumDimensions(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumDimensions()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim1BinBasedOn(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim1BinBasedOn in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetDim1BinBasedOn(DataBinningAttributes::BinBasedOn(ival));
    else
    {
        fprintf(stderr, "An invalid dim1BinBasedOn value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "X, Y, Z, Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim1BinBasedOn(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim1BinBasedOn()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim1Var(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the dim1Var in the object.
    obj->data->SetDim1Var(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim1Var(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDim1Var().c_str());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim1SpecifyRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim1SpecifyRange in the object.
    obj->data->SetDim1SpecifyRange(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim1SpecifyRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDim1SpecifyRange()?1L:0L);
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim1MinRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the dim1MinRange in the object.
    obj->data->SetDim1MinRange(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim1MinRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDim1MinRange());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim1MaxRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the dim1MaxRange in the object.
    obj->data->SetDim1MaxRange(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim1MaxRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDim1MaxRange());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim1NumBins(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim1NumBins in the object.
    obj->data->SetDim1NumBins((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim1NumBins(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim1NumBins()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim2BinBasedOn(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim2BinBasedOn in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetDim2BinBasedOn(DataBinningAttributes::BinBasedOn(ival));
    else
    {
        fprintf(stderr, "An invalid dim2BinBasedOn value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "X, Y, Z, Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim2BinBasedOn(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim2BinBasedOn()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim2Var(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the dim2Var in the object.
    obj->data->SetDim2Var(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim2Var(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDim2Var().c_str());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim2SpecifyRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim2SpecifyRange in the object.
    obj->data->SetDim2SpecifyRange(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim2SpecifyRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDim2SpecifyRange()?1L:0L);
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim2MinRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the dim2MinRange in the object.
    obj->data->SetDim2MinRange(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim2MinRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDim2MinRange());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim2MaxRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the dim2MaxRange in the object.
    obj->data->SetDim2MaxRange(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim2MaxRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDim2MaxRange());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim2NumBins(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim2NumBins in the object.
    obj->data->SetDim2NumBins((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim2NumBins(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim2NumBins()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim3BinBasedOn(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim3BinBasedOn in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetDim3BinBasedOn(DataBinningAttributes::BinBasedOn(ival));
    else
    {
        fprintf(stderr, "An invalid dim3BinBasedOn value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "X, Y, Z, Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim3BinBasedOn(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim3BinBasedOn()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim3Var(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the dim3Var in the object.
    obj->data->SetDim3Var(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim3Var(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDim3Var().c_str());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim3SpecifyRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim3SpecifyRange in the object.
    obj->data->SetDim3SpecifyRange(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim3SpecifyRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDim3SpecifyRange()?1L:0L);
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim3MinRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the dim3MinRange in the object.
    obj->data->SetDim3MinRange(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim3MinRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDim3MinRange());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim3MaxRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the dim3MaxRange in the object.
    obj->data->SetDim3MaxRange(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim3MaxRange(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDim3MaxRange());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetDim3NumBins(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim3NumBins in the object.
    obj->data->SetDim3NumBins((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetDim3NumBins(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim3NumBins()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetOutOfBoundsBehavior(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outOfBoundsBehavior in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOutOfBoundsBehavior(DataBinningAttributes::OutOfBoundsBehavior(ival));
    else
    {
        fprintf(stderr, "An invalid outOfBoundsBehavior value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Clamp, Discard.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetOutOfBoundsBehavior(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutOfBoundsBehavior()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetReductionOperator(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the reductionOperator in the object.
    if(ival >= 0 && ival < 9)
        obj->data->SetReductionOperator(DataBinningAttributes::ReductionOperator(ival));
    else
    {
        fprintf(stderr, "An invalid reductionOperator value was given. "
                        "Valid values are in the range of [0,8]. "
                        "You can also use the following names: "
                        "Average, Minimum, Maximum, StandardDeviation, Variance, "
                        "Sum, Count, RMS, PDF"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetReductionOperator(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetReductionOperator()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetVarForReduction(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the varForReduction in the object.
    obj->data->SetVarForReduction(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetVarForReduction(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVarForReduction().c_str());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetEmptyVal(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the emptyVal in the object.
    obj->data->SetEmptyVal(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetEmptyVal(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEmptyVal());
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetOutputType(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOutputType(DataBinningAttributes::OutputType(ival));
    else
    {
        fprintf(stderr, "An invalid outputType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OutputOnBins, OutputOnInputMesh.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetOutputType(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutputType()));
    return retval;
}

/*static*/ PyObject *
DataBinningAttributes_SetRemoveEmptyValFromCurve(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the removeEmptyValFromCurve in the object.
    obj->data->SetRemoveEmptyValFromCurve(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DataBinningAttributes_GetRemoveEmptyValFromCurve(PyObject *self, PyObject *args)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRemoveEmptyValFromCurve()?1L:0L);
    return retval;
}



PyMethodDef PyDataBinningAttributes_methods[DATABINNINGATTRIBUTES_NMETH] = {
    {"Notify", DataBinningAttributes_Notify, METH_VARARGS},
    {"SetNumDimensions", DataBinningAttributes_SetNumDimensions, METH_VARARGS},
    {"GetNumDimensions", DataBinningAttributes_GetNumDimensions, METH_VARARGS},
    {"SetDim1BinBasedOn", DataBinningAttributes_SetDim1BinBasedOn, METH_VARARGS},
    {"GetDim1BinBasedOn", DataBinningAttributes_GetDim1BinBasedOn, METH_VARARGS},
    {"SetDim1Var", DataBinningAttributes_SetDim1Var, METH_VARARGS},
    {"GetDim1Var", DataBinningAttributes_GetDim1Var, METH_VARARGS},
    {"SetDim1SpecifyRange", DataBinningAttributes_SetDim1SpecifyRange, METH_VARARGS},
    {"GetDim1SpecifyRange", DataBinningAttributes_GetDim1SpecifyRange, METH_VARARGS},
    {"SetDim1MinRange", DataBinningAttributes_SetDim1MinRange, METH_VARARGS},
    {"GetDim1MinRange", DataBinningAttributes_GetDim1MinRange, METH_VARARGS},
    {"SetDim1MaxRange", DataBinningAttributes_SetDim1MaxRange, METH_VARARGS},
    {"GetDim1MaxRange", DataBinningAttributes_GetDim1MaxRange, METH_VARARGS},
    {"SetDim1NumBins", DataBinningAttributes_SetDim1NumBins, METH_VARARGS},
    {"GetDim1NumBins", DataBinningAttributes_GetDim1NumBins, METH_VARARGS},
    {"SetDim2BinBasedOn", DataBinningAttributes_SetDim2BinBasedOn, METH_VARARGS},
    {"GetDim2BinBasedOn", DataBinningAttributes_GetDim2BinBasedOn, METH_VARARGS},
    {"SetDim2Var", DataBinningAttributes_SetDim2Var, METH_VARARGS},
    {"GetDim2Var", DataBinningAttributes_GetDim2Var, METH_VARARGS},
    {"SetDim2SpecifyRange", DataBinningAttributes_SetDim2SpecifyRange, METH_VARARGS},
    {"GetDim2SpecifyRange", DataBinningAttributes_GetDim2SpecifyRange, METH_VARARGS},
    {"SetDim2MinRange", DataBinningAttributes_SetDim2MinRange, METH_VARARGS},
    {"GetDim2MinRange", DataBinningAttributes_GetDim2MinRange, METH_VARARGS},
    {"SetDim2MaxRange", DataBinningAttributes_SetDim2MaxRange, METH_VARARGS},
    {"GetDim2MaxRange", DataBinningAttributes_GetDim2MaxRange, METH_VARARGS},
    {"SetDim2NumBins", DataBinningAttributes_SetDim2NumBins, METH_VARARGS},
    {"GetDim2NumBins", DataBinningAttributes_GetDim2NumBins, METH_VARARGS},
    {"SetDim3BinBasedOn", DataBinningAttributes_SetDim3BinBasedOn, METH_VARARGS},
    {"GetDim3BinBasedOn", DataBinningAttributes_GetDim3BinBasedOn, METH_VARARGS},
    {"SetDim3Var", DataBinningAttributes_SetDim3Var, METH_VARARGS},
    {"GetDim3Var", DataBinningAttributes_GetDim3Var, METH_VARARGS},
    {"SetDim3SpecifyRange", DataBinningAttributes_SetDim3SpecifyRange, METH_VARARGS},
    {"GetDim3SpecifyRange", DataBinningAttributes_GetDim3SpecifyRange, METH_VARARGS},
    {"SetDim3MinRange", DataBinningAttributes_SetDim3MinRange, METH_VARARGS},
    {"GetDim3MinRange", DataBinningAttributes_GetDim3MinRange, METH_VARARGS},
    {"SetDim3MaxRange", DataBinningAttributes_SetDim3MaxRange, METH_VARARGS},
    {"GetDim3MaxRange", DataBinningAttributes_GetDim3MaxRange, METH_VARARGS},
    {"SetDim3NumBins", DataBinningAttributes_SetDim3NumBins, METH_VARARGS},
    {"GetDim3NumBins", DataBinningAttributes_GetDim3NumBins, METH_VARARGS},
    {"SetOutOfBoundsBehavior", DataBinningAttributes_SetOutOfBoundsBehavior, METH_VARARGS},
    {"GetOutOfBoundsBehavior", DataBinningAttributes_GetOutOfBoundsBehavior, METH_VARARGS},
    {"SetReductionOperator", DataBinningAttributes_SetReductionOperator, METH_VARARGS},
    {"GetReductionOperator", DataBinningAttributes_GetReductionOperator, METH_VARARGS},
    {"SetVarForReduction", DataBinningAttributes_SetVarForReduction, METH_VARARGS},
    {"GetVarForReduction", DataBinningAttributes_GetVarForReduction, METH_VARARGS},
    {"SetEmptyVal", DataBinningAttributes_SetEmptyVal, METH_VARARGS},
    {"GetEmptyVal", DataBinningAttributes_GetEmptyVal, METH_VARARGS},
    {"SetOutputType", DataBinningAttributes_SetOutputType, METH_VARARGS},
    {"GetOutputType", DataBinningAttributes_GetOutputType, METH_VARARGS},
    {"SetRemoveEmptyValFromCurve", DataBinningAttributes_SetRemoveEmptyValFromCurve, METH_VARARGS},
    {"GetRemoveEmptyValFromCurve", DataBinningAttributes_GetRemoveEmptyValFromCurve, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DataBinningAttributes_dealloc(PyObject *v)
{
   DataBinningAttributesObject *obj = (DataBinningAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
DataBinningAttributes_compare(PyObject *v, PyObject *w)
{
    DataBinningAttributes *a = ((DataBinningAttributesObject *)v)->data;
    DataBinningAttributes *b = ((DataBinningAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyDataBinningAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "numDimensions") == 0)
        return DataBinningAttributes_GetNumDimensions(self, NULL);
    if(strcmp(name, "One") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::One));
    if(strcmp(name, "Two") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Two));
    if(strcmp(name, "Three") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Three));

    if(strcmp(name, "dim1BinBasedOn") == 0)
        return DataBinningAttributes_GetDim1BinBasedOn(self, NULL);
    if(strcmp(name, "X") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::X));
    if(strcmp(name, "Y") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Y));
    if(strcmp(name, "Z") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Z));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Variable));

    if(strcmp(name, "dim1Var") == 0)
        return DataBinningAttributes_GetDim1Var(self, NULL);
    if(strcmp(name, "dim1SpecifyRange") == 0)
        return DataBinningAttributes_GetDim1SpecifyRange(self, NULL);
    if(strcmp(name, "dim1MinRange") == 0)
        return DataBinningAttributes_GetDim1MinRange(self, NULL);
    if(strcmp(name, "dim1MaxRange") == 0)
        return DataBinningAttributes_GetDim1MaxRange(self, NULL);
    if(strcmp(name, "dim1NumBins") == 0)
        return DataBinningAttributes_GetDim1NumBins(self, NULL);
    if(strcmp(name, "dim2BinBasedOn") == 0)
        return DataBinningAttributes_GetDim2BinBasedOn(self, NULL);
    if(strcmp(name, "X") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::X));
    if(strcmp(name, "Y") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Y));
    if(strcmp(name, "Z") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Z));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Variable));

    if(strcmp(name, "dim2Var") == 0)
        return DataBinningAttributes_GetDim2Var(self, NULL);
    if(strcmp(name, "dim2SpecifyRange") == 0)
        return DataBinningAttributes_GetDim2SpecifyRange(self, NULL);
    if(strcmp(name, "dim2MinRange") == 0)
        return DataBinningAttributes_GetDim2MinRange(self, NULL);
    if(strcmp(name, "dim2MaxRange") == 0)
        return DataBinningAttributes_GetDim2MaxRange(self, NULL);
    if(strcmp(name, "dim2NumBins") == 0)
        return DataBinningAttributes_GetDim2NumBins(self, NULL);
    if(strcmp(name, "dim3BinBasedOn") == 0)
        return DataBinningAttributes_GetDim3BinBasedOn(self, NULL);
    if(strcmp(name, "X") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::X));
    if(strcmp(name, "Y") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Y));
    if(strcmp(name, "Z") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Z));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Variable));

    if(strcmp(name, "dim3Var") == 0)
        return DataBinningAttributes_GetDim3Var(self, NULL);
    if(strcmp(name, "dim3SpecifyRange") == 0)
        return DataBinningAttributes_GetDim3SpecifyRange(self, NULL);
    if(strcmp(name, "dim3MinRange") == 0)
        return DataBinningAttributes_GetDim3MinRange(self, NULL);
    if(strcmp(name, "dim3MaxRange") == 0)
        return DataBinningAttributes_GetDim3MaxRange(self, NULL);
    if(strcmp(name, "dim3NumBins") == 0)
        return DataBinningAttributes_GetDim3NumBins(self, NULL);
    if(strcmp(name, "outOfBoundsBehavior") == 0)
        return DataBinningAttributes_GetOutOfBoundsBehavior(self, NULL);
    if(strcmp(name, "Clamp") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Clamp));
    if(strcmp(name, "Discard") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Discard));

    if(strcmp(name, "reductionOperator") == 0)
        return DataBinningAttributes_GetReductionOperator(self, NULL);
    if(strcmp(name, "Average") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Average));
    if(strcmp(name, "Minimum") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Minimum));
    if(strcmp(name, "Maximum") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Maximum));
    if(strcmp(name, "StandardDeviation") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::StandardDeviation));
    if(strcmp(name, "Variance") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Variance));
    if(strcmp(name, "Sum") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Sum));
    if(strcmp(name, "Count") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::Count));
    if(strcmp(name, "RMS") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::RMS));
    if(strcmp(name, "PDF") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::PDF));

    if(strcmp(name, "varForReduction") == 0)
        return DataBinningAttributes_GetVarForReduction(self, NULL);
    if(strcmp(name, "emptyVal") == 0)
        return DataBinningAttributes_GetEmptyVal(self, NULL);
    if(strcmp(name, "outputType") == 0)
        return DataBinningAttributes_GetOutputType(self, NULL);
    if(strcmp(name, "OutputOnBins") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::OutputOnBins));
    if(strcmp(name, "OutputOnInputMesh") == 0)
        return PyInt_FromLong(long(DataBinningAttributes::OutputOnInputMesh));

    if(strcmp(name, "removeEmptyValFromCurve") == 0)
        return DataBinningAttributes_GetRemoveEmptyValFromCurve(self, NULL);

    return Py_FindMethod(PyDataBinningAttributes_methods, self, name);
}

int
PyDataBinningAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "numDimensions") == 0)
        obj = DataBinningAttributes_SetNumDimensions(self, tuple);
    else if(strcmp(name, "dim1BinBasedOn") == 0)
        obj = DataBinningAttributes_SetDim1BinBasedOn(self, tuple);
    else if(strcmp(name, "dim1Var") == 0)
        obj = DataBinningAttributes_SetDim1Var(self, tuple);
    else if(strcmp(name, "dim1SpecifyRange") == 0)
        obj = DataBinningAttributes_SetDim1SpecifyRange(self, tuple);
    else if(strcmp(name, "dim1MinRange") == 0)
        obj = DataBinningAttributes_SetDim1MinRange(self, tuple);
    else if(strcmp(name, "dim1MaxRange") == 0)
        obj = DataBinningAttributes_SetDim1MaxRange(self, tuple);
    else if(strcmp(name, "dim1NumBins") == 0)
        obj = DataBinningAttributes_SetDim1NumBins(self, tuple);
    else if(strcmp(name, "dim2BinBasedOn") == 0)
        obj = DataBinningAttributes_SetDim2BinBasedOn(self, tuple);
    else if(strcmp(name, "dim2Var") == 0)
        obj = DataBinningAttributes_SetDim2Var(self, tuple);
    else if(strcmp(name, "dim2SpecifyRange") == 0)
        obj = DataBinningAttributes_SetDim2SpecifyRange(self, tuple);
    else if(strcmp(name, "dim2MinRange") == 0)
        obj = DataBinningAttributes_SetDim2MinRange(self, tuple);
    else if(strcmp(name, "dim2MaxRange") == 0)
        obj = DataBinningAttributes_SetDim2MaxRange(self, tuple);
    else if(strcmp(name, "dim2NumBins") == 0)
        obj = DataBinningAttributes_SetDim2NumBins(self, tuple);
    else if(strcmp(name, "dim3BinBasedOn") == 0)
        obj = DataBinningAttributes_SetDim3BinBasedOn(self, tuple);
    else if(strcmp(name, "dim3Var") == 0)
        obj = DataBinningAttributes_SetDim3Var(self, tuple);
    else if(strcmp(name, "dim3SpecifyRange") == 0)
        obj = DataBinningAttributes_SetDim3SpecifyRange(self, tuple);
    else if(strcmp(name, "dim3MinRange") == 0)
        obj = DataBinningAttributes_SetDim3MinRange(self, tuple);
    else if(strcmp(name, "dim3MaxRange") == 0)
        obj = DataBinningAttributes_SetDim3MaxRange(self, tuple);
    else if(strcmp(name, "dim3NumBins") == 0)
        obj = DataBinningAttributes_SetDim3NumBins(self, tuple);
    else if(strcmp(name, "outOfBoundsBehavior") == 0)
        obj = DataBinningAttributes_SetOutOfBoundsBehavior(self, tuple);
    else if(strcmp(name, "reductionOperator") == 0)
        obj = DataBinningAttributes_SetReductionOperator(self, tuple);
    else if(strcmp(name, "varForReduction") == 0)
        obj = DataBinningAttributes_SetVarForReduction(self, tuple);
    else if(strcmp(name, "emptyVal") == 0)
        obj = DataBinningAttributes_SetEmptyVal(self, tuple);
    else if(strcmp(name, "outputType") == 0)
        obj = DataBinningAttributes_SetOutputType(self, tuple);
    else if(strcmp(name, "removeEmptyValFromCurve") == 0)
        obj = DataBinningAttributes_SetRemoveEmptyValFromCurve(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
DataBinningAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)v;
    fprintf(fp, "%s", PyDataBinningAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
DataBinningAttributes_str(PyObject *v)
{
    DataBinningAttributesObject *obj = (DataBinningAttributesObject *)v;
    return PyString_FromString(PyDataBinningAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *DataBinningAttributes_Purpose = "The attributes for the DataBinning operator";
#else
static char *DataBinningAttributes_Purpose = "The attributes for the DataBinning operator";
#endif

//
// The type description structure
//
static PyTypeObject DataBinningAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DataBinningAttributes",                    // tp_name
    sizeof(DataBinningAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DataBinningAttributes_dealloc,  // tp_dealloc
    (printfunc)DataBinningAttributes_print,     // tp_print
    (getattrfunc)PyDataBinningAttributes_getattr, // tp_getattr
    (setattrfunc)PyDataBinningAttributes_setattr, // tp_setattr
    (cmpfunc)DataBinningAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DataBinningAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DataBinningAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DataBinningAttributes *defaultAtts = 0;
static DataBinningAttributes *currentAtts = 0;

static PyObject *
NewDataBinningAttributes(int useCurrent)
{
    DataBinningAttributesObject *newObject;
    newObject = PyObject_NEW(DataBinningAttributesObject, &DataBinningAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new DataBinningAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new DataBinningAttributes(*defaultAtts);
    else
        newObject->data = new DataBinningAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapDataBinningAttributes(const DataBinningAttributes *attr)
{
    DataBinningAttributesObject *newObject;
    newObject = PyObject_NEW(DataBinningAttributesObject, &DataBinningAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DataBinningAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DataBinningAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewDataBinningAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DataBinningAttributesMethods[] = {
    {"DataBinningAttributes", DataBinningAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DataBinningAttributesObserver = 0;

std::string
PyDataBinningAttributes_GetLogString()
{
    std::string s("DataBinningAtts = DataBinningAttributes()\n");
    if(currentAtts != 0)
        s += PyDataBinningAttributes_ToString(currentAtts, "DataBinningAtts.");
    return s;
}

static void
PyDataBinningAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("DataBinningAtts = DataBinningAttributes()\n");
        s += PyDataBinningAttributes_ToString(currentAtts, "DataBinningAtts.");
        cb(s);
    }
}

void
PyDataBinningAttributes_StartUp(DataBinningAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyDataBinningAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DataBinningAttributesObserver == 0)
    {
        DataBinningAttributesObserver = new ObserverToCallback(subj,
            PyDataBinningAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyDataBinningAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DataBinningAttributesObserver;
    DataBinningAttributesObserver = 0;
}

PyMethodDef *
PyDataBinningAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DataBinningAttributesMethods;
}

bool
PyDataBinningAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DataBinningAttributesType);
}

DataBinningAttributes *
PyDataBinningAttributes_FromPyObject(PyObject *obj)
{
    DataBinningAttributesObject *obj2 = (DataBinningAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDataBinningAttributes_New()
{
    return NewDataBinningAttributes(0);
}

PyObject *
PyDataBinningAttributes_Wrap(const DataBinningAttributes *attr)
{
    return WrapDataBinningAttributes(attr);
}

void
PyDataBinningAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    DataBinningAttributesObject *obj2 = (DataBinningAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyDataBinningAttributes_SetDefaults(const DataBinningAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DataBinningAttributes(*atts);
}

