/*=========================================================================

   Program: ParaView
   Module:    QtWidgetsPlugin.h

   Copyright (c) 2005-2008 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2. 

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#ifndef _QtWidgetsPlugin_h
#define _QtWidgetsPlugin_h

#include <QDesignerCustomWidgetCollectionInterface>
#include <QDesignerCustomWidgetInterface>
#include <QObject>
#include <qplugin.h>

class pqCollapsedGroupPlugin :
  public QDesignerCustomWidgetInterface
{
  Q_INTERFACES(QDesignerCustomWidgetInterface)

public:
  QString name() const;
  QString domXml() const;
  QWidget* createWidget(QWidget* parent);
  QString group() const;
  QIcon icon() const;
  QString includeFile() const;
  QString toolTip() const;
  QString whatsThis() const;
  bool isContainer() const;
};

class pqDoubleRangeWidgetPlugin :
  public QDesignerCustomWidgetInterface
{
  Q_INTERFACES(QDesignerCustomWidgetInterface)

public:
  QString name() const;
  QString domXml() const;
  QWidget* createWidget(QWidget* parent);
  QString group() const;
  QIcon icon() const;
  QString includeFile() const;
  QString toolTip() const;
  QString whatsThis() const;
  bool isContainer() const;
};

class QtWidgetsPlugin :
  public QObject,
  public QDesignerCustomWidgetCollectionInterface
{
  Q_OBJECT
  Q_INTERFACES(QDesignerCustomWidgetCollectionInterface)
  
public:
  QtWidgetsPlugin(QObject* parent = 0);

  QList<QDesignerCustomWidgetInterface*> customWidgets() const;
  
private:
  QList<QDesignerCustomWidgetInterface*> List;
};

#endif // _QtWidgetsPlugin_h
