/*=========================================================================

   Program: ParaView
   Module:    pqDefaultViewBehavior.h

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2. 
   
   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#ifndef __pqDefaultViewBehavior_h 
#define __pqDefaultViewBehavior_h

#include <QObject>
#include "pqApplicationComponentsExport.h"

class pqServer;

/// @ingroup Behaviors
/// pqDefaultViewBehavior ensures that when a new server connection is made,
/// the default view of the user-specified type is automatically created.
/// This also has the logic to warn before server connection timesout.
class PQAPPLICATIONCOMPONENTS_EXPORT pqDefaultViewBehavior : public QObject
{
  Q_OBJECT
  typedef QObject Superclass;
public:
  pqDefaultViewBehavior(QObject* parent=0);

protected slots:
  void onServerCreation(pqServer*);
  void fiveMinuteTimeoutWarning();
  void finalTimeoutWarning();

private:
  Q_DISABLE_COPY(pqDefaultViewBehavior)
};

#endif


