/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkPVSaveBatchScriptDialog.h
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

Copyright (c) 2000-2001 Kitware Inc. 469 Clifton Corporate Parkway,
Clifton Park, NY, 12065, USA.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither the name of Kitware nor the names of any contributors may be used
   to endorse or promote products derived from this software without specific 
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
// .NAME vtkPVSaveBatchScriptDialog - Shows a text version of the timer log entries.
// .SECTION Description
// A widget to display timing information in the timer log.

#ifndef __vtkPVSaveBatchScriptDialog_h
#define __vtkPVSaveBatchScriptDialog_h

#include "vtkKWWidget.h"
class vtkKWApplication;
class vtkKWPushButton;
class vtkKWEntry;
class vtkKWLabel;
class vtkKWWindow;
class vtkKWEntry;
class vtkKWCheckButton;
class vtkPVApplication;

class VTK_EXPORT vtkPVSaveBatchScriptDialog : public vtkKWWidget
{
public:
  static vtkPVSaveBatchScriptDialog* New();
  vtkTypeRevisionMacro(vtkPVSaveBatchScriptDialog, vtkKWWidget);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Create a Tk widget
  virtual void Create(vtkKWApplication *app);
  
  // Description:
  // Display the interactor
  int Invoke();

  // Description:
  // Access to the results of the dialog.
  int GetOffScreen();
  const char* GetImagesFileName();
  const char* GetGeometryFileName();

  // Description:
  // Set the title of the TclInteractor to appear in the titlebar
  vtkSetStringMacro(Title);
  
  // Description:
  // Set the window to which the dialog will be slave.
  // If set, this dialog will always be on top of the master
  // window and will minimize with it (assuming that the windowing
  // system supports this)
  void SetMasterWindow(vtkKWWindow* win);
  
  // Description:
  // Path and root to use as default file names.
  vtkSetStringMacro(FilePath);
  vtkSetStringMacro(FileRoot);

  // Description:
  // Callback from the accept/dismiss button that closes the window.
  void Accept();
  void Cancel();

  // Description:
  // Callback used by widgets.
  void SaveImagesCheckCallback();
  void SaveGeometryCheckCallback();
  void ImageFileNameBrowseButtonCallback();
  void GeometryFileNameBrowseButtonCallback();

  // Description:
  // A convenience method.
  vtkPVApplication *GetPVApplication();

protected:
  vtkPVSaveBatchScriptDialog();
  ~vtkPVSaveBatchScriptDialog();

  char* FilePath;
  char* FileRoot;
  
  vtkKWWindow*      MasterWindow;

  vtkKWCheckButton* OffScreenCheck;

  vtkKWCheckButton* SaveImagesCheck;
  vtkKWWidget*      ImageFileNameFrame;
  vtkKWEntry*       ImageFileNameEntry;
  vtkKWPushButton*  ImageFileNameBrowseButton;

  vtkKWCheckButton* SaveGeometryCheck;
  vtkKWWidget*      GeometryFileNameFrame;
  vtkKWEntry*       GeometryFileNameEntry;
  vtkKWPushButton*  GeometryFileNameBrowseButton;

  vtkKWWidget*      ButtonFrame;
  vtkKWPushButton*  AcceptButton;
  vtkKWPushButton*  CancelButton;
  int               AcceptedFlag;
  int               Exit;
    
  char*   Title;

private:
  vtkPVSaveBatchScriptDialog(const vtkPVSaveBatchScriptDialog&); // Not implemented
  void operator=(const vtkPVSaveBatchScriptDialog&); // Not implemented
};

#endif
