Cam5 Catalyst Adaptor  {#Cam5Adaptor}
=====================

We provide a ParaView Catalyst Adaptor for CAM5 simulation
with Finite Volume (fv) or Spectral Element (se) dynamic modules.
We tested our code with cesm1_2_2.

Files:

* catalyst_add_and_coprocess.F90: included in one of the simulation
    files as it needs to call functions from the simulation
    executable.
* fv_create_data.cxx, se_create_data.cxx: initializes and stores the VTK grid.
* Grid.cxx, Grid.h: manages the VTK grid.
* fv_coprocess.py, se_coprocess.py: ParaView pipeline.
* cesm1_2_2.patch: patch to Cam5 sources

Useful documentation:

* <http://www.cesm.ucar.edu/models/cesm1.2/cam/docs/ug5_3/ug.html>
* <http://www.cesm.ucar.edu/cgi-bin/eaton/namelist/nldef2html-cam5_3>
* <http://www.cesm.ucar.edu/models/cesm1.2/cesm/doc/usersguide/book1.html>
* <http://www.cesm.ucar.edu/models/cesm1.2/cesm/doc/modelnl/env_run.html>
* <http://www.cesm.ucar.edu/models/pio/decomp.html>
* <http://www.cesm.ucar.edu/models/pio/_c_a_mexample.html>
* For information about the SE grid see <https://www.earthsystemcog.org/projects/dcmip-2012/cam-se>.

To build CAM5 and the Catalyst adaptor:

1. Download ParaView source code and
   download CESM (Community Earth System Model) source code using instructions in:

    <http://www.cesm.ucar.edu/models/cesm1.2/cesm/doc/usersguide/book1.html>

2. Modify `configure-cam.sh`, `gen-cam.sh`, `build-namelist.sh` in
   `~/src/ParaView/CoProcessing/Adaptors/CamAdaptor/`
   such that `CAM_ROOT` points to the location for `cesm1_2_2` sources.
   By default the scripts assume that `cesm1_2_2` is stored in `~/src/cesm_1_2_2`.

3. Build ParaView.

    Patch `cesm1_2_2` sources to call the Catalyst Adaptor:

        cd ~/src/cesm1_2_2/models/atm/cam
        patch < ~/build/ParaView/CoProcessing/Adaptors/CamAdaptor/cesm1_2_2.patch

    By default, Cam5 Adaptor saves the simulation data. See `fv_coprocess.py` and `se_coprocess.py`
    for the ParaView pipeline that is executed. To execute a different script you can modify those files
    or modify `src/cpl_mct/atm_comp_mct.F90` to point to your scripts.

4. Configure Cam5:

        mkdir ~/build/cam-5.3
        cd ~/build/cam-5.3

    Edit the configuration script by uncommenting the configuration
    you want or creating a different configuration. Parameters for
    finite volume and spectral element with different grid sizes are
    available. Run the configuration script.

        ~/src/ParaView/CoProcessing/Adaptors/CamAdaptor/configure-cam.sh

    Note you have to configure the number of MPI processors and use the same
    number when you run the simulation.

    Build cam5:

        make -j10

5. Create a run directory for the simulation and create the parameters
   for the simulation. This is where you set for how long you run the
   simulation and how often you save data.

        mkdir ~/run/cam-5.3
        cd ~/run/cam-5.3
        ~/src/ParaView/CoProcessing/Adaptors/CamAdaptor/build-namelist.sh | grep FOUND
   Namelists (parameters) for the simulation are listed in:

   <http://www.cesm.ucar.edu/cgi-bin/eaton/namelist/nldef2html-cam5_3>

    Different configurations need different data files. If any of the required
    data files are NOT FOUND download them from:
    <https://svn-ccsm-inputdata.cgd.ucar.edu/trunk/inputdata>
    Don't checkout everything as the datafiles are big!
    First checkout individual empty directories leading to the file you
    are interested in:

        cd ~/src/cesm-data
        svn update --depth empty atm
        cd atm
        svn update --depth empty cam
        cd cam
        svn update --depth empty inic
        cd inic
        svn update --depth empty homme
        cd homme

    Then checkout the file:

        svn update cami-mam3_0000-01-01_ne30np4_L30_c130424.nc

6. Run the simulation:

        ~/src/ParaView/CoProcessing/Adaptors/CamAdaptor/run-cam.sh

    The data fields generated by the simulation (those stored in the
    .nc file) are listed in:

   <http://www.cesm.ucar.edu/models/cesm1.2/cam/docs/ug5_3/hist_flds_fv_cam5.html>

   You can view the history file `camrun.cam.h0.*.nc` in ParaView
   using 'NetCDF files generic and CF conventions' reader. You can
   switch the dimensions viewed to be (lat,lon) or (lev, lat, lon) to
   get a sphere or a ball.

7. Optional: If you want to debug certain pio files in the simulation run:

        ~/src/ParaView/CoProcessing/Adaptors/CamAdaptor/gen-cam.sh d

    This command copies a list of .F90.in to the corresponding .F90
    so that gdb works correctly over these files. When you need to rebuild
    run:

        ~/src/ParaView/CoProcessing/Adaptors/CamAdaptor/gen-cam.sh g


To dump the history file produced by the simulation in text format run
    ncdump camrun.cam.h0.*.nc > camrun.txt

See <http://www.unidata.ucar.edu/software/netcdf/docs/netcdf_utilities_guide.html#ncdump_SYNOPSIS>
for more information.
