def test_whole_frame_sample_shape():
    """
    <0.8.2 had a bug where requesting a full frame did not return data with a
    channel dimension.
    """
    import kwcoco
    import ndsampler
    import pytest
    try:
        import lark  # NOQA
    except ImportError:
        pytest.skip('requires lark')

    dset = kwcoco.CocoDataset.demo('vidshapes1', image_size=128, num_frames=1, sensorchan='gray')

    # Hack away any transforms so we can access the data in its full dims easy
    # (todo: would be nice if kwcoco had a way to not generate asset to image warps)
    coco_img = dset.coco_image(1)
    for asset in coco_img.assets:
        asset.pop('warp_aux_to_img', None)
        W = coco_img.img['width'] = asset['width']
        H = coco_img.img['height'] = asset['height']

    sampler = ndsampler.CocoSampler(dset)

    # Sample is the full image frame, no cropping. Previously this failed.
    target = {
        'space_slice': (slice(0, H), slice(0, W)),
        'gids': [1],
        'channels': 'gray',
        'verbose_ndsample': 0,
    }
    # image_fpath = dset.coco_image(1).primary_image_filepath()
    # print(f'image_fpath={image_fpath}')
    sample = sampler.load_sample(target, with_annots=False)
    assert sample['im'].shape == (1, H, W, 1)

    # Also test case where the shape is less
    target = {
        'space_slice': (slice(0, H - 2), slice(0, W - 2)),
        'gids': [1],
        'channels': 'gray',
    }
    sample = sampler.load_sample(target, with_annots=False)
    assert sample['im'].shape == (1, H - 2, W - 2, 1)

    # Also test case where the shape is more
    target = {
        'space_slice': (slice(0, H + 2), slice(0, W + 2)),
        'gids': [1],
        'channels': 'gray',
    }
    sample = sampler.load_sample(target, with_annots=False)
    assert sample['im'].shape == (1, H + 2, W + 2, 1)
