docker login gitlab.kitware.com:4567

cd ~/code/ci-docker
declare -a PythonVersions=(
    "3.6.14" 
    "3.7.11" 
    "3.8.5" 
    "3.9.6" 
)
 
# Iterate the string array using for loop
for TAG in ${PythonVersions[@]}; do
    echo "TAG = $TAG"
done

for TAG in ${PythonVersions[@]}; do
    docker build \
        --build-arg "TAG=$TAG" \
        --build-arg "MAKE_OPTS=-j$(nproc)" \
        -t "ci-docker/gl-pyenv:${TAG}" \
        -f pyenv.dockerfile .
done

for TAG in ${PythonVersions[@]}; do
    docker tag ci-docker/gl-pyenv:$TAG gitlab.kitware.com:4567/computer-vision/ci-docker/gl-pyenv:$TAG
    docker push gitlab.kitware.com:4567/computer-vision/ci-docker/gl-pyenv:$TAG
done
