#!/bin/bash
INSTALL_URL="https://astral.sh/uv/install.sh"
INSTALL_TMP="assets/uv-install-latest.sh"
rm -rf "$INSTALL_TMP"
curl -LsSf "$INSTALL_URL" -o "$INSTALL_TMP"

# Step 2: Extract version from the script
# The version is typically assigned in a line like:
#   version="v0.1.21"
# So we grep and extract it
UV_VERSION=$(grep -E '^APP_VERSION=' "$INSTALL_TMP" | sed -E 's/APP_VERSION="([^"]+)"/\1/')
echo "UV_VERSION = $UV_VERSION"

# Step 3: Rename the file using the extracted version
INSTALL_NAME="uv-install-v${UV_VERSION}.sh"
cp "$INSTALL_TMP" "assets/$INSTALL_NAME"
