# This makes an ubuntu image with podman installed, suitable for running cibuildwheel
#FROM ubuntu:20.04
ARG BASE_IMAGE=gitlab.kitware.com:4567/computer-vision/ci-docker/uv:0.8.4-python3.12
FROM ${BASE_IMAGE} AS base

# Install common deps
#RUN apt-get update \
#    && DEBIAN_FRONTEND=noninteractive apt-get install btrfs-progs git golang-go go-md2man iptables libassuan-dev libbtrfs-dev libc6-dev libdevmapper-dev libglib2.0-dev libgpgme-dev libgpg-error-dev libprotobuf-dev libprotobuf-c-dev libseccomp-dev libselinux1-dev libsystemd-dev pkg-config runc uidmap gcc g++ build-essential  curl git iptables python3-pip libgl1-mesa-glx tree wget gnupg2 libapparmor-dev -y \
#    && rm -rf /var/lib/apt/lists/*  

# ------------------------------------
# Step 1: Install System Prerequisites
# ------------------------------------
RUN --mount=type=cache,target=/var/cache/apt \
    --mount=type=cache,target=/var/lib/apt/lists <<EOF
#!/bin/bash
set -e
apt update -q
#iptables
#go-md2man
#libbtrfs-dev 
#btrfs-progs
#python3-pip libgl1-mesa-glx 
#tree wget gnupg2 
# git golang-go \
#libassuan-dev libc6-dev libdevmapper-dev libglib2.0-dev \
#libgpgme-dev libgpg-error-dev libprotobuf-dev \
#libprotobuf-c-dev libseccomp-dev libselinux1-dev \
#libsystemd-dev \
#pkg-config runc uidmap gcc g++ build-essential \
#curl git libapparmor-dev 

DEBIAN_FRONTEND=noninteractive apt-get install -q -y --no-install-recommends \
  curl wget \
  btrfs-progs \
  gcc \
  git \
  golang-go \
  go-md2man \
  iptables \
  libassuan-dev \
  libbtrfs-dev \
  libc6-dev \
  libdevmapper-dev \
  libglib2.0-dev \
  libgpgme-dev \
  libgpg-error-dev \
  libprotobuf-dev \
  libprotobuf-c-dev \
  libseccomp-dev \
  libselinux1-dev \
  libsystemd-dev \
  make \
  pkg-config \
  runc \
  uidmap \
  libapparmor-dev 

  #passt \
  #netavark \


# Note: normal image cleanup not needed with buildkit cache
EOF



COPY podman_build_script.sh /podman_build_script.sh

ARG PODMAN_VERSION
ENV PODMAN_VERSION="$PODMAN_VERSION"
ARG CONMAN_VERSION
ENV CONMAN_VERSION="$CONMAN_VERSION"
RUN echo PODMAN_VERSION=$PODMAN_VERSION
RUN PODMAN_VERSION=$PODMAN_VERSION CONMAN_VERSION=$CONMAN_VERSION bash /podman_build_script.sh


RUN <<EOF
#!/bin/bash

cat <<__EOSCRIPT__ > /etc/containers/policy.json
{
    "default": [
        {
            "type": "insecureAcceptAnything"
        }
    ],
    "transports":
        {
            "docker-daemon":
                {
                    "": [{"type":"insecureAcceptAnything"}]
                }
        }
}
__EOSCRIPT__

cat <<__EOSCRIPT__ > /etc/containers/registries.conf

[registries.search]
registries = ['docker.io', 'quay.io', 'gitlab.kitware.com']

[registries.insecure]
registries = []

[registries.block]
registries = []

__EOSCRIPT__

EOF
