#!/bin/bash
cd ~/code/ci-docker

export PYTHON_VERSION=3.12
export UV_VERSION=0.8.8
export CONMAN_VERSION=v2.1.8
export PODMAN_VERSION=v4.9.0

export BASE_IMAGE="gitlab.kitware.com:4567/computer-vision/ci-docker/uv:$UV_VERSION-python$PYTHON_VERSION"-cuda12.4.1-cudnn-devel-ubuntu22.04
echo "BASE_IMAGE = $BASE_IMAGE"
docker pull "$BASE_IMAGE"

# Derive tag components
# shellcheck disable=SC2001
export BASE_TAG="$(echo "$BASE_IMAGE" | sed "s#.*/##; s/://g")"
echo "BASE_TAG = $BASE_TAG"
export IMAGE_NAME=podman
export IMAGE_TAG="${PODMAN_VERSION}-${BASE_TAG}"
export IMAGE_QUALNAME=$IMAGE_NAME:$IMAGE_TAG
export REMOTE_NAME="gitlab.kitware.com:4567/computer-vision/ci-docker"
export REMOTE_QUALNAME=$REMOTE_NAME/$IMAGE_QUALNAME
echo "IMAGE_QUALNAME = $IMAGE_QUALNAME"
echo "REMOTE_QUALNAME = $REMOTE_QUALNAME"

export ALIAS1=$IMAGE_NAME:latest-python${PYTHON_VERSION}
export ALIAS2=$IMAGE_NAME:latest

# Build image
echo "=== Building image for Python ${PYTHON_VERSION} with Podman ${PODMAN_VERSION} ==="
DOCKER_BUILDKIT=1 docker build --progress=plain \
    -t "$IMAGE_QUALNAME" \
    --build-arg "PODMAN_VERSION=$PODMAN_VERSION" \
    --build-arg "CONMAN_VERSION=$CONMAN_VERSION" \
    --build-arg "BASE_IMAGE=$BASE_IMAGE" \
    -f podman.dockerfile .

# Local tags
docker tag "$IMAGE_QUALNAME" "$ALIAS1"
docker tag "$IMAGE_QUALNAME" "$ALIAS2"

# Remote tags
docker tag "$IMAGE_QUALNAME" "$REMOTE_NAME/$IMAGE_QUALNAME"
docker tag "$IMAGE_QUALNAME" "$REMOTE_NAME/$ALIAS1"
docker tag "$IMAGE_QUALNAME" "$REMOTE_NAME/$ALIAS2"

inspect_build(){
    docker image history "$IMAGE_QUALNAME"
    #docker image history "$IMAGE_QUALNAME" --no-trunc
    #docker image inspect "$IMAGE_QUALNAME"
}

# Push all remote tags
REMOTE_TAGS=(
    "$REMOTE_NAME/$IMAGE_QUALNAME"
    "$REMOTE_NAME/$ALIAS1"
    "$REMOTE_NAME/$ALIAS2"
)

for TAG in "${REMOTE_TAGS[@]}"; do
    echo "TAG = $TAG"
done

docker run -it "$IMAGE_QUALNAME" podman --version
docker run --privileged -it "$IMAGE_QUALNAME" podman info --debug

for TAG in "${REMOTE_TAGS[@]}"; do
    docker push  "$TAG"
done

__heredoc__="
docker run -it ci-docker/podman podman --version

"


test_using_with_kwimage_ext(){

    docker run --rm --privileged -v ~/code/kwimage_ext:/host -it podman:latest bash

    # in container
	git config --global --add safe.directory /host/.git
    git clone /host/.git kwimage_ext
    cd kwimage_ext
    uv pip install cibuildwheel

  codeblock()
  {
      PYEXE=python3
      echo "$1" | $PYEXE -c "import sys; from textwrap import dedent; print(dedent(sys.stdin.read()).strip(chr(10)))"
  }
  # Make a storage.conf and containers.conf file
  #
  # https://github.com/containers/common/blob/main/docs/containers.conf.5.md
  # https://github.com/containers/storage/blob/main/docs/containers-storage.conf.5.md
  export CONTAINERS_CONF=$(realpath "temp_containers.conf")
  export CONTAINERS_STORAGE_CONF=$(realpath "temp_storage.conf")
  # --
  codeblock "
  [storage]
  driver=\"vfs\"
  graphroot=\"$HOME/.local/share/containers/vfs-storage\"
  runroot=\"$HOME/.local/share/containers/vfs-runroot\"
  [storage.options.aufs]
  mountopt=\"rw\"
  " > "$CONTAINERS_STORAGE_CONF"
  # --
  # For defaults see /usr/share/containers/containers.conf
  codeblock "
  [containers]
  default_capabilities = [
    \"CHOWN\",
    \"DAC_OVERRIDE\",
    \"FOWNER\",
    \"FSETID\",
    \"KILL\",
    \"NET_BIND_SERVICE\",
    \"SETFCAP\",
    \"SETGID\",
    \"SETPCAP\",
    \"SETUID\",
    \"SYS_CHROOT\"
  ]
  [engine]
  cgroup_manager=\"cgroupfs\"
  events_logger=\"file\"
  [machine]
  " > "$CONTAINERS_CONF"
  #podman run ubi8 mount
  #podman run --privileged ubi8 mount
  cat "$CONTAINERS_CONF"
  cat "$CONTAINERS_STORAGE_CONF"


    cibuildwheel --config-file pyproject.toml --platform linux --archs x86_64  #  kwimage_ext: +UNCOMMENT_IF(binpy)

}
