FROM nvidia/cuda:10.2-cudnn8-devel-ubuntu18.04

RUN apt-get update -q && \
    DEBIAN_FRONTEND=noninteractive apt-get install -q -y --no-install-recommends \
        bzip2 \
        ca-certificates \
        git \
        tree \
        libgl1-mesa-glx \
        libglib2.0-0 \
        libsm6 \
        libxext6 \
        libxrender1 \
        mercurial \
        subversion \
        wget \
        libgl1-mesa-glx \
        make build-essential libssl-dev zlib1g-dev \
        libbz2-dev libreadline-dev libsqlite3-dev wget curl llvm libncurses5-dev \
        libncursesw5-dev xz-utils tk-dev libffi-dev liblzma-dev python-openssl python3-openssl \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/*

RUN git clone https://github.com/pyenv/pyenv.git -b v2.0.3 /opt/pyenv

RUN (cd /opt/pyenv && src/configure && make -C src)

ENV PATH /opt/pyenv/bin:$PATH

RUN /opt/pyenv/bin/pyenv init -
RUN /opt/pyenv/bin/pyenv init --path

CMD [ "/bin/bash" ]
# SHELL ["/bin/bash", "--login", "-c"]

ARG TAG=3.8.6

RUN \
    MAKE_OPTS="" \
    PYTHON_CFLAGS="-march=native -O2 -pipe" \
    PYTHON_CONFIGURE_OPTS=" --enable-shared --enable-optimizations --with-computed-gotos --with-lto" \
    PROFILE_TASK="-m test.regrtest --pgo test_array test_base64 test_binascii test_binop test_bisect test_bytes test_bz2 test_cmath test_codecs test_collections test_complex test_dataclasses test_datetime test_decimal test_difflib test_embed test_float test_fstring test_functools test_generators test_hashlib test_heapq test_int test_itertools test_json test_long test_lzma test_math test_memoryview test_operator test_ordered_dict test_pickle test_pprint test_re test_set test_sqlite test_statistics test_struct test_tabnanny test_time test_unicode test_xml_etree test_xml_etree_c " \
    pyenv install $TAG --verbose

RUN pyenv shell $TAG
RUN pyenv global $TAG

# docker build --build-arg "TAG=3.8.6" -f pyenv.dockerfile .
