file(STRINGS "${Data}" lines LIMIT_INPUT 1024)
if(NOT "x${lines}" STREQUAL "xInput file already transformed.")
  message(SEND_ERROR "Input file:\n  ${Data}\ndoes not have expected content, but [[${lines}]]")
endif()
if(DEFINED DataSpace)
  file(STRINGS "${DataSpace}" lines LIMIT_INPUT 1024)
  if(NOT "x${lines}" STREQUAL "xInput file already transformed.")
    message(SEND_ERROR "Input file:\n  ${DataSpace}\ndoes not have expected content, but [[${lines}]]")
  endif()
endif()
if(DataMissing)
  if(EXISTS "${DataMissing}")
    message(SEND_ERROR
      "Input file:\n"
      "  ${DataMissing}\n"
      "exists but should not."
      )
  endif()
else()
  message(SEND_ERROR "DataMissing is not set!")
endif()
if(DataMissingWithAssociated)
  if(EXISTS "${DataMissingWithAssociated}")
    message(SEND_ERROR
      "Input file:\n"
      "  ${DataMissingWithAssociated}\n"
      "exists but should not."
      )
  endif()
else()
  message(SEND_ERROR "DataMissingWithAssociated is not set!")
endif()
set(SeriesAn1 "1\\.dat")
set(SeriesBn1 "_1\\.dat")
set(SeriesCn1 "\\.1\\.dat")
set(SeriesDn1 "-1\\.dat")
set(SeriesAl 1 2 3)
set(SeriesBl _1 _2 _3)
set(SeriesCl .1 .2 .3)
set(SeriesDl -1 -2 -3)
foreach(s A B C D)
  foreach(n "" ${Series${s}l})
    string(REGEX REPLACE "\\.dat$" "${n}.dat" file "${Series${s}}")
    if(NOT EXISTS "${file}")
      message(SEND_ERROR "Input file:\n  ${file}\ndoes not exist!")
    endif()
  endforeach()
endforeach()
foreach(s A B C D)
  foreach(n ${Series${s}l})
    string(REGEX REPLACE "${Series${s}n1}$" "${n}.dat" file "${Series${s}n}")
    if(NOT EXISTS "${file}")
      message(SEND_ERROR "Input file:\n  ${file}\ndoes not exist!")
    endif()
  endforeach()
endforeach()
foreach(n .1 .2 .3 .4)
  string(REGEX REPLACE "\\.1\\.dat$" "${n}.dat" file "${SeriesMixed}")
  if(NOT EXISTS "${file}")
    message(SEND_ERROR "Input file:\n  ${file}\ndoes not exist!")
  endif()
endforeach()
foreach(n A B)
  string(REGEX REPLACE "A\\.dat$" "${n}.dat" file "${Paired}")
  if(NOT EXISTS "${file}")
    message(SEND_ERROR "Input file:\n  ${file}\ndoes not exist!")
  endif()
endforeach()
foreach(n Top A B C)
  string(REGEX REPLACE "Top\\.dat$" "${n}.dat" file "${Meta}")
  if(NOT EXISTS "${file}")
    message(SEND_ERROR "Input file:\n  ${file}\ndoes not exist!")
  endif()
endforeach()
foreach(n A B C)
  set(file "${Directory}/${n}.dat")
  if(NOT EXISTS "${file}")
    message(SEND_ERROR "Input file:\n  ${file}\ndoes not exist!")
  endif()
endforeach()
list(LENGTH Semicolons len)
if("${len}" EQUAL 2)
  foreach(file ${Semicolons})
    if(NOT EXISTS "${file}")
      message(SEND_ERROR "Input file:\n  ${file}\ndoes not exist!")
    endif()
  endforeach()
else()
  message(SEND_ERROR "Semicolons value:\n  ${Semicolons}\nis not a list of length 2.")
endif()
