# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.

if(NOT CMAKE_GENERATOR MATCHES "Xcode|Ninja")
  message(FATAL_ERROR "Swift language is not supported by the ${CMAKE_GENERATOR} generator")
endif()

set(CMAKE_Swift_COMPILER_ENV_VAR "")

# Local system-specific compiler preferences for this language.
include(Platform/${CMAKE_SYSTEM_NAME}-Determine-Swift OPTIONAL)
include(Platform/${CMAKE_SYSTEM_NAME}-Swift OPTIONAL)
if(NOT CMAKE_Swift_COMPILER_NAMES)
  set(CMAKE_Swift_COMPILER_NAMES $ENV{CMAKE_Swift_COMPILER_ENV_VAR} swiftc)
endif()

find_program(CMAKE_Swift_COMPILER NAMES ${CMAKE_Swift_COMPILER_NAMES})

if(NOT CMAKE_Swift_COMPILER_ID_RUN)
  set(CMAKE_Swift_COMPILER_ID_RUN TRUE)

  # Try to identify the compiler.
  set(CMAKE_Swift_COMPILER_ID)
  # FIXME(compnerd) identify the compiler vendor.

  execute_process(COMMAND
                    ${CMAKE_Swift_COMPILER} "-version"
                  OUTPUT_VARIABLE
                    CMAKE_Swift_COMPILER_VERSION_OUTPUT)
  string(REGEX REPLACE "Swift version ([\\.0-9A-Za-z-]+).*$" "\\1"
         CMAKE_Swift_COMPILER_VERSION "${CMAKE_Swift_COMPILER_VERSION_OUTPUT}")
  message(STATUS "The swift compiler version is ${CMAKE_Swift_COMPILER_VERSION}")
endif()

set(_CMAKE_PROCESSING_LANGUAGE "Swift")
include(CMakeFindBinUtils)
unset(_CMAKE_PROCESSING_LANGUAGE)

# configure variables set in this file for fast reload later on
configure_file(${CMAKE_ROOT}/Modules/CMakeSwiftCompiler.cmake.in
               ${CMAKE_PLATFORM_INFO_DIR}/CMakeSwiftCompiler.cmake @ONLY)
