set(conda_prefix "$ENV{CONDA_PREFIX}")

set(netcdf_suffix ".so")
if (APPLE)
  set(netcdf_suffix ".dylib")
endif()

set(path_prefix "${conda_prefix}")
if ($ENV{CONDA_BUILD})
  set(path_prefix "$ENV{PREFIX}")
endif()
set(CURL_INCLUDE_DIR "${path_prefix}/include" CACHE PATH "Initial cache")
#set(CURL_LIBRARY "${path_prefix}/lib/libcurl${CMAKE_SHARED_LIBRARY_SUFFIX}" CACHE PATH "Initial cache")
set(EIGEN3_INCLUDE_DIR "${path_prefix}/include/eigen3" CACHE PATH "Initial cache")
set(HDF5_ROOT "${path_prefix}" CACHE PATH "Initial cache")
set(NETCDF_INCLUDE_DIR "${path_prefix}/include" CACHE PATH "Initial cache")
set(NETCDF_C_LIBRARY "${path_prefix}/lib/libnetcdf${netcdf_suffix}" CACHE PATH "Initial cache")
#set(NETCDF_ROOT "${path_prefix}/lib/cmake/netCDF" CACHE PATH "Initial cache")
set(nlohmann_json_DIR "${path_prefix}/lib/cmake/nlohmann_json" CACHE PATH "Initial cache")


set(BUILD_SHARED_LIBS OFF CACHE BOOL "Initial cache")
set(CMAKE_VISIBILITY_INLINES_HIDDEN ON CACHE BOOL "Initial cache")

set(ENABLE_BLASLAPACK OFF CACHE BOOL "Initial cache")
set(MOAB_HAVE_EIGEN ON CACHE BOOL "Initial cache")
set(MOAB_USE_SZIP ON CACHE BOOL "Initial cache")
set(MOAB_USE_MPI OFF CACHE BOOL "Initial cache")
set(MOAB_USE_HDF ON CACHE BOOL "Initial cache")
set(ENABLE_HDF5 ON CACHE BOOL "Initial cache")
set(MOAB_USE_NETCDF ON CACHE BOOL "Initial cache")
set(ENABLE_NETCDF ON CACHE BOOL "Initial cache")
set(MOAB_ENABLE_TESTING OFF CACHE BOOL "Initial cache")
set(ENABLE_TESTING OFF CACHE BOOL "Initial cache")

# Dont build any moab tools
set(MOAB_BUILD_MBCONVERT OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_HEXMODOPS OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBSIZE OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBMEM OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBSKIN OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBDEPTH OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBTAGPROP OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBGSETS OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_SPHEREDECOMP OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBSURFPLOT OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBPART OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBSLAVEPART OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBCOUPLER OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBHONODES OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBUMR OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBQUALITY OFF CACHE BOOL "Initial cache")
set(MOAB_BUILD_MBTEMPEST OFF CACHE BOOL "Initial cache")
