//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME rggNucCore - Represents a core for schema planner.
// Cores are composed of a bunch of assemblies.
// .SECTION Description
// .SECTION See Also

#ifndef __smtk_session_rgg_qt_rggNucCore_h
#define __smtk_session_rgg_qt_rggNucCore_h

#include "smtk/model/EntityRef.h"
#include "smtk/session/rgg/Exports.h"
#include "smtk/session/rgg/qt/rggLatticeContainer.h"

// Represents a nuclear core in schema planner.
class SMTKQTRGGSESSION_EXPORT rggNucCore : public rggLatticeContainer
{
public:
  rggNucCore(smtk::model::EntityRef entity);
  ~rggNucCore() override;
  virtual QString extractLabel(QString const&) override;
  // Create a list with pair<${name}(${label}, entity)>
  virtual void fillList(std::vector<std::pair<QString, smtk::model::EntityRef> >& l) override;
  virtual smtk::model::EntityRef getFromLabel(const QString& label) override;
  virtual bool IsHexType() override;
  virtual void calculateExtraTranslation(double& transX, double& transY) override;
  virtual void calculateTranslation(double& transX, double& transY) override;
  virtual void setUpdateUsed() override;
  virtual void getRadius(double& ri, double& rj) const override;

  // This function would use the assy to populate the rggNucCore
  void resetBySMTKCore(const smtk::model::EntityRef& core);

protected:
};

#endif
