//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef smtk_markup_ontology_OwlRdfSource_h
#define smtk_markup_ontology_OwlRdfSource_h

#include "smtk/markup/ontology/Source.h"

namespace smtk
{
namespace markup
{
namespace ontology
{

/**\brief Import ontology classes from an OWL-formatted RDF XML file.
  *
  * This class will extract class names and descriptions from
  * the Open Biological and Biomedical Ontologies (OBO) Foundry[1]
  * as well as those generated by yamlpyowl[2].
  *
  * [1]: https://github.com/OBOFoundry
  * [2]: https://github.com/cknoll/yamlpyowl
  */
class SMTKMARKUP_EXPORT OwlRdfSource : public Source
{
public:
  OwlRdfSource(const std::string& xml, const std::string& url, const std::string& name);
  ~OwlRdfSource() override = default;

protected:
  void parse();

  class Internal;
  friend class Internal;
  Internal* m_p;
};

} // namespace ontology
} // namespace markup
} // namespace smtk

#endif // smtk_markup_ontology_OwlRdfSource_h
