//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME qtPhasePropertyItem - Custom ItemView for Truchas material properties
// .SECTION Description
// .SECTION See Also
// qtItem

#ifndef __smtk_simulation_truchas_qt_qtPhasePropertyItem_h
#define __smtk_simulation_truchas_qt_qtPhasePropertyItem_h

#include "smtk/simulation/truchas/qt/Exports.h"

#include "smtk/extension/qt/qtAttributeItemInfo.h"
#include "smtk/extension/qt/qtItem.h"

#include <string>

typedef smtk::extension::qtAttributeItemInfo qtItemInfo;

// Implements custom ItemView for a Truchas material property
// that is part of one phase. These properties can be superseded
// by shared-material properties, in which case the corresponding
// property is disabled in the individual phases. This ItemView
// checks for integer UserData attached to the item to determine
// whether the item should be displayed or not. Because all properties
// are type double, this is a subclass of qtInputsItem, which is the
// default for doubles.
class SMTKTRUCHASQTEXT_EXPORT qtPhasePropertyItem : public smtk::extension::qtItem
{
  Q_OBJECT
public:
  // Return UserData key for indicating that item is in shared state
  static std::string userDataKey();

  static smtk::extension::qtItem* createItemWidget(const qtItemInfo& info);

  qtPhasePropertyItem(const smtk::extension::qtAttributeItemInfo& info);

  void updateItemData() override;
}; // class
#endif
