//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#include "qtPhasePropertyItem.h"

#include "smtk/attribute/Item.h"
#include "smtk/extension/qt/qtInputsItem.h"
#include "smtk/simulation/UserData.h"

#include <QDebug>
#include <QLabel>
#include <QString>

std::string qtPhasePropertyItem::userDataKey()
{
  return "_truchas_qtPhasePropertyItem_";
}

smtk::extension::qtItem* qtPhasePropertyItem::createItemWidget(
  const smtk::extension::qtAttributeItemInfo& info)
{
  // qDebug() << "qtPhasePropertyItem::createItemWidget()";
  // Check item's userdata to determine if this is a shared property
  bool isShared = false;
  auto item = info.item();
  auto userData = item->userData(userDataKey());
  if (userData != nullptr)
  {
    auto userDataInt = smtk::dynamic_pointer_cast<smtk::simulation::UserDataInt>(userData);
    isShared = userDataInt->value();
  }
  // qDebug() << "isShared" << isShared;

  if (isShared)
  {
    // qDebug() << "New qtPhasePropertyItem" << item->name().c_str();
    return new qtPhasePropertyItem(info);
  }

  // (else) If not shared, return qtInputsItem
  return smtk::extension::qtInputsItem::createItemWidget(info);
}

qtPhasePropertyItem::qtPhasePropertyItem(const smtk::extension::qtAttributeItemInfo& info)
  : qtItem(info)
{
  this->updateItemData();
}

void qtPhasePropertyItem::updateItemData()
{
  if (m_widget == nullptr)
  {
    QString text = QString::fromStdString(m_itemInfo.item()->label());
    text += " => Shared Property";
    m_widget = new QLabel(text, this->parentWidget());
    m_widget->setEnabled(false);
  }
  this->qtItem::updateItemData();
}
