//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtk_simulation_truchas_utiltiy_MaterialAttributeUtils_h
#define smtk_simulation_truchas_utility_MaterialAttributeUtils_h

#include "smtk/simulation/truchas/Exports.h"

#include "smtk/PublicPointerDefs.h"
#include "smtk/attribute/Categories.h"

namespace smtk
{
namespace simulation
{
namespace truchas
{
class SMTKTRUCHAS_EXPORT MaterialAttributeUtils
{
public:
  bool configureNewAttribute(smtk::attribute::AttributePtr att) const;
  bool addPhase(smtk::attribute::AttributePtr att) const;
  bool removePhase(smtk::attribute::AttributePtr att, std::size_t phase) const;

  bool enableSharedItem(smtk::attribute::ItemPtr sharedItem, bool enabled) const;

  bool isValid(smtk::attribute::AttributePtr att) const;
  bool isValid(smtk::attribute::AttributePtr att, const std::set<std::string>& categories,
    std::string& reason) const;
};
}
}
}

#endif
