//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_simulation_truchas_MaterialAttributeUtils_h
#define pybind_smtk_simulation_truchas_MaterialAttributeUtils_h

#include <pybind11/pybind11.h>

#include "smtk/simulation/truchas/utility/MaterialAttributeUtils.h"

#include "smtk/attribute/Attribute.h"


namespace py = pybind11;

py::class_< smtk::simulation::truchas::MaterialAttributeUtils > pybind11_init_smtk_truchas_MaterialAttributeUtils(py::module &m)
{
  py::class_< smtk::simulation::truchas::MaterialAttributeUtils > instance(m, "MaterialAttributeUtils");
  instance
    .def(py::init<>())
    .def("addPhase", &smtk::simulation::truchas::MaterialAttributeUtils::addPhase)
    ;
  return instance;
}

#endif
