<?xml version="1.0" encoding="utf-8" ?>
<!-- Description of the RGG "CreateModel" Operator -->
<SMTK_AttributeResource Version="3">
  <Definitions>
    <!-- Operator -->
    <include href="smtk/operation/Operation.xml"/>
    <AttDef Type="create model" Label="Model - Create" BaseType="operation">
      <BriefDescription>Create a RGG model.</BriefDescription>
      <DetailedDescription>
        Create a RGG model with a simple nuclear core. Users can next use the "edit core" operator
        to change other properties. Ex. z origin, duct thickness and height. Geometry type should
        be decided at creation time and cannot be modified later.
      </DetailedDescription>
      <ItemDefinitions>
        <Resource Name="resource" Label="Import into" Optional="true" IsEnabledByDefault="false">
          <Accepts>
            <Resource Name="smtk::session::rgg::Resource"/>
          </Accepts>
        </Resource>

        <String Name="session only" Label="session" Advanced="1">
          <DiscreteInfo DefaultIndex="0">
            <Structure>
              <Value Enum="this file">import into this file</Value>
            </Structure>
            <Structure>
              <Value Enum="this session">import into a new file using this file's session</Value>
            </Structure>
          </DiscreteInfo>
        </String>

        <String Name="name" NumberOfValuesRequired="1">
          <BriefDescription>A user-assigned name for the core.</BriefDescription>
          <DetailedDescription>
            A user-assigned name for the model.
            The name need not be unique, but unique names are best.
            If not assigned, a machine-generated name will be assigned.
          </DetailedDescription>
          <DefaultValue>nuclearCore</DefaultValue>
        </String>
        <String Name="geometry type" Label="geometry type" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <ChildrenDefinitions>
            <Double Name="duct thickness X" NumberOfRequiredValues="1">
              <BriefDescription>Thickness of the associated rectilinear duct along x axis</BriefDescription>
              <DetailedDescription>
                Thickness of the associated rectilinear duct along x axis.
              </DetailedDescription>
              <DefaultValue>10.0</DefaultValue>
            </Double>
            <Double Name="duct thickness Y" NumberOfRequiredValues="1">
              <BriefDescription>Thickness of the associated rectilinear assembly along y axis</BriefDescription>
              <DetailedDescription>
                Thickness of the associated rectilinear assembly along y axis.
              </DetailedDescription>
              <DefaultValue>10.0</DefaultValue>
            </Double>
            <Double Name="duct thickness" NumberOfRequiredValues="1">
              <BriefDescription>Thickness of the hex duct</BriefDescription>
              <DetailedDescription>
                Thickness of the hex duct(radius of the inscribed circle).
              </DetailedDescription>
              <DefaultValue>10.0</DefaultValue>
            </Double>
            <Double Name="height" NumberOfRequiredValues="1">
              <BriefDescription>Height of the nuclear core</BriefDescription>
              <DetailedDescription>
                Height of the nuclear core. It would be consumed by related ducts.
              </DetailedDescription>
              <DefaultValue>10.0</DefaultValue>
            </Double>
            <Double Name="z origin" NumberOfRequiredValues="1" AdvanceLevel="0">
              <BriefDescription>z origin of the nuclear core</BriefDescription>
              <DetailedDescription>
              </DetailedDescription>
                Z origin of the core. It would be consumed by related ducts.
              <DefaultValue>0.0</DefaultValue>
            </Double>
            <Int Name="hex lattice size" NumberOfRequiredValues="1" AdvanceLevel="0">
              <DefaultValue>1</DefaultValue>
            </Int>
            <Int Name="rect lattice size" NumberOfRequiredValues="2" AdvanceLevel="0">
              <DefaultValue>4, 4</DefaultValue>
            </Int>
          </ChildrenDefinitions>
          <DiscreteInfo DefaultIndex="0">
            <Structure>
              <Value Enum= "Hex">Hex</Value>
              <Items>
                <Item>z origin</Item>
                <Item>height</Item>
                <Item>duct thickness</Item>
                <Item>hex lattice size</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum= "Rect">Rect</Value>
              <Items>
                <Item>z origin</Item>
                <Item>height</Item>
                <Item>duct thickness X</Item>
                <Item>duct thickness Y</Item>
                <Item>rect lattice size</Item>
              </Items>
            </Structure>
          </DiscreteInfo>
        </String>
      </ItemDefinitions>
    </AttDef>
    <!-- Result -->
    <include href="smtk/operation/Result.xml"/>
    <AttDef Type="result(create model)" BaseType="result">
      <ItemDefinitions>
        <!-- The created model is returned in the base result's "created" item. -->
        <Resource Name="resource" HoldReference="true">
          <Accepts>
            <Resource Name="smtk::session::rgg::Resource"/>
          </Accepts>
        </Resource>
      </ItemDefinitions>
    </AttDef>
  </Definitions>
</SMTK_AttributeResource>
