<?xml version="1.0"?>
<SMTK_AttributeResource Version="5" DisplayHint="true">
  <Categories>
    <Cat>overset</Cat>
    <Cat>background</Cat>
    <Cat>object</Cat>
    <Cat>3d</Cat>
    <Cat>2d</Cat>
  </Categories>

  <!-- For now, make all background/object/overset categories active -->
  <Analyses Exclusive="true">
    <Analysis Type="overInterDyMFoam" Exclusive="True">
      <Cat>overset</Cat>
      <Cat>background</Cat>
      <Cat>object</Cat>
    </Analysis>
    <Analysis Type="Two Dimension" BaseType="overInterDyMFoam">
      <Cat>2d</Cat>
    </Analysis>
    <Analysis Type="Three Dimension" BaseType="overInterDyMFoam">
      <Cat>3d</Cat>
    </Analysis>
  </Analyses>


  <Includes>
    <File>internal/templates/wavetank-common.sbt</File>
  </Includes>

  <Definitions>
    <!-- Explicity specify analysis attribute definition so that we can
         initialize it the way we want.
    -->
    <AttDef Type="Analysis" Label="Analysis">
      <ItemDefinitions>
        <String Name="Analysis" Label="Solver" NumberOfRequiredValues="1">
          <ChildrenDefinitions>
            <String Name="overInterDyMFoam" Label="overInterDyMFoam" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="1">
                <Value Enum="Two Dimension">Two Dimension</Value>
                <Value Enum="Three Dimension">Three Dimension</Value>
              </DiscreteInfo>
            </String>
          </ChildrenDefinitions>
          <DiscreteInfo DefaultIndex="0">
            <Structure>
              <Value Enum="overInterDyMFoam">overInterDyMFoam</Value>
              <Items>
                <Item>overInterDyMFoam</Item>
              </Items>
            </Structure>
          </DiscreteInfo>
        </String>
      </ItemDefinitions>
    </AttDef>

    <AttDef Type="BackgroundBlockMesh" BaseType="AbstractBlockMesh">
      <!-- Use inheritance mode to include BaseType items w/o adding categories -->
      <CategoryInfo InheritanceMode="LocalOnly">
        <Include><Cat>background</Cat></Include>
      </CategoryInfo>
    </AttDef>

    <AttDef Type="OversetBlockMesh" BaseType="AbstractBlockMesh">
      <!-- Use inheritance mode to include BaseType items w/o adding categories -->
      <CategoryInfo InheritanceMode="LocalOnly">
        <Include><Cat>overset</Cat></Include>
      </CategoryInfo>
    </AttDef>

  </Definitions>

  <Views>
    <View Type="Group" Title="Wave Tank" TopLevel="true" TabPosition="North"
    FilterByAdvanceLevel="true" FilterByCategory="false">
      <Views>
        <View Title="Control" />
        <View Title="OversetMesh" />
        <View Title="BackgroundMesh" />
        <View Title="Physics" />
      </Views>
    </View>

    <!-- Analysis view is contained inside Control view in wavetank-common.sbt -->
    <View Type="Analysis" Title="Solver" Label="Solver"
      AnalysisAttributeName="Analysis" AnalysisAttributeType="Analysis">
    </View>

    <View Title="BackgroundMesh" Type="Group" Label="Background Mesh" TabPosition="North">
      <Views>
        <View Title="BackgroundBlockMesh" />
        <View Title="refineMesh" />
      </Views>
    </View>

    <View Type="Instanced" Title="BackgroundBlockMesh" Label="blockMesh">
      <InstancedAttributes>
        <Att Type="BackgroundBlockMesh" Name="BackgroundBlockMesh">
          <ItemViews>
            <View Item="box" Type="Box" Min="point 0" Max="point 1" Angles="angles" ShowControls="true"/>
          </ItemViews>
        </Att>
      </InstancedAttributes>
    </View>

    <View Type="Group" Title="Object" Label="Object" Style="Tiled">
      <Views>
        <View Title="ObjectPoint" />
        <View Title="SurfaceFeatures" />
        <View Title="MassProperties" />
      </Views>
    </View>

    <View Title="OversetMesh" Type="Group" Label="Overset Mesh" TabPosition="North">
      <Views>
        <View Title="Object" />
        <View Title="OversetBlockMesh" />
        <View Title="Snappy" />
      </Views>
    </View>

    <View Type="Instanced" Title="OversetBlockMesh" Label="blockMesh">
      <InstancedAttributes>
        <Att Type="OversetBlockMesh" Name="OversetBlockMesh">
          <ItemViews>
            <View Item="box" Type="Box" Min="point 0" Max="point 1" Angles="angles" ShowControls="true"/>
          </ItemViews>
        </Att>
      </InstancedAttributes>
    </View>

    <View Title="Physics" Type="Group" TabPosition="North">
      <Views>
        <View Title="WaveModel" />
      </Views>
    </View>


    <View Type="Instanced" Title="WaveModel" Label="Wave Model">
      <InstancedAttributes>
        <Att Type="WaveModel" Name="WaveModel" />
      </InstancedAttributes>
    </View>
  </Views>

</SMTK_AttributeResource>
