"""
Script to insert entry in Simulation Asset Location Index.
This script REQUIRES a key file with "url" and "apikey" fields.

"""

import argparse
import json

import girder_client
from girder_client import GirderClient, HttpError

from writers import sali

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Add remote asset location to SALI')
    parser.add_argument('keyfile', help='json file with girder url and apikey strings')
    parser.add_argument('newt_sessionid', help='NEWT session id')
    parser.add_argument('modelfile', help='model file (path)')
    parser.add_argument('cori_path', help='path on Cori file system to save')
    parser.add_argument('-r', action='store_true', help='can replace existing cori_path')

    args = parser.parse_args()

    # Read keyfile
    with open(args.keyfile) as key_fp:
        js = json.load(key_fp)
        girder_url = js['url']
        apikey = js['apikey']
    if girder_url is None:
        raise RuntimeError('key file missing girder_url')
    if apikey is None:
        raise RuntimeError('key file missing apikey')

    # Initialize girder client
    url = '%s/api/v1' % girder_url
    girder_client = GirderClient(apiUrl=url)
    girder_client.authenticate(apiKey=apikey)

    sali = sali.SimulationAssetLocationIndex(girder_client, args.newt_sessionid)
    result = sali.put(args.modelfile, args.cori_path, remote_machine='cori', can_replace=args.r)

    print('finis')
