"""
Script to add simulation asset location to SALI.
SALI = Simulation Asset Location Index

"""

import argparse
import json

from client import sali_client

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Add remote asset location to SALI')
    parser.add_argument('keyfile', help='json file with girder url and apikey strings')
    parser.add_argument('modelfile', help='model file (path)')
    parser.add_argument('cori_path', help='path on Cori file system to save')
    parser.add_argument('-r', action='store_true', help='can replace existing cori_path')

    args = parser.parse_args()

    # Read keyfile
    with open(args.keyfile) as key_fp:
        js = json.load(key_fp)
        girder_url = js['url']
        apikey = js['apikey']
    if girder_url is None:
        raise RuntimeError('key file missing girder_url')
    if apikey is None:
        raise RuntimeError('key file missing apikey')

    sali = sali_client.SALIClient(girder_url, apikey)
    result = sali.put(args.modelfile, 'cori', args.cori_path, can_replace=args.r)

    print('finis')
