<?xml version="1.0"?>
<SMTK_AttributeResource Version="4">
  <Categories>
    <Cat>Simulation</Cat>
    <Cat>Rf-Postprocess</Cat>
  </Categories>

  <Definitions>
    <AttDef Type="ace3p-export" BaseType="operation" Label="Export to ACE3P" Version="2">
      <Categories>
        <Cat>Simulation</Cat>
      </Categories>
      <!-- Version 2 adds option for NEWT Session ID -->
      <BriefDescription>
        Write ACE3P input file for selected program.
      </BriefDescription>
      <DetailedDescription>
      </DetailedDescription>
      <ItemDefinitions>
        <Resource Name="model" Label="Model" LockType="DoNotLock">
          <Accepts>
            <Resource Name="smtk::model::Resource" />
          </Accepts>
        </Resource>
        <Resource Name="attributes" Label="Attributes" LockType="DoNotLock">
          <Categories>
            <Cat>Rf-Postprocess</Cat>
          </Categories>
          <Accepts>
            <Resource Name="smtk::attribute::Resource"/>
          </Accepts>
        </Resource>
        <File Name="MeshFile" Label="Mesh File" ShouldExist="True"
          FileFilters="Exodus files (*.exo *.ex2 *.gen);;NetCDf files (*.ncdf);; All files (*.*)" Version="0">
          <CategoryInfo Combination="All">
            <Exclude Combination="All">
              <Cat>Rf-Postprocess</Cat>
            </Exclude>
          </CategoryInfo>
        </File>
        <Directory Name="OutputFolder" Label="Export Folder" Version="0">
          <BriefDescription>The folder to use on the local filesystem</BriefDescription>
          <Categories>
            <Cat>Rf-Postprocess</Cat>
          </Categories>
        </Directory>
        <String Name="OutputFilePrefix" Label="Filename prefix" Version="0">
          <BriefDescription>The prefix to use for generated files</BriefDescription>
          <Categories>
            <Cat>Rf-Postprocess</Cat>
          </Categories>
        </String>
        <Void Name="TestMode" Label="Test Mode" Optional="true" IsEnabledByDefault="false" AdvanceLevel="1">
          <BriefDescription>For internal use</BriefDescription>
          <Categories>
            <Cat>Rf-Postprocess</Cat>
          </Categories>
        </Void>

        <Group Name="NERSCSimulation" Label="Submit job to NERSC"
               Optional="true" IsEnabledByDefault="false"
               Version="1" NumberOfRequiredGroups="1">
          <Categories>
            <Cat>Rf-Postprocess</Cat>
          </Categories>
          <ItemDefinitions>
            <String Name="JobName" Label="Job name" Version="0">
              <BriefDescription>Label you can use to track your job</BriefDescription>
              <DefaultValue>ACE3P</DefaultValue>
            </String>
            <String Name="JobNotes" Label="Notes" Version="0" MultipleLines="true">
              <BriefDescription>Optional notes you want to save with this job</BriefDescription>
              <DefaultValue> </DefaultValue>
            </String>
            <String Name="CumulusHost" Label="Cumulus host" Version="0">
              <!-- DefaultValue>http://localhost:8080</DefaultValue
                -->
              <DefaultValue>https://ace3p.kitware.com</DefaultValue>
            </String>
            <String Name="NERSCRepository" Label="Project repository" Version="0" />

            <String Name="NERSCCredentials" Label="NERSC Credentials" Version="0">
              <ChildrenDefinitions>
                <String Name="NEWTSessionId" Label="NEWT Session ID" Version="0" />
                <String Name="NERSCAccountName" Label="NERSC Account name" Version="0" />
                <String Name="NERSCAccountPassword" Label="Password"
                        Secure="true" Version="0" />
                <String Name="NERSCMultfactorToken" Label="Multifactor token" Version="0" />
              </ChildrenDefinitions>
              <DiscreteInfo DefaultIndex="0">
                <Structure>
                  <Value Enum="NEWT">newt_sessionid</Value>
                  <Items>
                    <Item>NEWTSessionId</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value Enum="Login">login</Value>
                  <Items>
                    <Item>NERSCAccountName</Item>
                    <Item>NERSCAccountPassword</Item>
                    <Item>NERSCMultfactorToken</Item>
                  </Items>
                </Structure>
              </DiscreteInfo>
            </String>
            <String Name="Machine" Label="NERSC Machine" Version="0">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Cori (Cray XC40)">cori</Value>
              </DiscreteInfo>
            </String>
            <Group Name="JobDirectory" Label="Job directory" Version="1" NumberOfRequiredGroups="1" Enabled="true">
              <BriefDescription>The working directory to use on the NERSC machine.</BriefDescription>
              <ItemDefinitions>
                <String Name="FileSystem" Label="File System" Version="0">
                  <ChildrenDefinitions>
                    <String Name="SubFolder" Label="Subfolder"  Version="0">
                      <BriefDescription>Relative path from user's $SCRATCH directory</BriefDescription>
                    </String>
                    <Void Name="AppendJobNameFolder" Label="Append Job Name Folder" Version="0"
                      Optional="true" IsEnabledByDefault="true">
                      <BriefDescription>Adds a folder with the job name to the specified path</BriefDescription>
                    </Void>
                    <String Name="FullPath" Label="Full Path"  Version="0">
                      <BriefDescription>Absolute path on NERSC machine</BriefDescription>
                    </String>
                  </ChildrenDefinitions>
                  <DiscreteInfo DefaultIndex = "0">
                    <Structure>
                      <Value Enum="$SCRATCH">scratch</Value>
                      <Items>
                        <Item>SubFolder</Item>
                        <Item>AppendJobNameFolder</Item>
                      </Items>
                    </Structure>
                    <Structure>
                      <Value Enum="Other">other</Value>
                      <Items>
                        <Item>FullPath</Item>
                      </Items>
                    </Structure>
                  </DiscreteInfo>
                </String>
              </ItemDefinitions>
            </Group>
            <String Name="Queue" Label="Queue" Version="0">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="debug">debug</Value>
                <Value Enum="regular">normal</Value>
                <Value Enum="premium">premium</Value>
                <Value Enum="low priority">low</Value>
                <Value Enum="scavenger">scavenger</Value>
              </DiscreteInfo>
            </String>
            <Int Name="NumberOfNodes" Label="Number of nodes" Version="0">
              <DefaultValue>1</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>
            <!--  Note that SLAC calls this number of "cores" -->
            <Int Name="NumberOfTasks" Label="Number of cores" Version="0">
              <BriefDescription>Number of processes per node</BriefDescription>
              <DefaultValue>1</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>
            <Int Name="Timeout" Label="Time limit" Units="min" Version="0">
              <DefaultValue>5</DefaultValue>
              <RangeInfo><Min Inclusive="true">1</Min></RangeInfo>
            </Int>
<!--             <String Name="TailFile" Label="Tail Filename" Version="0" AdvanceLevel="1">
            </String>
 -->          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
     </AttDef>

     <AttDef Type="export-result" BaseType="result">
      <ItemDefinitions>
        <File Name="output-file" />
      </ItemDefinitions>
     </AttDef>
   </Definitions>
  <Views>
    <View Type="Operation" Title="Export Settings" TopLevel="true" FilterByCategory="false" FilterByAdvanceLevel="true">
      <InstancedAttributes>
        <Att Name="Options" Type="ace3p-export" />
      </InstancedAttributes>
    </View>
  </Views>
</SMTK_AttributeResource>
